<?PHP
/*
  admin/adminglobal.php - 4/3/2009 - 8:32pm PST - 4.1.9

  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/

  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

@set_time_limit(0);

define('COUNTRY', '1');
define('STATE', '2');
define('PROVINCE', '3');
define('OUTSIDE', '4');
define('ZIP', '5');

if (!defined('SS_SESSION_START')) { header("location: login.php?access_denied"); die("Access denied"); }

$abs_path = dirname(dirname(__FILE__));

//////////////////////
// Laod Secure Library
//////////////////////

define('ABS_PATH', $abs_path);
require $abs_path."/".ADMIN_DIR."/libsecure.php";
if (!defined('ADMIN_DIR')) define('ADMIN_DIR', 'admin');

// Uncomment this line to disable strict SQL
// $DB_site->query("SET sql_mode='MYSQL40'");

////////////////////////
// Initialize Menu Links
////////////////////////

function startlinks () {
	global $DB_site, $dbprefix, $settings, $lang;

	$sid = session_id();
	$sn  = session_name();

	/* Users  Menu */

	$startlink[0][0][name]			= $lang['musers'];
	$startlink[0][0][link]			= "adminindex.php?action=users&amp;sub=view";
	$startlink[0][0][sub][0][name] 	= $lang['vusers'];
	$startlink[0][0][sub][0][link] 	= "adminindex.php?action=users&amp;sub=view";
	$startlink[0][0][sub][1][name] 	= $lang['auser'];
	$startlink[0][0][sub][1][link] 	= "adminindex.php?action=users&amp;sub=add";
	$startlink[0][0][sub][2][name] 	= $lang['impext'];
	$startlink[0][0][sub][2][link] 	= "adminindex.php?action=settings&amp;sub=impexp&amp;type=users";

	$startlink[0][1][name]			= $lang['madmins'];
	$startlink[0][1][link]			= "adminindex.php?action=users&amp;sub=view&amp;type=admin";
	$startlink[0][1][sub][0][name] 	= $lang['vadmins'];
	$startlink[0][1][sub][0][link] 	= "adminindex.php?action=users&amp;sub=view&amp;type=admin";
	$startlink[0][1][sub][1][name] 	= $lang['aadmin'];
	$startlink[0][1][sub][1][link] 	= "adminindex.php?action=users&amp;sub=add&amp;type=admin";
	$startlink[0][1][sub][2][name] 	= $lang['impext'];
	$startlink[0][1][sub][2][link] 	= "adminindex.php?action=settings&amp;sub=impexp&amp;type=admins";

	$startlink[0][2][name]			= $lang['mgroups'];
	$startlink[0][2][link]			= "adminindex.php?action=users&amp;sub=view&amp;type=group";
	$startlink[0][2][sub][0][name] 	= $lang['vgroups'];
	$startlink[0][2][sub][0][link] 	= "adminindex.php?action=users&amp;sub=view&amp;type=group";
	$startlink[0][2][sub][1][name] 	= $lang['agroup'];
	$startlink[0][2][sub][1][link] 	= "adminindex.php?action=users&amp;sub=add&amp;type=group";
	$startlink[0][2][sub][2][name] 	= $lang['impext'];
	$startlink[0][2][sub][2][link] 	= "adminindex.php?action=settings&amp;sub=impexp&amp;type=groups";

	$startlink[0][4][name]			= $lang['snewsletter'];
	$startlink[0][4][link]	 		= "adminindex.php?action=users&amp;sub=mail";

	/* Products  Menu */

	$startlink[1][0][name]			= $lang['mproducts'];
	$startlink[1][0][link]			= "adminindex.php?action=products&amp;sub=view";
	$startlink[1][0][sub][0][name] 	= $lang['vproducts'];
	$startlink[1][0][sub][0][link] 	= "adminindex.php?action=products&amp;sub=view";
	$startlink[1][0][sub][1][name] 	= $lang['aproducts'];
	$startlink[1][0][sub][1][link] 	= "adminindex.php?action=products&amp;sub=add";
	$startlink[1][0][sub][2][name]	= $lang['impext'];
	$startlink[1][0][sub][2][link]	= "adminindex.php?action=settings&amp;sub=impexp&amp;type=products";

	$startlink[1][1][name]			= $lang['mvendors'];
	$startlink[1][1][link]			= "adminindex.php?action=products&amp;sub=manage&amp;type=vendors";
	$startlink[1][1][sub][0][name] 	= $lang['vvendors'];
	$startlink[1][1][sub][0][link] 	= "adminindex.php?action=products&amp;sub=manage&amp;type=vendors";
	$startlink[1][1][sub][1][name] 	= $lang['avendor'];
	$startlink[1][1][sub][1][link] 	= "adminindex.php?action=products&amp;sub=addvm&amp;type=vendors";
	$startlink[1][1][sub][2][name]	= $lang['impext'];
	$startlink[1][1][sub][2][link]	= "adminindex.php?action=settings&amp;sub=impexp&amp;type=vendors";

	$startlink[1][2][name]			= $lang['mmanufacturers'];
	$startlink[1][2][link]			= "adminindex.php?action=products&amp;sub=manage&amp;type=manufacturers";
	$startlink[1][2][sub][0][name] 	= $lang['vmanufacturers'];
	$startlink[1][2][sub][0][link] 	= "adminindex.php?action=products&amp;sub=manage&amp;type=manufacturers";
	$startlink[1][2][sub][1][name] 	= $lang['amanufacturers'];
	$startlink[1][2][sub][1][link] 	= "adminindex.php?action=products&amp;sub=addvm&amp;type=manufacturers";
	$startlink[1][2][sub][2][name]	= $lang['impext'];
	$startlink[1][2][sub][2][link]	= "adminindex.php?action=settings&amp;sub=impexp&amp;type=manufacturers";

	$startlink[1][3][name]			= $lang['mreviews'];
	$startlink[1][3][link]	 		= "adminindex.php?action=products&amp;sub=manage&amp;type=products_reviews";

	$startlink[1][4][name]			= $lang['imanage'];
	$startlink[1][4][link]	 		= "adminindex.php?action=products&amp;sub=images";
	$startlink[1][4][sub][0][name]	= $lang['iresize'];
	$startlink[1][4][sub][0][link]	= "adminindex.php?action=products&amp;sub=images";
	$startlink[1][4][sub][1][name]	= $lang['icleanup'];
	$startlink[1][4][sub][1][link]	= "adminindex.php?action=products&amp;sub=image_cleanup";
	$startlink[1][4][sub][2][name]	= $lang['ibackup'];
	$startlink[1][4][sub][2][link]	= "adminindex.php?action=products&amp;sub=backup_images";

	$startlink[1][5][name]			= $lang['ffeed'];
	$startlink[1][5][link]	 		= "adminindex.php?action=settings&amp;sub=gbexport";

	/* Categories  Menu */

	$startlink[2][0][name]		= $lang['vcategories'];
	$startlink[2][0][link]		= "adminindex.php?action=categories&amp;sub=view";
	$startlink[2][1][name]		= $lang['acategories'];
	$startlink[2][1][link]		= "adminindex.php?action=categories&amp;sub=add".(($_GET[subof]!="")?'&subof='.$_GET[subof]:'');
	$startlink[2][2][name]		= $lang['bacategories'];
	$startlink[2][2][link]		= "adminindex.php?action=categories&amp;sub=bulkadd";
	$startlink[2][3][name]		= $lang['impext'];
	$startlink[2][3][link]	 	= "adminindex.php?action=settings&amp;sub=impexp&amp;type=categories";

	/* Transactions  Menu */

	$startlink[3][0][name]		= $lang['vtransactions'];
	$startlink[3][0][link]	 	= "adminindex.php?action=transactions&amp;sub=view";

	$startlink[3][1][name]		= $lang['transactionsr'];
	$startlink[3][1][link]	 	= "adminindex.php?action=transactions&amp;sub=reports";

	$startlink[3][2][name]		= $lang['transactionss'];
	$startlink[3][2][link]	 	= "adminindex.php?action=transactions&amp;sub=stats";

	$startlink[3][3][name]			= $lang['mstatuses'];
	$startlink[3][3][link]	 		= "adminindex.php?action=transactions&amp;sub=status";
	$startlink[3][3][sub][0][name]	= $lang['statlist'];
	$startlink[3][3][sub][0][link] 	= "adminindex.php?action=transactions&amp;sub=status";
	$startlink[3][3][sub][1][name]	= $lang['mstatusesm'];
	$startlink[3][3][sub][1][link] 	= "adminindex.php?action=settings&amp;sub=statmeanings&type=2";
	$startlink[3][3][sub][2][name]	= $lang['pmstatusesm'];
	$startlink[3][3][sub][2][link] 	= "adminindex.php?action=settings&amp;sub=statmeanings&type=1";

	$startlink[3][4][name]		= $lang['impext'];
	$startlink[3][4][link]		= "adminindex.php?action=settings&amp;sub=impexp&amp;type=orders";

	$startlink[3][5][name]		= $lang['qbexport'];
	$startlink[3][5][link]		= "adminindex.php?action=transactions&amp;sub=preqbexport";

	/* Settings  Menu */

	$startlink[4][0][name]		= $lang['msettings'];
	$startlink[4][0][link]	 	= "adminindex.php?action=settings&amp;sub=general";

	$startlink[4][0][sub][0][name]	= $lang['gsettings'];
	$startlink[4][0][sub][0][link]	= "adminindex.php?action=settings&amp;sub=general";

	$startlink[4][0][sub][1][name]	= $lang['ssettings'];
	$startlink[4][0][sub][1][link]	= "adminindex.php?action=settings&amp;sub=shipping";

	$startlink[4][0][sub][2][name]	= $lang['psettings'];
	$startlink[4][0][sub][2][link]	= "adminindex.php?action=settings&amp;sub=paymodules";

	$startlink[4][0][sub][3][name]	= $lang['rsettings'];
	$startlink[4][0][sub][3][link]	= "adminindex.php?action=settings&amp;sub=resizing";

	$startlink[4][0][sub][4][name]	= $lang['tsettings'];
	$startlink[4][0][sub][4][link]	= "adminindex.php?action=settings&amp;sub=tax";

	$startlink[4][0][sub][5][name]	= $lang['fsettings'];
	$startlink[4][0][sub][5][link]	= "adminindex.php?action=settings&amp;sub=google";

	$startlink[4][0][sub][6][name]	= $lang['qbsettings'];
	$startlink[4][0][sub][6][link]	= "adminindex.php?action=settings&amp;sub=quickbooks";

	//NETWAVE DESIGN - 04-22-09
	$startlink[4][0][sub][7][name]	= "Events";
	$startlink[4][0][sub][7][link]	= "adminindex.php?action=settings&amp;sub=events";
	$startlink[4][0][sub][8][name]	= "Endorsers";
	$startlink[4][0][sub][8][link]	= "adminindex.php?action=settings&amp;sub=favorites";
	$startlink[4][0][sub][9][name]	= "Videos";
	$startlink[4][0][sub][9][link]	= "adminindex.php?action=settings&amp;sub=videos";
	$startlink[4][0][sub][10][name]	= "Pictures";
	$startlink[4][0][sub][10][link]	= "adminindex.php?action=settings&amp;sub=pictures";
	// END NETWAVE MODIFICATION

	$startlink[4][1][name]			= $lang['mareas'];
	$startlink[4][1][link]	 		= "adminindex.php?action=settings&amp;sub=areas";
	$startlink[4][1][sub][0][name]	= $lang['mcount'];
	$startlink[4][1][sub][0][link]	= "adminindex.php?action=settings&amp;sub=areas&amp;type=1";
	$startlink[4][1][sub][1][name]	= $lang['mstates'];
	$startlink[4][1][sub][1][link]	= "adminindex.php?action=settings&amp;sub=areas&amp;type=2";
	$startlink[4][1][sub][2][name]	= $lang['mprov'];
	$startlink[4][1][sub][2][link]	= "adminindex.php?action=settings&amp;sub=areas&amp;type=3";
	$startlink[4][1][sub][3][name]	= $lang['mzip'];
	$startlink[4][1][sub][3][link]	= "adminindex.php?action=settings&amp;sub=areas&amp;type=5";
	$startlink[4][1][sub][4][name]	= $lang['impext'];
	$startlink[4][1][sub][4][link]	= "adminindex.php?action=settings&amp;sub=impexp&amp;type=state_country";

	$startlink[4][2][name]			= $lang['mtemplates'];
	$startlink[4][2][link]	 		= "adminindex.php?action=settings&amp;sub=templates";
	$startlink[4][2][sub][0][name]	= $lang['etemplates'];
	$startlink[4][2][sub][0][link]	= "adminindex.php?action=settings&amp;sub=templates";
	$startlink[4][2][sub][1][name]	= $lang['btemplates'];
	$startlink[4][2][sub][1][link]	= "adminindex.php?action=settings&amp;sub=backup_templates";

	$startlink[4][3][name]			= $lang['mrates'];
	$startlink[4][3][link]	 		= "adminindex.php?action=settings&amp;sub=rates";
	$startlink[4][3][sub][0][name]	= $lang['icurr'];
	$startlink[4][3][sub][0][link]	= "adminindex.php?action=settings&amp;sub=rates&amp;do=commonrates";
	$startlink[4][3][sub][1][name]	= $lang['grates'];
	$startlink[4][3][sub][1][link]	= "adminindex.php?action=settings&amp;sub=rates&amp;do=updaterates";
	$startlink[4][3][sub][2][name]	= $lang['impext'];
	$startlink[4][3][sub][2][link]	= "adminindex.php?action=settings&amp;sub=impexp&amp;type=currency";

	$startlink[4][4][name]			= $lang['mcfs'];
	$startlink[4][4][link]	 		= "adminindex.php?action=settings&amp;sub=fields&amp;type=orders";
	$startlink[4][4][sub][0][name]	= $lang['mcofs'];
	$startlink[4][4][sub][0][link]	= "adminindex.php?action=settings&amp;sub=fields&amp;type=orders";
	$startlink[4][4][sub][1][name]	= $lang['mcafs'];
	$startlink[4][4][sub][1][link]	= "adminindex.php?action=settings&amp;sub=fields&amp;type=users";
	$startlink[4][4][sub][2][name]	= $lang['macfs'];
	$startlink[4][4][sub][2][link]	= "adminindex.php?action=settings&amp;sub=editadd_fields";

	$startlink[4][5][name]			= $lang['mplugins'];
	$startlink[4][5][link]	 		= "adminindex.php?action=settings&amp;sub=plugins";

	$startlink[4][6][name]			= $lang['mdatabase'];
	$startlink[4][6][link]	 		= "adminindex.php?action=settings&amp;sub=backup";
	$startlink[4][6][sub][0][name]	= $lang['bdatabase'];
	$startlink[4][6][sub][0][link]	= "adminindex.php?action=settings&amp;sub=backup";
	$startlink[4][6][sub][1][name]	= $lang['odatabase'];
	$startlink[4][6][sub][1][link]	= "adminindex.php?action=settings&amp;sub=optimize";
	$startlink[4][6][sub][2][name]	= $lang['cleanupdb'];
	$startlink[4][6][sub][2][link]	= "adminindex.php?action=settings&amp;sub=clean";

	$startlink[4][7][name]			= $lang['mmd'];
	$startlink[4][7][link]	 		= "adminindex.php?action=settings&amp;sub=meta";
	$startlink[4][7][sub][0][name]	= $lang['mml'];
	$startlink[4][7][sub][0][link]	= "adminindex.php?action=settings&amp;sub=meta";
	$startlink[4][7][sub][1][name]	= $lang['mmda'];
	$startlink[4][7][sub][1][link]	= "adminindex.php?action=settings&amp;sub=editadd_meta";

	$startlink[4][8][name]			= $lang['ghtml'];
	$startlink[4][8][link]	 		= 'adminindex.php?action=settings&amp;sub=html';

	$startlink[4][9][name]			= $lang['gsitemap'];
	$startlink[4][9][link]	 		= 'adminindex.php?action=settings&amp;sub=sitemap';

	/* Coupons  Menu */

	$startlink[5][0][name]			= $lang['mcoupons'];
	$startlink[5][0][link]	 		= "adminindex.php?action=cdg&amp;sub=view&amp;type=coupons";
	$startlink[5][0][sub][0][name]	= $lang['vcoupons'];
	$startlink[5][0][sub][0][link]	= "adminindex.php?action=cdg&amp;sub=view&amp;type=coupons";
	$startlink[5][0][sub][1][name]	= $lang['acoupons'];
	$startlink[5][0][sub][1][link]	= "adminindex.php?action=cdg&amp;sub=add&amp;type=coupons";
	$startlink[5][0][sub][2][name]	= $lang['impext'];
	$startlink[5][0][sub][2][link]	= "adminindex.php?action=settings&amp;sub=impexp&amp;type=coupons";

	$startlink[5][1][name]			= $lang['mdiscounts'];
	$startlink[5][1][link]	 		= "adminindex.php?action=cdg&amp;sub=view&amp;type=discounts";
	$startlink[5][1][sub][0][name]	= $lang['vdiscounts'];
	$startlink[5][1][sub][0][link]	= "adminindex.php?action=cdg&amp;sub=view&amp;type=discounts";
	$startlink[5][1][sub][1][name]	= $lang['adiscounts'];
	$startlink[5][1][sub][1][link]	= "adminindex.php?action=cdg&amp;sub=add&amp;type=discounts";
	$startlink[5][1][sub][2][name]	= $lang['impext'];
	$startlink[5][1][sub][2][link]	= "adminindex.php?action=settings&amp;sub=impexp&amp;type=discounts";

	$startlink[5][2][name]			= $lang['mgiftcerts'];
	$startlink[5][2][link]	 		= "adminindex.php?action=cdg&amp;sub=view&amp;type=giftcerts";
	$startlink[5][2][sub][0][name]	= $lang['vgiftcerts'];
	$startlink[5][2][sub][0][link]	= "adminindex.php?action=cdg&amp;sub=view&amp;type=giftcerts";
	$startlink[5][2][sub][1][name]	= $lang['agiftcerts'];
	$startlink[5][2][sub][1][link]	= "adminindex.php?action=cdg&amp;sub=add&amp;type=giftcerts";
	$startlink[5][2][sub][2][name]	= $lang['impext'];
	$startlink[5][2][sub][2][link]	= "adminindex.php?action=settings&amp;sub=impexp&amp;type=gift_certificates";

	return $startlink;
}

///////////////
// Check Access
///////////////

function check_access ($action, $sub, $type='', $notused='') {
	global $admin;
	$check_array = array (
		'show_invoices' => array (
			'' => array (
				''	=> 'view_trans',
			),
		),

		'generate_html' => array (
			'' => array (
				''	=> 'html_pages',
			),
		),

		'news_mailer' => array (
			'' => array (
				''	=> 'send_news',
			),
		),

		'users' => array (
			'' => array (
				'mail'			=> 'send_news',
				'news_mailer'	=> 'send_news',
				'view' 			=> 'view_users',
				'def' 			=> 'manage_users'
			),
			'users' => array (
				'view' 		=> 'view_users',
				'def' 		=> 'manage_users'
			),
			'admin' => array (
				'view' 		=> 'view_admins',
				'def' 		=> 'manage_admins'
			),
			'group' => array (
				'view' 		=> 'view_groups',
				'def' 		=> 'manage_groups'
			)
		),

		'products' => array (
			'' => array (
				'view' 			=> 'view_prods',
				'images'		=> 'manage_images',
				'image_cleanup'	=> 'manage_images',
				'def' 			=> 'manage_prods'
			),
			'vendors' => array (
				'manage' 	=> 'view_vends',
				'def' 		=> 'manage_vends'
			),
			'manufacturers' => array (
				'manage' 	=> 'view_mans',
				'def' 		=> 'manage_mans'
			),
			'products_reviews' => array (
				'view' 		=> 'manage_reviews',
				'def' 		=> 'manage_reviews'
			)
		),

		'categories' => array (
			'' => array (
				'view' 		=> 'view_cats',
				'def' 		=> 'manage_cats'
			)
		),

		'transactions' => array (
			'' => array (
				'view' 			=> 'view_trans',
				'reports' 		=> 'view_reports',
				'stats' 		=> 'view_reports',
				'status' 		=> 'manage_status',
				'def' 			=> 'manage_trans',
				'preqbexport'	=> 'manage_trans',
				'qbexport'		=> 'manage_trans'
			)
		),

		'settings' => array (
			''	=> array (
				'general' 		 => 'gen_settings',
				'shipping'		 => 'ship_settings',
				'paymodules'	 => 'pay_settings',
				'resizing' 		 => 'resize_settings',
				'tax'			 => 'tax_settings',
				'google'		 => 'google_settings',
				'affilaite'		 => 'aff_settings',
				'areas' 		 => 'manage_areas',
				'templates' 	 => 'manage_templates',
				'rates' 		 => 'curr_rates',
				'plugins' 		 => 'plugin_settings',
				'gbexport' 		 => 'manage_prods',
				'backup' 		 => 'manage_backs',
				'html' 			 => 'html_pages',
				'sitemap' 		 => 'html_pages',
				'gb_export'		 => 'manage_google',
				'editadd_fields' => 'gen_settings',
				'quickbooks'	 => 'gen_settings',
			),

			'general' 	=> array('update' => 'gen_settings'),
			'resizing' 	=> array('update' => 'resize_settings'),
			'tax' 		=> array('update' => 'tax_settings'),
			'google' 	=> array('update' => 'google_settings'),
			'affiliate' => array('update' => 'aff_settings'),

			'shipping' => array (
				'update' 			=> 'ship_settings',
				'module_settings' 	=> 'ship_settings',
				'module_update' 	=> 'ship_settings'
			),

			'paymodules' => array (
				'update' 			=> 'pay_settings',
				'module_settings'	=> 'pay_settings',
				'module_update' 	=> 'pay_settings'
			),

			'plugins' => array (
				'update' 			=> 'plugin_settings',
				'module_settings' 	=> 'plugin_settings',
				'module_update' 	=> 'plugin_settings'
			),

			'users' 				=> array('def' => 'manage_users', 'fields' => 'gen_settings', 'editadd_fields' => 'gen_settings'),
			'admins' 				=> array('def' => 'manage_admins'),
			'groups' 				=> array('def' => 'manage_groups'),
			'products' 				=> array('def' => 'manage_prods'),
			'products_categories'	=> array('def' => 'manage_prods'),
			'vendors' 				=> array('def' => 'manage_vends'),
			'manufacturers' 		=> array('def' => 'manage_mans'),
			'reviews' 				=> array('def' => 'manage_reviews'),
			'categories' 			=> array('def' => 'manage_cats'),
			'orders' 				=> array('def' => 'manage_trans', 'fields' => 'gen_settings', 'editadd_fields' => 'gen_settings'),
			'status' 				=> array('def' => 'manage_status'),
			'state_country' 		=> array('def' => 'manage_areas'),
			'currency' 				=> array('def' => 'curr_rates'),
			'taxes' 				=> array('def' => 'tax_settings'),
			'coupons' 				=> array('def' => 'manage_coups'),
			'discounts' 			=> array('def' => 'manage_disc'),
			'gift_certificates' 	=> array('def' => 'manage_certs')
		),

		'cdg' => array (
			'coupons'   => array (
				'view' 	=> 'view_coup',
				'def' 	=> 'manage_coups',
			),

			'discounts' => array (
				'view' 	=> 'view_disc',
				'def' 	=> 'manage_disc',
			),

			'giftcerts' => array (
				'view' 	=> 'view_certs',
				'def' 	=> 'manage_certs',
			)
		),

		'move' => array (
			'categories' 			=> array('' => 'manage_cats'),
			'products_options' 		=> array('' => 'manage_prods'),
			'products_attributes' 	=> array('' => 'manage_prods'),
			'products_related' 		=> array('' => 'manage_prods'),
			'status' 				=> array('' => 'manage_status')
		),
	);

	$key = ($check_array[$action][$type][$sub] != "")?$check_array[$action][$type][$sub]:$check_array[$action][$type][def];

	if ($admin[$key] == 1 || $key == "") return 1;
	else return 0;
}

//////////////////
// Dropship Notify
//////////////////

function dropship_notify () {
	global $DB_site, $dbprefix, $settings;
	$vendors = array();
	$order = get('orders', $_POST[id]);

	foreach ($order as $k => $v) if ($v == "" || (is_numeric($v) && p($v) == p(0))) $order[hide][] = $k;

	$results = $DB_site->query("SELECT * FROM `".$dbprefix."orders_products` where `orderid`='".$_POST[id]."' ORDER by `id`");
	while ($row = $DB_site->fetch_assoc($results)) {
		$row  = filter_data($row);
		$prod = get('products', $row[productid]);
		$vend = get('vendors', $prod[vendor]);
		$item = new orderitem ($row[data]);
		$id = $vend[id];
		if ($vend[dropship] == '1') {
			$vendors[$id][item][] = $item->item->id;
			$vendors[$id][quan][] = $item->item->quantity;
			$vendors[$id][options][] = $item->display_options();
		}
	}

	$order['datestamp'] = date($settings[datestamp].' '.$settings[timestamp], $order[order_stamp]);
	foreach ($vendors as $k => $v) {
		$order[items] = '';
		$vend = get('vendors',  $k);
		for ($i=0; $i < count($v[item]); $i++) {
			$product = get('products', $v[item][$i]);
			$product[quantity]	= $v[quan][$i];
			$product[options]	= $v[options][$i];;
			$order[items] .= template('email_reseller_notify_item.html', $product);
		}

		$email = template('email_reseller_notify.html', array_merge($vend, $order));
		mail_send($vend[email], $vend[company], $settings[title].' Order Fullfillment Notification', $email, $settings[contactemail], $settings[title], true);
	}

	$DB_site->query("UPDATE `".$dbprefix."orders` set `dropship_notified`='1' where `id`='".$_POST[id]."'");
}

/////////////////
// Info Page List
/////////////////

function info_page_list () {
	global $DB_site, $dbprefix, $abs_path, $settings;
	$the_directory = @opendir($abs_path."/themes/".$settings[theme]."/");
	$skip_array = array('message_output', 'welcome', 'user_registry', 'user_registry_item', 'user_wishlist', 'user_wishlist_item', 'site_map_item', 'site_map_open', 'site_map_close');
	$out = array();
	while($FILE_NAME = @readdir($the_directory)) {
		$filename_arr = @explode("_", $FILE_NAME);
                $name = str_replace(array("page_", ".html"), "", $FILE_NAME);
		if ($filename_arr[0] == "page" && !in_array($name, $skip_array)) array_push($out, $name);
	}
	@closedir($the_directory);
	return $out;
}

//////////////////////
// Bulk Action Display
//////////////////////

function bulk_action () {
	global $bulk, $forms;
	$selections = array();
	$section 	= ($_GET[type]=="" && $_GET[sub]!="" && $_GET[sub]!="view")?$_GET[sub]:$_GET[type];
	$act_array 	= $bulk->action_array[$_GET[action]][$section][actions];
	if (is_array($act_array)) {
		foreach ($act_array as $k => $v) array_push($selections, $k);
		array_unshift($selections, 'Select Action');
		$statuses = $forms->item("dropdown", "", "baction", $forms->farray($selections, $selections), "", "", "", array('return_item' => 1));
		return template('form_bulk_action.html', array('boptions' => $statuses));
	}
}

//////////////////
// Themes Dropdown
//////////////////

function themes () {
	global $abs_path;
	$the_directory = @opendir($abs_path."/themes");
	while ($node = readdir($the_directory)) {
		$nodebase = basename($node);
		if ($nodebase != "." && $nodebase != ".." && $nodebase != "_vti_cnf") $out[] = $node;
	}
	@closedir($the_directory);
	return $out;
}

//////////////////////////
// Evaluate Admin Template
//////////////////////////

function template ($file, $vars=array(), $eval=1, $path="") {
	global $lang, $settings, $abs_path, $plugin;
	ob_start();
	$path = $abs_path.(($path=="")?'/'.ADMIN_DIR.'/'.$settings[theme_path]:$path)."/";
   	if (@include $path.$file) $contents = ob_get_contents();
	else $contents = 'Unable to open template file "'.$path.$file.'"';
   	ob_end_clean();

	if (is_array($vars[hide])) {
		foreach ($vars[hide] as $k => $v) {
			if (!$contents = @preg_replace('/(.*)(<!--\/\/ Start Hide '.$vars[hide][$k].' \/\/-->)(.*)(<!--\/\/ End Hide '.$vars[hide][$k].' \/\/-->)(.*)/sim', '\1\5', $contents)) {
				$contents = ($vars[hide][$k]!='')?str_replace("Start Hide ".$vars[hide][$k]." //-->", "", $contents):$contents;
				$contents = ($vars[hide][$k]!='')?str_replace("<!--// End Hide ".$vars[hide][$k], "", $contents):$contents;
			}
		}
	}

	if ($eval == 1) {
		if (!@eval("return \$out = \"".addslashes($contents)."\";")) $out = "Error parsing template $file";
	} else {
		$out = $contents;
   	}
   	return stripslashes(stripslashes($out));
}

///////////////////////////
// Evaluate Client Template
///////////////////////////

function template_client ($file, $vars=array(), $eval=1) {
	global $lang_client, $settings, $abs_path, $plugin, $plugin_cache;

	ob_start();
   	if (@include $abs_path."/themes/".$settings[theme]."/".$file) $contents = ob_get_contents();
	else $contents = 'Unable to open template file "'.$file.'"';
   	ob_end_clean();

	foreach ($vars as $key => $val) ${$key} = $val;

	for ($i=0; $i<count($hide); $i++) {
		if (!$contents = @preg_replace('/(.*)(<!--\/\/ Start Hide '.$hide[$i].' \/\/-->)(.*)(<!--\/\/ End Hide '.$hide[$i].' \/\/-->)(.*)/sim', '\1\5', $contents)) {
			$contents = ($hide[$i]!='')?str_replace("Start Hide ".$hide[$i]." //-->", "", $contents):$contents;
			$contents = ($hide[$i]!='')?str_replace("<!--// End Hide ".$hide[$i], "", $contents):$contents;
		}
	}

	if ($eval == 1) {
		if (!@eval("return \$out = \"".addslashes($contents)."\";")) $out = "Error parsing template $file";
	}

	else $out = $contents;

	return stripslashes(stripslashes($out));
}

/////////////
// XML Output
/////////////

function xml_doc ($file, $vars=array(), $noheader=0) {
	global $lang, $abs_path, $settings;
	ob_start();
   	if (@include $abs_path."/".$file) $contents = ob_get_contents();
   	ob_end_clean();
	if (!$contents = @preg_replace('/(.*)(<!--\/\/ Start Hide '.$vars[hide].' \/\/-->)(.*)(<!--\/\/ End Hide '.$vars[hide].' \/\/-->)(.*)/sim', '\1\5', $contents)) {
		$contents = ($vars[hide]!='')?str_replace("Start Hide ".$vars[hide]." //-->", "", $contents):$contents;
		$contents = ($vars[hide]!='')?str_replace("<!--// End Hide ".$vars[hide], "", $contents):$contents;
	}
	@eval("\$out = \"".addslashes((($noheader==1)?'<?xml version="1.0" encoding="UTF-8"?>':'').$contents)."\";");
   	return stripslashes(stripslashes($out));
}

///////////////
// Side Content
///////////////

function getside ($startlink, $i) {
	global $lang;
	$heading = array($lang['husers'], $lang['hproducts'], $lang['hcategories'], $lang['htransactions'], $lang['hsettings'], $lang['hcoupons']);
	if (is_array($startlink[$i])) {
		while (list($key, $val) = @each($startlink[$i])) {
			$subs = $startlink[$i][$key][sub]; $name = $startlink[$i][$key][name]; $link = $startlink[$i][$key][link];
			$sidecont .= "<a href=\"$link\" class=\"side_link\">$name</a>";
		}
	}
	return sidetable ($heading[$i], $sidecont);
}

function getsidesubs ($startlink, $i, $j) {
	global $lang;
	if (is_array($startlink[$i][$j][sub])) {
		while (list($key, $val) = @each($startlink[$i][$j][sub])) {
			$name = $startlink[$i][$j][sub][$key][name]; $link = $startlink[$i][$j][sub][$key][link];
			$sidecont .= "<a href=\"$link\" class=\"side_link\">$name</a>";
		}
	}
	return sidetable ('Areas', $sidecont);
}

///////////
// Add Side
///////////

function addside ($action, $links, $names) {
	while (list($key) = @each($links)) {
		$sidecont .= '<a href="adminindex.php?action=$action&sub='.$links[$key].'" class="side_link">'.$names[$key].'</a>';
	}
	return sidetable ($this->lang[action2], $sidecont);
}

////////////////
// Heading Links
////////////////

function head_links ($startlink) {
	global $lang;
	$heading = array($lang['husers'], $lang['hproducts'], $lang['hcategories'], $lang['htransactions'], $lang['hsettings'], $lang['hcoupons']);
	for ($i=0; $i<6; $i++) {
		if (is_array($startlink[$i])) {
			$links['link_'.$i] = $startlink[$i][0][link];
			$links['name_'.$i] = $heading[$i];
		}
	}
	return $links;
}

//////////////////
// News Collection
//////////////////

function get_news() {
	global $settings, $ver, $lang;
	$news	= news_connect();
	$data	= parse_xml($news, array('news'));
	$data 	= $data[product_info];
	$out	= template('version_compare.html', array('version' => $data[version], 'ssversion' => $settings[version]));
	for ($i=0; $i<count($data[news]); $i++)
		$out .= template('news.html', $data[news][$i]);
	return $out;
}

///////////////
// Modules Data
///////////////

function modules ($type) {
	global $abs_path;
	$the_directory = @opendir($abs_path."/include/".$type."/");
	$out = array();
	while($FILE_NAME = @readdir($the_directory)) {
		$filenamea	= @explode(".", $FILE_NAME);
		$temp		= @count($filenamea)-1;
		$extension	= @strtolower($filenamea[$temp]);
		if ($extension == "php") {
			$success = include_once($abs_path."/include/".$type."/".$FILE_NAME);
			array_push($out, module_data($type, array('FILE_NAME' => $FILE_NAME, 'ADDON_NAME' => $ADDON_NAME, 'ADDON_FULLNAME' => $ADDON_FULLNAME, 'ADDON_TYPE' => $ADDON_TYPE, 'ADDON_VERSION' => $ADDON_VERSION, 'CLASS_NAME' => $CLASS_NAME)));
		}
	}
	@closedir($the_directory);
	return $out;
}

//////////////////////////
// Cookie Crumb Navigation
//////////////////////////

function cookiecrumb ($id) {
	global $DB_site, $dbprefix, $subs_arr;
	if (!is_array($subs_arr)) { $subs_arr = array(); $subs_arr[ids] = array(); $subs_arr[titles] = array(); }
	$result = get('categories', $id);
	array_push($subs_arr[ids], $id);
	array_push($subs_arr[titles], $result[title]);
	if ($result[subof] == 0) {
		$crumbs = array();
		for ($i=(count($subs_arr[ids])-1); $i>=0; $i--) {
			$crumb = array();
			$crumb['link']  = 'adminindex.php?action=categories&amp;sub=view&amp;subof='.$subs_arr[ids][$i];
			$crumb['title'] = $subs_arr[titles][$i];
			$crumbs[path] .= template('category_cookie_crumb_item.html', $crumb);
		}
		$out = template('category_cookie_crumb.html', $crumbs);
	} else {
		$out = cookiecrumb($result[subof]);
	}
	return $out;
}

/////////////
// Date Stamp
/////////////

function stamp () {
	return strtotime('now');
}

//////////////
// User Search
//////////////

function user_search ($s) {
	global $dbprefix;
	$searchin = array();
	$sql = "SELECT u.* FROM `".$dbprefix."users` u WHERE u.`id`<>''";

	if ($s[customer] != "") {
		$sql .= " AND u.`id`='".$s[customer]."'";
	}
	if ($s[name] != "") {
		$sql .= " AND (u.`ship_first_name` like '%".$s[name]."%'";
		$sql .= " OR u.`ship_last_name` like '%".$s[name]."%'";
		$sql .= " OR u.`bill_first_name` like '%".$s[name]."%'";
		$sql .= " OR u.`bill_last_name` like '%".$s[name]."%')";
	}
	if ($s[company] != "") {
		$sql .= " AND (u.`ship_company_name` like '%".$s[company]."%'";
		$sql .= " OR u.`bill_company_name` like '%".$s[company]."%')";
	}
	if ($s[email] != "") {
		$sql .= " AND u.`email` like '%".$s[email]."%'";
	}
	if ($s[login] != "") {
		$sql .= " AND u.`username`='".$s[login]."'";
	}
	if ($s[group] != 0) {
		$sql .= " AND u.`group_in`='".$s[group]."'";
	}
	$sql .= " GROUP by u.id";

	return $sql;
}

/////////////////
// Product Search
/////////////////

function prod_search ($s) {
	global $dbprefix, $subarr;
	$fields = array("p.*", "c.`id` AS catid", "c.`title` AS cattitle", "pc.`productid`", "pc.`catid` AS pcatid", "p.`manufacturer`");
	$searchin = array();
	$sql = "SELECT ".implode(", ",$fields)." FROM `".$dbprefix."products` p
		LEFT JOIN `".$dbprefix."products_categories` pc ON p.`id`=pc.`productid`
		LEFT JOIN `".$dbprefix."categories` c ON (c.`id`=pc.`catid` OR p.`catid`=c.`id`)
		LEFT JOIN `".$dbprefix."manufacturers` m ON m.`id`=p.`manufacturer` WHERE
	";
	if ($s[title] == "Y") {
		if ($s[match] == "exact") {
			$searchin[title] = "p.`title` = '".$s[search]."'";
		} elseif ($s[match] == "any") {
			$words = explode(" ",$s[search]);
			foreach ($words as $key => $word) {
				$titles[] = "p.`title` LIKE '%".$word."%'";
			}
			$searchin[title] = implode(" OR ", $titles);
		} else {
			$words = explode(" ",$s[search]);
			foreach ($words as $key => $word) {
				$titles[] = "p.`title` LIKE '%".$word."%'";
			}
			$searchin[title] = implode(" AND ", $titles);
		}
	}
	if ($s[short_desc] == "Y") {
		if ($s[match] == "exact") {
			$searchin[short_desc] = "p.`short_desc` = '".$s[search]."'";
		} elseif ($s[match] == "any") {
			$words = explode(" ",$s[search]);
			foreach ($words as $key => $word) {
				$short_descs[] = "p.`short_desc` LIKE '%".$word."%'";
			}
			$searchin[short_desc] = implode(" OR ", $short_descs);
		} else {
			$words = explode(" ",$s[search]);
			foreach ($words as $key => $word) {
				$short_descs[] = "p.`short_desc` LIKE '%".$word."%'";
			}
			$searchin[short_desc] = implode(" AND ", $short_descs);
		}
	}
	if ($s[full_desc] == "Y") {
		if ($s[match] == "exact") {
			$searchin[short_desc] = "p.`full_desc` = '".$s[search]."'";
		} elseif ($s[match] == "any") {
			$words = explode(" ",$s[search]);
			foreach ($words as $key => $word) {
				$full_descs[] = "p.`full_desc` LIKE '%".$word."%'";
			}
			$searchin[full_desc] = implode(" OR ", $full_descs);
		} else {
			$words = explode(" ",$s[search]);
			foreach ($words as $key => $word) {
				$full_descs[] = "p.`full_desc` LIKE '%".$word."%'";
			}
			$searchin[full_desc] = implode(" AND ", $full_descs);
		}
	}

	if (!isset($searchin[title]) || $searchin[title] == "") $searchin[title] = 0;
	if (!isset($searchin[short_desc]) || $searchin[short_desc] == "") $searchin[short_desc] = 0;
	if (!isset($searchin[full_desc]) || $searchin[full_desc] == "") $searchin[full_desc] = 0;

	$sql .= "((".$searchin[title].") OR (".$searchin[short_desc].") OR (".$searchin[full_desc]."))";

	if ($s[sku] != "")
		$sql .= " AND (p.`sku` = '".$s[sku]."')";

	if ($s[price_from] != "" || $s[price_to] != "")
		$sql .= " AND (".(($s[price_from]!="")?"p.`price` >= ".$s[price_from]:"1")." AND ".(($s[price_to]!="")?"p.`price` <= ".$s[price_to]:"1").")";
	if ($s[weight_from] != "" || $s[weight_to] != "")
		$sql .= " AND (".(($s[weight_from]!="")?"p.`weight` >= ".$s[weight_from]:"1")." AND ".(($s[weight_to]!="")?"p.`weight` <= ".$s[weight_to]:"1").")";
	if ($s[mid] > 0)
		$sql .= " AND (m.`id` = ".$s[mid].")";
	if ($s[cid] > 0) {
		if ($s[subcats] == "Y") {
			subcats($s[cid]);
			array_push($subarr, $s[cid]);
			$sql .= " AND (c.`id` IN (".implode(",", $subarr)."))";
		} else
			$sql .= " AND (c.`id` = ".$s[cid].")";
	}
	$sql .= " GROUP by p.`id`";

	return $sql;
}

/////////////////////
// Transaction Search
/////////////////////

function trans_search ($s) {
	global $dbprefix;

	$searchin = array();
	$sql = "SELECT * FROM `".$dbprefix."orders` WHERE `id`<>'0'";
	if ($s[customer] != "") {
		if (is_numeric($s[customer])) $sql .= " AND `userid`='".$s[customer]."'";
		else {
			$sql .= " AND (`bill_first_name`='".$s[customer]."'";
			$sql .= " OR `bill_last_name`='".$s[customer]."'";
			$sql .= " OR `ship_first_name`='".$s[customer]."'";
			$sql .= " OR `ship_last_name`='".$s[customer]."'";
			$sql .= " OR `ship_company_name`='".$s[customer]."'";
			$sql .= " OR `bill_company_name`='".$s[customer]."')";
		}
	}
	if ($s[email] != "") {
		$sql .= " AND `email` like '%".$s[email]."%'";
	}
	if ($s[id] != "") {
		$sql .= " AND `id`='".$s[id]."'";
	}
	if ($s[status] != "Any") {
		$sql .= " AND `status`='".$s[status]."'";
	}
	if ($s[span] == "today") {
		$sql .= " AND `order_date`='".date('Y').'-'.date('m').'-'.date('d')."'";
	}
	if ($s[span] == "yesterday") {
		$sql .= " AND `order_date`='".date("Y-m-d", mktime(0, 0, 0, date("m"), (date("d")-1), date("Y")))."'";
	}
	if ($s[span] == "month") {
		$sql .= " AND `order_stamp`>='".mktime(0, 0, 0, date('m'), 1, date('Y'))."' AND `order_stamp`<='".mktime(23, 59, 59, date("m")+1, 0, date("Y"))."'";
	}
	if ($s[span] == "date") {
		$sql .= " AND `order_stamp`>='".mktime(0, 0, 0, $s[smonth], $s[sday], $s[syear])."' AND `order_stamp`<='".mktime(23, 59, 59, $s[emonth], $s[eday], $s[eyear])."'";
	}
	//$sql .= " GROUP by o.id";

	return $sql;
}

///////////////////////
// Subcategories Search
///////////////////////

$subarr = array();
function subcats ($id) {
	global $subarr, $DB_site, $dbprefix;
	$temp = $DB_site->query("SELECT id FROM `".$dbprefix."categories` as c WHERE c.viewable='1' AND c.subof='".$id."'");
	while ($row = $DB_site->fetch_assoc($temp)) {
		array_push($subarr, $row[id]);
		subcats($row[id]);
	}
}

///////////////////
//  Update Field Data
///////////////////

function update_custom ($data, $type, $marker, $mark, $delete=false) {
	global $DB_site, $dbprefix;
	if (is_array($data)) {
		if ($delete) $DB_site->query("DELETE FROM `".$dbprefix.$type."_custom_entries` where `$marker`='$mark'");
		foreach ($data as $k => $v) {
			$field = $DB_site->query_first("SELECT * FROM `".$dbprefix.$type."_custom_fields` where `id`='".addslashes($k)."'");
			$field_item = $DB_site->query_first("SELECT * FROM `".$dbprefix.$type."_custom_fields_items` where `id`='".addslashes($v)."'");
			$DB_site->query("INSERT INTO `".$dbprefix.$type."_custom_entries` set `$marker`='$mark', `fieldid`='$field[id]', `name`='".sf($field[name])."', `value`='".sf(($field_item[id]!='')?$field_item[value]:$v)."', `dorder`='$field[dorder]'");
		}
	}
}

/////////////////////
// Show Custom Fields
/////////////////////

function cf_show ($type, $marker, $mark) {
	global $DB_site, $dbprefix, $settings, $sess, $lang, $forms;
	$results = $DB_site->query("SELECT * FROM `".$dbprefix.$type."_custom_entries` where `$marker`='".addslashes($mark)."'");
	while ($entry = $DB_site->fetch_assoc($results)) {
		$entry = filter_data($entry);
		$return .= $forms->item("show", help($entry[name], ''), "", "", $entry[value], "");
	}
	return $return;
}

/////////////////////
// Editable Custom Fields
/////////////////////

function cf_edit ($type, $marker, $mark) {
	global $DB_site, $dbprefix, $settings, $sess, $lang, $forms;
	$results = $DB_site->query("SELECT * FROM `".$dbprefix.$type."_custom_entries` where `$marker`='".$mark."'");
	while ($entry = $DB_site->fetch_assoc($results)) {
		$match = $DB_site->query_first("SELECT * FROM `".$dbprefix.$type."_custom_fields_items` where `fieldid`='".addslashes($entry[fieldid])."' AND `value`='".addslashes($entry[value])."'");
		$saved[$entry[fieldid]] = ($match[id]!='')?$match[id]:$entry[value];
	}

	$results = $DB_site->query("SELECT * FROM `".$dbprefix.$type."_custom_fields` order by `dorder`");
	while ($field = $DB_site->fetch_assoc($results)) {
		$field = filter_data($field);
		$field_out[name] = $field[name];
		$field[name] = 'customfield['.$type.']['.$field[id].']';
		switch ($field[type]) {
			case 'textbox': case 'textarea':
				$return .= $forms->item($field[type], help($field_out[name], ''), $field[name], "", $saved[$field[id]], $field[length], 3);
				break;
			case 'select': case 'radio':
				$items_array = array(); $values_array = array();
				$items = $DB_site->query("SELECT * FROM `".$dbprefix.$type."_custom_fields_items` WHERE `fieldid`='".$field[id]."' order by `dorder`");
				while ($item = $DB_site->fetch_assoc($items)) { array_push($items_array, $item[value]); array_push($values_array, $item[id]); }
				$return .= $forms->item((($field[type]=='select')?'dropdown':'radio'), help($field_out[name], ''), $field[name], $forms->farray($values_array, $items_array), $saved[$field[id]]);
				break;
			case 'checkbox':
				$item = $DB_site->query_first("SELECT * FROM `".$dbprefix.$type."_custom_fields_items` WHERE `fieldid`='".$field[id]."' order by `dorder`");
				$return .= $forms->item($field[type], help($field_out[name], ''), $field[name], array($item[id], $item[value]), $saved[$field[id]], "", "");
				break;
		}
	}
	return $return;
}

////////////////////
// Directory To Array
/////////////////////

function dir_to_array ($dir) {
	global $dir_array;
	$the_directory = @opendir($dir);
	while (@$filename = readdir($the_directory)) {
		$filenamea	= explode(".", $filename);
		$temp 		= count($filenamea)-1;
		$extension	= strtolower($filenamea[$temp]);
		if (is_dir($dir.$filename) && $filename != "." && $filename != ".." && $filename != "_vti_cnf") {
			dir_to_array($dir.$filename.'/');
		} elseif (!is_dir($dir.$filename)) {
			array_push($dir_array, $dir.$filename);
		}
	}
	@closedir($the_directory);
	return;
}

/////////////////
// Get Table Data
/////////////////

function get ($table, $id, $match='id', $append="") {
	global $DB_site, $dbprefix, $settings, $lang, $userinfo, $gs;
	$result = $DB_site->query_first("SELECT * FROM `".$dbprefix.$table."` WHERE `".$match."`='".addslashes($id)."'");
	if (is_array($result)) {
		foreach ($result as $key => $val) {
			$info[$append.$key] = stripslashes($val);
		}
	}
	switch ($table) {
		case 'users':
			$check_array = array('_address1', '_address2', '_city', '_state', '_zip', '_country');
			foreach ($check_array as $value) $info['bill'.$value] = ($info['bill'.$value]=="")?$info['ship'.$value]:$info['bill'.$value];
			$area = get('state_country', $info[ship_country], 'type`=\''.COUNTRY.'\' AND `abb');
			$info[area_id] = $area[id];
			$groupinfo = get('groups', $info[group_in], 'id', 'group_');
			$rewards = get('users_rewards', $info[id], 'userid', 'rewards_');
			$info = array_merge($info, $groupinfo, $rewards);
			break;
		case 'products':
			if ($id == '0') return $gs->info();
			$info[title] = str_replace('"', '&quot;', $info[title]);
			$info[num] = ($info[sku]!="")?$info[sku]:$info[id];
			$vendorinfo = get('vendors', $info[vendor], 'id', 'vendor_');
			$info = array_merge($info, $vendorinfo);
            $info[out_price] = (p($info[sale_price])!=p(0))?$info[sale_price]:$info[price];
			break;
		case 'categories':
			if (!is_numeric($id)) {
				$info[title] = $lang[$id];
				$info[meta_title] = $lang[$id];
				$info[id] = 0;
			}
			break;
		default;
			break;
	}
	return (!is_array($info))?array():$info;
}

////////////
// IP Lookup
////////////

function ip_lookup ($ip) {
	return xml_service('ip_lookup', $ip);
}

/////////////////
// Template Class
/////////////////

class template {
	var $name;
	var $content;
	var $writable;

	function template ($name='', $content='', $writable='') {
		$this->name = $name;
		$this->content = base64_encode($content);
		$this->writable = (($writable==1)?true:false);
	}

	function get_name () {
		return $this->name;
	}

	function get_content () {
		return base64_decode($this->content);
	}

	function is_writable () {
		return $this->writable;
	}
}

/////////////////
// Get Data Array
/////////////////

function get_data_array ($from, $ret, $order, $sql="") {
    global $DB_site, $dbprefix;
	$result = $DB_site->query("SELECT * FROM `".$dbprefix.$from."` ".$sql." order by ".$order);
	while($row = $DB_site->fetch_assoc($result)) {
	    if (is_array($ret)) {
			$this_return = array();
			foreach($ret as $v) array_push($this_return, trim(stripslashes($row[$v])));
			$return[] = implode(', ', $this_return);
		} else {
			$return[] = trim(stripslashes($row[$ret]));
		}
	}
	return is_array($return)?$return:array();
}

/////////////
// List Icons
/////////////

function icon ($num, $link, $name="") {
	global $settings, $lang;
	switch ($num) {
		case 1: $image = "view"; $langv = "viewi"; break;
		case 2:	$image = "edit"; $langv = "editi"; break;
		case 3: $image = "delete"; $langv = "deletei"; break;
		case 4: $image = "edit"; $langv = "editi"; break;
		case 5: $image = "packing_list"; $langv = "packingi"; break;
		case 6: $image = "print"; $langv = "printi"; break;
		case 7: $image = "clone"; $langv = "clonei"; break;
		case 8: $image = "add"; $langv = "addi"; break;
		case 9: $image = "settings"; $langv = "settingsi"; break;
		case 10: $image = "install"; $langv = "installi"; break;
		case 11: $image = "uninstall"; $langv = "uninstalli"; break;
		case 12: $image = "set_off"; $langv = "setoffi"; break;
		case 13: $image = "set_on"; $langv = "setoni"; break;
		case 14: $image = "down"; $langv = "showmt"; break;
		case 15: $image = "up"; $langv = "showlt"; break;
	}
	$out = '&nbsp;<a href="'.$link.'" onmouseover="window.status=\''.$lang[$langv].'\'; return true;" onmouseout="javascript:window.status=\'\'; return true;"><img src="'.$settings[theme_path].'/images/icons/'.$image.'.gif" alt="'.$lang[$langv].'" border="0" title="'.$lang[$langv].'"'.(($name!="")?' name="'.$name.'" id="'.$name.'"':'').'></a>';
	return $out;
}

//////////////
// Admin Check
//////////////

function checkadmin ($username, $password, $rerror=0) {
	 global $DB_site, $dbprefix, $lang;
	if ((!isset($username) || !isset($password)) && $rerror != 1) {
		header("location: login.php");
		exit;
	}
	$result = $DB_site->query_first("SELECT * from `".$dbprefix."admins` where username='".desql($username)."' AND password='".desql($password)."'");
	if (isset($result[name])) {
		foreach ($result as $key => $val) {
			$return[$key] = stripslashes($val);
		}
	} elseif ($rerror == 1) {
		return false;
	} else {
		header("location: login.php?error=".$lang[ilogin]);
		exit;
	}
	return $return;
}

/////////////
// Start Tabs
/////////////

function start_tabs ($data) {
	return template('tabs_start.html', array('tab_items' => $data));
}

///////////
// Tab Item
///////////

function tab_item ($title, $data) {
	global $tabcount;
	$isdef = ($_GET[tab]==$tabcount++)?1:0;
	return template('tabs_item.html', array('default' => ($isdef==1)?'tabbertabdefault':'', 'tabs_title' => $title, 'tabs_data' => $data));
}

///////////////////
// Import Templates
///////////////////

function import_templates () {
	global $DB_site, $dbprefix, $abs_path;
	$templates = array();
	$theme = $DB_site->query_first("SELECT * from `".$dbprefix."settings` where name='theme'");
	$theme_path = $abs_path."/themes/".$theme[value]."/";
	foreach (array_merge(glob($theme_path."*.html"), glob($theme_path."*.css")) as $filename) {
		$name = str_replace($theme_path, "", $filename);
		$templates[$name] = new template($name, "", is_writable($filename));
	}
	return $templates;
}

//////////////
// Query Array
//////////////

function query_array ($q) {
	$return = array();
	$vars = explode("&", $q);
	for ($i=0; $i<count($vars); $i++) {
		$items = explode("=", $vars[$i]);
		$return[$items[0]] = $items[1];
	}
	return $return;
}

function sc ($in) {
	global $settings;
	return str_replace($settings[cs], '', $in);
}

////////////////
// Template List
////////////////

function template_list ($templates) {
	foreach ($templates as $k => $v) {
		$out .= '<option value="'.$templates[$k]->name.'">'.$templates[$k]->name.(($templates[$k]->is_writable())?'':' *')."</option>\n";
	}
	return $out;
}

////////////////////
// Parse Option Data
////////////////////

function option_data ($id, $value) {
	$op_data	= get('products_options', $id);
	$single		= ($op_data[type]=="select" || $op_data[type]=="radio" || $op_data[type]=="checkbox")?true:false;
	$selected	= ($single)?get('products_options_items', $value):"";

	$data[id] 		= $op_data[id];
	$data[product] 	= $op_data[productid];
	$data[name] 	= $op_data[name];
	$data[value] 	= ($single)?$selected[value]:strip_tags($value);
	$data[valueid] 	= ($single)?$value:'';
	$data[weight] 	= ($single)?$selected[weight]:'';
	$data[price] 	= ($single)?$selected[price]:'';
	$data[desc] 	= $op_data[description];
	$data[type] 	= $op_data[type];
	return $data;
}

///////////////
// Edit Options
///////////////

function edit_options ($data, $count) {
	global $DB_site, $dbprefix, $settings, $lang;
	foreach ($data->item->options as $k => $v) {
		$option = $DB_site->query_first("SELECT * FROM `".$dbprefix."products_options` where `id`='".$v->id."' order by `dorder`");
		$s_sql	 = ($settings[enforceoptionstock]=="Yes")?"AND `in_stock`>'0' ":"";
		$option = filter_data($option);
		$option_out[name] = $option[name];
		$option[name] = 'options['.$count.']['.$option[id].']';
		switch ($option[type]) {
			case 'textbox':
			case 'textarea':
				$option[value] = $v->value;
				$option_out[value] = template('transaction_edit_option_'.$option[type].'.html', $option);
				break;
			case 'select':
				$items = $DB_site->query("SELECT * FROM `".$dbprefix."products_options_items` WHERE `optionid`='".$option[id]."' ".$s_sql."order by `dorder`");
				while ($item = $DB_site->fetch_assoc($items)) {
					$item = filter_data($item);
					$mod  = substr($item[price], 0, 1);
					$item[price]		= ($mod=="-")?substr($item[price], 1):$item[price];
					$item[selected]		= ($item[id]==$v->valueid)?'selected="selected"':'';
					$item[add_price]	= (p($item[price])!=p(0))?' ('.(($mod!="-")?'+':'-').p($item[price]).')':'';
					$option[options]	.= template('transaction_edit_option_select_option.html', array_merge($option, $item, array('name' => $option[name])));
				}
				$option_out[value] = ($option[options]=="")?"":template('transaction_edit_option_select.html', $option);
				break;
			case 'radio':
				$option_out[value] = "";
				$items = $DB_site->query("SELECT * FROM `".$dbprefix."products_options_items` WHERE `optionid`='".$option[id]."' ".$s_sql."order by `dorder`");
				while ($item = $DB_site->fetch_assoc($items)) {
					$item = filter_data($item);
					$mod  = substr($item[price], 0, 1);
					$item[price]		= ($mod=="-")?substr($item[price], 1):$item[price];
					$item[selected]		= ($item[id]==$v->valueid)?'checked="checked"':'';
					$item[add_price]	= (p($item[price])!=p(0))?' ('.(($mod!="-")?'+':'-').p($item[price]).')':'';
					$option_out[value]	.= template('transaction_edit_option_radio_option.html', array_merge($option, $item, array('name' => $option[name])));
				}
				break;
			case 'checkbox':
				$item = $DB_site->query_first("SELECT * FROM `".$dbprefix."products_options_items` WHERE `optionid`='".$option[id]."' ".$s_sql."order by `dorder`");
				if ($item[id] != "") {
					$item = filter_data($item);
					$mod  = substr($item[price], 0, 1);
					$item[price]		= ($mod=="-")?substr($item[price], 1):$item[price];
					$item[selected]		= ($item[id]==$v->valueid)?'checked="checked"':'';
					$item[add_price]	= (p($item[price])!=p(0))?' ('.(($mod!="-")?'+':'-').p($item[price]).')':'';
					$option_out[value]	= template('transaction_edit_option_checkbox.html', array_merge($option, $item, array('name' => $option[name])));
				}
				break;
		}
		$out_items .= template('transaction_edit_option_shell_item.html', array('name' => $option_out[name], 'option' => $option_out[value]));
	}
	return template('transaction_edit_option_shell.html', array('items' => $out_items));
}

//////////////
// Admin Login
//////////////

function login ($username, $password) {
	global $DB_site, $dbprefix, $lang;
	$result = $DB_site->query_first("SELECT * from `".$dbprefix."admins` where `username`='".desql($username)."'");

	if (!isset($result[id])){
		header("location: login.php?error=".$lang[ilogin]);
		exit;
	} elseif ($result[password] != $password) {
		header("location: login.php?error=".$lang[ipass]);
		exit;
	}

	$DB_site->query("UPDATE `".$dbprefix."admins` set `lastvisit`='".stamp()."' where `username`='".desql($username)."'");
	return;
}

//////////////////////
// Categories To Array
//////////////////////

function cats2array ($sub, $editid="") {
	global $DB_site, $dbprefix;
	$array = array();
	$result = $DB_site->query("SELECT * FROM `".$dbprefix."categories` WHERE `subof`='".$sub."' order by `dorder`");
	if ($DB_site->num_rows($result) == 0) return $array;
	while ($row = $DB_site->fetch_assoc($result)) {
		$temp 		= array();
		$temp[id] 	= $row[id];
		$temp[title] 	= stripslashes($row[title]);
		$temp[subof] 	= $row[subof];
		$temp[subs]	= ($editid == $row[id])?array():cats2array($row[id], $editid);
		array_push($array, $temp);
	}
	return $array;
}

///////////////////
// Category Options
///////////////////

function catoptionlist ($cats, $level=0, $select=""){
	global $options_array;
	if (!is_array($options_array)) $options_array = array();
	for ($x=0; $x<count($cats); $x++) {
		$addstyle = ($level == "0")?" class=\"option_base\"":"";
		if (is_array($select)) {
			if (in_array($cats[$x][id], $select)) $is_match = "selected";
			else $is_match = "";
		} else {
			if ($select == $cats[$x][id]) $is_match = "selected";
			else $is_match = "";
		}

		$out = '<option value="'.$cats[$x][id].'"'.$addstyle.' '.$is_match.'>';
		for ($z=0; $z<$level; $z++) $out .= "..";
		$out .= $cats[$x][title].'</option>';
		array_push($options_array, $out);

		if (count($cats[$x][subs]) > 0) {
			catoptionlist($cats[$x][subs], $level+1, $select);
		}
	}
	if ($level == 0) return $options_array;
}

function resetopt () {
	global $options_array;
	$options_array = array();
}

///////////////
// Item Options
///////////////

function itemoptionlist ($sub="", $value=array()) {
	global $DB_site, $dbprefix, $showqueries;
	$array = array();
	$sql = "SELECT p.`id`, p.`title` FROM `".$dbprefix."products` p
		".(($sub != "")?"INNER JOIN (
			SELECT p.`id` AS pid
			FROM `".$dbprefix."products` p
			LEFT JOIN `".$dbprefix."categories` c ON c.`id`=p.`catid`
			WHERE ".((is_array($sub))?"(p.`catid` IN (".implode(",", $sub)."))":"p.`catid`='".$sub."'")."
			UNION SELECT `productid` AS pid
			FROM `".$dbprefix."products_categories` pc
			LEFT JOIN `".$dbprefix."categories` c ON c.`id`=pc.`catid`
			WHERE ".((is_array($sub))?"(pc.`catid` IN (".implode(",", $sub)."))":"pc.`catid`='".$sub."'")."
		) prods ON prods.`pid`=p.`id`
		":"")."ORDER by p.`title`";
	$result = $DB_site->query($sql);
	while ($row = $DB_site->fetch_assoc($result)) {
		$out = '<option value="'.$row[id].'" '.((in_array($row[id], $value))?'selected':'').'>'.stripslashes($row[title]).'</option>';
		array_push($array, $out);
	}
	return $array;
}

/////////////////
// Status Message
/////////////////

function status ($message, $size="545") {
	$status = starttable($size, "Status", $message, array('style' => 'height: 55px;'))."<br>";
    return $status;
}

//////////////
// Filter Data
//////////////

function filter_data ($row) {
	$return = array();
	if (is_array($row)) {
		foreach ($row as $k => $v) {
			$return[$k] = stripslashes($v);
		}
	}
	return $return;
}

////////////
// Count SQL
////////////

function sqlcount ($table, $sql) {
    global $DB_site, $dbprefix;
	$result = $DB_site->query("SELECT COUNT(*) as `total` FROM `".$dbprefix.$table."` ".$sql);
	$row = $DB_site->fetch_assoc($result);
	return $row[total];
}

/////////////////
// XML Formatting
/////////////////

function xf ($in) {
        $replace = array('&', '<', '>', '\'', '"');
        $with = array('&amp;', '&lt;', '&gt;', '&apos;', '&quot;');
        return str_replace($replace, $with, $in);
}

///////////////
// XML To Array
///////////////

function XMLtoArray ($vals, $tags) {
	$at = 0; $act = 0; $return = array();
	$attribute = array(); reset($vals);
	while (list ($key, $val) = each ($vals)) {
		$tag = $val['tag']; $value = $val['value'];
		$type = $val['type']; $level = $val['level'];
		switch ($type) {
			case 'open':
				if (in_array($tag, $tags, false))
					$attribute[$at++] = $tag."][".$act++;
				else
					$attribute[$at++] = $tag;
			break;
			case 'complete':
			    $arraystring = "";
				for ($i=0; $i<$at; $i++) $arraystring .= "[".$attribute[$i]."]";
				@eval("\$return".addslashes($arraystring)."[".addslashes($tag)."] = \"".addslashes($value)."\";");
			break;
			case 'close':
				$at--;
			break;
		}
	}
	return $return;
}

//////////////
// Order Links
//////////////

function l ($word, $extra, $toend='') {
    global $searchfor, $categoryin;
	if ($_GET[sort] == "asc") { $newsort = "desc"; } else { $newsort = "asc"; }
	$out = '<a href="adminindex.php?action='.$_GET[action].'&sub='.$_GET[sub].'&type='.$_GET[type].'&sort='.$newsort.'&orderby='.$extra.$toend.'">'.$word.'</a>';
	return $out;
}

////////////////////////////
// Image Output (On The Fly)
////////////////////////////

function image_output ($image, $mode) {
	global $DB_site, $dbprefix, $settings, $abs_path;

	$image = $abs_path.'/'.$settings[productpath].$image;

	switch ($mode) {
		case '':
		case 'fullsize':
			header("Content-type: image/jpeg");
			readfile($image);
			break;
		case 'thumb':
			if ($settings[resize] == "gd" || $settings[resize] == "imagick") {
				$resize = new image_resize();
				$resize->resize_and_display($image, '115', '115');
			} else {
				header("Content-type: image/jpeg");
				readfile($image);
			}
			break;
	}
}

/////////////////////////
// Regular Image Resizing
/////////////////////////

function resize_image ($image="", $height=0, $width=0) {
	$resize = new image_resize();
	return $resize->resize_and_store($image, $height, $width);
}

///////////////////////
// Alter Decimal Places
///////////////////////

function alter_decimals ($dec) {
	global $DB_site, $dbprefix, $settings, $abs_path;

	$DB_site->query("
		ALTER TABLE `".$dbprefix."coupons`
		CHANGE `value` `value` DECIMAL(12, ".$dec.") NOT NULL DEFAULT '0.".str_pad('', $dec, "0")."',
		CHANGE `omin` `omin` DECIMAL(12, ".$dec.") NOT NULL DEFAULT '0.".str_pad('', $dec, "0")."'
	");

	$DB_site->query("
		ALTER TABLE `".$dbprefix."discounts`
		CHANGE `value` `value` DECIMAL(12, ".$dec.") NOT NULL DEFAULT '0.".str_pad('', $dec, "0")."',
		CHANGE `omin` `omin` DECIMAL(12, ".$dec.") NOT NULL DEFAULT '0.".str_pad('', $dec, "0")."'
	");

	$DB_site->query("
		ALTER TABLE `".$dbprefix."gift_certificates`
		CHANGE `amount` `amount` DECIMAL(12, ".$dec.") NOT NULL DEFAULT '0.".str_pad('', $dec, "0")."',
		CHANGE `remaining` `remaining` DECIMAL(12, ".$dec.") NOT NULL DEFAULT '0.".str_pad('', $dec, "0")."'
	");

	$DB_site->query("
		ALTER TABLE `".$dbprefix."orders`
		CHANGE `ship_price` `ship_price` DECIMAL(12, ".$dec.") NOT NULL DEFAULT '0.".str_pad('', $dec, "0")."',
		CHANGE `tax` `tax` DECIMAL(12, ".$dec.") NOT NULL DEFAULT '0.".str_pad('', $dec, "0")."',
		CHANGE `subtotal` `subtotal` DECIMAL(12, ".$dec.") NOT NULL DEFAULT '0.".str_pad('', $dec, "0")."',
		CHANGE `discount` `discount` DECIMAL(12, ".$dec.") NOT NULL DEFAULT '0.".str_pad('', $dec, "0")."',
		CHANGE `total` `total` DECIMAL(12, ".$dec.") NOT NULL DEFAULT '0.".str_pad('', $dec, "0")."',
		CHANGE `coupon_savings` `coupon_savings` DECIMAL(12, ".$dec.") NOT NULL DEFAULT '0.".str_pad('', $dec, "0")."',
		CHANGE `gift_cert_savings` `gift_cert_savings` DECIMAL(12, ".$dec.") NOT NULL DEFAULT '0.".str_pad('', $dec, "0")."'
	");

	$DB_site->query("
		ALTER TABLE `".$dbprefix."orders_products`
		CHANGE `price` `price` DECIMAL(12, ".$dec.") NOT NULL DEFAULT '0.".str_pad('', $dec, "0")."'
	");

	$DB_site->query("
		ALTER TABLE `".$dbprefix."products` CHANGE `list_price` `list_price` DECIMAL(12, ".$dec.") NOT NULL DEFAULT '0.".str_pad('', $dec, "0")."',
		CHANGE `price` `price` DECIMAL(12, ".$dec.") NOT NULL DEFAULT '0.".str_pad('', $dec, "0")."',
		CHANGE `sale_price` `sale_price` DECIMAL(12, ".$dec.") NOT NULL DEFAULT '0.".str_pad('', $dec, "0")."',
		CHANGE `flat_rate_shipping` `flat_rate_shipping` DECIMAL(12, ".$dec.") NOT NULL DEFAULT '0.".str_pad('', $dec, "0")."'
	");

	$DB_site->query("
		ALTER TABLE `".$dbprefix."products_options_items`
		CHANGE `price` `price` DECIMAL(12, ".$dec.") NOT NULL DEFAULT '0.".str_pad('', $dec, "0")."'
	");

	$DB_site->query("
		ALTER TABLE `".$dbprefix."products_pricing`
		CHANGE `retail` `retail` DECIMAL(12, ".$dec.") NOT NULL DEFAULT '0.".str_pad('', $dec, "0")."',
		CHANGE `price` `price` DECIMAL(12, ".$dec.") NOT NULL DEFAULT '0.".str_pad('', $dec, "0")."'
	");

	$DB_site->query("
		ALTER TABLE `".$dbprefix."ship_table`
		CHANGE `price` `price` DECIMAL(12, ".$dec.") NOT NULL DEFAULT '0.".str_pad('', $dec, "0")."'
	");
}

?>