<?PHP
/*
  admin/adminindex.php - 4/3/2009 - 8:32pm PST - 4.1.9

  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/

  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

define('SS_SESSION_START', '1');

$abs_path = dirname(dirname(__FILE__));
include $abs_path.'/include/config.php';
if (!defined('ADMIN_DIR')) define('ADMIN_DIR', 'admin');
include $abs_path.'/'.ADMIN_DIR.'/adminglobal.php';

$startlink		= startlinks();
$admin  		= checkadmin($sess->gvar('adminid'), $sess->gvar('adminpass'));
$_GET[action]	= (!isset($_GET[action]))?"home":$_GET[action];

///////////////
// Check Access
///////////////

$bulk = new bulk_action();

$manages = array(
	'view_users', 'manage_users', 'view_admins', 'manage_admins', 'view_groups', 'manage_groups', 'send_news', 'view_prods',
	'manage_prods', 'view_vends', 'manage_vends', 'view_mans', 'manage_mans', 'manage_reviews', 'manage_images', 'view_cats',
	'manage_cats', 'view_trans', 'manage_trans', 'view_reports', 'manage_status', 'gen_settings', 'ship_settings',
	'pay_settings', 'resize_settings', 'tax_settings', 'manage_areas', 'manage_templates', 'html_pages', 'curr_rates',
	'plugin_settings', 'google_settings', 'manage_backs', 'manage_exports', 'view_coup', 'manage_coups',
	'view_disc', 'manage_disc', 'view_certs', 'manage_certs'
);

if (($_GET[sub] == 'export' || $_GET[sub] == 'import') && $_GET[action] == "settings") $_GET[type] = $_POST[table];

if (check_access($_GET[action], $_GET[sub], $_GET[type]) == 0 && $_GET[sub] != "impexp") {
	$action_arr = array('users' => 0, 'products' => 1, 'categories' => 2, 'transactions' => 3, 'settings'=> 4, 'cdg'=> 5);
	$vars[sidetable] = getside($startlink, $action_arr[$_GET[action]]);
	$vars[sidetable] .= ($_GET[action]=='settings')?getsidesubs($startlink, 4, 0):"";
	$_GET[action] = "denied";
}

if (file_exists($abs_path.'/'.ADMIN_DIR.'/license_key.php')) import_key();

//////////////////////
// Perform Bulk Action
//////////////////////

if (isset($_POST[baction]) && $_GET[action] != "denied" && $_POST[baction] != "Select Action") {
	$bulk->perform();
	$status = $lang['bulk_done'];
}

/////////////
// Adv Editor
/////////////

if ($_GET[action] == "adv_editor") {
	$base_path = $_SERVER['PHP_SELF'] ;
	$base_path = substr($base_path, 0, strpos($base_path, "adminindex.php"))."htmleditor/";
	echo template('adv_editor.html', array('base_path' => $base_path));
	exit;
}

//////////////////////////////
// Show Invoices By Date Range
//////////////////////////////

if ($_GET[action] == "show_invoices") {
	include $abs_path.'/include/classes/class.reports.php';
	$sreports = new sreports;

	$start	= $_POST['ystart'].'-'.$_POST['mstart'].'-'.$_POST['dstart'];
	$end	= $_POST['yend'].'-'.$_POST['mend'].'-'.$_POST['dend'];
	$ship	= $_POST['shipstatus'];
	$pay	= $_POST['paystatus'];

	$sreports->invoices($start, $end, $ship, $pay);
	exit;
}

//////////////////////
// HTML Page Generator
//////////////////////

if ($_GET[action] == "generate_html") {
	$DB_site->query("TRUNCATE ".$dbprefix."generate_html"); $total = 0;

	if (is_array($_POST[categories])) {
		foreach ($_POST[categories] as $v) {
			$DB_site->query("INSERT INTO `".$dbprefix."generate_html` set `gen_id`='".$v."', `type`='categories'");
			if (is_numeric($v)) {
				$query = "SELECT p.`id` FROM `".$dbprefix."products` p
					INNER JOIN (
						SELECT p.`id` AS pid
						FROM `".$dbprefix."products` p
						LEFT JOIN `".$dbprefix."categories` c ON c.`id`=p.`catid`
						WHERE p.`catid`='".$v."'
						UNION SELECT `productid` AS pid
						FROM `".$dbprefix."products_categories` pc
						LEFT JOIN `".$dbprefix."categories` c ON c.`id`=pc.`catid`
						WHERE pc.`catid`='".$v."'
					) prods ON prods.`pid`=p.`id` WHERE p.`viewable`='y'";
			} else {
				switch ($v) {
					case 'bestsellers':
						$query = "SELECT p.`id` FROM `".$dbprefix."products` p WHERE title<>'' AND p.`viewable`='y' LIMIT $settings[itemsperpage]";
						break;
					case 'new':
						$query = "SELECT p.`id` FROM `".$dbprefix."products` p WHERE p.`is_new`='y' AND p.`viewable`='y'";
						break;
					case 'specials':
						$query = "SELECT p.`id` FROM `".$dbprefix."products` p WHERE p.`sale_price`>'0' AND p.`viewable`='y'";
						break;
					case 'featured':
						$query = "SELECT p.`id` FROM `".$dbprefix."products` p WHERE p.`is_featured`='y' AND p.`viewable`='y'";
						break;
				}
			}
			$results = $DB_site->query($query);
			$count = $DB_site->num_rows($results);
			$num = ceil(($count/$settings[itemsperpage]));
			$total += $num;
		}
	}

	if (is_array($_POST[products])) {
		foreach ($_POST[products] as $v) {
			$DB_site->query("INSERT INTO `".$dbprefix."generate_html` set `gen_id`='".$v."', `type`='products'");
			$total++;
		}
	}

	if (is_array($_POST[manufacturers])) {
		foreach ($_POST[manufacturers] as $v) {
			$DB_site->query("INSERT INTO `".$dbprefix."generate_html` set `gen_id`='".$v."', `type`='manufacturers'");
			$query = "SELECT p.id FROM `".$dbprefix."products` p
				LEFT JOIN `".$dbprefix."manufacturers` pm ON p.`manufacturer`=pm.`id`
				WHERE pm.`id`='".$v."'";
			$results = $DB_site->query($query);
			$count = $DB_site->num_rows($results);
			$num = ceil(($count/$settings[itemsperpage]));
			$total += $num;
		}
	}

	if (is_array($_POST[infos])) {
		foreach ($_POST[infos] as $v) {
			$DB_site->query("INSERT INTO `".$dbprefix."generate_html` set `gen_id`='".$v."', `type`='pages'");
			$total++;
		}
	}

	echo template('generate_html.html', array('total' => $total));
	exit;
}

////////////////////
// Newsletter Mailer
////////////////////

if ($_GET[action] == "news_mailer") {
	$DB_site->query("TRUNCATE ".$dbprefix."newsletters_recipients");
	$emails = array();

	foreach ($_POST[recipients] as $v) {
		switch ($v) {
			case 'users':
				$add_sql = "WHERE `newsletter`='1'";
				if (is_array($_POST[groups])) $add_sql .= " AND (`group_in` IN (".implode(",", $_POST[groups])."))";
			break;
			default: $add_sql = "";	break;
		}

		$result = $DB_site->query("SELECT * FROM ".$dbprefix.$v." ".$add_sql);
		while ($row = $DB_site->fetch_assoc($result)) {
			if (!in_array($row[email], $emails)) array_push($emails, $row[email]);
		}
	}

	foreach ($emails as $v) $DB_site->query("INSERT INTO ".$dbprefix."newsletters_recipients set email='".sf($v)."'");
	echo template('newsletter_send.html', array('from_name' => urlencode(base64_encode($_POST[from_name])), 'from_email' => urlencode(base64_encode($_POST[from_email])), 'subject' => urlencode(base64_encode($_POST[subject])), 'message' => urlencode(base64_encode($_POST[message])), 'mode' => urlencode(base64_encode($_POST[mode])), 'total' => count($emails)));
	exit;
}

///////////////
// Image Resize
///////////////

if ($_GET[action] == "image") {
	image_output($_GET[location], $_GET[mode]);
	exit;
}

//////////////
// Home Screen
//////////////

if ($_GET[action] == "home") {
	$heading = array($lang['husers'], $lang['hproducts'], $lang['hcategories'], $lang['htransactions'], $lang['hsettings'], $lang['hcoupons']);
	for ($i=0; $i<6; $i++) {
		$sidecont = "";
		while (list($key, $val) = @each($startlink[$i])) {
			$subs = $startlink[$i][$key][sub]; $name = $startlink[$i][$key][name]; $link = $startlink[$i][$key][link];
			$sidecont .= '<a href="'.$link.'" class="side_link">'.$name.'</a>';
		}
		$vars[sidetable] .= sidetable($heading[$i], $sidecont);
	}

	$graphs  = new graphs();

	// Week Graph
	$week = $graphs->week_view(515, 225);
	$out  = starttable("545", $lang['s_sales'], $week, array());

	// Year Graph
	$year  = $graphs->year_view(515, 225);
	$out  .= starttable("545", $lang['y_sales'], $year, array());


}

///////////////////
// Users Management
///////////////////

elseif ($_GET[action] == "users") {

	$vars[sidetable] 	= getside($startlink, 0);

	//////////////////////////////
	// View Users, Admins & Groups
	//////////////////////////////

    if ($_GET[sub] == "view") {
		$_GET[orderby]	= ($_GET[orderby]=='')?'id':$_GET[orderby];
		$_GET[sort]		= ($_GET[sort]=='')?'asc':$_GET[sort];
		$_GET[pg] 		= (isset($_GET[pg]) && $_GET[pg] > 0)?intval($_GET[pg]):0;
		$type			= ($_GET[type]=="")?$lang['users']:$lang[$_GET[type].'s'];
		$status 		= urldecode($_GET[status]);

		if ($_POST[s] != "") {
			$sess->dvar('usearch');
			$sess->svar('usearch', $_POST[s]);
		} elseif ($_POST[s] == "" && $_GET[pg] != "") {
			$_POST[s] = $sess->gvar('usearch');
		} else {
			$sess->dvar('usearch');
		}

		switch ($_GET[type]) {
			case '':
			case 'user':
				$tablestart = contentstart(array(template('form_toggle_checkbox.html', array('cname' => 'selectall', 'name' => 'item', 'form' => 'bulk')), l($lang['id'],"id"), l($lang['last'],"bill_last_name,bill_first_name").", ".l($lang['first'],"bill_first_name,bill_last_name"), $lang['type'], l($lang['lastvisit'],"lastvisit"), $lang['action']), array(), array("center","center","left","left","left","center"), "#536da7", 1);
				$query = (($_POST[s]!="")?user_search($_POST[s]):"SELECT id FROM `".$dbprefix."users`")." order by ".$_GET[orderby]." ".$_GET[sort]." LIMIT ".((($_GET[pg]==0)?0:$_GET[pg]-1)*$settings[admin_user_max]).",".$settings[admin_user_max];
				$vars[sidetable] .= getsidesubs($startlink, 0, 0);
				break;
			case 'group':
				$tablestart = contentstart(array(template('form_toggle_checkbox.html', array('cname' => 'selectall', 'name' => 'item', 'form' => 'bulk')), l($lang['id'],"id"), l($lang['groupname'],"name"), $lang['members'], l($lang['disc'],"discount"), $lang['priceview'], $lang['action']), array(), array("center","center","left","center","center","center","center"), "#536da7", 1);
				$query = "SELECT id FROM `".$dbprefix."groups` order by ".$_GET[orderby]." ".$_GET[sort]." LIMIT ".((($_GET[pg]==0)?0:$_GET[pg]-1)*$settings[admin_user_max]).",".$settings[admin_user_max];
				$vars[sidetable] .= getsidesubs($startlink, 0, 2);
				break;
			case 'admin':
				$tablestart = contentstart(array(template('form_toggle_checkbox.html', array('cname' => 'selectall', 'name' => 'item', 'form' => 'bulk')), l($lang['id'],"id"), l($lang['username'],"username"), l($lang['lastvisit'],"lastvisit"), $lang['action']), array(), array("center","center","left","left","left"), "#536da7", 1);
				$query = "SELECT id FROM `".$dbprefix."admins` order by ".$_GET[orderby]." ".$_GET[sort]." LIMIT ".((($_GET[pg]==0)?0:$_GET[pg]-1)*$settings[admin_user_max]).",".$settings[admin_user_max];
				$vars[sidetable] .= getsidesubs($startlink, 0, 1);
				break;
		}

		$append = preg_replace('/pg=([0-9]*)/', '', (($_GET[pg]=="")?'&amp;':'').htmlentities($_SERVER["QUERY_STRING"]));
		$page = new pager($query, template('list_pages_output.html', array(), 0), 5, $settings[admin_user_max], $_GET[pg], $append);
		$list[pages] = $page->paginate();

		$table1content  = $list[pages]."<br />";
		$table1content .= $forms->start(array('name' => 'bulk', 'url' => 'adminindex.php?action=users&sub=view'.(($_GET[type]!="")?'&type='.$_GET[type]:''), 'hide' => 'Table'));
		$table1content .= $tablestart;

		$results = $DB_site->query($query);
		while ($row = $DB_site->fetch_assoc($results)) {
			switch ($_GET[type]) {
				case '':
				case 'user':
					$user = get('users', $row[id]);
					$links = ($admin[manage_users]==1)?icon(2,"adminindex.php?action=users&sub=edit&type=user&id=$row[id]").icon(3,"adminindex.php?action=users&sub=delete&type=user&id=$row[id]\" onclick=\"return jsconfirm();"):'None';
					$table1content .= content(array(template('form_checkbox.html', array('value' => $row[id], 'name' => 'item[]')), $row[id], $user[bill_last_name].", ".$user[bill_first_name], $user[group_name], ($user[lastvisit]!="NEVER")?@date($settings[datestamp], $user[lastvisit]).' '.@date($settings[timestamp], $user[lastvisit]):$user[lastvisit], $links), array(), array("center","center","left","left","left","center"));
					break;
				case 'group':
					$group = get('groups', $row[id]);
					$res = $DB_site->query("SELECT * from `".$dbprefix."users` where `group_in`='$row[id]'");
					$count = $DB_site->num_rows($res);
					$links = ($admin[manage_groups]==1)?icon(2,"adminindex.php?action=users&sub=edit&type=group&id=$row[id]").(($row[id]!=1)?icon(3,"adminindex.php?action=users&sub=delete&type=group&id=$row[id]\" onclick=\"return jsconfirm(');"):''):'None';
					$table1content .= content(array(template('form_checkbox.html', array('value' => $row[id], 'name' => 'item[]')), $row[id], $group[name], $count, $group[discount].'%', ($group[showprices]=="1")?'Yes':'No', $links), array(), array("center","center","left","center","center","center","center"));
					break;
				case 'admin':
					$min = get('admins', $row[id]);
					$links = ($admin[manage_admins]==1)?icon(2,"adminindex.php?action=users&sub=edit&type=admin&id=$row[id]").icon(3,"adminindex.php?action=users&sub=delete&type=admin&id=$row[id]\" onclick=\"return jsconfirm();"):'None';
					$table1content .= content(array(template('form_checkbox.html', array('value' => $row[id], 'name' => 'item[]')), $row[id], $min[username], ($min[lastvisit]!="NEVER" && $min[lastvisit]!="")?@date($settings[datestamp], $min[lastvisit]).' '.@date($settings[timestamp], $min[lastvisit]):$min[lastvisit], $links), array(), array("center","center","left","left","left"));
					break;
			}
		}
		$table1content .= contentend();
		$table1content .= bulk_action().$forms->end(array('hide' => 'Table'));
		$table1content .= "<br />".$list[pages];

		$grouplist1 = get_data_array('groups', 'id', 'name');
		$grouplist2 = get_data_array('groups', 'name', 'name');
		array_unshift($grouplist1, 0); array_unshift($grouplist2, $lang['all_groups']);
		$groups = $forms->item("dropdown", "", "s[group]", $forms->farray($grouplist1, $grouplist2), '', '', '', array('return_item' => 1, 'style' => 'width: 100%;'));

		$table_search = ($_GET[type]=='' || $_GET[type]=='user')?starttable("545", $lang['user_search'], template('user_search.html', array('groups' => $groups)), array()).'<br />':'';

		$out = (($status!="")?status($status):"").$table_search.starttable("545", $type, $table1content, array('style' => ((3<2)?'height: 50px;':'')));
	}

	//////////////
	// Store Users
	//////////////

	if ($_GET[sub] == "store") {
		$result = $DB_site->query_first("SELECT * FROM ".$dbprefix.$_GET[type]."s where `".(($_GET[type]=='group')?'name':'username')."`='".(($_GET[type]=='group')?$_POST[name]:$_POST[username])."'");
		if (isset($result[id])) {
			$_GET[sub] = "add";
			$status = $lang['u_exists'];
		} else {
			$query = "INSERT into ".$dbprefix.$_GET[type]."s set";
			$result = $DB_site->query("DESCRIBE ".$dbprefix.$_GET[type]."s");
			while ($field = $DB_site->fetch_assoc($result)) {
				if (($_GET[type] == 'user' || $_GET[type] == 'admin') && $field['Field'] == 'password' && $_POST[$field['Field']] != '') $_POST[password] = md5($_POST[password]);
				if (isset($_POST[$field['Field']]))
					$query .= " `".$field['Field']."`='".sf($_POST[$field['Field']])."',";
			}
			if ($_GET[type] == 'admin') {
				for ($i=0; $i<count($manages); $i++) {
					$query .= " ".$manages[$i]."='".$_POST[manage][$manages[$i]]."',";
				}
			}
			$DB_site->query(substr($query, 0, -1));

			$status = urlencode($lang['store_s'].' '.$_GET[type]);
			header("location: adminindex.php?action=users&sub=view&type=".$_GET[type].'&status='.$status);
			exit;
		}
	}

	///////////////
	// Update Users
	///////////////

	if ($_GET[sub] == "update") {
		$query 	= "UPDATE ".$dbprefix.$_GET[type]."s set";
		$result = $DB_site->query("DESCRIBE ".$dbprefix.$_GET[type]."s");
		while ($field = $DB_site->fetch_assoc($result)) {
			if (($_GET[type] == 'user' || $_GET[type] == 'admin') && $field['Field'] == 'password' && $_POST[$field['Field']] == '') unset($_POST[$field['Field']]);
			if ($field['Field'] == 'password' && $_POST[$field['Field']] != '') $_POST[password] = md5($_POST[password]);
			if (isset($_POST[$field['Field']]))
				$query .= " `".$field['Field']."`='".sf($_POST[$field['Field']])."',";
		}
		if ($_GET[type] == 'admin') {
			for ($i=0; $i<count($manages); $i++) {
				$query .= " ".$manages[$i]."='".$_POST[manage][$manages[$i]]."',";
			}
		}
		$query .= " `id`='".$_POST[id]."' where `id`='".$_POST[id]."'";
		$DB_site->query($query);

		$rewards = $DB_site->query_first("SELECT * FROM `".$dbprefix."users_rewards` WHERE `userid`='".$_POST[id]."'");
		if ($rewards[id] != "") $DB_site->query("UPDATE `".$dbprefix."users_rewards` set `total`='".sf($_POST[rewards_total])."', `pending`='".sf($_POST[rewards_pending])."' WHERE `userid`='".$_POST[id]."'");
		else $DB_site->query("INSERT INTO `".$dbprefix."users_rewards` set `userid`='".$_POST[id]."', `total`='".sf($_POST[rewards_total])."', `pending`='".sf($_POST[rewards_pending])."'");

		if ($_GET[type] == 'user') update_custom($_POST[customfield][users], 'users', 'userid', $_POST[id], true);

		header("location: adminindex.php?action=users&sub=view&type=".$_GET[type].'&status='.urlencode($lang['update_s'].' '.$_GET[type].' #'.$_POST[id]));
		exit;
	}

	///////////////////
	// Add & Edit Users
	///////////////////

	if ($_GET[sub] == "add" || $_GET[sub] == "edit") {
		$do 	= ($_GET[sub]=="add")?'store':'update';
		$word 	= ($_GET[sub]=="add")?$lang['add']:$lang['edit'];
		$type	= ($_GET[type]=="")?$lang['user']:$lang[$_GET[type]];

		switch ($_GET[type]) {
			case '':
			case 'user':
				$vars[sidetable] .= getsidesubs($startlink, 0, 0);
				$info = get('users', $_GET[id]);
				$info = ($status!="")?$_POST:$info;

				if ($_GET[redirect] == 1) {
					$hash = hash_me($info);	header('location: '.$settings[shopurl].'index.php?l=hashlogin&hash='.$hash); exit;
				}

				$info[bill_country]	= ($info[bill_country]=="")?$settings[country]:$info[bill_country];
				$info[ship_country]	= ($info[ship_country]=="")?$settings[country]:$info[ship_country];

				$grouplist1 = get_data_array('groups', 'id', 'name');
				$grouplist2 = get_data_array('groups', 'name', 'name');
				$statelist1 = get_data_array('state_country', 'abb',  'type, name', 'WHERE type=\''.STATE.'\' OR type=\'3\'');
				$statelist2 = get_data_array('state_country', 'name',  'type, name', 'WHERE type=\''.STATE.'\' OR type=\'3\'');
				$countrylist1 = get_data_array('state_country', 'abb',  'name', 'WHERE type=\''.COUNTRY.'\'');
				$countrylist2 = get_data_array('state_country', 'name',  'name', 'WHERE type=\''.COUNTRY.'\'');
				array_unshift($statelist1, '');
				array_unshift($statelist2, '');

				$start = $forms->start(array('url' => 'adminindex.php?action=users&type=user&sub='.$do, 'name' => 'update_user'));
				$start .= ($_GET[sub]=="edit")?$forms->item("hidden", "", "id", "", $_GET[id]):'';
				$start .= ($_GET[sub]=="edit")?$forms->item("show", $lang['username'], "", "", $info[username].'&nbsp;&nbsp; (<a href="adminindex.php?action=users&sub=edit&id='.$info[id].'&redirect=1" target="_SSFRONT">'.$lang[lau].'</a>)'):'';
				$start .= ($_GET[sub]=="edit")?$forms->item("hidden", "", "username", "", $info[username]):'';
				$start .= ($_GET[sub]!="edit")?$forms->item("textbox", help($lang['username'], $lang['userdesc']), "username", "", $info[username], 15):'';
				$start .= $forms->item("textbox", help($lang['password'], $lang['pwduser']), "password", "", '', 15);
				$start .= $forms->item("textbox", help($lang['phone'], $lang['phoneuser']), "phone", "", $info[phone], 15);
				$start .= $forms->item("textbox", help($lang['email'], $lang['emailuser']), "email", "", $info[email], 30);
				$start .= $forms->item("dropdown", help($lang['usrgroup'], $lang['groupuser']), "group_in", $forms->farray($grouplist1, $grouplist2), $info[group_in]);
				$start .= $forms->item("radio", help($lang['newslet'], $lang['newslet_d']), "newsletter", $forms->farray(array("1","0"), array($lang['optin'],$lang['optout'])), $info[newsletter]);
				$start .= $forms->end(array('hide' => 'Form'));

				$form  = $forms->start(array('hide' => 'Form'));
				$form .= $forms->item("textbox", help($lang['firstn'], $lang['firstn_d']),  "bill_first_name", "", $info[bill_first_name], 20);
				$form .= $forms->item("textbox", help($lang['lastn'], $lang['lastn_d']),  "bill_last_name", "", $info[bill_last_name], 20);
				$form .= $forms->item("textbox", help($lang['companyn'], $lang['companyn_d']),  "bill_company_name", "", $info[bill_company_name], 30);
				$form .= $forms->item("textbox", help($lang['addr1bill'], $lang['baddr']), "bill_address1", "", $info[bill_address1], 30);
				$form .= $forms->item("textbox", help($lang['addr2bill'], $lang['baddr2']), "bill_address2", "", $info[bill_address2], 30);
				$form .= $forms->item("textbox", help($lang['city'], $lang['bcity']), "bill_city", "", $info[bill_city], 15);
				$form .= $forms->item("dropdown", help($lang['state'], $lang['bstate']), "bill_state", $forms->farray($statelist1, $statelist2), $info[bill_state]);
				$form .= $forms->item("textbox", help($lang['stateo'], $lang['stateo_d']), "bill_other", "", $info[bill_other], 15);
				$form .= $forms->item("textbox", help($lang['zip'], $lang['bzip']), "bill_zip", "", $info[bill_zip], 15);
				$form .= $forms->item("dropdown", help($lang['country'], $lang['bcountry']), "bill_country", $forms->farray($countrylist1, $countrylist2), $info[bill_country]);
				$form .= $forms->item("submit", "", "", "", "$word $type");
				$form .= $forms->end(array('hide' => 'Form'));

				$tab_items = tab_item($lang['billinfo'], $form);

				$form = $forms->start(array('hide' => 'Form'));
				$form .= $forms->item("textbox", help($lang['firstn'], $lang['firstn_d']),  "ship_first_name", "", $info[ship_first_name], 20);
				$form .= $forms->item("textbox", help($lang['lastn'], $lang['lastn_d']),  "ship_last_name", "", $info[ship_last_name], 20);
				$form .= $forms->item("textbox", help($lang['companyn'], $lang['companyn_d']),  "ship_company_name", "", $info[ship_company_name], 30);
				$form .= $forms->item("textbox", help($lang['addr1bill'], $lang['saddr']), "ship_address1", "", $info[ship_address1], 30);
				$form .= $forms->item("textbox", help($lang['addr2bill'], $lang['saddr2']), "ship_address2", "", $info[ship_address2], 30);
				$form .= $forms->item("textbox", help($lang['city'], $lang['scity']), "ship_city", "", $info[ship_city], 15);
				$form .= $forms->item("dropdown", help($lang['state'], $lang['bstate']), "ship_state", $forms->farray($statelist1, $statelist2), $info[ship_state]);
				$form .= $forms->item("textbox", help($lang['stateo'], $lang['stateo_d']), "ship_other", "", $info[ship_other], 15);
				$form .= $forms->item("textbox", help($lang['zip'], $lang['szip']), "ship_zip", "", $info[ship_zip], 15);
				$form .= $forms->item("dropdown", help($lang['country'], $lang['scountry']), "ship_country", $forms->farray($countrylist1, $countrylist2), $info[ship_country]);
				$form .= $forms->item("submit", "", "", "", "$word $type");
				$form .= $forms->end();

				$tab_items .= tab_item($lang['shipinfo'], $form);

				$form = $forms->start(array('hide' => 'Form'));
				$form .= $forms->item("textbox", help($lang['upearned'], $lang['upearned_d']),  "rewards_total", "", $info[rewards_total], 10);
				$form .= $forms->item("textbox", help($lang['uppearned'], $lang['uppearned_d']),  "rewards_pending", "", $info[rewards_pending], 10);
				$form .= $forms->item("submit", "", "", "", "$word $type");
				$form .= $forms->end();

				$tab_items .= tab_item($lang['rewardsp'], $form);

				$order_by = ($_GET[orderby]=='')?'order_stamp':$_GET[orderby];
				$sort_by = ($_GET[sort]=='')?'desc':$_GET[sort];

				$table1content = contentstart(array(template('form_toggle_checkbox.html', array('cname' => 'selectall', 'name' => 'item', 'form' => 'update_user')), l($lang['id'],"id","&tab=3&id=$_GET[id]"), l($lang['date'],"order_stamp","&tab=3&id=$_GET[id]"), l($lang['status'],"status","&tab=3&id=$_GET[id]"), l($lang['total'],"total","&tab=3&id=$_GET[id]"), $lang['action']), array(), array("center","center","left","left","left","center"), "#536da7", 1, "500");
				$results = $DB_site->query("SELECT id FROM `".$dbprefix."orders` WHERE `userid`='".$_GET[id]."' order by `".$order_by."` ".$sort_by."");
				while ($row = $DB_site->fetch_assoc($results)) {
					$tran = get('orders', $row[id]);
					$links  = ($admin[view_trans]==1)?icon(1, "adminindex.php?action=transactions&sub=view&id=$row[id]").icon(6, "adminindex.php?action=transactions&sub=print&id=$row[id]\" target=\"_PLIST").icon(5, "adminindex.php?action=transactions&sub=plist&id=$row[id]\"  target=\"_PLIST"):'';
					$links .= ($admin[manage_trans]==1)?icon(2, "adminindex.php?action=transactions&sub=edit&id=$row[id]").icon(3, "adminindex.php?action=transactions&sub=delete&id=$row[id]\" onclick=\"return jsconfirm();"):'';
					$table1content .= content(array(template('form_checkbox.html', array('value' => $row[id], 'name' => 'item')), $row[id], date($settings[datestamp], $tran[order_stamp]), $tran[status], p($tran[total]), $links), array(), array("center","center","left","left","left","center"));
				}
				$table1content .= contentend();
				$tab_items .= ($_GET[sub]=="edit")?tab_item($lang['orders'], $table1content):'';

				$custom_fields = cf_edit('users', 'userid', $_GET[id]);
				$form  = $forms->start(array('hide' => 'Form'));
				$form .= $custom_fields;
				$form .= $forms->item("submit", "", "", "", "$word $type");
				$form .= $forms->end(array('hide' => 'Form'));

				$tab_items .= ($custom_fields!="")?tab_item($lang['custfields'], $form):'';

				$data = $start.start_tabs($tab_items);
				break;
			case 'group':
				$vars[sidetable] .= getsidesubs($startlink, 0, 2);
				$info = get('groups', $_GET[id]);
				$info = ($status!="")?$_POST:$info;

				$form  = $forms->start(array('url' => 'adminindex.php?action=users&type=group&sub='.$do));
				$form .= ($_GET[sub]=="edit")?$forms->item("hidden", "", "id", "", $info[id]):'';
				$form .= $forms->item("textbox", help($lang['groupname'], $lang['namegroup']), "name", "", $info[name], 30);
				$form .= $forms->item("textbox", help($lang['disc'], $lang['discgroup']), "discount", "", $info[discount], 5, '', array('follow' => '%'));
				$form .= $forms->item("radio", help($lang['addtax'], $lang['taxgroup']), "taxable", $forms->farray(array("1","0"), array($lang['yes'],$lang['no'])), ($info[taxable]=="")?1:$info[taxable]);
				$form .= $forms->item("radio", help($lang['showretail'], $lang['retailgroup']), "showretail", $forms->farray(array("1","0"), array($lang['yes'],$lang['no'])), ($info[showretail]=="")?1:$info[showretail]);
				$form .= $forms->item("radio", help($lang['showprice'], $lang['pricegroup']), "showprices", $forms->farray(array("1","0"), array($lang['yes'],$lang['no'])), ($info[showprices]=="")?1:$info[showprices]);
				$form .= $forms->item("submit", "", "", "", "$word $type");
				$form .= $forms->end();

				$data = $form;
				break;
			case 'admin':
				$vars[sidetable] .= getsidesubs($startlink, 0, 1);
				$info = get('admins', $_GET[id]);
				$info = ($status!="")?$_POST:$info;

				$form  = $forms->start(array('url' => 'adminindex.php?action=users&type=admin&sub='.$do));
				$form .= ($_GET[sub]=="edit")?$forms->item("hidden", "", "id", "", $info[id]):'';
				$form .= ($_GET[sub]=="edit")?$forms->item("hidden", "", "olduserid", "", $info[userid]):'';
				$form .= $forms->item("textbox", help($lang['name'], $lang['name_d']), "name", "", $info[name]);
		    	$form .= $forms->item("textbox", help($lang['email'], $lang['opemail']), "email", "", $info[email]);
				$form .= $forms->item("textbox", help($lang['username'], $lang['username_d']), "username", "", $info[username], 12);
				$form .= $forms->item("textbox", help($lang['password'], $lang['oppass']), "password", "", "", 12);
				for ($i=0; $i<count($manages); $i++) {
					$form .= $forms->item("radio", help($lang[$manages[$i]], $lang['perms'][$manages[$i]]), "manage[".$manages[$i]."]", $forms->farray(array(1,0), array($lang['yes'],$lang['no'])), (($info[$manages[$i]]=="")?'1':$info[$manages[$i]]));
				}
				$form .= $forms->item("submit", "", "", "", "$word $type");
				$form .= $forms->end();

				$data = $form;
				break;
		}

		$out = (($status!="")?status($status):"").starttable("545", "$word $type", $data, array());
	}

	/////////
	// Delete
	/////////

	if ($_GET[sub] == "delete") {
		$DB_site->query("DELETE from ".$dbprefix.$_GET[type]."s where id='".$_GET[id]."'");
		header("location: adminindex.php?action=users&sub=view&type=".$_GET[type].'&status='.urlencode($lang['succd'].' '.$_GET[type].' #'.$_GET[id]));
		exit;
	}

	//////////////////
	// Newsletter Send
	//////////////////

	if ($_GET[sub] == "mail") {
		$grouplist1 = get_data_array('groups', 'id', 'name');
		$grouplist2 = get_data_array('groups', 'name', 'name');

		$form = $forms->start(array('url' => 'adminindex.php?action=news_mailer" target="news_mailer" onsubmit="window.open(\'\', this.target, \'directories=no,status=no,location=no,menubar=no,toolbar=no,scrollbars=no,resizable=no,width=300,height=200\');'));
		$form .= $forms->item("dropdown", help($lang['recipients'], $lang['recipients_d']), "recipients", $forms->farray(array('users', 'admins', 'vendors', 'newsletters_list'), array($lang['users'], $lang['admins'], $lang['vendors'], $lang['news_signups'])), array('users'), '', '', array('multi' => 1));
		$form .= $forms->item("dropdown", help($lang['userg'], $lang['userg_d']), "groups", $forms->farray($grouplist1, $grouplist2), $grouplist1, '', '', array('style' => 'height: 45px;', 'multi' => 1));
		$form .= $forms->item("dropdown", help($lang['format'], $lang['format_d']), "mode", $forms->farray(array('false', 'true'), array($lang['plaint'], $lang['html'])), 'html');
		$form .= $forms->end(array('hide' => 'Form'));

		$out = starttable("545", $lang['newsletters'], $form, array());

		$form = $forms->start(array('hide' => 'Form'));
		$form .= $forms->item("textbox", help($lang['fromn'], $lang['fromn_d']), "from_name", "", $settings[companyname], 35);
		$form .= $forms->item("textbox", help($lang['frome'], $lang['frome_d']), "from_email", "", $settings[contactemail], 35);
		$form .= $forms->item("textbox", help($lang['subject'], $lang['subject_d']), "subject", "", "", 35);
		$form .= $forms->item("textarea", help($lang['message'], $lang['message_d']), "message", "", "", 75, 20);
		$form .= $forms->item("show", "", "", "", "<a href=\"javascript:adv_editor('message');\">".$lang['advancede']."</a>", 0, 0);
		$form .= $forms->item("submit", "", "", "", $lang['send'].' '.$lang['newsletter']);
		$form .= $forms->end(array('hide' => 'Form'));

		$out .= "<br />".starttable("545", $lang['newsletter'], $form, array());
	}
}

//////////////////////
// Products Management
//////////////////////

elseif ($_GET[action] == "products") {

	$vars[sidetable] 	= getside($startlink, 1);

	/////////////////
	// Delete Product
	/////////////////

    if ($_GET[sub] == "delete") {
		$results = $DB_site->query("SELECT dr.* FROM `".$dbprefix."discounts` d ".
		"LEFT JOIN `".$dbprefix."discounts_relation` dr ON d.`id`=dr.`discountid` ".
		"WHERE dr.`relationid`='".$_GET[id]."' ".
		"AND d.`type`='P'");
		while ($row = $DB_site->fetch_assoc($results)) {
			$DB_site->query("DELETE FROM `".$dbprefix."discounts_relation` WHERE `id`='".$row[id]."'");
		}

		$results = $DB_site->query("SELECT po.* FROM `".$dbprefix."products_options` po ".
		"LEFT JOIN `".$dbprefix."products_options_items` oi ON po.`id`=oi.`optionid` ".
		"WHERE po.`productid`='".$_GET[id]."'");
		while ($row = $DB_site->fetch_assoc($results)) {
			$DB_site->query("DELETE FROM `".$dbprefix."products_options_items` WHERE `optionid`='".$row[id]."'");
			$DB_site->query("DELETE FROM `".$dbprefix."products_options` WHERE `id`='".$row[id]."'");
		}

		$DB_site->query("DELETE FROM `".$dbprefix."products_attributes` WHERE `productid`='".$_GET[id]."'");
		$DB_site->query("DELETE FROM `".$dbprefix."products_categories` WHERE `productid`='".$_GET[id]."'");
		$DB_site->query("DELETE FROM `".$dbprefix."products_dl_count` WHERE `productid`='".$_GET[id]."'");
		$DB_site->query("DELETE FROM `".$dbprefix."products_downloads` WHERE `productid`='".$_GET[id]."'");
		$DB_site->query("DELETE FROM `".$dbprefix."products_images` WHERE `productid`='".$_GET[id]."'");
		$DB_site->query("DELETE FROM `".$dbprefix."products_pricing` WHERE `productid`='".$_GET[id]."'");
		$DB_site->query("DELETE FROM `".$dbprefix."products_related` WHERE `productid`='".$_GET[id]."'");
		$DB_site->query("DELETE FROM `".$dbprefix."products_reviews` WHERE `productid`='".$_GET[id]."'");
		$DB_site->query("DELETE FROM `".$dbprefix."users_wishlist` WHERE `productid`='".$_GET[id]."'");
		$DB_site->query("DELETE FROM `".$dbprefix."products` WHERE `id`='".$_GET[id]."'");

		$status = $lang['producth'];
		$_GET[sub] = "view";
	}

	/////////////////////////////////////////
	// Pre Clone Product Options & Attributes
	/////////////////////////////////////////

	if ($_GET[sub] == "preclone") {
		$type	= ucfirst($_GET[type]);
		$info	= get('products_'.$_GET[type].'s', (($_POST[id]!="")?$_POST[id]:$_GET[id]));
		$prod	= get('products', $info[productid]);
		$select	= get_data_array('products_'.$_GET[type].'s', 'productid', 'id', "WHERE `name`='".sf($info[name])."' AND ".(($_GET[type]=='option')?"`default`='".sf($info['default'])."'":"`value`='".sf($info['value'])."'"));
		$items	= $forms->item("itemlist", "", "products", "", $select, "", "", array('style' => 'width: 380px; height: 100px;', 'return_item' => 1, 'multi' => 1));
		$form  = $forms->start(array('name' => 'fClone', 'url' => 'adminindex.php?action=products&sub=clone&type='.$_GET[type]));
		$form .= $forms->item("hidden", "", "id", "", $_GET[id]);
		$form .= $forms->item("show", $lang['product'].":", "", "", '<a href="adminindex.php?action=products&sub=edit&id='.$info[productid].'&tab='.(($_GET[type]=="option")?'5':'6').'">'.$prod[title].'</a>');
		$form .= $forms->item("show", "$type ".$lang['name'].":", "", "", $info[name].'<br />');
		$form .= $forms->item("show", (($_GET[type]=='option')?$lang['defaultv'].":":"Value:"), "", "", (($_GET[type]=='option')?$info['default']:$info[value]).'<br /><br />');
		$form .= $forms->item("catlist", help($lang['productsi'], $lang['productsi_d']), "cats", "", "", "", "", array('style' => 'width: 380px; height: 100px;', 'multi' => 1, 'onchange' => 'updateClone(\'fClone\', \''.$_GET[type].'\', '.$_GET[id].');'));
		$form .= $forms->item("show", help($lang['hproducts']."*", ""), "", "", '<span id="itemList">'.$items.'</span>');
		$form .= $forms->item("show", "", "", "", $lang['itemssel_s'], "", "", "");
		$form .= $forms->item("submit", "", "", "", $lang['clone']." $type");
		$form .= $forms->end(array('hide' => 'Form'));

		$out = starttable("545", $lang['choosep'], $form);
	}

	///////////////////////////////////////////////
	// Clone Products, Product Options & Attributes
	///////////////////////////////////////////////

	if ($_GET[sub] == "clone") {
		switch ($_GET[type]) {
			case 'attribute':
			case 'option':
				$type	= ucfirst($_GET[type]);
				$info = get('products_'.$_GET[type].'s', $_POST[id]);
				foreach ($_POST[products] as $id) {
					$already = $DB_site->query_first("SELECT * FROM `".$dbprefix."products_".$_GET[type]."s` WHERE `productid`='$id' AND `name`='".sf($info[name])."' AND ".(($_GET[type]=='option')?"`default`='".sf($info['default'])."'":"`value`='".sf($info['value'])."'"));
					if ($already[id] == "") {
						$DB_site->query("INSERT INTO `".$dbprefix."products_".$_GET[type]."s` set `productid`='$id', `name`='".sf($info[name])."', `dorder`='".sf($info[dorder])."', ".(($_GET[type]=='option')?"`description`='".sf($info['description'])."', `default`='".sf($info['default'])."', `type`='".sf($info['type'])."', `length`='".sf($info['length'])."'":"`value`='".sf($info['value'])."'"));
						$option_id = $DB_site->insert_id();
					} else {
						$option_id = $already[id];
					}
					if ($_GET[type] == 'option') {
						$items = $DB_site->query("SELECT * FROM `".$dbprefix."products_options_items` WHERE `optionid`='".$_POST[id]."'");
						while ($row = $DB_site->fetch_assoc($items)) {
							$already = $DB_site->query_first("SELECT * FROM `".$dbprefix."products_options_items` WHERE optionid='".$option_id."' AND name='".$row[name]."' AND value='".$row[value]."' AND price='".$row[price]."' AND weight='".$row[weight]."' AND sku='".$row[sku]."'");
							if ($already[id] == "") $DB_site->query("INSERT INTO `".$dbprefix."products_options_items` set optionid='".$option_id."', name='".$row[name]."', value='".$row[value]."', price='".$row[price]."', weight='".$row[weight]."', sku='".$row[sku]."', in_stock='".$row[in_stock]."', dorder='".$row[dorder]."'");
						}
					}
				}
				$ops = $DB_site->query("SELECT `id` FROM `".$dbprefix."products_".$_GET[type]."s` WHERE `productid` NOT IN ('".join("','", $_POST[products])."') AND `name`='".sf($info[name])."' AND ".(($_GET[type]=='option')?"`default`='".sf($info['default'])."'":"`value`='".sf($info['value'])."'"));
				while ($row = $DB_site->fetch_assoc($ops)) {
					$DB_site->query("DELETE FROM `".$dbprefix."products_options_items` WHERE `optionid`='".$row[id]."'");
				}
				$DB_site->query("DELETE FROM `".$dbprefix."products_".$_GET[type]."s` WHERE `productid` NOT IN ('".join("','", $_POST[products])."') AND `name`='".sf($info[name])."' AND ".(($_GET[type]=='option')?"`default`='".sf($info['default'])."'":"`value`='".sf($info['value'])."'"));

				$status = "$type ".$lang['cloneh'];
				header('location: adminindex.php?action=products&sub=edit&id='.$info[productid].'&status='.urlencode($status).'&tab='.(($_GET[type]=="option")?'4':'5'));
				exit;
				break;
			default:
				$tables = array(
					array("table" => "products", "key_field" => "id"),
					array("table" => "products_attributes", "key_field" => "productid"),
					array("table" => "products_categories", "key_field" => "productid"),
					array("table" => "products_downloads", "key_field" => "productid"),
					array("table" => "products_images", "key_field" => "productid"),
					array("table" => "products_options", "key_field" => "productid"),
					array("table" => "products_pricing", "key_field" => "productid"),
					array("table" => "products_related", "key_field" => "productid"),
					//array("table" => "products_reviews", "key_field" => "productid"),
				);

				$related = array (
					"products_options" => array(
						array("table" => "products_options_items", "key_field" => "optionid")
					)
				);

				$clone = new clone_tables($tables, $related);
				$clone->process($_GET[id]);

				$prodinfo = get('products', $clone->clone_id);
				$DB_site->query("UPDATE `".$dbprefix."products` set `title`='(CLONE) ".sf($prodinfo[title])."' where `id`='".$clone->clone_id."'");

				$status = $lang['pcloneh'];
				$_GET[sub] = "view";
				break;
		}
	}

	/////////////////
	// Update Product
	/////////////////

	if ($_GET[sub] == "update") {
		$prodinfo = get('products', $_POST[id]);

		switch ($_POST[type]) {
			case 'attributes':
				if (is_array($_POST[ids])) {
					foreach ($_POST[ids] as $k => $v) {
						$DB_site->query("UPDATE `".$dbprefix."products_attributes` set `name`='".sf($_POST[names][$k])."', `value`='".sf($_POST[values][$k])."' where `id`='".$_POST[ids][$k]."'");
					}
				}

				// Output Status
				$_GET[status] = $lang['pattrib'];
				$_GET[sub]	= "edit";
				$_GET[id]	= $_POST[id];
				$_GET[tab]	= 6;
				break;
			case 'pricing':
				if (is_array($_POST[ids])) {
					foreach ($_POST[ids] as $k => $v) {
						$DB_site->query("UPDATE `".$dbprefix."products_pricing` set `groupid`='".sf($_POST[groups][$k])."', `quantity`='".sf($_POST[quantitys][$k])."', `retail`='".sf($_POST[retails][$k])."', `price`='".sf($_POST[prices][$k])."' where `id`='".$_POST[ids][$k]."'");
					}
				}

				// Output Status
				$_GET[status] = $lang['ppricing'];
				$_GET[sub]	= "edit";
				$_GET[id]	= $_POST[id];
				$_GET[tab]	= 7;
				break;
			case 'downloads':
				if (is_array($_POST[ids])) {
					foreach ($_POST[ids] as $k => $v) {
						$DB_site->query("UPDATE `".$dbprefix."products_downloads` set `name`='".sf($_POST[names][$k])."', `filename`='".sf($_POST[filenames][$k])."', `description`='".sf($_POST[descriptions][$k])."' where `id`='".$_POST[ids][$k]."'");
					}
				}

				// Output Status
				$_GET[status] = $lang['pdownloads'];
				$_GET[sub]	= "edit";
				$_GET[id]	= $_POST[id];
				$_GET[tab]	= 8;
				break;
			default:
				// Process Images
				$add 	= array();
				$fullp	= $abs_path.'/'.$settings[productpath];
				foreach ($_FILES as $k => $v) {
					$num_images = count($_FILES[$k][name]);
					for ($i=0; $i<$num_images; $i++) {
						$add 		= array();
						$tmp_array 	= array();
						$tmp_array	= $_FILES[$k];
						if (is_array($tmp_array[name][$i])) {
							foreach ($tmp_array[name][$i] as $k1 => $v2) {
								switch ($k) {
									case 'mainimages'; $existing = $prodinfo[$k1.'_image']; break;
									case 'curimages'; $imginfo = get('products_images', $curimages_ref[$i]); $existing = $imginfo[$k1.'_image']; break;
									case 'addimages'; $existing = 'photo-not-available.jpg'; break;
								}

								if ($tmp_array[name][$i][$k1] != "") {
									$this_name = $tmp_array[name][$i][$k1];
									$this_tmp_name = $tmp_array[tmp_name][$i][$k1];
									$file_type = $tmp_array[type][$i][$k1];
									$new_name = str_replace(' ', '_', $k1.'_'.$_POST[id].'_'.$this_name);

									file_check($this_name, "image", $file_type);

									if (@file_exists($fullp.$new_name)) @unlink($fullp.$new_name);

									if (!move_uploaded_file($this_tmp_name, $fullp.$new_name))
										$errors .= $lang['nouploadimg']."'".$this_name."'.<br>";
									else
									   @chmod($fullp.$new_name, 0777);

									if ($settings[auto_resize] && $settings[resize] != 'none') resize_image($fullp.$new_name, $settings['auto_'.$k1.'_height'], $settings['auto_'.$k1.'_width']);
								} else {
									$server		= $_POST[server];
									$tmp_name	= $server[$k][$i][$k1];
									if ($tmp_name != "") {
										$this_name = $tmp_name;
										$new_name = $k1.'_'.$_POST[id].'_'.str_replace(array($k1.'_'.$_POST[id].'_', ' '), array('', '_'), $this_name);
										if ($new_name != $this_name) {
											if (!@copy($fullp.$this_name, $fullp.$new_name)) $new_name = $this_name;
											if ($settings[auto_resize] && $settings[resize] != 'none') resize_image($fullp.$new_name, $settings['auto_'.$k1.'_height'], $settings['auto_'.$k1.'_width']);
										}
									} else {
										$this_name = "photo-not-available.jpg";
										$new_name = str_replace(' ', '_', $k1.'_'.$_POST[id].'_'.$this_name);
										if (!@copy($abs_path.'/images/'.$this_name, $fullp.$new_name)) $new_name = '';
										if ($settings[auto_resize] && $settings[resize] != 'none') resize_image($fullp.$new_name, $settings['auto_'.$k1.'_height'], $settings['auto_'.$k1.'_width']);
									}
								}

								switch ($k) {
									case 'mainimages'; $DB_site->query("UPDATE `".$dbprefix."products` set `".$k1."_image`='".$new_name."' where `id`='".$_POST[id]."'"); break;
									case 'curimages'; $DB_site->query("UPDATE `".$dbprefix."products_images` set `".$k1."_image`='".$new_name."' where `id`='".$curimages_ref[$i]."'"); break;
									case 'addimages'; $add[$k1] = $new_name; break;
								}
							}
						}
						if ($k == 'addimages') $DB_site->query("INSERT INTO `".$dbprefix."products_images` set `productid`='".$_POST[id]."', `thumb_image`='".$add[thumb]."',  `large_image`='".$add[large]."'");
					}
				}
				// Update Product Data
				$query 	= "UPDATE `".$dbprefix."products` set";
				$result = $DB_site->query("DESCRIBE `".$dbprefix."products`");
				while ($field = $DB_site->fetch_assoc($result)) {
					if (isset($_POST[$field['Field']])) {
						$query .= " `".$field['Field']."`='".sf($_POST[$field['Field']])."',";
					}
				}
				$query .= " `id`='".$_POST[id]."' where `id`='".$_POST[id]."'";
				$DB_site->query($query);

				// Update Additional Categories
				$DB_site->query("DELETE FROM `".$dbprefix."products_categories` where `productid`='".$_POST[id]."'");
				for ($i=0; $i<count($_POST[additional]); $i++) {
					$DB_site->query("INSERT INTO `".$dbprefix."products_categories` set `productid`='".$_POST[id]."', `catid`='".$_POST[additional][$i]."'");
				}

				// Output Status
				$status = $lang['pupdated']."<br>$errors";
				$_GET[sub] = "edit";
				$_GET[id] = $_POST[id];
				break;
		}
	}

	////////////////
	// View Products
	////////////////

    if ($_GET[sub] == "view") {
		$vars[sidetable] .= getsidesubs($startlink, 1, 0);

		$_GET[orderby]	= ($_GET[orderby]=='')?'title':$_GET[orderby];
		$_GET[sort]		= ($_GET[sort]=='')?'asc':$_GET[sort];
		$_GET[pg] 		= (isset($_GET[pg]) && $_GET[pg] > 0)?intval($_GET[pg]):0;

		if (isset($_GET[s][cid])) { $_POST[s][cid] = $_GET[s][cid]; $_POST[s][subcats] = "Y"; $_POST[s][search] = ""; $_POST[s][title] = "Y"; }

		if ($_POST[s] != "") {
			$sess->dvar('search');
			$sess->svar('search', $_POST[s]);
		} elseif ($_POST[s] == "" && $_GET[pg] != "") {
			$_POST[s] = $sess->gvar('search');
		} else {
			$sess->dvar('search');
		}

		$tablestart     = contentstart(array(template('form_toggle_checkbox.html', array('cname' => 'selectall', 'name' => 'item', 'form' => 'bulk')), l($lang['id'],"id"), l($lang['sku'],"sku"), l($lang['title'],"title"), l($lang['price'],"price"), l($lang['prodstock'],"in_stock"), $lang['action']), array(), array("center","center","left","left","left","center","center"), "#536da7", 1);
		$query 	 	= (($_POST[s]!="")?prod_search($_POST[s]):"SELECT id FROM `".$dbprefix."products`")." order by ".$_GET[orderby]." ".$_GET[sort]." LIMIT ".((($_GET[pg]==0)?0:$_GET[pg]-1)*$settings[admin_products_max]).",".$settings[admin_products_max];
		$results 	= $DB_site->query($query);
		$count	 	= $DB_site->num_rows($results);

		$append = preg_replace('/pg=([0-9]*)/', '', (($_GET[pg]=="")?'&amp;':'').htmlentities($_SERVER["QUERY_STRING"]));
		$page = new pager($query, template('list_pages_output.html', array(), 0), 5, $settings[admin_products_max], $_GET[pg], $append);
		$list[pages] = $page->paginate();

		$table1content  = $list[pages]."<br />";
		$table1content .= $forms->start(array('name' => 'bulk', 'url' => 'adminindex.php?action=products&sub=view'.(($_GET[type]!="")?'&type='.$_GET[type]:''), 'hide' => 'Table'));
		$table1content .= $tablestart;

		while ($row = $DB_site->fetch_assoc($results)) {
			$product = get('products', $row[id]); $count = 0;
			$links = ($admin[manage_prods]==1)?icon(2, "adminindex.php?action=products&sub=edit&id=$row[id]").icon(3, "adminindex.php?action=products&sub=delete&id=$row[id]\" onclick=\"return jsconfirm();").icon(7,"adminindex.php?action=products&sub=clone&id=$row[id]"):'None';
			$table1content .= content(array(template('form_checkbox.html', array('value' => $row[id], 'name' => 'item[]')), $row[id], shortenit($product[num], 10), shortenit($product[title], 35), p($product[price]), $product[in_stock], $links), array(), array("center","center","left","left","left","center","center"));
		}
		$table1content .= contentend();
		$table1content .= bulk_action().$forms->end(array('hide' => 'Table'));
		$table1content .= "<br />".$list[pages];


		$catlist1 = get_data_array('categories', 'id', 'title');
		$catlist2 = get_data_array('categories', 'title', 'title');
		$categories = $forms->item("catlist", "", "s[cid]", "", 0, "", "", array('return_item' => '1', 'addblank' => '1', 'blankname' => $lang['incats']));

		$manlist1 = get_data_array('manufacturers', 'id', 'name');
		$manlist2 = get_data_array('manufacturers', 'name', 'name');
		array_unshift($manlist1, 0);
		array_unshift($manlist2, $lang['inmanufacturer']);
		$manufacturers = $forms->item("dropdown", "", "s[mid]", $forms->farray($manlist1, $manlist2), 0, "", "", array('return_item' => 1));

		$table1 = starttable("545", $lang['prods_search'], template('product_search.html', array_merge((($_POST[s]!="")?$_POST[s]:array()), array('manufacturers' => $manufacturers, 'categories' => $categories))), array());
		$table2 = starttable("545", $lang['prods'], $table1content, array());

		$out = "$table1<br>".(($status!="")?status($status):"")."$table2";
	}

	///////////////
	// Add Products
	///////////////

	if ($_GET[sub] == "add") {
		$DB_site->query("INSERT INTO `".$dbprefix."products` set `title`='".$lang['prodblank']."', full_desc=''");
		$_GET[id] = $DB_site->insert_id();
		$_GET[sub] = "edit";
	}

	////////////////
	// Edit Products
	////////////////

    if ($_GET[sub] == "edit") {
		$vars[sidetable] .= getsidesubs($startlink, 1, 0);

		$do 		= 'update';
		$word 		= $lang['edit'];
		$prodinfo	= get('products', $_GET[id]);
		$status		= ($status=="")?urldecode($_GET[status]):$status;

		$manlist1 	= get_data_array('manufacturers', 'id', 'name');
		$manlist2 	= get_data_array('manufacturers', 'name', 'name');
		$vendlist1 	= get_data_array('vendors', 'id', 'company');
		$vendlist2 	= get_data_array('vendors', 'company', 'company');
		$grouplist1 = get_data_array('groups', 'id', 'name');
		$grouplist2	= get_data_array('groups', 'name', 'name');
		array_unshift($grouplist1, 0);
		array_unshift($grouplist2, "All");
		array_unshift($manlist1, 0);
		array_unshift($manlist2, "None");
		array_unshift($vendlist1, 0);
		array_unshift($vendlist2, "None");

		$start  = $forms->start(array('url' => 'adminindex.php?action=products&sub='.$do.'" enctype="multipart/form-data', 'name' => 'product_edit'));
		$start .= $forms->item("hidden", "", "id", "", $prodinfo[id]);
		$start .= $forms->item("textbox", help($lang['sku'], $lang['invnumb']), "sku", "", $prodinfo[sku], 30);
		$start .= $forms->item("textbox", help($lang['title'], $lang['prodtitle']), "title", "", str_replace("&", "&amp;", $prodinfo[title]), 60);
		$start .= $forms->item("catlist", help($lang['mainc'], $lang['prodlist']), "catid", "", $prodinfo[catid], "", "", array('style' => 'width: 338px;'));
		$start .= $forms->item("textarea", help($lang['shortd'], $lang['prodoverdesc']), "short_desc", "", str_replace("&", "&amp;", $prodinfo[short_desc]), 60, 5);
		$start .= $forms->item("textarea", help($lang['fulld'], $lang['proddetdesc']), "full_desc", "", str_replace("&", "&amp;", $prodinfo[full_desc]), 60, 10);
		$start .= $forms->item("show", "", "", "", "<a href=\"javascript:adv_editor('full_desc');\">".$lang['aeditor']."</a>", 0, 0);
		$start .= $forms->item("submit", "", "", "", $lang['produpdate']);
		$start .= $forms->end(array('hide' => 'Form'));

		$form  = $forms->start(array('hide' => 'Form'));
		$form .= $forms->item("images", help($lang['images'], $lang['images_d']), "mainimages", $forms->farray(array("thumb", "detail", "large"), array("Thumb", "Detail", "Large")), array($prodinfo[thumb_image], $prodinfo[detail_image], $prodinfo[large_image]), '', '', array('cnt' => 0));
		$form .= $forms->item("textbox", help($lang['metat'], $lang['metakeysdesc']), "meta_title", "",$prodinfo[meta_title], 63);
		$form .= $forms->item("textbox", help($lang['metakeys'], $lang['metakeysdesc']), "meta_keywords", "",$prodinfo[meta_keywords], 63);
		$form .= $forms->item("textarea", help($lang['metadesc'], $lang['metadescdesc']), "meta_description", "", $prodinfo[meta_description], 60, 5);
		$form .= (count($manlist1)>0)?$forms->item("dropdown", help($lang['mftr'], $lang['mftrset']), "manufacturer", $forms->farray($manlist1, $manlist2), $prodinfo[manufacturer]):'';
		$form .= (count($vendlist1)>0)?$forms->item("dropdown", help($lang['vendor'], $lang['vendorset']), "vendor", $forms->farray($vendlist1, $vendlist2), trim($prodinfo[vendor])):'';
		$form .= $forms->item("dropdown", help($lang['prodavail'], $lang['prodavailto']), "avail_to", $forms->farray($grouplist1, $grouplist2), $prodinfo[avail_to]);
		$form .= $forms->item("textbox", help($lang['prodstock'], $lang['instock']), "in_stock", "", $prodinfo[in_stock], 13);
		$form .= $forms->item("textbox", help($lang['prodretail'], $lang['prodretaildesc']), "list_price", "", $prodinfo[list_price], 13);
		$form .= $forms->item("textbox", help($lang['produprice'], $lang['yourprice']), "price", "", $prodinfo[price], 13);
		$form .= $forms->item("textbox", help($lang['prodsale'], $lang['onsale']), "sale_price", "", $prodinfo[sale_price],13);
		$form .= $forms->item("radio", help($lang['prodtax'], $lang['prodcalctax']), "charge_tax", $forms->farray(array("y","n"), array($lang[yes],$lang[no])), $prodinfo[charge_tax]);
		$form .= $forms->item("radio", help($lang['prodnew'], $lang['prodadnew']), "is_new", $forms->farray(array("y","n"), array($lang[yes],$lang[no])), $prodinfo[is_new]);
		$form .= $forms->item("radio", help($lang['prodfeat'], $lang['prodadfeat']), "is_featured", $forms->farray(array("y","n"), array($lang[yes],$lang[no])), $prodinfo[is_featured]);
		$form .= $forms->item("radio", help($lang['viewable'], $lang['prodviewable']), "viewable", $forms->farray(array("y","n"), array($lang[yes],$lang[no])), $prodinfo[viewable]);
		$form .= $forms->item("radio", help($lang['orderable'], $lang['prodorderable']), "orderable", $forms->farray(array("y","n"), array($lang[yes],$lang[no])), $prodinfo[orderable]);
		$form .= $forms->item("submit", "", "", "", $lang['produpdate']);
		$form .= $forms->end(array('hide' => 'Form'));

		$tab_items .= tab_item("Detail", $form);

		// Product Shipping Settings
		$form  = $forms->start(array('hide' => 'Form'));
		$form .= $forms->item("radio", help($lang['charges'], $lang['charges_d']), "charge_shipping", $forms->farray(array("y","n"), array($lang[yes],$lang[no])), $prodinfo[charge_shipping]);
		$form .= $forms->item("textbox", help($lang['fixeds'], $lang['fixeds_d']), "flat_rate_shipping", "", $prodinfo[flat_rate_shipping], 13);
		$form .= $forms->item("textbox", help($lang['weight'], $lang['weight_d']), "weight", "", $prodinfo[weight], 13, '', array('follow' => $settings[weight_units]));
		$form .= $forms->item("radio", help($lang['seperateb'], $lang['seperateb_d']), "ship_seperatly", $forms->farray(array("y","n"), array($lang[yes],$lang[no])), $prodinfo[ship_seperatly]);
		$form .= $forms->item("textbox", help($lang['boxl'], $lang['boxl_d']), "box_length", "", $prodinfo[box_length], 13, '', array('follow' => $settings[dimension_units]));
		$form .= $forms->item("textbox", help($lang['boxw'], $lang['boxw_d']), "box_width", "", $prodinfo[box_width], 13, '', array('follow' => $settings[dimension_units]));
		$form .= $forms->item("textbox", help($lang['boxh'], $lang['boxh_d']), "box_height", "", $prodinfo[box_height], 13, '', array('follow' => $settings[dimension_units]));
		$form .= $forms->item("textbox", help($lang['maxp'], $lang['maxp_d']), "max_per_box", "", $prodinfo[max_per_box], 13);
		$form .= $forms->item("submit", "", "", "", $lang['produpdate']);
		$form .= $forms->end(array('hide' => 'Form'));

		$tab_items .= tab_item("Ship", $form);

		// Product Additional Images
		$form  = $forms->start(array('hide' => 'Form'));
		$results = $DB_site->query("SELECT * from `".$dbprefix."products_images` where `productid`='".$prodinfo[id]."' ORDER by `dorder`"); $cnt = 0;
		while ($row = $DB_site->fetch_assoc($results)) {
			$form .= $forms->item("images", "", "curimages", $forms->farray(array("thumb", "large"), array("Add Thumb", "Add Large")), array($row[thumb_image], $row[large_image]), '', '', array('divid' => 'img_'.$row[id], 'cnt' => $cnt, 'id' => ($cnt*2), 'image_id' => $row[id], 'hide' => 'X')); $cnt++;
		}
		$form .= $forms->item("show", "", "", "", template('add_images.html', array()), 0, 0);
		$form .= $forms->item("submit", "", "", "", $lang['produpdate']);
		$form .= $forms->end(array('hide' => 'Form'));

		$tab_items .= tab_item("Images", $form);

		// Product Secondary Categories
		$catslist = get_data_array('products_categories', 'catid', "id", "WHERE `productid`='$prodinfo[id]'");
		$form  = $forms->start(array('hide' => 'Form'));
		$form .= $forms->item("catlist", help($lang['additionalc'], $lang['prodlist']), "additional", "", $catslist, "", "", array('style' => 'width: 355px;', 'multi' => 1));
		$form .= $forms->item("submit", "", "", "", $lang['produpdate']);
		$form .= $forms->end();

		$tab_items .= tab_item("Categories", $form);

		// Product Options
		$content  = $forms->start(array('name' => 'bulk', 'url' => 'action=products&sub=edit&id='.$prodinfo[id].'&tab=5', 'hide' => 'Table'));
		$content .= contentstart(array(template('form_toggle_checkbox.html', array('cname' => 'selectall', 'name' => 'item', 'form' => 'bulk')), $lang['pos'], $lang['name'], $lang['type'], $lang['action']), array(), array("center","center","left","left","center"), "#536da7", 1, "500");
		$results = $DB_site->query("SELECT * FROM `".$dbprefix."products_options` where `productid`='".$prodinfo[id]."' order by dorder");
		while ($row = $DB_site->fetch_assoc($results)) {
			$row = filter_data($row);
			$links = icon(2, "adminindex.php?action=products&sub=options&id=$row[id]")." ".icon(3, "javascript:void(0);\" onclick=\"delOption('opt_$row[id]');").icon(7,"adminindex.php?action=products&sub=preclone&type=option&id=$row[id]");
			$move = template('move_up_down.html', array('type' => 'products_options', 'id' => $row[id], 'extra' => '&pid='.$prodinfo[id].'&tab=4'));
			$content .= content(array(template('form_checkbox.html', array('value' => $row[id], 'name' => 'item[]')), $move, $row[name], ucfirst(($row[type]=='select')?'dropdown':$row[type]), $links), array(), array("center","center","left","left","center"), 'opt_'.$row[id]);
		}
		$content .= contentend().bulk_action().$forms->end(array('hide' => 'Table'));
		$content .= template('add_options.html', array('productid' => $prodinfo[id]));

		$tab_items .= tab_item("Options", $content);

		// Product Attributes
		$atts = contentstart(array(template('form_toggle_checkbox.html', array('cname' => 'selectall', 'name' => 'item', 'form' => 'editAtts')), $lang['pos'], $lang['name'], $lang['value'], $lang['action']), array(), array("center","center","left","left","center"), "#536da7", 1, "500");
		$results = $DB_site->query("SELECT * FROM `".$dbprefix."products_attributes` where `productid`='".$prodinfo[id]."' order by dorder"); $num = 0;
		while ($row = $DB_site->fetch_assoc($results)) {
			$row 	= filter_data($row);
			$links 	= icon(3, "javascript:void(0);\" onclick=\"delAttribute('att_$row[id]');").icon(7,"adminindex.php?action=products&sub=preclone&type=attribute&id=$row[id]");
			$move 	= template('move_up_down.html', array('type' => 'products_attributes', 'id' => $row[id], 'extra' => '&pid='.$prodinfo[id].'&&tab=5'));
			$hide 	= $forms->item("hidden", "", 'ids['.$num.']', "", $row[id], "", "", array('return_item' => 1));
			$name 	= $forms->item("textbox", "", 'names['.$num.']', "", $row[name], "33", "", array('return_item' => 1));
			$value	= $forms->item("textbox", "", 'values['.$num.']', "", $row[value], "33", "", array('return_item' => 1));
			$atts  .= content(array(template('form_checkbox.html', array('value' => $row[id], 'name' => 'item[]')), $move.$hide, $name, $value, $links), array(), array("center","center","left","left","center"), 'att_'.$row[id]);
			$num++;
		}
		$listend = contentend().bulk_action();
		$content = template('add_attributes.html', array('productid' => $prodinfo[id], 'attribute_list' => $atts, 'listend' => $listend, 'id' => $_GET[id]));

		$tab_items .= tab_item("Attributes", $content);

		// Additional Product Pricing
		$pricing = contentstart(array(template('form_toggle_checkbox.html', array('cname' => 'selectall', 'name' => 'item', 'form' => 'editPri')), $lang['qty'], $lang['retail'], $lang['price'], $lang['group'], $lang['action']), array(), array("center","center","left","left","left","center"), "#536da7", 1, "500");
		$results = $DB_site->query("SELECT * FROM `".$dbprefix."products_pricing` where `productid`='".$prodinfo[id]."' order by quantity"); $num = 0;
		while ($row = $DB_site->fetch_assoc($results)) {
			$row 	= filter_data($row);
			$links 	= icon(3, "javascript:void(0);\" onclick=\"delPricing('pri_$row[id]');");
			$hide 	= $forms->item("hidden", "", 'ids['.$num.']', "", $row[id], "", "", array('return_item' => 1));
			$group	= $forms->item("dropdown", "", 'groups['.$num.']', $forms->farray($grouplist1, $grouplist2), $row[groupid], "", "", array('return_item' => 1, 'style' => 'width: 150px;'));
			$quan 	= $forms->item("textbox", "", 'quantitys['.$num.']', "", $row[quantity], "7", "", array('return_item' => 1));
			$retail = $forms->item("textbox", "", 'retails['.$num.']', "", p($row[retail], false), "7", "", array('return_item' => 1));
			$price	= $forms->item("textbox", "", 'prices['.$num.']', "", p($row[price], false), "7", "", array('return_item' => 1));
			$pricing .= content(array(template('form_checkbox.html', array('value' => $row[id], 'name' => 'item[]')), $hide.$quan, (($settings[cs_pos]=='before')?$settings[cs]:'').$retail.(($settings[cs_pos]=='after')?$settings[cs]:''), $settings[cs].$price, $group, $links), array(), array("center","center","left","left","left","center"), 'pri_'.$row[id]);
			$num++;
		}
		$listend = contentend().bulk_action();
		$pri_group = $forms->item("dropdown", "", "group", $forms->farray($grouplist1, $grouplist2), "", "", "", array('return_item' => 1, 'style' => 'width: 100%;'));
		$content = template('add_pricing.html', array('productid' => $prodinfo[id], 'group' => $pri_group, 'price_list' => $pricing, 'listend' => $listend, 'id' => $_GET[id]));

		$tab_items .= tab_item("Pricing", $content);

		// Product Downloads
		$downloads = contentstart(array(template('form_toggle_checkbox.html', array('cname' => 'selectall', 'name' => 'item', 'form' => 'editDwn')), $lang['name'], $lang['filen2'], $lang['description'], $lang['action']), array(), array("center","left","left","left","center"), "#536da7", 1, "500");
		$results = $DB_site->query("SELECT * FROM `".$dbprefix."products_downloads` where `productid`='".$prodinfo[id]."' order by name"); $num = 0;
		while ($row = $DB_site->fetch_assoc($results)) {
			$row = filter_data($row);
			$links = icon(3, "javascript:void(0);\" onclick=\"delDownload('dwn_$row[id]');");
			$hide 	= $forms->item("hidden", "", 'ids['.$num.']', "", $row[id], "", "", array('return_item' => 1));
			$name 	= $forms->item("textbox", "", 'names['.$num.']', "", $row[name], "21", "", array('return_item' => 1));
			$fname	= $forms->item("textbox", "", 'filenames['.$num.']', "", $row[filename], "21", "", array('return_item' => 1));
			$desc	= $forms->item("textbox", "", 'descriptions['.$num.']', "", $row[description], "30", "", array('return_item' => 1));
			$downloads .= content(array(template('form_checkbox.html', array('value' => $row[id], 'name' => 'item[]')), $hide.$name, $fname, $desc, $links), array(), array("center","left","left","left","center"), 'dwn_'.$row[id]);
			$num++;
		}
		$listend = contentend().bulk_action();
		$content = template('add_download.html', array('productid' => $prodinfo[id], 'down_list' => $downloads, 'listend' => $listend, 'id' => $_GET[id]));

		$tab_items .= tab_item("Files", $content);

		// Releated Products
		$content  = $forms->start(array('name' => 'bulk2', 'url' => 'action=products&sub=edit&id='.$prodinfo[id].'&tab=9', 'hide' => 'Table'));
		$content .= contentstart(array(template('form_toggle_checkbox.html', array('cname' => 'selectall', 'name' => 'item', 'form' => 'bulk2')), $lang['pos'], $lang['prodname'], $lang['action']), array(), array("center","center","left","center"), "#536da7", 1, "500");
		$results = $DB_site->query("SELECT * FROM `".$dbprefix."products_related` where `productid`='".$prodinfo[id]."' order by dorder");
		while ($row = $DB_site->fetch_assoc($results)) {
			$row = filter_data($row);
			$relinfo = get('products', $row[relatedto]);
			$links = icon(3, "javascript:void(0);\" onclick=\"delRelated('rel_$row[id]');");
			$move = template('move_up_down.html', array('type' => 'products_related', 'id' => $row[id], 'extra' => '&pid='.$prodinfo[id].'&&tab=8'));
			$content .= content(array(template('form_checkbox.html', array('value' => $row[id], 'name' => 'item[]')), $move, $relinfo[title], $links), array(), array("center","center","left","center"), 'rel_'.$row[id]);
		}
		$content .= contentend().bulk_action().$forms->end(array('hide' => 'Table'));
		$cats = $forms->item("catlist", "", "cats", "", "", "", "", array('style' => 'width: 100%;', 'return_item' => 1, 'All' => 1, 'onchange' => 'updateItems(\'addRel\')'));
		$items = $forms->item("itemlist", "", "items", "", "", "", "", array('style' => 'width: 100%;', 'return_item' => 1));
		$content .= template('add_related.html', array('productid' => $prodinfo[id], 'cats' => $cats, 'items' => $items));

		$tab_items .= tab_item("Related", $content);

		$data = $start.start_tabs($tab_items);

		$out = (($status!="")?status($status):"").starttable("545", "$word Product", $data);
	}

	///////////////////////
	// Edit Product Options
	///////////////////////

    if ($_GET[sub] == "options") {

		if ($_GET['do'] == "delete") {
			$DB_site->query("DELETE FROM `".$dbprefix."products_options_items` where `id`='".$_GET[opid]."'");
			$status = $lang['proddels'];
		}

		if ($_GET['do'] == "update") {
			$DB_site->query("UPDATE `".$dbprefix."products_options` set `name`='".sf($_POST[name])."', `description`='".sf($_POST[description])."', `default`='".sf($_POST['default'])."', `type`='".sf($_POST[type])."', `length`='".sf($_POST[length])."' where `id`='".$_POST[id]."'");
			if ($_POST[ivalue] != "") {
				$info = get('products_options', $_POST[id]);
				if (sqlcount('products_options_items', "WHERE `optionid`='$_POST[id]'") < 1 || $info[type] != 'checkbox') {
					$count = $DB_site->query_first("SELECT `dorder` FROM `".$dbprefix."products_options_items` WHERE `optionid`='".$_POST[id]."' order by `dorder` desc");
					$DB_site->query("INSERT INTO `".$dbprefix."products_options_items` set `optionid`='".$_POST[id]."', `name`='".sf($_POST[iname])."', `value`='".sf($_POST[ivalue])."', `price`='".sf($_POST[iprice])."', `weight`='".sf($_POST[iweight])."', `sku`='".sf($_POST[isku])."', `in_stock`='".sf($_POST[istock])."', `dorder`='".($count[dorder]+10)."'");
					$status = $lang['prodadds']."<br />";
				} else {
					$status = $lang['thisoptc']."<br />";
				}
			}
			if (is_array($_POST[ids])) {
				foreach ($_POST[ids] as $k => $v) {
					$DB_site->query("UPDATE `".$dbprefix."products_options_items` set `name`='".sf($_POST[names][$k])."', `value`='".sf($_POST[values][$k])."', `price`='".sf($_POST[prices][$k])."', `weight`='".sf($_POST[weights][$k])."', `sku`='".sf($_POST[skus][$k])."', `in_stock`='".sf($_POST[stocks][$k])."' where `id`='".$_POST[ids][$k]."'");
				}
			}
			$status .= $lang['prodoptc'];
		}

		$info = get('products_options', (($_POST[id]!="")?$_POST[id]:$_GET[id]));
		$prod	= get('products', $info[productid]);

		$start  = $forms->start(array('url' => 'adminindex.php?action=products&sub=options&do=update'));
		$start .= $forms->item("hidden", "", "id", "", $info[id]);
		$start .= $forms->item("show", $lang['product'].":", "", "", '<a href="adminindex.php?action=products&sub=edit&id='.$info[productid].'&tab=5">'.$prod[title].'</a><br /><br />');
		$start .= $forms->item("textbox", help($lang['name'], $lang['name_d']), "name", "", $info[name], 35);
		$start .= $forms->item("textbox", help($lang['default'], $lang['default_d']), "default", "", $info['default'], 35);
		$start .= $forms->item("dropdown", help($lang['type'], $lang['type_d']), "type", $forms->farray(array('select', 'radio', 'checkbox', 'textbox', 'textarea'), array('Dropdown', 'Radio', 'Checkbox', 'Textbox', 'Textarea')), $info[type], 35);
		$start .= ($info[type]=="textarea" || $info[type]=="textbox")?$forms->item("textbox", help($lang['length'], $lang['length_d']), "length", "", $info[length], 5):"";
		$start .= $forms->item("textarea", help($lang['description'], $lang['description_d']), "description", "", $info[description], 45, 5);
		$start .= $forms->item("submit", "", "", "", $lang['updatepo']);
		$start .= $forms->end(array('hide' => 'Form'));

		// Option Items
		$form = contentstart(array($lang['id'], $lang['order'], $lang['value'], $lang['price'], $lang['weight'], $lang['stock'], $lang['sku'], $lang['action']), array(), array("center","center","left","left","left","left","left","center"), "#536da7");
		$results = $DB_site->query("SELECT * FROM `".$dbprefix."products_options_items` where `optionid`='".$info[id]."' ORDER by `dorder`"); $num = 0;
		while ($row = $DB_site->fetch_assoc($results)) {
			$hide 	= $forms->item("hidden", "", 'ids['.$num.']', "", $row[id], "", "", array('return_item' => 1));
			$move 	= template('move_up_down.html', array('type' => 'products_options_items', 'id' => $row[id], 'extra' => '&oid='.$info[id]));
			$value 	= $forms->item("textbox", "", 'values['.$num.']', "", $row[value], "31", "", array('return_item' => 1));
			$price	= $forms->item("textbox", "", 'prices['.$num.']', "", p($row[price], false), "5", "", array('return_item' => 1));
			$weight = $forms->item("textbox", "", 'weights['.$num.']', "", $row[weight], "4", "", array('return_item' => 1));
			$stock	= $forms->item("textbox", "", 'stocks['.$num.']', "", $row[in_stock], "4", "", array('return_item' => 1));
			$sku	= $forms->item("textbox", "", 'skus['.$num.']', "", $row[sku], "4", "", array('return_item' => 1));
			$links  = icon(3, "adminindex.php?action=products&sub=options&id=$info[id]&do=delete&opid=$row[id]\" onclick=\"return jsconfirm();");
			$form .= content(array($row[id].$hide, $move, $value, (($settings[cs_pos]=='before')?$settings[cs]:'').$price.(($settings[cs_pos]=='after')?$settings[cs]:''), $weight, $stock, $sku, $links), array(), array("center","center","left","left","left","left","left","center"));
			$num++;
		}
		$form .= contentend();
		$form .= $forms->start(array('hide' => 'Form'));
		$form .= $forms->item("submit", "", "", "", $lang['updateopt']);
		$form .= $forms->end(array('hide' => 'Form'));

		$form .= template('add_options_item.html', array());

		$tab_items .= tab_item($lang['optioni'], $form);

		$data = $start.(($info[type]!='textbox' && $info[type]!='textarea')?start_tabs($tab_items):'');

		$out = (($status!="")?status($status):"").starttable("545", $lang['editprodo'], $data);
	}

	/////////////////////////////////////////////////
	// Store & Update Vendors, Manufacturer & Reviews
	/////////////////////////////////////////////////

	if ($_GET[sub] == "storevm" || $_GET[sub] == "updatevm") {

		if ($_GET[type] == 'manufacturers') {
			$maninfo = get('manufacturers', $_GET[id]);

			// Process Images
			$fullp	= $abs_path.'/'.$settings[productpath];
			$tmp_array	= is_array($_FILES[mainimages])?$_FILES[mainimages]:array();
			foreach ($tmp_array[name][0] as $k1 => $v2) {
				$existing = $maninfo[$k1.'_image'];
				if ($tmp_array[name][0][$k1] != "") {
					$this_name = $tmp_array[name][0][$k1];
					$this_tmp_name = $tmp_array[tmp_name][0][$k1];
					$file_type = $tmp_array[type][0][$k1];
					$prefix = $k1.'_manufacturer_';
					$new_name = $prefix.str_replace(array($prefix, ' '), array('', '_'), $this_name);

					file_check($this_name, "image", $file_type);

					if (@file_exists($fullp.$new_name)) @unlink($fullp.$new_name);

					if (!move_uploaded_file($this_tmp_name, $fullp.$new_name)) $errors .= "Could not upload image file '".$this_name."'.<br />";
					else @chmod($fullp.$new_name, 0777);
					if ($settings[auto_resize] && $settings[resize] != 'none') resize_image($fullp.$new_name, $settings['auto_'.$k1.'_height'], $settings['auto_'.$k1.'_width']);
				} else {
					$server   = $_POST[server];
					$tmp_name = $server[mainimages][0][$k1];
					if ($tmp_name != "") {
						$this_name = $tmp_name;
						$prefix = $k1.'_manufacturer_';
						$new_name = $prefix.str_replace(array($prefix, ' '), array('', '_'), $this_name);

						if (!@copy($fullp.$this_name, $fullp.$new_name)) $new_name = $this_name;
						if ($settings[auto_resize] && $settings[resize] != 'none') resize_image($fullp.$new_name, $settings['auto_'.$k1.'_height'], $settings['auto_'.$k1.'_width']);
					} else {
						if (@file_exists($fullp.$existing)) @unlink($fullp.$existing);
						$new_name = '';
					}
				}
				$_POST[$k1.'_image'] = $new_name;
			}
		}

		$query 	= (($_GET[sub]!="storevm")?"UPDATE":"INSERT INTO")." ".$dbprefix.$_GET[type]." set";
		$result = $DB_site->query("DESCRIBE ".$dbprefix.$_GET[type]);
		while ($field = $DB_site->fetch_assoc($result)) {
			if (isset($_POST[$field['Field']]))
				$query .= " `".$field['Field']."`='".sf($_POST[$field['Field']])."',";
		}
		$query .= ($_GET[sub]!="storevm")?" `id`='".$_POST[id]."' where `id`='".$_POST[id]."'":"";
		$DB_site->query(($_GET[sub]!="storevm")?$query:substr($query, 0, -1));
		$id = ($_GET[sub]!="storevm")?$_POST[id]:$DB_site->insert_id();

		$status = $lang[$_GET[type]]." ".$id.$lang['hasbeenu'];
		$_GET[sub]	= "manage";
	}

	/////////////////////////////////////////
	// Delete Vendors, Manufacturer & Reviews
	/////////////////////////////////////////

	if ($_GET[sub] == "del") {
		$DB_site->query("DELETE from ".$dbprefix.$_GET[type]." where id='".$_GET[id]."'");
		$status = $lang[$_GET[type]]." ".$_GET[id]." ".$lang['hdeleted'];
		$_GET[sub] = "manage";
	}

	/////////////////////////////////////////
	// View Vendors & Manufacturers & Reviews
	/////////////////////////////////////////

	if ($_GET[sub] == "manage") {
		$_GET[orderby]	= ($_GET[orderby]=='')?(($_GET[type]=='manufacturers')?'dorder':'id'):$_GET[orderby];
		$_GET[sort]		= ($_GET[sort]=='')?'asc':$_GET[sort];
		$_GET[pg] 		= (isset($_GET[pg]) && $_GET[pg] > 0)?intval($_GET[pg]):0;
		$type			= $lang[$_GET[type]];

		switch ($_GET[type]) {
			case '':
			case 'vendors':
				$tablestart = contentstart(array(template('form_toggle_checkbox.html', array('cname' => 'selectall', 'name' => 'item', 'form' => 'bulk')), l($lang['id'],"id"), l($lang['company'],"company"), l($lang['account'],"account_num"), $lang['pcount'], l($lang['viewable'],"viewable"), $lang['action']), array(), array("center","center","left","left","center","center","center"), "#536da7", 1);
				$query = "SELECT id FROM `".$dbprefix."vendors` order by ".$_GET[orderby]." ".$_GET[sort]." LIMIT ".((($_GET[pg]==0)?0:$_GET[pg]-1)*$settings[admin_products_max]).",".$settings[admin_products_max];
				$vars[sidetable] .= getsidesubs($startlink, 1, 1);
				break;
			case 'manufacturers':
				$tablestart = contentstart(array(template('form_toggle_checkbox.html', array('cname' => 'selectall', 'name' => 'item', 'form' => 'bulk')), l($lang['id'],"id"), l($lang['pos'],"dorder"), l($lang['company'],"name"), $lang['pcount'], l($lang['viewable'],"viewable"), $lang['action']), array(), array("center","center","center","left","center","center","center"), "#536da7", 1);
				$query = "SELECT id FROM `".$dbprefix."manufacturers` order by ".$_GET[orderby]." ".$_GET[sort]." LIMIT ".((($_GET[pg]==0)?0:$_GET[pg]-1)*$settings[admin_products_max]).",".$settings[admin_products_max];
				$vars[sidetable] .= getsidesubs($startlink, 1, 2);
				break;
			case 'products_reviews':
				$tablestart = contentstart(array(template('form_toggle_checkbox.html', array('cname' => 'selectall', 'name' => 'item', 'form' => 'bulk')), l($lang['id'],"id"), $lang['product'], l($lang['name'],"name"), l($lang['rating'],"rating"), l($lang['status'],"status"), $lang['action']), array(), array("center","center","left","left","center","center","center"), "#536da7", 1);
				$query = "SELECT id FROM `".$dbprefix."products_reviews` order by ".$_GET[orderby]." ".$_GET[sort]." LIMIT ".((($_GET[pg]==0)?0:$_GET[pg]-1)*$settings[admin_products_max]).",".$settings[admin_products_max];
				break;
		}

		$append = preg_replace('/pg=([0-9]*)/', '', (($_GET[pg]=="")?'&amp;':'').htmlentities($_SERVER["QUERY_STRING"]));
		$page = new pager($query, template('list_pages_output.html', array(), 0), 5, $settings[admin_products_max], $_GET[pg], $append);
		$list[pages] = $page->paginate();

		$table1content = $list[pages]."<br />";
		$table1content .= $forms->start(array('name' => 'bulk', 'url' => 'adminindex.php?action=products&sub=manage'.(($_GET[type]!="")?'&type='.$_GET[type]:''), 'hide' => 'Table'));
		$table1content .= $tablestart;

		$results = $DB_site->query($query);
		while ($row = $DB_site->fetch_assoc($results)) {
			switch ($_GET[type]) {
				case '':
				case 'vendors':
					$vend = get('vendors', $row[id]);
					$count = sqlcount('products', 'WHERE `vendor`='.$row[id]);
					$links = ($admin[manage_vends]==1)?icon(2,"adminindex.php?action=products&sub=editvm&type=vendors&id=$row[id]").icon(3,"adminindex.php?action=products&sub=del&type=vendors&id=$row[id]\" onclick=\"return jsconfirm();"):'None';
					$table1content .= content(array(template('form_checkbox.html', array('value' => $row[id], 'name' => 'item[]')), $row[id], $vend[company], $vend[account_num], $count, (($vend[viewable]==0)?'No':'Yes'), $links), array(), array("center","center","left","left","center","center","center"));
					break;
				case 'manufacturers':
					$man = get('manufacturers', $row[id]);
					$count = sqlcount('products', 'WHERE `manufacturer`='.$row[id]);
					$links = ($admin[manage_mans]==1)?icon(2,"adminindex.php?action=products&sub=editvm&type=manufacturers&id=$row[id]").icon(3,"adminindex.php?action=products&sub=del&type=manufacturers&id=$row[id]\" onclick=\"return jsconfirm();"):'None';
					$move  = template('move_up_down.html', array('type' => 'manufacturers', 'id' => $row[id], 'extra' => ''));
					$table1content .= content(array(template('form_checkbox.html', array('value' => $row[id], 'name' => 'item[]')), $row[id], $move, $man[name], $count, (($man[viewable]==0)?'No':'Yes'), $links), array(), array("center","center","center","left","center","center","center"));
					break;
				case 'products_reviews':
					$rev = get('products_reviews', $row[id]);
					$prodinfo = get('products', $rev[productid]);
					$links = ($admin[manage_reviews]==1)?icon(2,"adminindex.php?action=products&sub=editvm&type=products_reviews&id=$row[id]").icon(3,"adminindex.php?action=products&sub=del&type=products_reviews&id=$row[id]\" onclick=\"return jsconfirm();"):'None';
					$table1content .= content(array(template('form_checkbox.html', array('value' => $row[id], 'name' => 'item[]')), $row[id], shortenit($prodinfo[title], 35), '<a href="mailto:'.$rev[email].'">'.$rev[name].'</a>', $rev[rating], (($rev[status]==0)?'Pending':'Viewable'), $links), array(), array("center","center","left","left","center","center","center"));
					break;
			}
		}
		$table1content .= contentend();
		$table1content .= bulk_action().$forms->end(array('hide' => 'Table'));
		$table1content .= "<br />".$list[pages];

		$table1 = starttable("545", $type, $table1content, array('style' => ((3<2)?'height: 50px;':'')));
		$out = (($status!="")?status($status):"")."$table1";
	}

	//////////////////////////////////////////////
	// Add & Edit Vendors, Manufacturers & Reviews
	//////////////////////////////////////////////

	if ($_GET[sub] == "addvm" || $_GET[sub] == "editvm") {
		$do 	= ($_GET[sub]=="addvm")?'storevm':'updatevm';
		$word 	= ($_GET[sub]=="addvm")?$lang['add']:$lang['edit'];
		$type	= $lang[$_GET[type]];
		$info 	= get($_GET[type], $_GET[id]);

		$statelist1 = get_data_array('state_country', 'abb',  'type,name', 'WHERE type=\''.STATE.'\' OR type=\'3\'');
		$statelist2 = get_data_array('state_country', 'name',  'type,name', 'WHERE type=\''.STATE.'\' OR type=\'3\'');
		$countrylist1 = get_data_array('state_country', 'abb',  'name', 'WHERE type=\''.COUNTRY.'\'');
		$countrylist2 = get_data_array('state_country', 'name',  'name', 'WHERE type=\''.COUNTRY.'\'');

		$grouplist1 = get_data_array('groups', 'id', 'name');
		$grouplist2	= get_data_array('groups', 'name', 'name');
		array_unshift($grouplist1, 0);
		array_unshift($grouplist2, "All");

		switch ($_GET[type]) {
			case '':
			case 'vendors':
				$vars[sidetable] .= getsidesubs($startlink, 1, 1);
				$form  = $forms->start(array('url' => 'adminindex.php?action=products&sub='.$do.'&type=vendors'));
				$form .= ($_GET[sub]=="editvm")?$forms->item("hidden", "", "id", "", $info[id]):'';
				$form .= $forms->item("textbox", help($lang['acctno'], $lang['vendname']), "account_num", "", $info[account_num], 30);
				$form .= $forms->item("textbox", help($lang['coname'], $lang['vendname']), "company", "", $info[company], 30);
				$form .= $forms->item("textbox", help($lang['addr1bill'], $lang['addr1vend']), "address1", "", $info[address1], 30);
				$form .= $forms->item("textbox", help($lang['addr2bill'], $lang['addr2vend']), "address2", "", $info[address2], 30);
				$form .= $forms->item("textbox", help($lang['city'], $lang['vendcity']), "city", "",$info[city], 20);
				$form .= $forms->item("dropdown", help($lang['state2'], $lang['vendstate']), "state", $forms->farray($statelist1, $statelist2), $info[state]);
				$form .= $forms->item("textbox", help($lang['zip'], $lang['vendzip']), "zip", "", $info[zip], 20);
				$form .= $forms->item("dropdown", help($lang['country'], $lang['vendcountry']), "country", $forms->farray($countrylist1, $countrylist2), $info[country]);
				$form .= $forms->item("textbox", help($lang['phone'], $lang['vendphone']), "phone", "", $info[phone], 20);
				$form .= $forms->item("textbox", help($lang['email'], $lang['vendemail']), "email", "", $info[email], 30);
				$form .= $forms->item("dropdown", help($lang['dropship'], $lang['venddship']), "dropship", $forms->farray(array("1","0"),  array($lang[yes],$lang[no])), $info[dropship]);
				$form .= $forms->item("dropdown", help($lang['available'], $lang['vendavail']), "viewable", $forms->farray(array("1","0"), array($lang[yes],$lang[no])), $info[viewable]);
				$form .= $forms->item("submit", "", "", "", "$word $type");
				$form .= $forms->end();
				$data = $form;
				break;
			case 'manufacturers':
				$vars[sidetable] .= getsidesubs($startlink, 1, 2);
				$form  = $forms->start(array('url' => 'adminindex.php?action=products&sub='.$do.'&type=manufacturers" enctype="multipart/form-data'));
				$form .= ($_GET[sub]=="editvm")?$forms->item("hidden", "", "id", "", $info[id]):'';
				$form .= $forms->item("textbox", help($lang['mfname'], $lang['dispmfname']), "name", "", $info[name], 35);
				$form .= $forms->item("textbox", help($lang['metat'], $lang['metat_d']), "meta_title", "", $info[meta_title], 50);
				$form .= $forms->item("textbox", help($lang['metak'], $lang['metak_d']), "meta_keywords", "", $info[meta_keywords], 50);
				$form .= $forms->item("textarea", help($lang['metad'], $lang['metad_d']), "meta_desc", "", $info[meta_desc], 50, 5);
				$form .= $forms->item("textarea", help($lang['desc'], $lang['descat']), "description", "", $info[description], 50, 5);
				$form .= $forms->item("images", help($lang['images'], $lang['images_d']), "mainimages", $forms->farray(array("tiny", "thumb"), array($lang['tiny'], $lang['thumb'])), array($info[tiny_image], $info[thumb_image]), '', '', array('cnt' => 0));
				//$form .= $forms->item("dropdown", help($lang['prodavail'], $lang['selgrp']), "avail_to", $forms->farray($grouplist1, $grouplist2), $info[avail_to]);
				$form .= $forms->item("dropdown", help($lang['viewable'], $lang['viewdesc']), "viewable", $forms->farray(array("1","0"), array($lang[yes],$lang[no])), ($info[viewable]==""?1:$info[viewable]));
				$form .= $forms->item("submit", "", "", "", "$word $type");
				$form .= $forms->end();
				$data = $form;
				break;
			case 'products_reviews':
				$prodinfo = get('products', $info[productid]);
				$form  = $forms->start(array('url' => 'adminindex.php?action=products&sub='.$do.'&type=products_reviews'));
				$form .= ($_GET[sub]=="editvm")?$forms->item("hidden", "", "id", "", $info[id]):'';
				$form .= $forms->item("show", help($lang['date'], $lang['none']), $lang['datedesc'], "", date($settings[datestamp], $info[datestamp]).' '.date($settings[timestamp], $info[datestamp]));
				$form .= $forms->item("show", help($lang['prod'], $lang['none']), $lang['proddesc'], "", $prodinfo[title]);
				$form .= $forms->item("textbox", help($lang['name'], $lang['namedesc']), "name", "", $info[name], 30);
				$form .= $forms->item("textbox", help($lang['email'], $lang['emaildesc']), "email", "", $info[email], 30);
				$form .= $forms->item("textarea", help($lang['review'], $lang['vreview']), "description", "", $info[description], 75, 10);
				$form .= $forms->item("dropdown", help($lang['rating'], $lang['vrating']), "rating", $forms->farray(array("1","2","3","4","5"),  array("1","2","3","4","5")), $info[rating]);
				$form .= $forms->item("dropdown", help($lang['status'], $lang['revstatus']), "status", $forms->farray(array(0,1), array($lang[pending],$lang[viewable])), $info[status]);
				$form .= $forms->item("submit", "", "", "", "$word $type");
				$form .= $forms->end();
				$data = $form;
				break;

		}

		$out = starttable("545", "$word $type", $data, array());
	}

	////////////////////////
	//Product Image Resizing
	////////////////////////

	if ($_GET[sub] == "images") {
		$vars[sidetable] .= getsidesubs($startlink, 1, 4);

		if ($_GET['do'] == "update") {
			$total_images = 0;
			$fullp  = $abs_path.'/'.$settings[productpath];
			if (!is_dir($fullp."originals")) {
				mkdir($fullp."originals", 0777);
				chmod($fullp."originals", 0777);
			}
			$results = $DB_site->query("SELECT * FROM ".$dbprefix."products_images");
			while ($row = $DB_site->fetch_assoc($results)) {
					if (file_exists($fullp.$row[large_image]) && $row[large_image] != "" && $_POST[types] == "large") {
						$prefix = 'large_'.$row[productid].'_';
						$new_name = $prefix.str_replace(array($prefix, ' '), array('', '_'), $row[large_image]); @copy($fullp.$row[large_image], $fullp.$new_name);
						if (resize_image($fullp.$row[large_image], $_POST[max_width], $_POST[max_height], true)) {
							$total_images++;
							$DB_site->query("UPDATE ".$dbprefix."products_images set `large_image`='".$new_name."' where `id`='".$row[id]."'");
						}
					}
					if (file_exists($fullp.$row[thumb_image]) && $row[thumb_image] != "" && $_POST[types] == "thumb") {
						$prefix = 'thumb_'.$row[productid].'_';
						$new_name = $prefix.str_replace(array($prefix, ' '), array('', '_'), $row[thumb_image]); @copy($fullp.$row[thumb_image], $fullp.$new_name);
						if (resize_image($fullp.$new_name, $_POST[max_width], $_POST[max_height], true)) {
							$total_images++;
							$DB_site->query("UPDATE ".$dbprefix."products_images set `thumb_image`='".$new_name."' where `id`='".$row[id]."'");
						}
					}
			}
			$results = $DB_site->query("SELECT * FROM ".$dbprefix."products");
			while ($row = $DB_site->fetch_assoc($results)) {
					if (file_exists($fullp.$row[large_image]) && $row[large_image] != "" && $_POST[types] == "large") {
						$prefix = 'large_'.$row[id].'_';
						$new_name = $prefix.str_replace(array($prefix, ' '), array('', '_'), $row[large_image]); @copy($fullp.$row[large_image], $fullp.$new_name);
						if (resize_image($fullp.$row[large_image], $_POST[max_width], $_POST[max_height], true)) {
							$total_images++;
							$DB_site->query("UPDATE ".$dbprefix."products set `large_image`='".$new_name."' where `id`='".$row[id]."'");
						}
					}
					if (file_exists($fullp.$row[detail_image]) && $row[detail_image] != "" && $_POST[types] == "detail") {
						$prefix = 'detail_'.$row[id].'_';
						$new_name = $prefix.str_replace(array($prefix, ' '), array('', '_'), $row[detail_image]); @copy($fullp.$row[detail_image], $fullp.$new_name);
						if (resize_image($fullp.$new_name, $_POST[max_width], $_POST[max_height], true)) {
							$total_images++;
							$DB_site->query("UPDATE ".$dbprefix."products set `detail_image`='".$new_name."' where `id`='".$row[id]."'");
						}
					}
					if (file_exists($fullp.$row[thumb_image]) && $row[thumb_image] != "" && $_POST[types] == "thumb") {
						$prefix = 'thumb_'.$row[id].'_';
						$new_name = $prefix.str_replace(array($prefix, ' '), array('', '_'), $row[thumb_image]); @copy($fullp.$row[thumb_image], $fullp.$new_name);
						if (resize_image($fullp.$new_name, $_POST[max_width], $_POST[max_height], true)) {
							$total_images++;
							$DB_site->query("UPDATE ".$dbprefix."products set `thumb_image`='".$new_name."' where `id`='".$row[id]."'");
						}
					}
			}
			$results = $DB_site->query("SELECT * FROM ".$dbprefix."categories");
			while ($row = $DB_site->fetch_assoc($results)) {
					if (file_exists($fullp.$row[thumb_image]) && $row[thumb_image] != "" && $_POST[types] == "thumb") {
						$prefix = 'thumb_'.$row[id].'_';
						$new_name = $prefix.str_replace(array($prefix, ' '), array('', '_'), $row[thumb_image]); @copy($fullp.$row[thumb_image], $fullp.$new_name);
						if (resize_image($fullp.$new_name, $_POST[max_width], $_POST[max_height], true)) {
							$total_images++;
							$DB_site->query("UPDATE ".$dbprefix."categories set `thumb_image`='".$new_name."' where `id`='".$row[id]."'");
						}
					}
					if (file_exists($fullp.$row[tiny_image]) && $row[tiny_image] != "" && $_POST[types] == "tiny") {
						$prefix = 'tiny_'.$row[id].'_';
						$new_name = $prefix.str_replace(array($prefix, ' '), array('', '_'), $row[tiny_image]); @copy($fullp.$row[tiny_image], $fullp.$new_name);
						if (resize_image($fullp.$row[large_image], $_POST[max_width], $_POST[max_height], true)) {
							$total_images++;
							$DB_site->query("UPDATE ".$dbprefix."categories set `tiny_image`='".$new_name."' where `id`='".$row[id]."'");
						}
					}
			}
			$status = status($lang['resizesucc'].": $total_images ".$lang['imgresized']);
		}

		$form  = $forms->start(array('url' => 'adminindex.php?action=products&sub=images&do=update'));
		$form .= $forms->item("dropdown", help($lang['imaget'], $lang['imaget_d']), "types", $forms->farray(array("tiny", "thumb", "detail", "large"),  array("Tiny Images", "Thumb Images", "Detail Images", "Large Images")), "thumb");
		$form .= $forms->item("textbox", help($lang['maxw'], $lang['maxw_d']), "max_width", "", "300", 5);
		$form .= $forms->item("textbox", help($lang['maxwh'], $lang['maxwh_d']), "max_height", "", "300", 5);
		$form .= $forms->item("submit", "", "", "", $lang['pimages']);
		$form .= $forms->end();

		$out = $status.starttable("545", $lang['imgresize'], $form, array());
	}

	///////////////////////
	//Product Image Cleanup
	///////////////////////

	if ($_GET[sub] == "image_cleanup") {
		$vars[sidetable] .= getsidesubs($startlink, 1, 4);

		if ($_GET['do'] == "update") {
			$images = array();
			$deleted = 0;
			$fullp	= $abs_path.'/'.$settings[productpath];

			$results = $DB_site->query("SELECT * FROM `".$dbprefix."products_images`");
			while ($row = $DB_site->fetch_assoc($results)) {
				array_push($images, $row[large_image]);
				array_push($images, $row[thumb_image]);
			}
			$results = $DB_site->query("SELECT * FROM `".$dbprefix."products`");
			while ($row = $DB_site->fetch_assoc($results)) {
				array_push($images, $row[large_image]);
				array_push($images, $row[detail_image]);
				array_push($images, $row[thumb_image]);
			}

			$results = $DB_site->query("SELECT * FROM `".$dbprefix."categories`");
			while ($row = $DB_site->fetch_assoc($results)) {
				array_push($images, $row[tiny_image]);
				array_push($images, $row[thumb_image]);
			}

			$results = $DB_site->query("SELECT * FROM `".$dbprefix."manufacturers`");
			while ($row = $DB_site->fetch_assoc($results)) {
				array_push($images, $row[tiny_image]);
				array_push($images, $row[thumb_image]);
			}

			$the_directory = @opendir($fullp);
			while(@$filename = readdir($the_directory)) {
				$filename_arr = explode(".", $filename); $temp = count($filename_arr)-1;
				$extension = strtolower($filename_arr[$temp]);
				if ($extension == 'gif' || $extension == 'jpg' || $extension == 'jpeg' || $extension == 'png' || $extension == 'bmp' || $extension == 'tiff') {
					if (!in_array($filename, $images)) if (@unlink($fullp.$filename)) $deleted++;
				}
			}
			@closedir($the_directory);
			$status = status($lang['delsucc'].": $deleted ".$lang['imgdeleted']);
		}

		$form  = $forms->start(array('url' => 'adminindex.php?action=products&sub=image_cleanup&do=update'));
		$form .= $forms->item("show", "", "", "", $lang['cleaninfo'], "");
		$form .= $forms->item("submit", "", "", "", $lang['cleanimages']);
		$form .= $forms->end();

		$out = $status.starttable("545", $lang['cleanimages'], $form, array());
	}

	//////////////////////
	//Product Image Backup
	//////////////////////

	if ($_GET[sub] == "backup_images") {
		$vars[sidetable] .= getsidesubs($startlink, 1, 4);

		include $abs_path.'/include/classes/class.zip.php';

		$dir_array = array();
		dir_to_array($abs_path.'/'.$settings[productpath]);

		$filename = $abs_path.'/'.ADMIN_DIR.'/backup/'.randompass(10).'_site_images.zip';

		$ziper = new zipfile();
		$ziper->addFiles($dir_array);
		$ziper->output($filename);

		header("Cache-control: private");
		header("Content-type: application/zip");
		header("Content-transfer-encoding: binary\n");
		header("Content-disposition: attachment; filename=\"".strtolower(str_replace(" ", "_", $settings[title]))."_images.zip\"");
		header("Content-Length: ".filesize($filename));
		readfile($filename);
		@unlink($filename);
		exit;
	}
}

////////////////////////
// Categories Management
////////////////////////

elseif ($_GET[action] == "categories") {

	$vars[sidetable] = getside($startlink, 2);

	//////////////////////////
	// Add & Update Categories
	//////////////////////////

	if ($_GET[sub] == "update" || $_GET[sub] == "store") {
		$catinfo = get('categories', $_GET[id]);

		// Process Images
		$fullp	= $abs_path.'/'.$settings[productpath];
		$tmp_array 	= array();
		$tmp_array	= $_FILES[mainimages];
		foreach ($tmp_array[name][0] as $k1 => $v2) {
			$existing = $catinfo[$k1.'_image'];
			if ($tmp_array[name][0][$k1] != "") {
				$this_name = $tmp_array[name][0][$k1];
				$this_tmp_name = $tmp_array[tmp_name][0][$k1];
				$file_type = $tmp_array[type][0][$k1];
				$prefix = $k1.'_category_';
				$new_name = $prefix.str_replace(array($prefix, ' '), array('', '_'), $this_name);

				file_check($this_name, "image", $file_type);

				if (@file_exists($fullp.$new_name)) @unlink($fullp.$new_name);

				if (!move_uploaded_file($this_tmp_name, $fullp.$new_name)) $errors .= "Could not upload image file '".$this_name."'.<br />";
				else @chmod($fullp.$new_name, 0777);
				if ($settings[auto_resize] && $settings[resize] != 'none') resize_image($fullp.$new_name, $settings['auto_'.$k1.'_height'], $settings['auto_'.$k1.'_width']);
			} else {
				$server   = $_POST[server];
				$tmp_name = $server[mainimages][0][$k1];
				if ($tmp_name != "") {
					$this_name = $tmp_name;
					$prefix = $k1.'_category_';
					$new_name = $prefix.str_replace(array($prefix, ' '), array('', '_'), $this_name);

					if (!@copy($fullp.$this_name, $fullp.$new_name)) $new_name = $this_name;
					if ($settings[auto_resize] && $settings[resize] != 'none') resize_image($fullp.$new_name, $settings['auto_'.$k1.'_height'], $settings['auto_'.$k1.'_width']);
				} else {
					if (@file_exists($fullp.$existing)) @unlink($fullp.$existing);
					$new_name = '';
				}
			}
			$_POST[$k1.'_image'] = $new_name;
		}

		if ($_GET[sub]!="store") {
			if ($_POST[subof] == $_POST[id]) $_POST[subof] = 0;
		}

		// Update Category Data
		$query 	= (($_GET[sub]=="store")?"INSERT INTO `":"UPDATE `").$dbprefix."categories` set";
		$result = $DB_site->query("DESCRIBE `".$dbprefix."categories`");
		while ($field = $DB_site->fetch_assoc($result)) {
			if (isset($_POST[$field['Field']]))
				$query .= " `".$field['Field']."`='".sf($_POST[$field['Field']])."',";
		}
		$query .= ($_GET[sub]!="store")?" `id`='".$_POST[id]."' where `id`='".$_POST[id]."' ":"";
		$DB_site->query(substr($query, 0, -1));

		// Output Status
		$status = $lang['categoryhs']."<br>$errors";
		$_GET[sub] = "view";
		$_GET[subof] = $_POST[subof];
	}

	////////////////////
	// Delete Categories
	////////////////////

	if ($_GET[sub] == "delete") {
		$DB_site->query("DELETE from ".$dbprefix."categories where id='".$_GET[id]."'");
		$status = $lang['categoryds'];
		$_GET[sub] = "view";
	}

	//////////////////
	// View Categories
	//////////////////

    if ($_GET[sub] == "view") {
		$_GET[orderby]	= ($_GET[orderby]=='')?'dorder':$_GET[orderby];
		$_GET[sort]		= ($_GET[sort]=='')?'asc':$_GET[sort];
		$_GET[pg] 		= (isset($_GET[pg]) && $_GET[pg] > 0)?intval($_GET[pg]):0;
		$_GET[subof]	= ($_GET[subof]=='')?0:$_GET[subof];

		$tablestart = contentstart(array(template('form_toggle_checkbox.html', array('cname' => 'selectall', 'name' => 'item', 'form' => 'bulk')), l($lang['id'],"id","&amp;subof=".$_GET[subof]), l($lang['pos'],"dorder","&amp;subof=".$_GET[subof]), l($lang['title'],"title","&amp;subof=".$_GET[subof]), $lang['subcats'] , $lang['pcount'], l($lang['viewable'],"viewable","&amp;subof=".$_GET[subof]), $lang['action']), array(), array("center","center","center","left","center","center","center","center"), "#536da7", 1);
		$query = "SELECT id FROM `".$dbprefix."categories` where subof='".$_GET[subof]."' order by ".$_GET[orderby]." ".$_GET[sort]." LIMIT ".((($_GET[pg]==0)?0:$_GET[pg]-1)*$settings[admin_categories_max]).",".$settings[admin_categories_max];

		$append = preg_replace('/pg=([0-9]*)/', '', (($_GET[pg]=="")?'&amp;':'').htmlentities($_SERVER["QUERY_STRING"]));
		$page = new pager($query, template('list_pages_output.html', array(), 0), 5, $settings[admin_categories_max], $_GET[pg], $append);
		$list[pages] = $page->paginate();

		$table1content = (($_GET[subof]!=0)?cookiecrumb($_GET[subof]):'').$list[pages]."<br />";
		$table1content .= $forms->start(array('name' => 'bulk', 'url' => 'adminindex.php?action=categories&sub=view'.(($_GET[type]!="")?'&type='.$_GET[type]:''), 'hide' => 'Table'));
		$table1content .= $tablestart;

		$results = $DB_site->query($query);
		while ($row = $DB_site->fetch_assoc($results)) {
			$cat = get('categories', $row[id]);
			$scount = sqlcount('categories', 'WHERE `subof`='.$row[id]);
			$pcount = sqlcount('products_categories', 'WHERE `catid`='.$row[id]);
			$pcount += sqlcount('products', 'WHERE `catid`='.$row[id]);
			$links = ($admin[manage_cats]==1)?icon(2, "adminindex.php?action=categories&sub=edit&id=$row[id]").icon(8, "adminindex.php?action=categories&sub=add&subof=$row[id]").icon(3, "adminindex.php?action=categories&sub=delete&id=$row[id]&subof=".$_GET[subof]."\" onclick=\"return jsconfirm();"):'None';
			$move = template('move_up_down.html', array('type' => 'categories', 'id' => $row[id], 'extra' => '&subof='.$_GET[subof]));
			$table1content .= content(array(template('form_checkbox.html', array('value' => $row[id], 'name' => 'item[]')), $row[id], $move, '<a href="adminindex.php?action=categories&sub=view&subof='.$row[id].'">'.shortenit($cat[title], 35).'</a>', '<a href="adminindex.php?action=categories&sub=view&subof='.$row[id].'">'.$scount.'</a>', '<a href="adminindex.php?action=products&sub=view&s[cid]='.$row[id].'">'.$pcount.'</a>', ($cat[viewable]==1)?'Yes':'No', $links), array(), array("center","center","center","left","center","center","center","center"));
		}
		$table1content .= contentend();
		$table1content .= bulk_action().$forms->end(array('hide' => 'Table'));
		$table1content .= "<br />".$list[pages];

		$table1 = starttable("545", $lang['cats'], $table1content, array());

		$out = (($status!="")?status($status):"")."$table1";
	}

	////////////////////////
	// Add & Edit Categories
	////////////////////////

	if ($_GET[sub] == "add" || $_GET[sub] == "edit") {
		$info 	= get('categories', $_GET[id]);
		$do 	= ($_GET[sub]=="add")?'store':'update';
		$word 	= ($_GET[sub]=="add")?$lang['add']:$lang['edit'];
		$subof 	= (($_GET[subof]=="" && $_GET[sub]=="add")?0:$_GET[subof]).(($_GET[sub]=="edit")?$info[subof]:'');

		$grouplist1 = get_data_array('groups', 'id', 'name');
		$grouplist2	= get_data_array('groups', 'name', 'name');
		array_unshift($grouplist1, 0);
		array_unshift($grouplist2, "All");

		$form  = $forms->start(array('url' => 'adminindex.php?action=categories&sub='.$do.'" enctype="multipart/form-data'));
		$form .= ($_GET[sub]=="edit")?$forms->item("hidden", "", "id", "", $info[id]):'';
		$form .= $forms->item("textbox", help($lang['catname'], $lang['catitle']), "title", "", $info[title], 50);
		$form .= $forms->item("catlist", help($lang['parentc'], $lang['parentc_d']), "subof", "", $subof, "", "", array('style' =>  'width: 273px;', 'addblank' => 1));
		$form .= $forms->item("textbox", help($lang['metat'], $lang['metat_d']), "meta_title", "", $info[meta_title], 50);
		$form .= $forms->item("textbox", help($lang['metak'], $lang['metak_d']), "meta_keywords", "", $info[meta_keywords], 50);
		$form .= $forms->item("textarea", help($lang['metad'], $lang['metad_d']), "meta_desc", "", $info[meta_desc], 50, 5);
		$form .= $forms->item("textarea", help($lang['desc'], $lang['descat']), "description", "", $info[description], 50, 5);
		$form .= $forms->item("images", help($lang['images'], $lang['images_d']), "mainimages", $forms->farray(array("tiny", "thumb"), array($lang['tiny'], $lang['thumb'])), array($info[tiny_image], $info[thumb_image]), '', '', array('cnt' => 0));
		$form .= $forms->item("dropdown", help($lang['prodavail'], $lang['selgrp']), "avail_to", $forms->farray($grouplist1, $grouplist2), $info[avail_to]);
		$form .= $forms->item("radio", help($lang['viewable'], $lang['viewabledesc']), "viewable", $forms->farray(array("1","0"), array($lang[yes],$lang[no])), ($info[viewable]==""?1:$info[viewable]));
		$form .= $forms->item("submit", "", "", "", "$word ".$lang['category']);
		$form .= $forms->end();

		$out = starttable("545", "$word ".$lang['category'], $form, array());
	}

	///////////
	// Bulk Add
	///////////

	if ($_GET[sub] == "bulkadd") {
		if ($_POST['do'] == "save") {
			foreach($_POST[names] as $k => $v) {
				if ($_POST[names][$k] != "") {
					$last = $DB_site->query_first("SELECT `dorder` FROM `".$dbprefix."categories` where `subof`='".$_POST[cats][$k]."' order by `dorder` desc");
					$DB_site->query("INSERT INTO `".$dbprefix."categories` set `title`='".$_POST[names][$k]."', `description`='', `meta_title`='".$_POST[names][$k]."', `meta_keywords`='', `thumb_image`='', `tiny_image`='', `avail_to`='".$_POST[groups][$k]."', `viewable`='1', subof='".$_POST[cats][$k]."', dorder='".($last[dorder]+10)."'");
					$status = $lang['catsadd'];
				}
			}
		}

		$grouplist1 = get_data_array('groups', 'id', 'name');
		$grouplist2	= get_data_array('groups', 'name', 'name');
		array_unshift($grouplist1, 0);
		array_unshift($grouplist2, "All");

		$cats 	= $forms->item("catlist", "", "cats[0]", "", "", "", "", array('style' => 'width: 100%;', 'return_item' => 1, 'All' => 1, 'addblank' => '1'));
		$groups = $forms->item("dropdown", "", "groups[0]", $forms->farray($grouplist1, $grouplist2), '', '', '', array('return_item' => 1, 'style' => 'width: 100%;'));

		$links	 = ($admin[manage_cats]==1)?icon(8, "javascript:void(0);\" onclick=\"javascript:add_bulk();").icon(7,"javascript:void(0);\" onclick=\"javascript:clone_bulk(0);"):'None';
		$content = template('add_bulk_categories.html', array('cats' => $cats, 'groups' => $groups, 'links' => $links));

		$out = (($status!="")?status($status):"").starttable("545", $lang['bulkcat_add'], $content, array());
	}
}

//////////////////////////
// Transactions Management
//////////////////////////

elseif ($_GET[action] == "transactions") {

	$vars[sidetable] = getside($startlink, 3);

	/////////////////////
	// Update Transaction
	/////////////////////

	if ($_POST[Submit] == "Decrypt") { $_GET[sub] = "view"; $_GET[id] = $_POST[id]; $_GET[tab] = 2; }

    if ($_GET[sub] == "update") {
		if (is_array($_POST[ids])) {
			$count = 1;
			$subtot = 0;
			$results = $DB_site->query("SELECT * FROM `".$dbprefix."orders_products` where `orderid`='".$_POST[id]."' ORDER by `id`");
			while ($row = $DB_site->fetch_assoc($results)) {
				if ($_POST[removes][$count] == 'Yes') {
					$DB_site->query("DELETE FROM `".$dbprefix."orders_products` where `orderid`='".$_POST[id]."' AND `id`='".$row[id]."'");
				} else {
					$noptions = array();
					$row  = filter_data($row);
					$new_price = ($_POST[prices][$count]!=$row[price])?$_POST[prices][$count]:$row[price];
					$add_price = 0;
					$data = new orderitem ($row[data]);
					foreach ($data->item->options as $k => $v) {
						$optid = $v->id;
						$opt = option_data($v->id, $_POST[options][$count][$optid]);
						if ($opt[value] != $v->value) {
							$new_price -= ($v->price>=$opt[price])?($v->price-$opt[price]):0;
							$noptions[$optid] = $_POST[options][$count][$optid];
							$add_price += $opt[price];
						} else {
							$new_price -= $v->price;
							$noptions[$optid] = ($v->valueid!="")?$v->valueid:$v->value;
							$add_price += $v->price;
						}
					}
					$subtot += (($new_price + $add_price)*$_POST[quantities][$count]);
					$nitem = new item($_POST[ids][$count], $_POST[quantities][$count], $noptions);
					$DB_site->query("UPDATE `".$dbprefix."orders_products` set `price`='".$new_price."', `data`='".addslashes(base64_encode($nitem->return_serialized()))."' where `id`='".$row[id]."'");
				}
				$count++;
			}
		}

		if ($_POST[Submit] == "Save & Add Product") {
			$info = get('products', $_POST[add_id]);
			$def_price = $info[price];
			$noptions = array();
			$options = $DB_site->query("SELECT * FROM `".$dbprefix."products_options` where `productid`='".$_POST[add_id]."' order by `dorder`");
			while ($option = $DB_site->fetch_assoc($options)) {
				switch ($option[type]) {
					case 'textbox':	case 'textarea': case 'checkbox':
						$noptions[$option[id]] = '';
						break;
					case 'select': case 'radio':
						$default = $DB_site->query_first("SELECT * FROM `".$dbprefix."products_options_items` where `value`='".$option['default']."' AND optionid='".$option[id]."'");
						if ($default[id] == '') $default = $DB_site->query_first("SELECT * FROM `".$dbprefix."products_options_items` where optionid='".$option[id]."' order by `dorder`");
						$noptions[$option[id]] = $default[id];
						break;
				}
			}
			$nitem = new item($_POST[add_id], '1', $noptions);
			$DB_site->query("INSERT INTO `".$dbprefix."orders_products` set
				`orderid`='".$_POST[id]."',
				`productid`='".$_POST[add_id]."',
				`price`='".$def_price."',
				`data`='".addslashes(base64_encode($nitem->return_serialized()))."',
				`item`='".sf(base64_encode(serialize(array('num' => $info[num], 'title' => $info[title], 'short_desc' => $info[short_desc], 'full_desc' => $info[full_desc]))))."'
			");
		}

		if ($_POST[Submit] == "Save & Recalculate") {
			$_POST[subtotal] = $subtot;
			$_POST[total] = $subtot+$_POST[ship_price]+$_POST[tax]-$_POST[coupon_savings]-$_POST[gift_cert_savings]-$_POST[rewards_savings]-$_POST[discount];
		}

		$order = get('orders', $_POST[id]);
		if ($_POST[cc_card_no] == $order[cc_card_no_lastfour]) unset($_POST[cc_card_no]);

		$query 	= "UPDATE `".$dbprefix."orders` set";
		$result = $DB_site->query("DESCRIBE `".$dbprefix."orders`");
		while ($field = $DB_site->fetch_assoc($result)) {
			if (isset($_POST[$field['Field']])) {
				if ($field['Field'] == "cc_card_no") $_POST[cc_card_no] = encryptit($_POST[cc_card_no]);
				$query .= " `".$field['Field']."`='".sf($_POST[$field['Field']])."',";
			}
		}
		$query .= " `id`='".$_POST[id]."' where `id`='".$_POST[id]."'";
		$DB_site->query($query);

		// Update Fields
		$results = $DB_site->query_first("SELECT `id` FROM `".$dbprefix."orders_custom_entries` where `orderid`='".$_POST[id]."'");
		if ($results[id] != '') update_custom($_POST[customfield][orders], 'orders', 'orderid', $_POST[id], true);
		$results = $DB_site->query_first("SELECT `id` FROM `".$dbprefix."users_custom_entries` where `userid`='".$_POST[userid]."'");
		if ($results[id] != '') update_custom($_POST[customfield][users], 'users', 'userid', $_POST[userid], true);
		$results = $DB_site->query_first("SELECT `id` FROM `".$dbprefix."users_custom_entries` where `orderid`='".$_POST[id]."'");
		if ($results[id] != '') update_custom($_POST[customfield][users], 'users', 'orderid', $_POST[id], true);

		if ($_POST[carrier] != "" || $_POST[number] != "") {
			$DB_site->query("DELETE FROM `".$dbprefix."orders_tracking` where `orderid`='".$_POST[id]."'");
			$DB_site->query("INSERT INTO `".$dbprefix."orders_tracking` set `orderid`='".$_POST[id]."', `number`='".sf($_POST[number])."', `carrier`='".$_POST[carrier]."', `datestamp`='".stamp()."'");
		}

		if ($_POST[email3]) dropship_notify();

		if ($_POST[email1] || $_POST[email2]) {
			$tracking = get('orders_tracking', $_POST[id], 'orderid');
			$order = get('orders', $_POST[id]);
			$details = array_merge($tracking, $order);

			include $abs_path.'/include/classes/class.shiptrack.php';
			$track = new shiptrack();

			$details[carrier] 	= $details[carrier]!=""?$details[carrier]:'N/A';
			$details[number] 	= $details[number]!=""?$details[number]:'N/A';
			$details[url] 		= $details[number]!=""?$track->return_link($details[carrier], $details[number], $details[number]):'N/A';
			$details['datestamp'] = date($settings[datestamp].' '.$settings[timestamp], $details[order_stamp]);

			$email = template('email_order_status_update.html', $details, 1, '/themes/'.$settings[theme]);
			mail_send($order[email], $order[bill_first_name].' '.$order[bill_last_name], $settings[title].' '.$lang[ordup], $email, $settings[contactemail], $settings[title], true);
		}

		if ($_POST[approvepp]) {
			$order = get('orders', $_POST[id]);
			require_once $abs_path.'/include/classes/class.rewards.php';
			$rp = new rewards_points();
			$rp->update_points($order);
		}

		if ($_POST[Submit] == "Save & Add Product" || $_POST[Submit] == "Save Transaction" || $_POST[Submit] == "Save & Recalculate") {
			$status = $lang['transup']."<br />";
			$_GET[id]  = $_POST[id];
			$_GET[sub] = "edit";
		} else {
			$status = $lang['transup']."<br />";
			$_GET[sub] = "view";
		}
	}

	/////////////////////
	// Transaction Delete
	/////////////////////

	if ($_GET[sub] == "delete") {
		$DB_site->query("DELETE FROM `".$dbprefix."orders_tracking` WHERE `orderid`='".$_GET[id]."'");
		$DB_site->query("DELETE FROM `".$dbprefix."orders_notes` WHERE `orderid`='".$_GET[id]."'");
		$DB_site->query("DELETE FROM `".$dbprefix."orders_products` WHERE `orderid`='".$_GET[id]."'");
		$DB_site->query("DELETE FROM `".$dbprefix."orders` WHERE `id`='".$_GET[id]."'");

		$status = $lang['transdel']."<br />";
		$_GET[sub] = "view";
		$_GET[id] = "";
	}

	///////////////////
	// View Transaction
	///////////////////

    if ($_GET[sub] == "view" && $_GET[id] == "") {
		$_GET[orderby]	= ($_GET[orderby]=='')?'order_stamp':$_GET[orderby];
		$_GET[sort]		= ($_GET[sort]=='')?'desc':$_GET[sort];
		$_GET[pg] 		= (isset($_GET[pg]) && $_GET[pg] > 0)?intval($_GET[pg]):0;

		if ($_POST[s] != "") {
			$sess->dvar('tsearch');
			$sess->svar('tsearch', $_POST[s]);
		} elseif ($_POST[s] == "" && $_GET[pg] != "") {
			$_POST[s] = $sess->gvar('tsearch');
		} else {
			$sess->dvar('tsearch');
		}

		$tablestart = contentstart(array(template('form_toggle_checkbox.html', array('cname' => 'selectall', 'name' => 'item', 'form' => 'bulk')), l($lang['id'],"id"), l($lang['date'],"order_stamp"), l($lang['status'],"status"), l($lang['payment'],"cc_status"), l($lang['total'],"total"), $lang['action']), array(), array("center","center","left","left","left","left","center"), "#536da7", 1);
		$query = (($_POST[s]!="")?trans_search($_POST[s]):"SELECT id FROM `".$dbprefix."orders`")." order by ".$_GET[orderby]." ".$_GET[sort]." LIMIT ".((($_GET[pg]==0)?0:$_GET[pg]-1)*$settings[admin_transactions_max]).",".$settings[admin_transactions_max];

		$append = preg_replace('/pg=([0-9]*)/', '', (($_GET[pg]=="")?'&amp;':'').htmlentities($_SERVER["QUERY_STRING"]));
		$page = new pager($query, template('list_pages_output.html', array(), 0), 5, $settings[admin_transactions_max], $_GET[pg], $append);
		$list[pages] = $page->paginate();

		$table1content = $list[pages]."<br />";
		$table1content .= $forms->start(array('name' => 'bulk', 'url' => 'adminindex.php?action=transactions&sub=view'.(($_GET[type]!="")?'&type='.$_GET[type]:''), 'hide' => 'Table'));
		$table1content .= $tablestart;

		$results = $DB_site->query($query);
		while ($row = $DB_site->fetch_assoc($results)) {
			$tran = get('orders', $row[id]);
			$links  = ($admin[view_trans]==1)?icon(1, "adminindex.php?action=transactions&sub=view&id=$row[id]").icon(6, "adminindex.php?action=transactions&sub=print&id=$row[id]\" target=\"_PLIST").icon(5, "adminindex.php?action=transactions&sub=plist&id=$row[id]\"  target=\"_PLIST"):'';
			$links .= ($admin[manage_trans]==1)?icon(2, "adminindex.php?action=transactions&sub=edit&id=$row[id]").icon(3, "adminindex.php?action=transactions&sub=delete&id=$row[id]\" onclick=\"return jsconfirm();"):'';
			$links  .= ($admin[view_trans]==1)?icon(14, "javascript:get_order_data($row[id]);", "image_$row[id]"):'';
			$table1content .= content(array(template('form_checkbox.html', array('value' => $row[id], 'name' => 'item[]')), $row[id], date($settings[datestamp], $tran[order_stamp]), $tran[status], $tran[cc_status], p($tran[total]), $links), array(), array("center","center","left","left","left","left","center"), '', (($tran[status]=='Pending')?'#fffed7':''));
			$table1content .= template('transaction_hiddenrow.html', array('id' => $row[id]));
		}
		$table1content .= contentend();
		$table1content .= bulk_action().$forms->end(array('hide' => 'Table'));
		$table1content .= "<br />".$list[pages];

		$statuslist = get_data_array('status', 'name', 'dorder', "WHERE `type`='2'");
		array_unshift($statuslist, 'Any');
		$statuses = $forms->item("dropdown", "", "s[status]", $forms->farray($statuslist, $statuslist), "", "", "", array('style' => 'width: 100%;', 'return_item' => 1));

		$smonth = $forms->item("date", "", "s[smonth]", "month", date('n'), "", "", array('return_item' => 1));
		$sday   = $forms->item("date", "", "s[sday]", "day", date('j'), "", "", array('return_item' => 1));
		$syear  = $forms->item("date", "", "s[syear]", "year2", date('Y')-1, "", "", array('return_item' => 1));

		$emonth = $forms->item("date", "", "s[emonth]", "month", date('n'), "", "", array('return_item' => 1));
		$eday   = $forms->item("date", "", "s[eday]", "day", date('j'), "", "", array('return_item' => 1));
		$eyear  = $forms->item("date", "", "s[eyear]", "year2", (date('Y')), "", "", array('return_item' => 1));

		$table1 = starttable("545", $lang['trans_search'], template('transaction_search.html', array('statuses' => $statuses, 'smonth' => $smonth, 'sday' => $sday, 'syear' => $syear, 'emonth' => $emonth, 'eday' => $eday, 'eyear' => $eyear)), array());
		$table2 = starttable("545", $lang['trans'], $table1content, array());

		$out = (($status!="")?status($status):"")."$table1<br>$table2";
	}

	//////////////////////////
	// View Transaction Detail
	//////////////////////////

	 if ($_GET[sub] == "view" && $_GET[id] != "") {
		$info = get('orders', $_GET[id]);

		// Load Module
		if ($info[pm_module] != "") {
			include_once $abs_path."/include/".$info[pm_type]."/".$info[pm_module];
			$class_vars = module_vars($CLASS_NAME, $info[pm_type]);
			$module = new $CLASS_NAME($class_vars);

			if (method_exists($module, 'load_actions')) {
				$data = $module->load_actions();
				$mod = array();
				$mod[actions]	= array();
				$mod[names]	= array();
				foreach ($data as $k => $v) {
					array_push($mod[actions], $v);
					array_push($mod[names], $k);
				}
				array_unshift($mod[actions], '');
				array_unshift($mod[names], 'Please Select...');
			}
		}

	 	switch ($_GET['do']) {
			case 'module_action':
				$cconnect = new curl_connect();
				$info = get('orders', $_GET[id]);
				$track = get('orders_tracking', $_GET[id], 'orderid');
				$status = $module->$_GET[perform](array_merge($info, $track));
				break;
			case 'clearcc':
				$DB_site->query("UPDATE `".$dbprefix."orders` set `cc_card_no`='' where `id`='".$_GET[id]."'");
				$status = $lang['cc_clear']."<br />";
				$_GET[tab] = 2;
				break;
			case 'clearcvv2':
				$DB_site->query("UPDATE `".$dbprefix."orders` set `cc_cvv2`='' where `id`='".$_GET[id]."'");
				$status = $lang['cvv_clear']."<br />";
				$_GET[tab] = 2;
				break;
			case 'delnote':
				$DB_site->query("DELETE FROM `".$dbprefix."orders_notes` where `id`='".$_GET[noteid]."'");
				$status = $lang['order_clear']."<br />";
				$_GET[tab] = 4;
				break;
			case 'addnote':
				$DB_site->query("INSERT INTO `".$dbprefix."orders_notes` set
					`orderid`='".$_GET[id]."',
					`type`='A',
					`private`='".$_POST['private']."',
					`note`='".sf($_POST[note])."',
					`addedby`='".$sess->gvar('adminid')."',
					`datestamp`='".stamp()."'
				");
				$status = $lang['order_store']."<br />";
				$_GET[tab] = 4;

				if ($_POST['private'] != 1) {
					$info['datestamp'] = date($settings[datestamp].' '.$settings[timestamp], $info[order_stamp]);
					$email = template('email_order_note_update.html', $info, 1, '/themes/'.$settings[theme]);
					mail_send($info[email], $info[bill_first_name].' '.$info[bill_last_name], $settings[title].': '.$lang[nordnote], $email, $settings[contactemail], $settings[title], true);
				}
				break;
			default:
				break;
		}

		$info = get('orders', $_GET[id]);
		$track = get('orders_tracking', $_GET[id], 'orderid');
		$log = get('users_rewards_log', $_GET[id].'\' AND `earned`>\'0\'', 'orderid');

		if ($_POST[Submit] == 'Decrypt') {
			 $decrypted = decryptit($info[cc_card_no]);
			 if (!is_numeric(str_replace(array('-', ' ', 'X'), '', $decrypted))) { $decrypted = ""; $status = $lang['idecr']."<br />"; }
		}

		$bill_info  = "$info[bill_first_name] $info[bill_last_name]<br />".(($info[bill_company_name]!="")?"$info[bill_company_name]<br />":"");
		$bill_info .= "$info[bill_address1]<br />".(($info[bill_address2]!="")?"$info[bill_address2]<br />":"");
		$bill_info .= "$info[bill_city], $info[bill_state] $info[bill_zip]<br />$info[bill_country]";

		$ship_info  = "$info[ship_first_name] $info[ship_last_name]<br />".(($info[ship_company_name]!="")?"$info[ship_company_name]<br />":"");
		$ship_info .= "$info[ship_address1]<br />".(($info[ship_address2]!="")?"$info[ship_address2]<br />":"");
		$ship_info .= "$info[ship_city], $info[ship_state] $info[ship_zip]<br />$info[ship_country]";

		$tranhide1 = ($admin[view_trans]!=1)?array('Print', 'Packing'):array();
		$tranhide2 = ($admin[manage_trans]!=1)?array('Edit', 'Delete'):array();
		$tranhide3 = array('View');

		$start = template('transaction_icons.html', array('id' => $info[id], 'hide' => array_merge($tranhide1, $tranhide2, $tranhide3)));
		$start .= $forms->start(array('url' => 'adminindex.php?action=transactions&sub=update', 'name' => 'transaction_edit'));
		$start .= $forms->item("hidden", "", "id", "", $info[id]);
		$start .= $forms->item("show", $lang['orderi'].":", "", "", $info[id]);
		$start .= $forms->item("show", $lang['date'].":", "", "", date($settings[datestamp], $info[order_stamp]).' '.date($settings[timestamp], $info[order_stamp]));
		$start .= ($info[userid]!=0)?$forms->item("show", $lang['us_customer'].":", "", "", '<a href="adminindex.php?action=users&sub=edit&type=user&id='.$info[userid].'">'.$info[userid].'</a>'):'';
		$start .= $forms->item("show", $lang['billinfo2'].":", "", "", $bill_info);
		$start .= $forms->item("show", $lang['shipinfo2'].":", "", "", $ship_info);
		$start .= $forms->item("show", $lang['phone'].":", "", "", $info[phone]);
		$start .= $forms->item("show", $lang['email'].":", "", "", '<a href="mailto:'.$info[email].'">'.$info[email].'</a>');
		$start .= $forms->end(array('hide' => 'Form'));

		// Order Details
		$content = contentstart(array($lang['id'], $lang['name'], $lang['unitprice'], $lang['qty'], $lang['total']), array(), array("left","left","left","center","right"), "#536da7", "", "500");
		$results = $DB_site->query("SELECT * FROM `".$dbprefix."orders_products` where `orderid`='".$_GET[id]."' ORDER by `id`");
		while ($row = $DB_site->fetch_assoc($results)) {
			$row  = filter_data($row);
			$prod = unserialize(base64_decode($row[item]));
			$item = new orderitem ($row[data]);
			if ($_GET['do'] == "resend" && $row[id] == $_GET[gs_id]) { $gs->resend($gs->cert_array($item->item->options[0])); $status = $lang['gcresent']; }
			$content .= content(array(shortenit($prod[num], 10), '<a href="adminindex.php?action=products&sub=edit&id='.$row[productid].'" style="text-decoration: none;">'.shortenit($prod[title], 35).'</a><br />'.$item->display_options().(($prod[num]=='gift_cert')?'[ <a href="adminindex.php?action=transactions&sub=view&id='.$_GET[id].'&do=resend&gs_id='.$row[id].'" style="text-decoration: none;">Resend Certificate Email</a> ]':''), p($row[price]+$item->options_price_increase()), $item->get_quantity(), p(($row[price]+$item->options_price_increase())*$item->get_quantity())), array(), array("left","left","left","center","right"));
		}
		$vari = array('subtotal', 'discount', 'coupon_savings', 'ship_price', 'tax', 'gift_cert_savings', 'rewards_savings');
		$nams = array($lang['subtotal'], $lang['disc'], $lang['coupon_save'], $lang['shipping'], $lang['tax'], $lang['giftc2'], $lang['rew2']);
		foreach ($vari as $k => $v) {
			$content .= (p($info[$v])!=p('0.00'))?content(array('<strong>'.$nams[$k].':</strong> ', '', '', '', (($k==1 || $k==2 || $k==5 || $k==6)?'-':'&nbsp;').p($info[$v])), array(), array("right","left","left","right","right"), "", "", array('4', 'skip', 'skip', 'skip', '1')):'';
		}
		$content .= content(array('<strong>'.$lang['total'].':</strong> ', '', '', '', '&nbsp;'.p($info[total])), array(), array("right","left","left","right","right"), "", "", array('4', 'skip', 'skip', 'skip', '1'));
		$content .= contentend();

		$content .= $forms->start(array('hide' => 'Form'));
		$content .= $forms->item("show", $lang['shippingm'].":", "", "", $info[ship_method]);
		$content .= ($info[coupon]!="")?$forms->item("show", $lang['couponnum'].":", "", "", $info[coupon]):'';
		$content .= ($info[gift_cert]!="")?$forms->item("show", $lang['giftc2'].":", "", "", $info[gift_cert]):'';
		$content .= (p($info[rewards_savings])!=p(0))?$forms->item("show", $lang['pused'].":", "", "", p($info[rewards_savings]/$settings[points_to_dollars],false)):'';
		$content .= ($log[id]!="" && p($log[earned])!=p(0))?$forms->item("show", $lang[(($log[status]=='pending')?'ppearned':'pearned')].":", "", "", $log[earned]):'';
		$content .= ($info[comments]!="")?$forms->item("show", $lang['ordercom'].":", "", "", $info[comments]):'';
		$content .= $forms->end(array('hide' => 'Form'));

		$tab_items .= tab_item($lang['orddet'], $content);

		// Payment Information
		$statuslist = get_data_array('status', 'name', 'dorder', "WHERE `type`='1'");
		$form  = $forms->start(array('hide' => 'Form'));
		$form .= $forms->item("show", $lang['custipaddr'].":", "", "", '<a href="javascript:void(0);" onclick="toggle_div(\'ipinfo\');">'.$info[ip_addr].'</a>'.template('orders_ip_info.html', array('ipinfo' => ip_lookup($info[ip_addr]))));
		$form .= $forms->item("show", $lang['paymeth'].":", "", "", $info[pay_method]);
		$form .= ($info[pm_name]!="")?$forms->item("show", $lang['processor'].":", "", "", $info[pm_name]):'';
		$form .= ($info[pm_orderid]!="")?$forms->item("show", $lang['tranxnum'].":", "", "", $info[pm_orderid]):'';
		$form .= ($info[pm_avs]!="")?$forms->item("show", $lang['avsmatch'].":", "", "", $info[pm_avs]):'';
		$form .= ($info[pm_cvn]!="")?$forms->item("show", $lang['cvnmatch'].":", "", "", $info[pm_cvn]):'';
		$form .= ($info[pm_notes]!="")?$forms->item("show", $lang['procnotes'].":", "", "", $info[pm_notes]):'';
		$form .= ($info[cc_name_on_card]!="")?$forms->item("show", $lang['nsmeonc'].":", "", "", $info[cc_name_on_card]):'';
		$form .= ($info[cc_card_no_lastfour]!="" && $decrypted=="")?$forms->item("show", $lang['cc_numb'].":", "", "", $info[cc_card_no_lastfour].(($info[cc_card_no]!="")?' - (<a href="javascript:void(0);" onclick="toggle_div(\'getkey\');">'.$lang['show'].'</a>)':'').template('orders_get_key.html')):'';
		$form .= ($info[cc_card_no]!="" && $decrypted!="")?$forms->item("show", $lang['cc_numb'].":", "", "", $decrypted.' - (<a href="adminindex.php?action=transactions&sub=view&id='.$info[id].'&do=clearcc" onclick="return jsconfirm();">'.$lang['clear'].'</a>)'):'';
		$form .= ($info[cc_card_type]!="")?$forms->item("show", $lang['cc_type'].":", "", "", $info[cc_card_type]):'';
		$form .= ($info[cc_cvv2]!="" && $decrypted!="")?$forms->item("show", $lang['cvv2'].":", "", "", $info[cc_cvv2].' - (<a href="adminindex.php?action=transactions&sub=view&id='.$info[id].'&do=clearcvv2" onclick="return jsconfirm();">'.$lang['clear'].'</a>)'):'';
		$form .= ($info[cc_expir_date]!="")?$forms->item("show", $lang['expires'].":", "", "", $info[cc_expir_date]):'';
		$form .= ($info[cc_start_date]!="")?$forms->item("show", $lang['startdate'].":", "", "", $info[cc_start_date]):'';
		$form .= ($info[cc_issue_number]!="")?$forms->item("show", $lang['issueno'].":", "", "", $info[cc_issue_number]):'';
		$form .= ($info[po_company]!="")?$forms->item("show", $lang['poco'].":", "", "", $info[po_company]):'';
		$form .= ($info[po_number]!="")?$forms->item("show", $lang['ponumber'].":", "", "", $info[po_number]):'';
		$form .= is_array($mod)?$forms->item("dropdown", $lang['modactions'].":", "mod_action", $forms->farray($mod[actions], $mod[names]), $info[cc_status], '', '', array('onchange' => "javascript:module_action('".$info[id]."', this.value);")):"";
		$form .= $forms->item("dropdown", $lang['paystatus'].":", "cc_status", $forms->farray($statuslist, $statuslist), $info[cc_status]);
		$form .= $forms->item("radio", help($lang['emailnewstatus'], $lang['emailnewstatus_d']), "email1", $forms->farray(array(1, 0), array($lang['yes'], $lang['no'])), $lang['no']);
		$form .= (($log[status]=='pending')?$forms->item("radio", help($lang['ppapprove'], $lang['ppapprove_d']), "approvepp", $forms->farray(array(1, 0), array($lang['yes'], $lang['no'])), $lang['no']):'');
		$form .= $forms->item("submit", "", "", "", $lang['updatetrx']);
		$form .= $forms->end(array('hide' => 'Form'));

		$tab_items .= tab_item($lang['payinfo'], $form);

		// Status Information
		$statuslist = get_data_array('status', 'name', 'dorder', "WHERE `type`='2'");
		$form  = $forms->start(array('hide' => 'Form'));
		$form .= $forms->item("dropdown", $lang['ts_status'].":", "status", $forms->farray($statuslist, $statuslist), $info[status]);
		$form .= $forms->item("dropdown", $lang['carrier'].":", "carrier", $forms->farray(array('', 'USPS', 'UPS', 'Fedex', 'DHL', 'Canada Post', 'Australian Post', 'Other'), array('Please Select', 'USPS', 'UPS', 'Fedex', 'DHL', 'Canada Post', 'Australian Post', 'Other')), $track[carrier]);
		$form .= $forms->item("textbox", $lang['tracknum'].":", "number", "", $track[number], 35);
		$form .= $forms->item("radio", $lang['emailnew'].":", "email2", $forms->farray(array(1, 0), array($lang['yes'], $lang['no'])), "No");
		$form .= ($settings[dropshipon]=='1')?$forms->item("radio", (($info[dropship_notified]=='0' || $info[dropship_notified]=='')?$lang['send']:$lang['resend']).' '.$lang['vemails'].":", "email3", $forms->farray(array(1, 0), array($lang['yes'], $lang['no'])), "No"):'';
		$form .= $forms->item("submit", "", "", "", $lang['updatetrx']);
		$form .= $forms->end();

		$tab_items .= tab_item($lang['statinfo'], $form);

		// Order Notes
		$notesc = 0;
		$results = $DB_site->query("SELECT * FROM `".$dbprefix."orders_notes` where `orderid`='".$_GET[id]."' order by `datestamp`");
		while ($row = $DB_site->fetch_assoc($results)) {
			$notesc++;
			$row = filter_data($row);
			$datetime = date($settings[datestamp].' '.$settings[timestamp], $row[datestamp]);
			$notes .= template('add_order_note_item.html', array('id' => $_GET[id], 'type' => ($row['private']==1)?'Private':'Public', 'noteid' => $row[id], 'datetime' => $datetime, 'addedby' => $row[addedby],  'note' => $row[note]));
		}
		$content = template('add_order_note.html', array('id' => $_GET[id], 'notes' => $notes));

		$tab_items .= tab_item($lang['ordernotes'].' ('.$notesc.')', $content);

		// Custom Fields
		$results = $DB_site->query_first("SELECT `id` FROM `".$dbprefix."orders_custom_entries` where `orderid`='".$_GET[id]."'");
		if ($results[id] != '') $custom_fields = cf_show('orders', 'orderid', $_GET[id]);
		$results = $DB_site->query_first("SELECT `id` FROM `".$dbprefix."users_custom_entries` where `orderid`='".$_GET[id]."'");
		if ($results[id] != '') $custom_fields .= cf_show('users', 'orderid', $_GET[id]);

		$form  = $forms->start(array('hide' => 'Form'));
		$form .= $custom_fields;
		$form .= $forms->item("submit", "", "", "", $lang['updatetrx']);
		$form .= $forms->end();

		$tab_items .= ($custom_fields!='')?tab_item($lang['custfields'], $form):'';

		$data = $start.start_tabs($tab_items);

		$out = (($status!="")?status($status):"").starttable("545", "Order Information", $data);
	}

	////////////////////
	// Edit Transactions
	////////////////////

	 if ($_GET[sub] == "edit") {
		$info = get('orders', $_GET[id]);
		$track = get('orders_tracking', $_GET[id], 'orderid');

		$tranhide1 = ($admin[view_trans]!=1)?array('View', 'Print', 'Packing'):array();
		$tranhide2 = ($admin[manage_trans]!=1)?array('Delete'):array();
		$tranhide3 = array('Edit');

		$start  = template('transaction_icons.html', array('id' => $info[id], 'hide' => array_merge($tranhide1, $tranhide2, $tranhide3)));
		$start .= $forms->start(array('url' => 'adminindex.php?action=transactions&sub=update', 'name' => 'transaction_edit'));
		$start .= $forms->item("hidden", "", "id", "", $info[id]);
		$start .= $forms->item("show", $lang['orderi'].":", "", "", $info[id]);
		$start .= $forms->item("show", $lang['date'].":", "", "", date($settings[datestamp], $info[order_stamp]).' '.date($settings[timestamp], $info[order_stamp]));
		$start .= $forms->item("textbox", $lang['us_customer'].":", "userid", "", $info[userid], 15);
		$start .= $forms->item("textbox", $lang['phone'].":", "phone", "", $info[phone], 25);
		$start .= $forms->item("textbox", $lang['email'].":", "email", "", $info[email], 35);
		$start .= $forms->end(array('hide' => 'Form'));

		// Product Details
		$count = 1;
		$content = contentstart(array($lang['del'] , $lang['id'], $lang['name'], $lang['unitprice'] , $lang['qty'] , $lang['total'] ), array(), array("center","left","left","left","center","right"), "#536da7", '', "500");
		$results = $DB_site->query("SELECT * FROM `".$dbprefix."orders_products` where `orderid`='".$_GET[id]."' ORDER by `id`");
		while ($row = $DB_site->fetch_assoc($results)) {
			$row  = filter_data($row);
			$prod = unserialize(base64_decode($row[item]));
			$item = new orderitem ($row[data]);
			$content .= content(array(template('form_checkbox.html', array('value' => 'Yes', 'name' => 'removes['.$count.']')), '<input type="hidden" name="ids['.$count.']" value="'.$row[productid].'" size="5">'.shortenit($prod[num], 10), '<a href="adminindex.php?action=products&sub=edit&id='.$row[productid].'" style="text-decoration: none;">'.shortenit($prod[title], 30).'</a>', (($settings[cs_pos]=='before')?$settings[cs]:'').'<input type="textbox" name="prices['.$count.']" value="'.($row[price]+$item->options_price_increase()).'" size="5">'.(($settings[cs_pos]=='after')?$settings[cs]:''), '<input type="textbox" name="quantities['.$count.']" value="'.$item->get_quantity().'" size="2">', p(($row[price]+$item->options_price_increase())*$item->get_quantity())), array(), array("center","left","left","left","center","right"));
			$content .= edit_options($item, $count);
			$count++;
		}

		// Add New
		$items = $forms->item("itemlist", "", "add_id", "", "", "", "", array('style' => 'width: 100%;', 'return_item' => 1, 'addblank' => 1));
		$content .= template('transaction_edit_add_new.html', array('items' => $items));

		$vari = array('subtotal', 'discount', 'coupon_savings', 'ship_price', 'tax', 'gift_cert_savings', 'rewards_savings', 'total');
		$nams = array($lang['subtotal'], $lang['disc'], $lang['coupon_save'], $lang['shipping'], $lang['tax'], $lang['giftc2'], $lang['rew2'], $lang['total']);
		foreach ($vari as $k => $v) {
			$content .= content(array('<strong>'.$nams[$k].':</strong> ', '', '', '', '', (($k==1 || $k==2 || $k==5 || $k==6)?'-':'&nbsp;').(($settings[cs_pos]=='before')?$settings[cs]:'').'<input type="text" name="'.$v.'" value="'.$info[$v].'" size="6">'.(($settings[cs_pos]=='after')?$settings[cs]:'')), array(), array("right","left","left","left","right","right"), "", "", array('5', 'skip', 'skip', 'skip', 'skip', '1'));
		}
		$content .= content(array('', '', '', '', '', '<input type="submit" name="Submit" value="'.$lang['saverec'].'" class="submit_button" />'), array(), array("right","left","left","left","right","right"), "", "", array('5', 'skip', 'skip', 'skip', 'skip', '1'));
		$content .= contentend();
		$content .= $forms->start(array('hide' => 'Form'));
		$content .= $forms->item("textbox", $lang['shippingm'].":", "ship_method", "", $info[ship_method]);
		$content .= $forms->item("textbox", $lang['couponnum'].":", "coupon", "", $info[coupon]);
		$content .= $forms->item("textbox", $lang['giftc2'].":", "gift_cert", "", $info[gift_cert]);
		$content .= $forms->item("textarea", $lang['orderc'].":", "comments", "", $info[comments], 40, 2);
		$content .= $forms->item("submit", "", "", "", $lang['updatetrx']);
		$content .= $forms->end(array('hide' => 'Form'));

		$tab_items .= tab_item($lang['orddet'], $content);

		// Billing & Shipping Information
		$types = array('bill', 'ship');
		$names = array($lang['billaddr'], $lang['shipaddr']);
		foreach ($types as $k => $v) {
			$form  = $forms->start(array('hide' => 'Form'));
			$form .= $forms->item("textbox", $lang['firstn'].":", $v.'_first_name', "", $info[$v.'_first_name'], 20);
			$form .= $forms->item("textbox", $lang['lastn'].":", $v.'_last_name', "", $info[$v.'_last_name'], 20);
			$form .= $forms->item("textbox", $lang['companyn'].":", $v.'_company_name', "", $info[$v.'_company_name'], 20);
			$form .= $forms->item("textbox", $lang['addr1bill'].":", $v.'_address1', "", $info[$v.'_address1'], 20);
			$form .= $forms->item("textbox", $lang['addr2bill'].":", $v.'_address2', "", $info[$v.'_address2'], 20);
			$form .= $forms->item("textbox", $lang['city'].":", $v.'_city', "", $info[$v.'_city'], 20);
			$form .= $forms->item("textbox", $lang['state2'].":", $v.'_state', "", $info[$v.'_state'], 20);
			$form .= $forms->item("textbox", $lang['mzip2'].":", $v.'_zip', "", $info[$v.'_zip'], 20);
			$form .= $forms->item("textbox", $lang['country'].":", $v.'_country', "", $info[$v.'_country'], 20);
			$form .= $forms->item("submit", "", "", "", $lang['updatetrx']);
			$form .= $forms->end(array('hide' => 'Form'));

			$tab_items .= tab_item($names[$k], $form);
		}

		// Payment Information
		$statuslist = get_data_array('status', 'name', 'dorder', "WHERE `type`='1'");
		$form  = $forms->start(array('hide' => 'Form'));
		$form .= $forms->item("textbox", $lang['custipaddr'].":", "ip_addr", "", $info[ip_addr], 15);
		$form .= $forms->item("textbox", $lang['paymeth'].":", "pay_method", "", $info[pay_method], 15);
		$form .= $forms->item("textbox", $lang['processor'].":", "pm_name", "", $info[pm_name], 25);
		$form .= $forms->item("textbox", $lang['tranxnum'].":", "pm_orderid", "", $info[pm_orderid], 25);
		$form .= $forms->item("textbox", $lang['avsmatch'].":", "pm_avs", "", $info[pm_avs], 25);
		$form .= $forms->item("textbox", $lang['cvnmatch'].":", "pm_cvn", "", $info[pm_cvn], 25);
		$form .= $forms->item("textbox", $lang['procnotes'].":", "pm_notes", "", $info[pm_notes], 25);
		$form .= $forms->item("textbox", $lang['preauth'].":", "pm_preauth", "", $info[pm_preauth], 25);
		$form .= $forms->item("textbox", $lang['pocompany'].":", "po_company", "", $info[po_company], 25);
		$form .= $forms->item("textbox", $lang['ponumb'].":", "po_number", "", $info[po_number], 25);
		$form .= $forms->item("textbox", $lang['nsmeonc'].":", "cc_name_on_card", "", $info[cc_name_on_card], 25);
		$form .= $forms->item("textbox", $lang['cc_numb'].":", "cc_card_no", "", $info[cc_card_no_lastfour], 25);
		$form .= $forms->item("textbox", $lang['cc_type'].":", "cc_card_type", "", $info[cc_card_type], 25);
		$form .= $forms->item("textbox", $lang['cvv2'].":", "cc_cvv2", "", $info[cc_cvv2], 5);
		$form .= $forms->item("textbox", $lang['expires'].":", "cc_expir_date", "", $info[cc_expir_date], 5);
		$form .= $forms->item("textbox", $lang['startdate'].":", "cc_start_date", "", $info[cc_start_date], 5);
		$form .= $forms->item("textbox", $lang['issueno'].":", "cc_issue_number", "", $info[cc_issue_number], 5);
		$form .= $forms->item("submit", "", "", "", $lang['updatetrx']);
		$form .= $forms->end(array('hide' => 'Form'));

		$tab_items .= tab_item($lang['payinfo'], $form);

		// Custom Fields
		$results = $DB_site->query_first("SELECT `id` FROM `".$dbprefix."orders_custom_entries` where `orderid`='".$_GET[id]."'");
		if ($results[id] != '') $custom_fields = cf_edit('orders', 'orderid', $_GET[id]);
		$results = $DB_site->query_first("SELECT `id` FROM `".$dbprefix."users_custom_entries` where `orderid`='".$_GET[id]."'");
		if ($results[id] != '') $custom_fields .= cf_edit('users', 'orderid', $_GET[id]);

		$form  = $forms->start(array('hide' => 'Form'));
		$form .= $custom_fields;
		$form .= $forms->item("submit", "", "", "", $lang['updatetrx']);
		$form .= $forms->end();

		$tab_items .= ($custom_fields!='')?tab_item($lang['custfields'], $form):'';

		$data = $start.start_tabs($tab_items);

		$out = (($status!="")?status($status):"").starttable("545", $lang['edit'].' '.$lang['order'], $data);
	}

	///////////////////////
	// Print & Packing List
	///////////////////////

	if ($_GET[sub] == "plist" || $_GET[sub] == "print") {
		$info = get('orders', $_GET[id]);

		$showbc = ($settings['showbc_'.$_GET[sub]]=='Yes')?true:false;

		$info[date] = date($settings[datestamp], $info[order_stamp]);
		$info[time] = date($settings[timestamp], $info[order_stamp]);

		$info[hide] = array();
		$hides = array('userid', 'bill_company_name', 'bill_address2', 'ship_company_name', 'ship_address2', 'tax');
		foreach ($hides as $k => $v) {
			if ($info[$v] == "" || (p($info[$v]) == p(0.00) && is_numeric(str_replace('.', '', $info[$v]))))
				array_push($info[hide], $hides[$k]);
		}

		if (!$showbc) { array_push($info[hide], 'orderid_barcode'); array_push($info[hide], 'userid_barcode'); }
		else { $info[orderid_barcode] = urlencode($info[id]); $info[userid_barcode] = urlencode($info[userid]); }
		if ($info[userid]=='' || $info[userid]==0) array_push($info[hide], 'userid_barcode');

		$price = array('subtotal', 'discount', 'coupon_savings', 'ship_price', 'tax', 'gift_cert_savings', 'rewards_savings');
		foreach ($price as $k => $v) {
			$info[$v] = p($info[$v]);
			if (p(0) == $info[$v]) array_push($info[hide], $v);
		}

		$count = 1;
		$results = $DB_site->query("SELECT * FROM `".$dbprefix."orders_products` where `orderid`='".$_GET[id]."' ORDER by `id`");
		while ($row = $DB_site->fetch_assoc($results)) {
			$prod = unserialize(base64_decode($row[item]));
			$item = new orderitem ($row[data]);

			$prod[count] = $count;
			$prod[hide] = array();
			$prod[options] = $item->display_options();
			$prod[quantity] = $item->get_quantity();
			$prod[price] = $row[price]+$item->options_price_increase();
			$prod[ptotal] = ($prod[quantity] * ($row[price]+$item->options_price_increase()));

			if (!$showbc) array_push($prod[hide], 'num_barcode');
			else $prod[num_barcode] = $prod[num];

			$price = array('price', 'ptotal');
			foreach ($price as $k => $v) {
				$prod[$v] = p($prod[$v]);
			}

			$info[items] .= template('packing_list_item.html', $prod);
			$count++;
		}

		$check = ($_GET[sub] != "print")?'packinglist':'printorder';

		$results = $DB_site->query("SELECT * FROM `".$dbprefix."orders_custom_entries` e LEFT JOIN `".$dbprefix."orders_custom_fields` f on e.`fieldid`=f.`id` where e.`orderid`='".$_GET[id]."' AND f.`".$check."`='y'");
		while ($field = $DB_site->fetch_assoc($results)) {
			$field = filter_data($field);
			$info[custom_fields_order] .= template('packing_list_custom_field_item.html', $field);
		}

		if ($info[custom_fields_order] == "") array_push($info[hide],'Custom Order Fields');

		$results = $DB_site->query("SELECT * FROM `".$dbprefix."users_custom_entries` e LEFT JOIN `".$dbprefix."users_custom_fields` f on e.`fieldid`=f.`id` where e.`orderid`='".$_GET[id]."' AND f.`".$check."`='y'");
		while ($field = $DB_site->fetch_assoc($results)) {
			$field = filter_data($field);
			$info[custom_fields_user] .= template('packing_list_custom_field_item.html', $field);
		}

		$results = $DB_site->query("SELECT * FROM `".$dbprefix."users_custom_entries` e LEFT JOIN `".$dbprefix."users_custom_fields` f on e.`fieldid`=f.`id` where e.`userid`='".$info[userid]."' AND f.`".$check."`='y'");
		while ($field = $DB_site->fetch_assoc($results)) {
			$field = filter_data($field);
			$info[custom_fields_user] .= template('packing_list_custom_field_item.html', $field);
		}

		if ($info[custom_fields_user] == "") $info[hide][] = 'Custom User Fields';

		if ($_GET[sub] != "print") array_push($info[hide], 'Admin Notes');
		else {
			$hide_empty = array('pm_name', 'pm_orderid', 'cc_name_on_card', 'cc_card_no', 'cc_card_type', 'cc_cvv2', 'cc_expir_date', 'cc_start_date', 'cc_issue_number', 'po_company', 'po_number', 'gift_cert', 'coupon', 'comments');
			foreach ($hide_empty as $k => $v)
				if ($info[$v] == "") array_push($info[hide], $v);

			if ($_POST[hashkey] == '') {
				$info[cc_card_no] = $info[cc_card_no_lastfour].' - (<a href="javascript:void(0);" onclick="toggle_div(\'getkey\');">Show</a>)';
				$info[cc_card_no] .= template('packing_list_get_key.html');
				$info[cc_cvv2] = '';
			} else {
				$info[cc_card_no] = decryptit($info[cc_card_no]);
			}
		}

		echo template('packing_list.html', $info);
		exit;
	}

	//////////////////////
	// Transaction Reports
	//////////////////////

	if ($_GET[sub] == "reports") {
		include_once $abs_path.'/include/classes/class.reports.php';
		$sreports = new sreports;
		$graphs = new graphs();

		$months = array("01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12");
		for ($year=date("Y",time()); $year>=(date("Y",time())-5); $year--) $years[] = $year;
		for ($day=01; $day<=31; $day+=1) $days[] = $day;

		if (isset($_GET['r'])) {
			switch ($_GET['r']) {
				case "bymonth":
					$dstart = $_POST['year'].'-'.$_POST['month'].'-01';
					$dend 	= $_POST['year'].'-'.$_POST['month'].'-'.date("t", strtotime($dstart));
					$order 	= $_POST['shipstatus'];
					$pay 	= $_POST['paystatus'];

					$sales = $sreports->sales_bydate($dstart, $dend, $order, $pay);
					$sales[average] = p(@(sc($sales[total])/$sales[orders]));

					$graphs->on_fly(date("F", strtotime($dstart)), array($lang['subtotal'] => sc($sales[subtotal]), $lang['tax'] => sc($sales[tax]), $lang['shipping'] => sc($sales[ship_price]), $lang['total'] => sc($sales[total]), $lang['average'] => @(sc($sales[total])/$sales[orders])));
					$this_graph = $graphs->build_fly(515, 225, 10);

					if ($sales[orders] > 0) $form .= $this_graph.template('transaction_reports_by_month.html', $sales);
					else $form .= $sreports->reset(2);
				break;

				case "byproduct":
					$dstart = $_POST['ystart'].'-'.$_POST['mstart'].'-'.$_POST['dstart'];
					$dend 	= $_POST['yend'].'-'.$_POST['mend'].'-'.$_POST['dend'];
					$order 	= $_POST['shipstatus'];
					$pay 	= $_POST['paystatus'];
					$id 	= $_POST['products'];

					$sales = $sreports->sales_byitem($dstart, $dend, $order, $pay, $id);

					if ($sales[quantity] > 0) $form .= template('transaction_reports_by_type.html', $sales);
					else $form .= $sreports->reset(3);
				break;

				case "bycategory":
					$dstart = $_POST['ystart'].'-'.$_POST['mstart'].'-'.$_POST['dstart'];
					$dend 	= $_POST['yend'].'-'.$_POST['mend'].'-'.$_POST['dend'];
					$order 	= $_POST['shipstatus'];
					$pay 	= $_POST['paystatus'];
					$id 	= $_POST['categories'];

					$sales = $sreports->salesbycat($dstart, $dend, $order, $pay, $id);

					if ($sales[quantity] > 0) $form .= template('transaction_reports_by_type.html', $sales);
					else $form .= $sreports->reset(3);
				break;

				case "byvm":
					$dstart = $_POST['ystart'].'-'.$_POST['mstart'].'-'.$_POST['dstart'];
					$dend 	= $_POST['yend'].'-'.$_POST['mend'].'-'.$_POST['dend'];
					$order 	= $_POST['shipstatus'];
					$pay 	= $_POST['paystatus'];
					$id 	= $_POST['vmid'];

					$sales = $sreports->salesbyvm($_POST['from'], $dstart, $dend, $order, $pay, $id);

					if ($sales[quantity] > 0) $form .= template('transaction_reports_by_type.html', $sales);
					else $form .= $sreports->reset(3);
				break;

				case "bytype":
					if (isset($_POST['rtype'])) {
						switch (strtolower($_POST['rtype'])) {
							case "product":
								$form  = $forms->start(array('url' => 'adminindex.php?action=transactions&sub=reports&r=byproduct'));
								$form .= $forms->item("itemlist", $lang['product'].':', "products", "", array(), "", "", array('style' => 'width: 338px;'));
							break;

							case "category":
								$form  = $forms->start(array('url' => 'adminindex.php?action=transactions&sub=reports&r=bycategory'));
								$form .= $forms->item("catlist", $lang['category'].':', "categories", "", "", "", "", array('style' => 'width: 338px;'));
							break;

							case "vendor":
								$vm1 = get_data_array('vendors', 'id', 'company');
								$vm2 = get_data_array('vendors', 'company', 'company');
								$form  = $forms->start(array('url' => 'adminindex.php?action=transactions&sub=reports&r=byvm'));
								$form .= $forms->item("hidden", "", "from", "", "vendors");
								$form .= $forms->item("dropdown", $lang['vendor'].':', "vmid", $forms->farray($vm1, $vm2), "", "", "", array('style' => 'width: 338px;'));
							break;

							case "manufacturer":
								$vm1 = get_data_array('manufacturers', 'id', 'name');
								$vm2 = get_data_array('manufacturers', 'name', 'name');
								$form  = $forms->start(array('url' => 'adminindex.php?action=transactions&sub=reports&r=byvm'));
								$form .= $forms->item("hidden", "", "from", "", "manufacturers");
								$form .= $forms->item("dropdown", $lang['manufacturers'].':', "vmid", $forms->farray($vm1, $vm2), "", "", "", array('style' => 'width: 338px;'));
							break;
						}

						$form .= $forms->item("dropdown", $lang['datestart'], "mstart", $forms->farray($months, $lang['rmonths']), "");
						$form .= $forms->item("dropdown", " ", "dstart", $forms->farray($days, $days), "");
						$form .= $forms->item("dropdown", " ", "ystart", $forms->farray($years, $years), date("Y", stamp()));
						$form .= $forms->item("dropdown", $lang['dateend'], "mend", $forms->farray($months, $lang['rmonths']), date("m", stamp()));
						$form .= $forms->item("dropdown", " ", "dend", $forms->farray($days, $days),  date("t", stamp()));
						$form .= $forms->item("dropdown", " ", "yend", $forms->farray($years, $years),  date("Y", stamp()));
						$form .= $forms->item("dropdown", $lang['rsstatus'], "shipstatus", $forms->farray($sreports->status2, $sreports->status2), "");
						$form .= $forms->item("dropdown", $lang['rpstatus'], "paystatus", $forms->farray($sreports->status1, $sreports->status1), "");
						$form .= $forms->item("submit", "", "", "", "Submit");
						$form .= $forms->end();
					}
				break;
        	}
			$data	.= $form;
			$out	.= starttable("545", $lang['salesrepo'], '<div>'.$data.'</div>', array());
			$pages	.= contentend();

		} else {
			$sales = $sreports->sales_year($_GET[year]);

			$content = contentstart(array('M', '#', $lang['subtotal'], $lang['tax'], $lang['discount'], $lang['shipping'], $lang['gcerts'], $lang['total'], $lang['average']), array(), array("center","center","center","center","center","center","center","center","center"), "#536da7", "", "500");
			foreach($sales as $m => $d) {
				$content .= content(array($d[date], $d[orders], p($d[subtotal], true, true), p($d[tax], true, true), '-'.p($d[discount], true, true), p($d[ship_price], true, true), '-'.p($d[gift_cert_savings], true, true), p($d[total], true, true), p(@($d[total]/$d[orders]), true, true)), array(), array("center","center","center","center","center","center","center","center","center"));
				$add = array('orders', 'subtotal', 'tax', 'discount', 'coupon_savings', 'gift_cert_savings', 'rewards_savings', 'ship_price', 'total');
				foreach ($add as $v) $grand[$v] += p($d[$v], false);
				$graphs->on_fly($d[date], array($lang['tax'] => $d[tax], $lang['shipping'] => $d[ship_price], $lang['total'] => $d[total], $lang['average'] => @($d[total]/$d[orders])));
			}
			$content .= content(array("<strong>Tot:</strong>", "<strong>".$grand[orders]."</strong>", "<strong>".p($grand[subtotal], true, true)."</strong>", "<strong>".p($grand[tax], true, true)."</strong>", '<strong>-'.p($grand[discount], true, true)."</strong>", "<strong>".p($grand[ship_price], true, true)."</strong>", '<strong>-'.p($grand[gift_cert_savings], true, true)."</strong>", "<strong>".p($grand[total], true, true)."</strong>", "<strong>".p(@($grand[total]/$grand[orders])."</strong>", true, true)), array(), array("center","center","center","center","center","center","center","center","center"));
			$content .= contentend();

			$dropdown = $forms->item("dropdown", '', "noner", $forms->farray($years, $years), ($_GET[year]!=""?$_GET[year]:date("Y")), "", "", array('return_item' => 1, 'onchange' => 'javascript:location.href=\'adminindex.php?action=transactions&sub=reports&year=\'+this.value;'))."<br /><br />";
			$this_graph = $graphs->build_fly(515, 225);

			$tab_items .= tab_item($lang['ssummary'], $this_graph.'<strong>'.$lang['ryear'].'</strong> '.$dropdown.$content);


			$form  = $forms->start(array('url' => 'adminindex.php?action=transactions&sub=reports&r=bymonth'));
			$form .= $forms->item("dropdown", $lang['rmonth'], "month", $forms->farray($months, $lang['rmonths']), date("m", stamp()));
			$form .= $forms->item("dropdown", $lang['ryear'], "year", $forms->farray($years, $years), "");
			$form .= $forms->item("dropdown", $lang['rsstatus'], "shipstatus", $forms->farray($sreports->status2, $sreports->status2), "");
			$form .= $forms->item("dropdown", $lang['rpstatus'], "paystatus", $forms->farray($sreports->status1, $sreports->status1), "");
			$form .= $forms->item("submit", "", "", "", "Submit");
			$form .= $forms->end();

			$tab_items .= tab_item($lang['salesbym'], $form);

			$form  = $forms->start(array('url' => 'adminindex.php?action=transactions&sub=reports&r=bytype'));
			$form .= $forms->item("dropdown", $lang['rtype'], "rtype", $forms->farray(array("Product","Category","Vendor","Manufacturer"), array($lang['product'],$lang['category'],$lang['vendor'],$lang['manufacturers'])), "");
			$form .= $forms->item("submit", "", "", "", "Submit");
			$form .= $forms->end();

			$tab_items .= tab_item($lang['salesbyt'], $form);

			$form = $forms->start(array('url' => 'adminindex.php?action=show_invoices" target="show_invoices" onsubmit="window.open(\'\', this.target, \'directories=no,status=no,location=no,menubar=yes,toolbar=no,scrollbars=yes,resizable=yes,width=720,height=400\');'));
			$form .= $forms->item("textbox", help("Decryption Key", "Enter your decryption key to show card number."), "hashkey", "", "");
			$form .= $forms->item("dropdown", $lang['datestart'], "mstart", $forms->farray($months, $lang['rmonths']), "");
			$form .= $forms->item("dropdown", " ", "dstart", $forms->farray($days, $days), "");
			$form .= $forms->item("dropdown", " ", "ystart", $forms->farray($years, $years), date("Y", stamp()));
			$form .= $forms->item("dropdown", $lang['dateend'], "mend", $forms->farray($months, $lang['rmonths']), date("m", stamp()));
			$form .= $forms->item("dropdown", " ", "dend", $forms->farray($days, $days), date("t", stamp()));
			$form .= $forms->item("dropdown", " ", "yend", $forms->farray($years, $years), date("Y", stamp()));
			$form .= $forms->item("dropdown", $lang['rsstatus'], "shipstatus", $forms->farray($sreports->status2, $sreports->status2), "");
			$form .= $forms->item("dropdown", $lang['rpstatus'], "paystatus", $forms->farray($sreports->status1, $sreports->status1), "");
			$form .= $forms->item("submit", "", "", "", "Submit");
			$form .= $forms->end();

			$tab_items .= tab_item($lang['pinvoices'], $form);

			$data .= $start.start_tabs($tab_items);

			$out .= starttable("545", $lang['salesrepo'], '<div>'.$data.'</div>', array());
			$pages .= contentend();
		}
	}

	////////////////////
	// Transaction Stats
	////////////////////

	if ($_GET[sub] == "stats") {

		$cal 	= new Calendar;
		$smonth = isset($_GET[month])?$_GET[month]:date("n");
		$sday	= isset($_GET[day])?$_GET[day]:((isset($_GET[month]))?'':date("j"));
		$syear 	= isset($_GET[year])?$_GET[year]:date("Y");
		$settings[top_show] = 50;

		$graphs = new graphs();

		$vars[sidetable] .= sidetable("Calendar", $cal->getMonthView($smonth, $sday, $syear, $settings[theme_path]), array('style' => 'height: 150px;'));

		$rarray = $rep->csv_to_array($syear, $smonth, $sday);

		$rarray[visitors] 	= (!is_array($rarray[visitors]))?array():$sort->sortit($rarray[visitors], "hits", true);
		$rarray[pages]		= (!is_array($rarray[pages]))?array():$sort->sortit($rarray[pages], "hits", true);
		$rarray[referers] 	= (!is_array($rarray[referers]))?array():$sort->sortit($rarray[referers], "hits", true);
		$rarray[categories] = (!is_array($rarray[categories]))?array():$sort->sortit($rarray[categories], "hits", true);
		$rarray[products] 	= (!is_array($rarray[products]))?array():$sort->sortit($rarray[products], "hits", true);
		$rarray[unique_hits] = count($rarray[visitors]);

		switch ($mode) {
			case '':
			case 'day':
				// Last Seven Days Compare
				$last_seven = $graphs->last_seven($smonth, $sday, $syear, 515, 225);
				$out = starttable("545", $lang['lastseven'], $last_seven, array());
			break;
			case 'year':

			break;
		}

		// Top Viewed Products
		$top_prods = $graphs->pie_chart($rarray[products], 260, 175);
		$out .= starttable("545", $lang['topvp'], $top_prods, array());

		// Top Viewed Categories
		$top_cats = $graphs->pie_chart($rarray[categories], 260, 175);
		$out .= starttable("545", $lang['topvc'], $top_cats, array());

		// Top Referers
		$referers = contentstart(array($lang['page'], $lang['hits']), array(), array("left","center"), "#536da7", 1);
		for ($i=0; $i<$settings[top_show]; $i++) {
			if ($rarray[referers][$i][value] != "")
			$referers .= content(array('<a href="'.$rarray[referers][$i][value].'" target="_NEW" title="'.$rarray[referers][$i][value].'">'.shortenit($rarray[referers][$i][value],70).'</a>', $rarray[referers][$i][hits]), array(), array("left","center"));
		}
		$referers .= contentend();
		$out .= starttable("545", $lang['topsev'], '<div class="stats_container">'.$referers.'</div>', array());

		// Top Pages Visited
		$pages = contentstart(array($lang['page'], $lang['hits']), array(), array("left","center"), "#536da7", 1);
		for ($i=0; $i<(($settings[top_show] < count($rarray[pages]))?$settings[top_show]:count($rarray[pages])); $i++) {
			if ($rarray[pages][$i][value] != "")
			$pages .= content(array('<a href="'.(($rarray[pages][$i][secure]==1)?'https://':'http://').$rarray[pages][$i][value].'" target="_NEW" title="'.$rarray[pages][$i][value].'">'.(($rarray[pages][$i][secure]==1)?'https://':'http://').shortenit($rarray[pages][$i][value],70).'</a>', $rarray[pages][$i][hits]), array(), array("left","center"));
		}
		$pages .= contentend();
		$out .= starttable("545", $lang['toppv'], '<div class="stats_container">'.$pages.'</div>', array());
	}

	///////////////////////
	// Transaction Statuses
	///////////////////////

	if ($_GET[sub] == "status") {
		$vars[sidetable] .= getsidesubs($startlink, 3, 3);

		if ($_GET['do'] == "delete") {
			 $DB_site->query("DELETE FROM `".$dbprefix."status` WHERE `id`='".$_GET[id]."'");
			 $status = $lang['statushb'];
		}

		if ($_GET['do'] == "add") {
			 $DB_site->query("INSERT INTO `".$dbprefix."status` set `name`='".sf($_POST[name])."', `type`='".$_POST[type]."', `dorder`='1'");
			 $status = $lang['statushba'];
		}

		$_GET[orderby]	= ($_GET[orderby]=='')?'type, dorder':$_GET[orderby];
		$_GET[sort]		= ($_GET[sort]=='')?'asc':$_GET[sort];
		$_GET[pg] 		= (isset($_GET[pg]) && $_GET[pg] > 0)?intval($_GET[pg]):0;

		$tablestart = contentstart(array(template('form_toggle_checkbox.html', array('cname' => 'selectall', 'name' => 'item', 'form' => 'bulk')), l($lang['id'],"id"), l($lang['name'],"name"), l($lang['type'],"type"), l($lang['order'],"type, dorder"), $lang['action']), array(), array("center","center","left","center","center","center"), "#536da7", 1);
		$query = "SELECT id FROM `".$dbprefix."status` order by ".$_GET[orderby]." ".$_GET[sort]." LIMIT ".((($_GET[pg]==0)?0:$_GET[pg]-1)*50).",50";

		$append = preg_replace('/pg=([0-9]*)/', '', (($_GET[pg]=="")?'&amp;':'').htmlentities($_SERVER["QUERY_STRING"]));
		$page = new pager($query, template('list_pages_output.html', array(), 0), 5, 50, $_GET[pg], $append);
		$list[pages] = $page->paginate();

		$table1content = $list[pages]."<br />";
		$table1content .= $forms->start(array('name' => 'bulk', 'url' => 'adminindex.php?action=transactions&sub=status'.(($_GET[type]!="")?'&type='.$_GET[type]:''), 'hide' => 'Table'));
		$table1content .= $tablestart;

		$results = $DB_site->query($query);
		while ($row = $DB_site->fetch_assoc($results)) {
			$stat = get('status', $row[id]);
			$links = ($admin[manage_status]==1)?icon(3, "adminindex.php?action=transactions&sub=status&do=delete&id=$row[id]\" onclick=\"return jsconfirm();"):'None';
			$move = template('move_up_down.html', array('type' => 'status', 'id' => $row[id], 'extra' => '&stype='.$stat[type]));
			$table1content .= content(array(template('form_checkbox.html', array('value' => $row[id], 'name' => 'item[]')), $row[id], $stat[name], ($stat[type]==1)?'Payment':'Order', $move, $links), array(), array("center","center","left","center","center","center"));
		}
		$table1content .= contentend();
		$table1content .= bulk_action().$forms->end(array('hide' => 'Table'));
		$table1content .= "<br />".$list[pages].template('add_status.html');

		$table1 = starttable("545", $lang['trans'], $table1content, array());

		$out = (($status!="")?status($status):"")."$table1";
	}

	////////////////////
	// Quickbooks Export
	////////////////////

	if ($_GET[sub] == "preqbexport") {
		$status = urldecode($_GET[status]);

		$smonth = $forms->item("date", "", "s[smonth]", "month", date('n'), "", "", array('return_item' => 1));
		$sday   = $forms->item("date", "", "s[sday]", "day", date('j'), "", "", array('return_item' => 1));
		$syear  = $forms->item("date", "", "s[syear]", "year2", date('Y')-1, "", "", array('return_item' => 1));

		$emonth = $forms->item("date", "", "s[emonth]", "month", date('n'), "", "", array('return_item' => 1));
		$eday   = $forms->item("date", "", "s[eday]", "day", date('j'), "", "", array('return_item' => 1));
		$eyear  = $forms->item("date", "", "s[eyear]", "year2", (date('Y')), "", "", array('return_item' => 1));

		$radio1 = $forms->item("radio", "", "s[span]", $forms->farray(array("all"), array("All")), "all", "", "", array('return_item' => 1));
		$radio2 = $forms->item("radio", "", "s[span]", $forms->farray(array("today"), array("Today")), "", "", "", array('return_item' => 1));
		$radio3 = $forms->item("radio", "", "s[span]", $forms->farray(array("yesterday"), array("Yesterday")), "", "", "", array('return_item' => 1));
		$radio4 = $forms->item("radio", "", "s[span]", $forms->farray(array("month"), array("This Month")), "", "", "", array('return_item' => 1));
		$radio5 = $forms->item("radio", "", "s[span]", $forms->farray(array("lastmonth"), array("Last Month")), "", "", "", array('return_item' => 1));
		$radio6 = $forms->item("radio", "", "s[span]", $forms->farray(array("date"), array("Range")), "", "", "", array('return_item' => 1));

		$search = $radio1.'&nbsp;'.$radio2.'&nbsp;'.$radio3.'&nbsp;'.$radio4.'&nbsp;'.$radio5.'&nbsp;'.$radio6.'<br style="margin-bottom: 7px;">'.$smonth.' '.$sday.' '.$syear.' &nbsp;&nbsp;-&nbsp;&nbsp; '.$emonth.' '.$eday.' '.$eyear;

		$form  = $forms->start(array('url' => 'adminindex.php?action=transactions&sub=qbexport'));
		$form .= $forms->item("textbox", help($lang['filen'], $lang['filenqb']), "filename", "", "sunshop_".date('m_d_Y').".IIF", 30);
		$form .= $forms->item("show", help($lang['ts_span'], ''), "", "", $search, 30);
		$form .= $forms->item("submit", "", "", "", $lang['qbexport']);
		$form .= $forms->end(array('hide' => 'Form'));

		$out = (($status!="")?status($status):"").starttable("545", $lang['qbexport'], $form);
	}

	if ($_GET[sub] == "qbexport") {
		include $abs_path.'/include/classes/class.quickbooks.php';
		$qb = new quickbooks();
		$qb->search($_POST[s]);
		$export[customers] = $qb->process_customers();
		$export[products] = ($settings[qb_productexport]=='Y')?$qb->process_products():'';
		$export[invoices] = $qb->process_orders();
		$export[payments] = ($settings[qb_paymentsexport]=='Y')?$qb->process_payments():'';
		$data = template('quickbooks_export.html', $export);

		$filename = $abs_path.'/'.ADMIN_DIR.'/backup/'.randompass(10).'_'.$_POST[filename];
		$filehandle = fopen($filename, "w");
		fwrite($filehandle, $data);
		fclose($filehandle);

		header("Cache-control: private");
		header("Content-type: text/plain");
		header("Content-transfer-encoding: binary\n");
		header("Content-disposition: attachment; filename=\"".$_POST[filename]."\"");
		header("Content-Length: ".filesize($filename));
		readfile($filename);
		@unlink($filename);
		exit;
	}
}

///////////////////
// SunShop Settings
///////////////////

elseif ($_GET[action] == "settings") {

	$vars[sidetable]  = getside($startlink, 4);

	//////////////////
	// Update Settings
	//////////////////

	if ($_GET[sub] == "update") {
		$result = $DB_site->query("SELECT * FROM `".$dbprefix."settings` order by `name`");
		while ($entry = $DB_site->fetch_assoc($result)) {
			if (isset($_POST[$entry[name]])) {
				if ($settings[decimal] != $_POST[decimal] && $entry[name] == 'decimal' && $_POST[decimal] != "") {
					alter_decimals($_POST[decimal]);
				}
				$array = array('statcomplete2', 'statpending2', 'statfailed2', 'statcomplete1', 'statpending1', 'statfailed1');
				if (in_array($entry[name], $array)) $_POST[$entry[name]] = implode('::', $_POST[$entry[name]]);
				$DB_site->query("UPDATE `".$dbprefix."settings` set `value`='".sf($_POST[$entry[name]])."' WHERE `name`='".$entry[name]."'");
			}
		}

		if ($_FILES[new_logo][tmp_name] != "") {
			$fullp	= $abs_path.'/'.$settings[productpath];
			$image	= $_FILES[new_logo];

			file_check($image[name], "image", $image[type]);

			@unlink($abs_path.'/themes/'.$settings[theme].'/images/logo.gif');
			move_uploaded_file($image[tmp_name], $abs_path.'/themes/'.$settings[theme].'/images/logo.gif');
			@chmod($abs_path.'/themes/'.$settings[theme].'/images/logo.gif', 0777);

			if ($settings[auto_resize] && $settings[resize] != 'none')
				resize_image($abs_path.'/themes/'.$settings[theme].'/images/logo.gif', 75, 200);
		}

		header('location: adminindex.php?action=settings&sub='.$_GET[type].(($_GET[ptype]!='')?'&type='.$_GET[ptype]:'').'&status='.urlencode($lang['ssaveds']));
		exit;
	}

	///////////////////
	// General Settings
	///////////////////

	if ($_GET[sub] == "general") {
		$vars[sidetable] .= getsidesubs($startlink, 4, 0);

		// License Key Data
		$lictable = $form = $forms->start(array('hide' => 'Form'));
		$lictable .= $forms->item("show", $lang['regto'].": ", "", "", $lic['name']);
		$lictable .= $forms->item("show", $lang['purchased'].": ", "", "", date('m-d-Y', strtotime($lic['date'])));
		$lictable .= ($lic['exp']=="0000-00-00")?"":$forms->item("show", $lang['expirat'].": ", "", "", date('m-d-Y', strtotime($lic['exp'])));
		$lictable .= $forms->item("show", $lang['licensed'].": ", "", "", $lic['dom']);
		$lictable .= $forms->item("show", $lang['licensenum'].": ", "", "", $lic['num']);
		$lictable .= $forms->item("show", $lang['softver'].": ", "", "", $settings[version]);
		$lictable .= $forms->end(array('hide' => 'Form'));

		$table = ($lic_asp!="SSASP")?starttable("545", $lang['licinfo'], $lictable)."<br>":"";

		// General Shop Information
		$start  = $forms->start(array('url' => 'adminindex.php?action=settings&sub=update&type=general" enctype="multipart/form-data'));
		$start .= $forms->item("textbox", help($lang['shopt'], $lang['shopt_d']), "title", "", $settings[title], 50);
		$start .= $forms->item("textbox", help($lang['shopu'], $lang['shopu_d']), "shopurl", "", $settings[shopurl], 50);
		$start .= $forms->item("textbox", help($lang['shops'], $lang['shops_d']), "secureurl", "", $settings[secureurl], 50);
		$start .= $forms->item("textbox", help($lang['metat'], $lang['metat_d']), "metatitle", "", $settings[metatitle], 50);
		$start .= $forms->item("textbox", help($lang['metakeys'], $lang['metakeysdesc']), "metakeywords", "", $settings[metakeywords], 50);
		$start .= $forms->item("textarea", help($lang['metad'], $lang['metad_d']), "metadescription", "", $settings[metadescription], 50);
		$start .= $forms->end(array('hide' => 'Form'));

		// Shop Contact Information
		$statelist1 = get_data_array('state_country', 'abb',  'type,name', 'WHERE type=\''.STATE.'\' OR type=\'3\'');
		$statelist2 = get_data_array('state_country', 'name',  'type,name', 'WHERE type=\''.STATE.'\' OR type=\'3\'');
		$countrylist1 = get_data_array('state_country', 'abb',  'name', 'WHERE type=\''.COUNTRY.'\'');
		$countrylist2 = get_data_array('state_country', 'name',  'name', 'WHERE type=\''.COUNTRY.'\'');

		$form  = $forms->start(array('hide' => 'Form'));
		$form .= $forms->item("textbox", help($lang['companyn'], $lang['companyn_d']), "companyname", "", $settings[companyname], 40);
		$form .= $forms->item("textbox", help($lang['shopa'], $lang['shopa_d']), "address", "", $settings[address], 40);
		$form .= $forms->item("textbox", help($lang['shopc'], $lang['shopc_d']), "city", "", $settings[city], 40);
		$form .= $forms->item("dropdown", help($lang['shopstatep'], $lang['shopstatepd']), "state", $forms->farray($statelist1, $statelist2), $settings[state]);
		$form .= $forms->item("textbox", help($lang['shopp'], $lang['shopp_d']), "zip", "", $settings[zip], 40);
		$form .= $forms->item("dropdown", help($lang['shopco'], $lang['shopco_d']), "country", $forms->farray($countrylist1, $countrylist2), $settings[country]);
		$form .= $forms->item("textbox", help($lang['shopph'], $lang['shopph_d']), "phone", "", $settings[phone], 40);
		$form .= $forms->item("textbox", help($lang['shopf'], $lang['shopf_d']), "faxnumber", "", $settings[faxnumber], 40);
		$form .= $forms->item("textbox", help($lang['contacte'], $lang['contacte_d']), "contactemail", "", $settings[contactemail], 40);
		$form .= $forms->item("textbox", help($lang['homepaget'], $lang['homepaget_d']), "hometitle", "", $settings[hometitle], 40);
		$form .= $forms->item("textbox", help($lang['homepageu'], $lang['homepageu_d']), "homeurl", "", $settings[homeurl], 40);
		$form .= $forms->item("submit", "", "", "", $lang['edits']);
		$form .= $forms->end(array('hide' => 'Form'));

		$tab_items .= tab_item($lang['companyinf'], $form);

		// General Shop Settings
		$themes = themes();
		$lang1 	= languages(1);
		$lang2 	= languages(2);
		$grouplist1 = get_data_array('groups', 'id', 'name');
		$grouplist2	= get_data_array('groups', 'name', 'name');

		$form  = $forms->start(array('hide' => 'Form'));
		$form .= $forms->item("show", help($lang['slogo'], ''), "", "", template('settings_logo.html'));
		$form .= $forms->item("show", "", "", "", "<br />");
		$form .= $forms->item("dropdown", help($lang['shops2'], $lang['shops2_d']), "shopstatus", $forms->farray(array("On","Off"), array($lang['sopen'],$lang['sclosed'])), $settings[shopstatus]);
		$form .= $forms->item("dropdown", help($lang['themed'], $lang['themed_d']), "theme", $forms->farray($themes, $themes), $settings[theme]);
		$form .= $forms->item("dropdown", help($lang['languagef'], $lang['languagef_d']), "language", $forms->farray($lang1, $lang2), $settings[language]);
		$form .= $forms->item("dropdown", help($lang['mainp'], $lang['mainp_d']), "mainpage", $forms->farray(array(1,2,3), array($lang['showmp'],$lang['showm'],$lang['showp'])), $settings[mainpage]);
		$form .= $forms->item("dropdown", help($lang['mainpp'], $lang['mainpp_d']), "mainpageproducts", $forms->farray(array("bestsellers","new","specials","featured"), array($lang['bestsellers'],$lang['new'],$lang['specials'],$lang['featured'])), $settings[mainpageproducts]);
		$form .= $forms->item("dropdown", help($lang['defaulti'], $lang['defaulti_d']), "orderby", $forms->farray(array("title asc","num_sold desc","price asc","price desc","id asc","id desc"), array($lang['alhpa'],$lang['mostpop'],$lang['pricelow'],$lang['pricehigh'],$lang['agenew'],$lang['ageold'])), $settings[orderby]);
		$form .= $forms->item("dropdown", help($lang['defaultil'], $lang['defaultil_d']), "showitem", $forms->farray(array("list","tile"), array($lang['listtop'], $lang['tileright'])), $settings[showitem]);
		$form .= $forms->item("dropdown", help("'".$lang['addtocart']."' ".$lang['path'], ""), "addtocart", $forms->farray(array("goback","viewcart"), array($lang['previousloc'],$lang['cartcon'])), $settings[addtocart]);
		$form .= $forms->item("dropdown", help($lang['htmlp'], $lang['htmlp_d']), "htmlpages", $forms->farray(array("off", "on"), array($lang['offdyn'],$lang['onstatic'])), $settings[htmlpages]);
		$form .= $forms->item("dropdown", help($lang['newa'], $lang['newa_d']), "defaultgroup", $forms->farray($grouplist1, $grouplist2), $settings[defaultgroup]);
		$form .= $forms->item("textbox", help($lang['spagewidth'], $lang['spagewidth_d']), "width", "", $settings[width], 4);
		$form .= $forms->item("textbox", help($lang['tilea'], $lang['tilea_d']), "tilenum", "", $settings[tilenum], 4);
		$form .= $forms->item("textbox", help($lang['itemsp'], $lang['itemsp_d']), "itemsperpage", "", $settings[itemsperpage], 4);
		$form .= $forms->item("textbox", help($lang['ad_users'], $lang['ad_users_d']), "admin_user_max", "", $settings[admin_user_max], 4);
		$form .= $forms->item("textbox", help($lang['ad_prods'], $lang['ad_prods_d']), "admin_products_max", "", $settings[admin_products_max], 4);
		$form .= $forms->item("textbox", help($lang['ad_cats'], $lang['ad_cats_d']), "admin_categories_max", "", $settings[admin_categories_max], 4);
		$form .= $forms->item("textbox", help($lang['ad_trans'], $lang['ad_trans_d']), "admin_transactions_max", "", $settings[admin_transactions_max], 4);
		$form .= $forms->item("radio", help($lang['showc'], $lang['showc_d']), "showcattotals", $forms->farray(array("Yes","No"), array($lang['on'],$lang['off'])), $settings[showcattotals]);
		$form .= $forms->item("radio", help($lang['shows'], $lang['shows_d']), "showstock", $forms->farray(array("Yes","No"), array($lang['on'],$lang['off'])), $settings[showstock]);
		$form .= $forms->item("radio", help($lang['enforces'], $lang['enforces_d']), "enforcestock", $forms->farray(array("Yes","No"), array($lang['on'],$lang['off'])), $settings[enforcestock]);
		$form .= $forms->item("radio", help($lang['enforceo'], $lang['enforceo_d']), "enforceoptionstock", $forms->farray(array("Yes","No"), array($lang['on'],$lang['off'])), $settings[enforceoptionstock]);
		$form .= $forms->item("radio", help($lang['wishlistf'], $lang['wishlistf_d']), "wishlist", $forms->farray(array("Yes","No"), array($lang['on'],$lang['off'])), $settings[wishlist]);
		$form .= $forms->item("radio", help($lang['registryf'], $lang['registryf_d']), "registry", $forms->farray(array("Yes","No"), array($lang['on'],$lang['off'])), $settings[registry]);
		$form .= $forms->item("radio", help($lang['productr'], $lang['productr_d']), "reviews", $forms->farray(array("Yes","No"), array($lang['on'],$lang['off'])), $settings[reviews]);
		$form .= $forms->item("radio", help($lang['imagev'], $lang['imagev_d']), "imageverify", ((extension_loaded("gd"))?$forms->farray(array("Yes","No"), array($lang['on'],$lang['off'])):$forms->farray(array("No"), array($lang['gdoff']))), ((extension_loaded("gd"))?$settings[imageverify]:"No"));
		$form .= $forms->item("radio", help($lang['monitorp'], $lang['monitorp_d']), "checkreviews", $forms->farray(array("Yes","No"), array($lang['on'],$lang['off'])), $settings[checkreviews]);
		$form .= $forms->item("radio", help($lang['newp'], $lang['newicatdesc']), "newcat", $forms->farray(array("Yes","No"), array($lang['on'],$lang['off'])), $settings[newcat]);
		$form .= $forms->item("radio", help($lang['specat'], $lang['specatdesc']), "speccat", $forms->farray(array("Yes","No"), array($lang['on'],$lang['off'])), $settings[speccat]);
		$form .= $forms->item("radio", help($lang['bestcat'], $lang['bestcatdesc']), "bestcat", $forms->farray(array("Yes","No"), array($lang['on'],$lang['off'])), $settings[bestcat]);
		$form .= $forms->item("radio", help($lang['featcat'], $lang['featcatdesc']), "featcat", $forms->farray(array("Yes","No"), array($lang['on'],$lang['off'])), $settings[featcat]);
		$form .= $forms->item("submit", "", "", "", $lang['edits']);
		$form .= $forms->end(array('hide' => 'Form'));

		$tab_items .= tab_item($lang['shopsetti'], $form);

		// Time and Date Settings
		$form  = $forms->start(array('hide' => 'Form'));
		$form .= $forms->item("textbox", help($lang['datef'], $lang['datef_d']), "datestamp", "", $settings[datestamp], 40);
		$form .= $forms->item("textbox", help($lang['timef'], $lang['timef_d']), "timestamp", "", $settings[timestamp], 40);
		$form .= $forms->item("submit", "", "", "", $lang['edits']);
		$form .= $forms->end(array('hide' => 'Form'));

		$tab_items .= tab_item($lang['dateti'], $form);

		// Mail Send Settings
		$form  = $forms->start(array('hide' => 'Form'));
		$form .= $forms->item("dropdown", help($lang['mailingm'], $lang['mailingm_d']), "mail_method", $forms->farray(array("mail","smtp","sendmail"), array($lang['phpmail'],$lang['smtpcon'],$lang['sendm'])), $settings[mail_method]);
		$form .= $forms->item("textbox", help($lang['smtph'], $lang['smtph_d']), "mail_host", "", $settings[mail_host], 40);
		$form .= $forms->item("textbox", help($lang['smtpu'], $lang['smtpu_d']), "mail_username", "", $settings[mail_username], 40);
		$form .= $forms->item("textbox", help($lang['smtpp'], $lang['smtpp_d']), "mail_password", "", $settings[mail_password], 40);
		$form .= $forms->item("textbox", help($lang['sendmailp'], $lang['sendmailp_d']), "mail_sendmail", "", $settings[mail_sendmail], 40);
		$form .= $forms->item("submit", "", "", "", $lang['edits']);
		$form .= $forms->end(array('hide' => 'Form'));

		$tab_items .= tab_item($lang['mailmeth'], $form);

		// cURL Connection Settings
		$curl_list = array(); $curl_vals = array();
		if (extension_loaded("curl")) { array_push($curl_list, $lang['compcu']); array_push($curl_vals, "compiled"); }
		array_push($curl_list, $lang['installedcu']); array_push($curl_vals, "installed");

		$form  = $forms->start(array('hide' => 'Form'));
		$form .= $forms->item("dropdown", help($lang['curlc'], $lang['curlc_d']), "curltype", $forms->farray($curl_vals, $curl_list), $settings[curltype]);
		$form .= $forms->item("textbox", help($lang['patht'], $lang['patht_d']), "pathtocurl", "", $settings[pathtocurl], 40);
		$form .= $forms->item("show", "&nbsp;", "", "&nbsp;", "");
		$form .= $forms->item("dropdown", help($lang['proxstat'], $lang['proxstat_d']), "proxy_status", $forms->farray(array("on","off"), array($lang['on'],$lang['off'])), $settings[proxy_status]);
		$form .= $forms->item("textbox", help($lang['proxurl'], $lang['proxurl_d']), "proxy_url", "", $settings[proxy_url], 40);
		$form .= $forms->item("textbox", help($lang['proxport'], $lang['proxport_d']), "proxy_port", "", $settings[proxy_port], 10);
		$form .= $forms->item("textbox", help($lang['proxuser'], $lang['proxuser_d']), "proxy_user", "", $settings[proxy_user], 10);
		$form .= $forms->item("textbox", help($lang['proxpass'], $lang['proxpass_d']), "proxy_pass", "", $settings[proxy_pass], 10);
		$form .= $forms->item("submit", "", "", "", $lang['edits']);
		$form .= $forms->end(array('hide' => 'Form'));

		$tab_items .= tab_item($lang['curlcon'], $form);

		// Download Settings
		$form  = $forms->start(array('hide' => 'Form'));
		$statuslist = get_data_array('status', 'name', 'dorder', "WHERE `type`='1'");
		$form .= $forms->item("textbox", help($lang['maxd'], $lang['maxd_d']), "maxdownloads", "", $settings[maxdownloads], 5);
		$form .= $forms->item("textbox", help($lang['maxdt'], $lang['maxdt_d']), "hoursdownloads", "", $settings[hoursdownloads], 5);
		$form .= $forms->item("dropdown", help($lang['requiredp'], $lang['requiredp_d']), "statusdownloads", $forms->farray($statuslist, $statuslist), $settings[statusdownloads]);
		$form .= $forms->item("textbox", help($lang['pathtd'], $lang['pathtd_d']), "pathtodownloads", "", $settings[pathtodownloads], 40);
		$form .= $forms->item("submit", "", "", "", $lang['edits']);
		$form .= $forms->end(array('hide' => 'Form'));

		$tab_items .= tab_item($lang['dwnlds'], $form);

		$data = $start.start_tabs($tab_items);

		$out = $table.starttable("545", $lang['gsettings'], $data);
	}

	/////////////////////
	// Module Maintenence
	/////////////////////

	if ($_GET[sub] == "module_update") {
		switch ($_GET['do']) {
			case 'update_table':
				for ($i=0; $i<count($_POST[tableids]); $i++) {
					$DB_site->query("UPDATE ".$dbprefix."ship_table set `from_value`='".$_POST[froms][$i]."', `to_value`='".$_POST[tos][$i]."', `price`='".$_POST[prices][$i]."' where `zoneid`='".$_POST[zone_id]."' AND `id`='".$_POST[tableids][$i]."'");
				}
				$status = $lang['shitablee'];
				$zid = $_POST[zone_id];
				$_GET[type] = "shipping";
				$tab = 3;
				break;
			case 'delete_table':
				$DB_site->query("DELETE FROM ".$dbprefix."ship_table where id='".$_GET[id]."'");
				$status = $lang['shitabled'];
				$zid = $_GET[zid];
				$_GET[type] = "shipping";
				$tab = 3;
				break;
			case 'delete_zone':
				$DB_site->query("DELETE FROM ".$dbprefix."ship_zones_relation where zoneid='".$_GET[id]."'");
				$DB_site->query("DELETE FROM ".$dbprefix."ship_zones where id='".$_GET[id]."'");
				$DB_site->query("DELETE FROM ".$dbprefix."ship_table where zoneid='".$_GET[id]."'");
				$status = $lang['dszones'];
				$_GET[type] = "shipping";
				$tab = 2;
				break;
			case 'update_module':
				if ($_POST[update][free] == "") $_POST[update][free] = array();
				foreach($_POST[update] as $key => $val){
					if (is_array($val)) $val = implode("::", $val);
					$DB_site->query("UPDATE `".$dbprefix."modules_".$_GET[type]."` set `value`='".((is_array($val))?sf(implode('::', $val)):sf($val))."' where `module`='".$_POST[class_name]."' and `internalname`='".$key."'");
				}
				$status = $lang['settingss'];
				$tab = $_POST[tab];

				$class_vars = module_vars($_POST[class_name], $_GET[type]);
				@include($abs_path."/include/".$_GET[type]."/".$_POST[id]);
				if ($_POST[update][enabled] == 1) {
					$reg = new $CLASS_NAME($class_vars);
					if (method_exists($reg, 'register')) $status .= $reg->register();
				}
				break;
			case 'uninstall':
				@include($abs_path."/include/".$_GET[type]."/".$_GET[id]);
				$install = new $CLASS_NAME($class_vars);
				$install->uninstall();
				$status = $lang['uninstallc'];
				$tab = $_GET[tab];
				break;
			case 'pre_install':
				@include($abs_path."/include/".$_GET[type]."/".$_GET[id]);
				$install = new $CLASS_NAME($class_vars);
				$out = $install->pre_install();
				break;
			case 'install':
				@include($abs_path."/include/".$_GET[type]."/".$_GET[id]);
				$install = new $CLASS_NAME($class_vars);
				if (method_exists($install, 'pre_install')) {
					if ($install->pre_install_check()) {
						header('location: adminindex.php?action=settings&sub=module_update&do=pre_install&type='.$_GET[type].'&id='.$_GET[id].'&tab='.$_GET[tab]); exit;
					}
				}
				$install->install();
				$status = $lang['installc'];
				$tab = $_GET[tab];
				break;
			case 'seton':
				$DB_site->query("UPDATE `".$dbprefix."settings` set `value`='".sf($_GET[id])."' where `name`='".$_GET[type]."_module'");
				$status = $lang['module_ens'];
				$tab = $_GET[tab];
				break;
			case 'setoff':
				$DB_site->query("UPDATE `".$dbprefix."settings` set `value`='' where `name`='".$_GET[type]."_module'");
				$status = $lang['module_dis'];
				$tab = $_GET[tab];
				break;
		}
		if ($_GET['do'] != "pre_install") {
			header('location: adminindex.php?action=settings&sub='.$_GET[type].'&status='.urlencode($status).(($zid!='')?'&zone_id='.$zid:'').(($aid!='')?'&area_id='.$aid:'').(($tab!='')?'&tab='.$tab:''));
			exit;
		}
	}

	if ($_GET[sub] == "module_settings") {
		$vars[sidetable] .= getsidesubs($startlink, 4, 0);

		@include($abs_path."/include/".$_GET[type]."/".$_GET[id]); ob_start();
		if ($success = @include($abs_path."/include/".$_GET[type]."/docs/".str_replace(".php", ".txt", $_GET[id]))) $module_instructions = ob_get_contents();
		ob_end_clean();

		$form  = $forms->start(array('url' => 'adminindex.php?action=settings&sub=module_update&do=update_module&type='.$_GET[type]));
		$form .= $forms->item("hidden", "", "class_name", "", $CLASS_NAME);
		$form .= $forms->item("hidden", "", "id", "", $_GET[id]);
		$form .= $forms->item("hidden", "", "tab", "", $_GET[tab]);
		$result = $DB_site->query("SELECT * FROM ".$dbprefix."modules_".$_GET[type]." where module='".$CLASS_NAME."' AND name<>'' order by dorder");
		while ($row = $DB_site->fetch_assoc($result)) {
			switch ($row[field_type]) {
				case 'dropdown':
					$sep = explode("->", (($row[options]!='')?$row[options]:$row[moptions]));
					$values = explode("::", $sep[0]); $select = explode("::", $sep[1]);
					$form .= $forms->item("dropdown", help(stripslashes($row[name]), stripslashes($row[help])), "update[".$row[internalname]."]", $forms->farray($values, $select), (($row[moptions] != "")?explode("::",stripslashes($row[value])):stripslashes($row[value])), '', '', array('multi' => (($row[moptions]!="")?1:0), 'style' => (($row[size]!=0)?"width: ".$row[size].";":(($row[moptions]!="" && count($values) > 6)?'height: 100px;':''))));
					break;
				case 'textbox': case 'password':
					$form .= $forms->item($row[field_type], help(stripslashes($row[name]), stripslashes($row[help])), "update[".$row[internalname]."]", "", stripslashes($row[value]), (($row[size]!=0)?$row[size]:"30"));
					break;
				case 'textarea':
					$form .= $forms->item("textarea", help(stripslashes($row[name]), stripslashes($row[help])), "update[".$row[internalname]."]", "", stripslashes($row[value]), (($row[size]!=0)?$row[size]:"30"));
					break;
				case 'radio':
					break;
			}
		}
		$form .= $forms->item("submit", "", "", "", $lang['editmodset']);
		$form .= $forms->end();

		$out = starttable("545", str_replace("plugin_", "", $_GET[id]), $form, array());
		$out .= ($OUT_DATA!="")?starttable("545", str_replace("plugin_", "", $_GET[id]), base64_decode($OUT_DATA), array()):"";
		$out .= ($module_instructions!="")?starttable("545", $lang['instructions'].':', $forms->item("textarea", "", "", "", $module_instructions, "100", "10", array('style' => 'width: 100%;', 'return_item' => 1, 'extra' => ' readonly="readonly"')), array()):"";
	}


	/////////////////////////////////////////////////////////////////////////
	// NETWAVE DESIGN
	// EVENTS - ADDED 04-22-08
	/////////////////////////////////////////////////////////////////////////

	if ($_GET[sub] == "events") {

		$vars[sidetable] .= getsidesubs($startlink, 4, 0);

		if ($_GET[type] == "add") {

		$event_name = addslashes($event_name);
		$event_loc = addslashes($event_loc);
		$event_detials = addslashes($event_detials);

		if($e_hour == "") {
		$e_hour = "11";
		$e_min = "59";
		$e_tz = "pm";
		}

		$p_edate = "$e_date $e_hour:$e_min $e_tz";
		$event_date = strtotime("$p_edate");

		$DB_site->query("INSERT INTO events (event_name, event_date, event_loc, event_detials, event_link) values ('$event_name', '$event_date', '$event_loc', '$event_detials', '$event_link')");

		header('location: adminindex.php?action=settings&sub=events');
		exit;
		}


		elseif ($_GET[type] == "update") {

		$event_name = addslashes($event_name);
		$event_loc = addslashes($event_loc);
		$event_detials = addslashes($event_detials);

		if($e_hour == "") {
		$e_hour = "11";
		$e_min = "59";
		$e_tz = "pm";
		}
		$p_edate = "$e_date $e_hour:$e_min $e_tz";
		$event_date = strtotime("$p_edate");

		$DB_site->query("UPDATE events SET event_name = '$event_name', event_date = '$event_date', event_loc = '$event_loc', event_detials = '$event_detials', event_link = '$event_link' WHERE ((event_id = '$id'))");

		header('location: adminindex.php?action=settings&sub=events');
		exit;

		}

		elseif ($_GET[type] == "delete") {

		$DB_site->query("DELETE FROM events WHERE ((event_id = '$id'))");

		header('location: adminindex.php?action=settings&sub=events');
		exit;

		}


		if ($_GET[type] == "edit") {


		$query2 = "SELECT * FROM `events` WHERE event_id = '$_GET[id]'";
		$results = $DB_site->query($query2);
		while ($row = $DB_site->fetch_assoc($results)) {

		$event[event_id] = $row[event_id];
		$event[event_name] = stripslashes($row[event_name]);
		$event[event_date] = $row[event_date];
		$event[event_loc] = stripslashes($row[event_loc]);
		$event[event_detials] = stripslashes($row[event_detials]);
		$event[event_link] = $row[event_link];

		$e_date = strftime("%m/%d/%y",$event[event_date]);
		$e_hour = strftime("%I",$event[event_date]);
		$e_min = strftime("%M",$event[event_date]);
		$e_tz = strftime("%P",$event[event_date]);

		if ($e_hour == "11" AND $e_min == "59" AND $e_tz == "pm"){
		$e_hour = "";
		$e_min = "";
		$e_tz = "";
		}

		}

		$data  = $forms->start(array("url" => "adminindex.php?action=settings&sub=events&type=update&id=$event[event_id]"));
		$data .= $forms->item("textbox", help("Event Name", "Event Name"), "event_name", "", $event[event_name], 40);
		$data .= $forms->item("textbox", help("Event Location", "Event Location"), "event_loc", "", $event[event_loc], 40);
		$data .= $forms->item("textarea", help("Event Details", "Event Details"), "event_detials", "", $event[event_detials], 60);
		$data .= $forms->item("textbox", help("Event Date", "Event Date"), "e_date", "", $e_date, 40);
		$data .= $forms->item("textbox", help("Event Hour", "Event Hour"), "e_hour", "", $e_hour, 10);
		$data .= $forms->item("textbox", help("Event Minute", "Event Minute"), "e_min", "", $e_min, 10);
		$data .= $forms->item("radio", help("AM or PM", "AM or PM"), "e_tz", $forms->farray(array("am","pm"), array("am","pm")), $e_tz);
		$data .= $forms->item("textbox", help("Buy Ticket Link", "Buy Ticket Link"), "event_link", "", $event[event_link], 40);
		$data .= $forms->item("submit", "", "", "", "Update Event");
		$data .= $forms->end();


		$table1 = starttable("545", Events, $data);


		$tablestart = contentstart(array(template('form_toggle_checkbox.html', array('cname' => 'selectall', 'name' => 'item', 'form' => 'bulk')), l($lang['id'],"id"), l("Event Name","event_name"), l("Event Location","event_loc"),  l("Event Date","event_date"), $lang['action']), array(), array("center","center","left","center"), "#536da7", 1);
		$query = "SELECT * FROM `events` order by event_date LIMIT ".((($_GET[pg]==0)?0:$_GET[pg]-1)*$settings[admin_transactions_max]).",".$settings[admin_transactions_max];

		$append = preg_replace('/pg=([0-9]*)/', '', (($_GET[pg]=="")?'&amp;':'').htmlentities($_SERVER["QUERY_STRING"]));
		$page = new pager($query, template('list_pages_output.html', array(), 0), 5, $settings[admin_transactions_max], $_GET[pg], $append);
		$list[pages] = $page->paginate();

		$table1content = $list[pages]."<br />";
		$table1content .= $forms->start(array('name' => 'bulk', 'url' => 'adminindex.php?action=settings&sub=events'.(($_GET[type]!="")?'&type='.$_GET[type]:''), 'hide' => 'Table'));
		$table1content .= $tablestart;

		$results = $DB_site->query($query);
		while ($row = $DB_site->fetch_assoc($results)) {
		$ef_date = strftime("%m/%d/%y",$row[event_date]);
			$links = ($admin[manage_trans]==1)?icon(2, "adminindex.php?action=settings&sub=events&type=edit&id=$row[event_id]").icon(3, "adminindex.php?action=settings&sub=events&type=delete&id=$row[test_id]\" onclick=\"return jsconfirm();"):'';
			$table1content .= content(array(template('form_checkbox.html', array('value' => $row[event_id], 'name' => 'item[]')), $row[event_id], $row[event_name], $row[event_loc], substr($ef_date,0,50), $links), array(), array("center","center","left","center"), '', "#FFFFFF", 1);
		}
		$table1content .= contentend();
		$table1content .= bulk_action().$forms->end(array('hide' => 'Table'));
		$table1content .= "<br />".$list[pages];

		$statuslist = get_data_array('status', 'name', 'dorder', "WHERE `type`='2'");
		array_unshift($statuslist, 'Any');
		$statuses = $forms->item("dropdown", "", "s[status]", $forms->farray($statuslist, $statuslist), "", "", "", array('style' => 'width: 100%;', 'return_item' => 1));

		$table2 = starttable("545", Events, $table1content, array());

		$out = (($status!="")?status($status):"")."$table1<br>$table2";

		}


		else {


		$data  = $forms->start(array('url' => 'adminindex.php?action=settings&sub=events&type=add'));
		$data .= $forms->item("textbox", help("Event Name", "Event Name"), "event_name", "", $event[event_name], 40);
		$data .= $forms->item("textbox", help("Event Location", "Event Location"), "event_loc", "", $event[event_loc], 40);
		$data .= $forms->item("textarea", help("Event Details", "Event Details"), "event_detials", "", $event[event_detials], 60);
		$data .= $forms->item("textbox", help("Event Date", "Event Date"), "e_date", "", $e_date, 40);
		$data .= $forms->item("textbox", help("Event Hour", "Event Hour"), "e_hour", "", $e_hour, 10);
		$data .= $forms->item("textbox", help("Event Minute", "Event Minute"), "e_min", "", $e_min, 10);
		$data .= $forms->item("radio", help("AM or PM", "AM or PM"), "e_tz", $forms->farray(array("am","pm"), array("am","pm")), $e_tz);
		$data .= $forms->item("textbox", help("Buy Ticket Link", "Buy Ticket Link"), "event_link", "", $event[event_link], 40);
		$data .= $forms->item("submit", "", "", "", "Add Event");
		$data .= $forms->end();

		$table1 = starttable("545", Events, $data);

		$tablestart = contentstart(array(template('form_toggle_checkbox.html', array('cname' => 'selectall', 'name' => 'item', 'form' => 'bulk')), l($lang['id'],"id"), l("Event Name","event_name"), l("Event Location","event_loc"), l("Event Date","event_date"), $lang['action']), array(), array("center","center","left","center"), "#536da7", 1);
		$query = "SELECT * FROM `events` order by event_date LIMIT ".((($_GET[pg]==0)?0:$_GET[pg]-1)*$settings[admin_transactions_max]).",".$settings[admin_transactions_max];

		$append = preg_replace('/pg=([0-9]*)/', '', (($_GET[pg]=="")?'&amp;':'').htmlentities($_SERVER["QUERY_STRING"]));
		$page = new pager($query, template('list_pages_output.html', array(), 0), 5, $settings[admin_transactions_max], $_GET[pg], $append);
		$list[pages] = $page->paginate();

		$table1content = $list[pages]."<br />";
		$table1content .= $forms->start(array('name' => 'bulk', 'url' => 'adminindex.php?action=settings&sub=events'.(($_GET[type]!="")?'&type='.$_GET[type]:''), 'hide' => 'Table'));
		$table1content .= $tablestart;

		$results = $DB_site->query($query);
		while ($row = $DB_site->fetch_assoc($results)) {
		$ef_date = strftime("%m/%d/%y",$row[event_date]);

			$links = ($admin[manage_trans]==1)?icon(2, "adminindex.php?action=settings&sub=events&type=edit&id=$row[event_id]").icon(3, "adminindex.php?action=settings&sub=events&type=delete&id=$row[test_id]\" onclick=\"return jsconfirm();"):'';
			$table1content .= content(array(template('form_checkbox.html', array('value' => $row[event_id], 'name' => 'item[]')), $row[event_id], $row[event_name], $row[event_loc], substr($ef_date,0,50), $links), array(), array("center","center","left","center"), '', "#FFFFFF", 1);
		}
		$table1content .= contentend();
		$table1content .= bulk_action().$forms->end(array('hide' => 'Table'));
		$table1content .= "<br />".$list[pages];

		$statuslist = get_data_array('status', 'name', 'dorder', "WHERE `type`='2'");
		array_unshift($statuslist, 'Any');
		$statuses = $forms->item("dropdown", "", "s[status]", $forms->farray($statuslist, $statuslist), "", "", "", array('style' => 'width: 100%;', 'return_item' => 1));

		$table2 = starttable("545", Events, $table1content, array());

		$out = (($status!="")?status($status):"")."$table1<br>$table2";

		}
	}
	/////////////////////////////////////////////////////////////////////////
	// END EVENTS - NETWAVE DESIGN
	/////////////////////////////////////////////////////////////////////////


	/////////////////////////////////////////////////////////////////////////
	// NETWAVE DESIGN
	// Endorsers - ADDED 04-22-08
	/////////////////////////////////////////////////////////////////////////

	if ($_GET[sub] == "favorites") {

		$vars[sidetable] .= getsidesubs($startlink, 4, 0);

		if ($_GET[type] == "add") {

		$fav_title = addslashes($fav_title);
		$fav_desc = addslashes($fav_desc);

		$DB_site->query("INSERT INTO favorites (fav_title, fav_link, fav_desc) values ('$fav_title', '$fav_link', '$fav_desc')");

		header('location: adminindex.php?action=settings&sub=favorites');
		exit;
		}


		elseif ($_GET[type] == "update") {

		$fav_title = addslashes($fav_title);
		$fav_desc = addslashes($fav_desc);


		$DB_site->query("UPDATE favorites SET fav_title = '$fav_title', fav_link = '$fav_link', fav_desc = '$fav_desc' WHERE ((fav_id = '$id'))");

		header('location: adminindex.php?action=settings&sub=favorites');
		exit;

		}

		elseif ($_GET[type] == "delete") {

		$DB_site->query("DELETE FROM favorites WHERE ((fav_id = '$id'))");

		header('location: adminindex.php?action=settings&sub=favorites');
		exit;

		}


		if ($_GET[type] == "edit") {


		$query2 = "SELECT * FROM `favorites` WHERE fav_id = '$_GET[id]'";
		$results = $DB_site->query($query2);
		while ($row = $DB_site->fetch_assoc($results)) {

		$fav[fav_id] = $row[fav_id];
		$fav[fav_title] = stripslashes($row[fav_title]);
		$fav[fav_link] = $row[fav_link];
		$fav[fav_desc] = stripslashes($row[fav_desc]);

		}

		$data  = $forms->start(array("url" => "adminindex.php?action=settings&sub=favorites&type=update&id=$fav[fav_id]"));
		$data .= $forms->item("textbox", help("Endorser Title", "Endorsers Title"), "fav_title", "", $fav[fav_title], 40);
		$data .= $forms->item("textbox", help("Endorser Link", "Endorsers Link"), "fav_link", "", $fav[fav_link], 40);
		$data .= $forms->item("textarea", help("Endorser Description", "Favorite Endorsers"), "fav_desc", "", $fav[fav_desc], 60);
		$data .= $forms->item("submit", "", "", "", "Update Endorser");
		$data .= $forms->end();


		$table1 = starttable("545", Endorsers, $data);


		$tablestart = contentstart(array(template('form_toggle_checkbox.html', array('cname' => 'selectall', 'name' => 'item', 'form' => 'bulk')), l($lang['id'],"id"), l("Endorsers Title","fav_title"), $lang['action']), array(), array("center","center","left","center"), "#536da7", 1);
		$query = "SELECT * FROM `favorites` order by fav_title LIMIT ".((($_GET[pg]==0)?0:$_GET[pg]-1)*$settings[admin_transactions_max]).",".$settings[admin_transactions_max];

		$append = preg_replace('/pg=([0-9]*)/', '', (($_GET[pg]=="")?'&amp;':'').htmlentities($_SERVER["QUERY_STRING"]));
		$page = new pager($query, template('list_pages_output.html', array(), 0), 5, $settings[admin_transactions_max], $_GET[pg], $append);
		$list[pages] = $page->paginate();

		$table1content = $list[pages]."<br />";
		$table1content .= $forms->start(array('name' => 'bulk', 'url' => 'adminindex.php?action=settings&sub=favorites'.(($_GET[type]!="")?'&type='.$_GET[type]:''), 'hide' => 'Table'));
		$table1content .= $tablestart;

		$results = $DB_site->query($query);
		while ($row = $DB_site->fetch_assoc($results)) {
		$ef_date = strftime("%m/%d/%y",$row[event_date]);
			$links = ($admin[manage_trans]==1)?icon(2, "adminindex.php?action=settings&sub=favorites&type=edit&id=$row[fav_id]").icon(3, "adminindex.php?action=settings&sub=favorites&type=delete&id=$row[fav_id]\" onclick=\"return jsconfirm();"):'';
			$table1content .= content(array(template('form_checkbox.html', array('value' => $row[fav_id], 'name' => 'item[]')), $row[fav_id], $row[fav_title], $links), array(), array("center","center","left","center"), '', "#FFFFFF", 1);
		}
		$table1content .= contentend();
		$table1content .= bulk_action().$forms->end(array('hide' => 'Table'));
		$table1content .= "<br />".$list[pages];

		$statuslist = get_data_array('status', 'name', 'dorder', "WHERE `type`='2'");
		array_unshift($statuslist, 'Any');
		$statuses = $forms->item("dropdown", "", "s[status]", $forms->farray($statuslist, $statuslist), "", "", "", array('style' => 'width: 100%;', 'return_item' => 1));

		$table2 = starttable("545", Endorsers, $table1content, array());

		$out = (($status!="")?status($status):"")."$table1<br>$table2";

		}


		else {


		$data  = $forms->start(array('url' => 'adminindex.php?action=settings&sub=favorites&type=add'));
		$data .= $forms->item("textbox", help("Endorser Title", "Endorsers Title"), "fav_title", "", $fav[fav_title], 40);
		$data .= $forms->item("textbox", help("Endorser Link", "Endorsers Link"), "fav_link", "", $fav[fav_link], 40);
		$data .= $forms->item("textarea", help("Endorser Description", "Endorsers Description"), "fav_desc", "", $fav[fav_desc], 60);
		$data .= $forms->item("submit", "", "", "", "Add Endorser");
		$data .= $forms->end();

		$table1 = starttable("545", Endorsers, $data);

		$tablestart = contentstart(array(template('form_toggle_checkbox.html', array('cname' => 'selectall', 'name' => 'item', 'form' => 'bulk')), l($lang['id'],"id"), l("Endorsers Title","fav_title"), $lang['action']), array(), array("center","center","left","center"), "#536da7", 1);
		$query = "SELECT * FROM `favorites` order by fav_title LIMIT ".((($_GET[pg]==0)?0:$_GET[pg]-1)*$settings[admin_transactions_max]).",".$settings[admin_transactions_max];

		$append = preg_replace('/pg=([0-9]*)/', '', (($_GET[pg]=="")?'&amp;':'').htmlentities($_SERVER["QUERY_STRING"]));
		$page = new pager($query, template('list_pages_output.html', array(), 0), 5, $settings[admin_transactions_max], $_GET[pg], $append);
		$list[pages] = $page->paginate();

		$table1content = $list[pages]."<br />";
		$table1content .= $forms->start(array('name' => 'bulk', 'url' => 'adminindex.php?action=settings&sub=favorites'.(($_GET[type]!="")?'&type='.$_GET[type]:''), 'hide' => 'Table'));
		$table1content .= $tablestart;

		$results = $DB_site->query($query);
		while ($row = $DB_site->fetch_assoc($results)) {
		$ef_date = strftime("%m/%d/%y",$row[event_date]);

			$links = ($admin[manage_trans]==1)?icon(2, "adminindex.php?action=settings&sub=favorites&type=edit&id=$row[fav_id]").icon(3, "adminindex.php?action=settings&sub=favorites&type=delete&id=$row[test_id]\" onclick=\"return jsconfirm();"):'';
			$table1content .= content(array(template('form_checkbox.html', array('value' => $row[fav_id], 'name' => 'item[]')), $row[fav_id], $row[fav_title], $links), array(), array("center","center","left","center"), '', "#FFFFFF", 1);
		}
		$table1content .= contentend();
		$table1content .= bulk_action().$forms->end(array('hide' => 'Table'));
		$table1content .= "<br />".$list[pages];

		$statuslist = get_data_array('status', 'name', 'dorder', "WHERE `type`='2'");
		array_unshift($statuslist, 'Any');
		$statuses = $forms->item("dropdown", "", "s[status]", $forms->farray($statuslist, $statuslist), "", "", "", array('style' => 'width: 100%;', 'return_item' => 1));

		$table2 = starttable("545", Endorsers, $table1content, array());

		$out = (($status!="")?status($status):"")."$table1<br>$table2";

		}
	}
	/////////////////////////////////////////////////////////////////////////
	// END Endorsers - NETWAVE DESIGN
	/////////////////////////////////////////////////////////////////////////


	/////////////////////////////////////////////////////////////////////////
	// NETWAVE DESIGN
	// VIDEOS - ADDED 05-12-09
	/////////////////////////////////////////////////////////////////////////

	if ($_GET[sub] == "videos") {

		$vars[sidetable] .= getsidesubs($startlink, 4, 0);

		if ($_GET[type] == "add") {

		$video_title = addslashes($video_title);
		$video_desc = addslashes($video_desc);

		$DB_site->query("INSERT INTO videos (video_title, video_desc, video_embed) values ('$video_title', '$video_desc', '$video_embed')");

		header('location: adminindex.php?action=settings&sub=videos');
		exit;
		}


		elseif ($_GET[type] == "update") {

		$video_title = addslashes($video_title);
		$video_desc = addslashes($video_desc);

		$DB_site->query("UPDATE videos SET video_title = '$video_title', video_desc = '$video_desc', video_embed = '$video_embed' WHERE ((video_id = '$id'))");

		header('location: adminindex.php?action=settings&sub=videos');
		exit;

		}

		elseif ($_GET[type] == "delete") {

		$DB_site->query("DELETE FROM videos WHERE ((video_id = '$id'))");

		header('location: adminindex.php?action=settings&sub=videos');
		exit;

		}


		if ($_GET[type] == "edit") {


		$query2 = "SELECT * FROM `videos` WHERE video_id = '$_GET[id]'";
		$results = $DB_site->query($query2);
		while ($row = $DB_site->fetch_assoc($results)) {

		$vid[video_id] = $row[video_id];
		$vid[video_title] = stripslashes($row[video_title]);
		$vid[video_desc] = stripslashes($row[video_desc]);
		$vid[video_embed] = $row[video_embed];
		}

		$data  = $forms->start(array("url" => "adminindex.php?action=settings&sub=videos&type=update&id=$vid[video_id]"));
		$data .= $forms->item("textbox", help("Video Name", "Video Name / Title"), "video_title", "", $vid[video_title], 40);
		$data .= $forms->item("textarea", help("Video Description", "A short description on the video"), "video_desc", "", $vid[video_desc], 60);
		$data .= $forms->item("textarea", help("Embed Code", "Embed or Share Code from YouTube/MySpace"), "video_embed", "", $vid[video_embed], 60);
		$data .= $forms->item("submit", "", "", "", "Update Video");
		$data .= $forms->end();


		$table1 = starttable("545", Videos, $data);


		$tablestart = contentstart(array(template('form_toggle_checkbox.html', array('cname' => 'selectall', 'name' => 'item', 'form' => 'bulk')), l($lang['id'],"id"), l("Video Title","video_title"), $lang['action']), array(), array("center","center","left","center"), "#536da7", 1);
		$query = "SELECT * FROM `videos` order by video_id LIMIT ".((($_GET[pg]==0)?0:$_GET[pg]-1)*$settings[admin_transactions_max]).",".$settings[admin_transactions_max];

		$append = preg_replace('/pg=([0-9]*)/', '', (($_GET[pg]=="")?'&amp;':'').htmlentities($_SERVER["QUERY_STRING"]));
		$page = new pager($query, template('list_pages_output.html', array(), 0), 5, $settings[admin_transactions_max], $_GET[pg], $append);
		$list[pages] = $page->paginate();

		$table1content = $list[pages]."<br />";
		$table1content .= $forms->start(array('name' => 'bulk', 'url' => 'adminindex.php?action=settings&sub=videos'.(($_GET[type]!="")?'&type='.$_GET[type]:''), 'hide' => 'Table'));
		$table1content .= $tablestart;

		$results = $DB_site->query($query);
		while ($row = $DB_site->fetch_assoc($results)) {
		$ef_date = strftime("%m/%d/%y",$row[event_date]);
			$links = ($admin[manage_trans]==1)?icon(2, "adminindex.php?action=settings&sub=videos&type=edit&id=$row[video_id]").icon(3, "adminindex.php?action=settings&sub=videos&type=delete&id=$row[video_id]\" onclick=\"return jsconfirm();"):'';
			$table1content .= content(array(template('form_checkbox.html', array('value' => $row[event_id], 'name' => 'item[]')), $row[video_id], $row[video_title], $links), array(), array("center","center","left","center"), '', "#FFFFFF", 1);
		}
		$table1content .= contentend();
		$table1content .= bulk_action().$forms->end(array('hide' => 'Table'));
		$table1content .= "<br />".$list[pages];

		$statuslist = get_data_array('status', 'name', 'dorder', "WHERE `type`='2'");
		array_unshift($statuslist, 'Any');
		$statuses = $forms->item("dropdown", "", "s[status]", $forms->farray($statuslist, $statuslist), "", "", "", array('style' => 'width: 100%;', 'return_item' => 1));

		$table2 = starttable("545", Videos, $table1content, array());

		$out = (($status!="")?status($status):"")."$table1<br>$table2";

		}


		else {


		$data  = $forms->start(array('url' => 'adminindex.php?action=settings&sub=videos&type=add'));
		$data .= $forms->item("textbox", help("Video Name", "Video Name / Title"), "video_title", "", $vid[video_title], 40);
		$data .= $forms->item("textarea", help("Video Description", "A short description on the video"), "video_desc", "", $vid[video_desc], 60);
		$data .= $forms->item("textarea", help("Embed Code", "Embed or Share Code from YouTube/MySpace"), "video_embed", "", $vid[video_embed], 60);
		$data .= $forms->item("submit", "", "", "", "Add Video");
		$data .= $forms->end();

		$table1 = starttable("545", Videos, $data);

		$tablestart = contentstart(array(template('form_toggle_checkbox.html', array('cname' => 'selectall', 'name' => 'item', 'form' => 'bulk')), l($lang['id'],"id"), l("Video Title","video_title"), $lang['action']), array(), array("center","center","left","center"), "#536da7", 1);
		$query = "SELECT * FROM `videos` order by video_id LIMIT ".((($_GET[pg]==0)?0:$_GET[pg]-1)*$settings[admin_transactions_max]).",".$settings[admin_transactions_max];

		$append = preg_replace('/pg=([0-9]*)/', '', (($_GET[pg]=="")?'&amp;':'').htmlentities($_SERVER["QUERY_STRING"]));
		$page = new pager($query, template('list_pages_output.html', array(), 0), 5, $settings[admin_transactions_max], $_GET[pg], $append);
		$list[pages] = $page->paginate();

		$table1content = $list[pages]."<br />";
		$table1content .= $forms->start(array('name' => 'bulk', 'url' => 'adminindex.php?action=settings&sub=videos'.(($_GET[type]!="")?'&type='.$_GET[type]:''), 'hide' => 'Table'));
		$table1content .= $tablestart;

		$results = $DB_site->query($query);
		while ($row = $DB_site->fetch_assoc($results)) {
		$ef_date = strftime("%m/%d/%y",$row[event_date]);

			$links = ($admin[manage_trans]==1)?icon(2, "adminindex.php?action=settings&sub=videos&type=edit&id=$row[video_id]").icon(3, "adminindex.php?action=settings&sub=videos&type=delete&id=$row[video_id]\" onclick=\"return jsconfirm();"):'';
			$table1content .= content(array(template('form_checkbox.html', array('value' => $row[video_id], 'name' => 'item[]')), $row[video_id], $row[video_title], $links), array(), array("center","center","left","center"), '', "#FFFFFF", 1);
		}
		$table1content .= contentend();
		$table1content .= bulk_action().$forms->end(array('hide' => 'Table'));
		$table1content .= "<br />".$list[pages];

		$statuslist = get_data_array('status', 'name', 'dorder', "WHERE `type`='2'");
		array_unshift($statuslist, 'Any');
		$statuses = $forms->item("dropdown", "", "s[status]", $forms->farray($statuslist, $statuslist), "", "", "", array('style' => 'width: 100%;', 'return_item' => 1));

		$table2 = starttable("545", Videos, $table1content, array());

		$out = (($status!="")?status($status):"")."$table1<br>$table2";

		}
	}
	/////////////////////////////////////////////////////////////////////////
	// END VIDEOS - NETWAVE DESIGN
	/////////////////////////////////////////////////////////////////////////
	
	
	/////////////////////////////////////////////////////////////////////////
	// NETWAVE DESIGN
	// PICTURES - ADDED 05-12-09
	/////////////////////////////////////////////////////////////////////////

	if ($_GET[sub] == "pictures") {

		require_once('class.upload.php');
		$vars[sidetable] .= getsidesubs($startlink, 4, 0);

		if ($_GET[type] == "add") {

		$pic_title = addslashes($pic_title);
		$pic_cat = addslashes($pic_cat);

		$DB_site->query("INSERT INTO pictures (pic_title, pic_cat) values ('$pic_title', '$pic_cat')");
		$ph_id = mysql_insert_id();

		if ($pic[name] != "") {
		
		$handle = new upload($_FILES['pic']);  		
  		$getnew = "large_" . $ph_id;
		$new_thumb = "th_" . $ph_id;
		
		 if ($handle->uploaded)
		  {
		   $handle->file_new_name_body   = "$getnew";
		    $handle->image_convert 	    = jpg;
		    $handle->image_resize         = true;
		    $handle->image_x              = 500;
		    $handle->image_ratio_y        = true;
		    $handle->process("/home/thunder/public_html/pictures/");
		
		
		    $handle->file_new_name_body   = "$new_thumb";
		    $handle->image_convert 	    = jpg;
		    $handle->image_resize         = true;
		    $handle->image_x              = 75;
		    $handle->image_y           	  = 50;
		    $handle->image_ratio_y        = true;
		    $handle->process("/home/thunder/public_html/pictures/");
		


		
		$photo_thumb = "$new_thumb" . ".jpg";
		$photo_large = "$getnew" . ".jpg";
		
		
		$DB_site->query("UPDATE pictures SET pic_file = '$photo_large', thumb_file = '$photo_thumb' WHERE ((pic_id = '$ph_id'))");
		}
		}
  		
		header('location: adminindex.php?action=settings&sub=pictures');
		exit;
		}


		elseif ($_GET[type] == "update") {

		$pic_title = addslashes($pic_title);
		$pic_cat = addslashes($pic_cat);

		$DB_site->query("UPDATE pictures SET pic_title = '$pic_title', pic_cat= '$pic_cat' WHERE ((pic_id = '$id'))");

		if ($pic[name] != "") {
		
		$handle = new upload($_FILES['pic']);  		
  		$getnew = "large_" . $id;
		$new_thumb = "th_" . $id;
		
		 if ($handle->uploaded)
		  {
		   $handle->file_new_name_body   = "$getnew";
		    $handle->image_convert 	    = jpg;
		    $handle->image_resize         = true;
		    $handle->image_x              = 500;
		    $handle->image_ratio_y        = true;
		    $handle->process("/home/thunder/public_html/pictures/");
		
		
		    $handle->file_new_name_body   = "$new_thumb";
		    $handle->image_convert 	    = jpg;
		    $handle->image_resize         = true;
		    $handle->image_x              = 75;
		    $handle->image_y           	  = 50;
		    $handle->image_ratio_y        = true;
		    $handle->process("/home/thunder/public_html/pictures/");
		


		
		$photo_thumb = "$new_thumb" . ".jpg";
		$photo_large = "$getnew" . ".jpg";
		
		
		$DB_site->query("UPDATE pictures SET pic_file = '$photo_large', thumb_file = '$photo_thumb' WHERE ((pic_id = '$ph_id'))");
		}
		}


		header('location: adminindex.php?action=settings&sub=pictures');
		exit;

		}

		elseif ($_GET[type] == "delete") {

		$DB_site->query("DELETE FROM pictures WHERE ((pic_id = '$id'))");

		header('location: adminindex.php?action=settings&sub=pictures');
		exit;

		}


		if ($_GET[type] == "edit") {


		$query2 = "SELECT * FROM `pictures` WHERE pic_id = '$_GET[id]'";
		$results = $DB_site->query($query2);
		while ($row = $DB_site->fetch_assoc($results)) {

		$pic[pic_id] = $row[pic_id];
		$pic[pic_title] = stripslashes($row[pic_title]);
		$pic[pic_cat] = stripslashes($row[pic_cat]);
		$pic[pic_file] = $row[pic_file];
		$pic[thumb_file] = $row[thumb_file];
		}

		$data  = $forms->start(array("url" => 'adminindex.php?action=settings&sub=pictures&type=update&id=$pic[pic_id]" enctype="multipart/form-data', 'name' => 'pic_edit'));
		$data .= $forms->item("textbox", help("Picture Title", "Picture Title"), "pic_title", "", $pic[pic_title], 40);
		$data .= $forms->item("dropdown", help(Category, Category), "pic_cat", $forms->farray(array("General","Out and About","On the Road","Celebrities","Misc"), array("General","Out and About","On the Road","Celebrities","Misc")), $pic[pic_cat]);
		$data .= $forms->item("show", help(Picture, ''), "", "", template('pic_upload.html'));
		$data .= $forms->item("show", help(Picture, ''), "", "", "<img src=\"../pictures/".$pic[thumb_file]."\">");

		$data .= $forms->item("submit", "", "", "", "Update Picture");
		$data .= $forms->end();


		$table1 = starttable("545", Pictures, $data);


		$tablestart = contentstart(array(template('form_toggle_checkbox.html', array('cname' => 'selectall', 'name' => 'item', 'form' => 'bulk')), l($lang['id'],"id"), l("Picture Title","pic_title", "Category", "pic_cat"), $lang['action']), array(), array("center","center","left","center"), "#536da7", 1);
		$query = "SELECT * FROM `pictures` order by pic_id LIMIT ".((($_GET[pg]==0)?0:$_GET[pg]-1)*$settings[admin_transactions_max]).",".$settings[admin_transactions_max];

		$append = preg_replace('/pg=([0-9]*)/', '', (($_GET[pg]=="")?'&amp;':'').htmlentities($_SERVER["QUERY_STRING"]));
		$page = new pager($query, template('list_pages_output.html', array(), 0), 5, $settings[admin_transactions_max], $_GET[pg], $append);
		$list[pages] = $page->paginate();

		$table1content = $list[pages]."<br />";
		$table1content .= $forms->start(array('name' => 'bulk', 'url' => 'adminindex.php?action=settings&sub=pictures'.(($_GET[type]!="")?'&type='.$_GET[type]:''), 'hide' => 'Table'));
		$table1content .= $tablestart;

		$results = $DB_site->query($query);
		while ($row = $DB_site->fetch_assoc($results)) {
			$links = ($admin[manage_trans]==1)?icon(2, "adminindex.php?action=settings&sub=pictures&type=edit&id=$row[pic_id]").icon(3, "adminindex.php?action=settings&sub=pictures&type=delete&id=$row[pic_id]\" onclick=\"return jsconfirm();"):'';
			$table1content .= content(array(template('form_checkbox.html', array('value' => $row[pic_id], 'name' => 'item[]')), $row[pic_id], $row[pic_title], $row[pic_cat], $links), array(), array("center","center","left","center"), '', "#FFFFFF", 1);
		}
		$table1content .= contentend();
		$table1content .= bulk_action().$forms->end(array('hide' => 'Table'));
		$table1content .= "<br />".$list[pages];

		$statuslist = get_data_array('status', 'name', 'dorder', "WHERE `type`='2'");
		array_unshift($statuslist, 'Any');
		$statuses = $forms->item("dropdown", "", "s[status]", $forms->farray($statuslist, $statuslist), "", "", "", array('style' => 'width: 100%;', 'return_item' => 1));

		$table2 = starttable("545", Pictures, $table1content, array());

		$out = (($status!="")?status($status):"")."$table1<br>$table2";

		}


		else {


		$data  = $forms->start(array('url' => 'adminindex.php?action=settings&sub=pictures&type=add" enctype="multipart/form-data', 'name' => 'pic_add'));
		$data .= $forms->item("textbox", help("Picture Title", "Picture Title"), "pic_title", "", $pic[pic_title], 40);
		$data .= $forms->item("dropdown", help(Category, Category), "pic_cat", $forms->farray(array("General","Out and About","On the Road","Celebrities","Misc"), array("General","Out and About","On the Road","Celebrities","Misc")), $pic[pic_cat]);
		$data .= $forms->item("show", help(Picture, ''), "", "", template('pic_upload.html'));
		$data .= $forms->item("submit", "", "", "", "Add Picture");
		$data .= $forms->end();


		$table1 = starttable("545", Pictures, $data);


		$tablestart = contentstart(array(template('form_toggle_checkbox.html', array('cname' => 'selectall', 'name' => 'item', 'form' => 'bulk')), l($lang['id'],"id"), l("Picture Title","pic_title"), l("Category", "pic_cat"), $lang['action']), array(), array("center","center","left","center"), "#536da7", 1);
		$query = "SELECT * FROM `pictures` order by pic_id LIMIT ".((($_GET[pg]==0)?0:$_GET[pg]-1)*$settings[admin_transactions_max]).",".$settings[admin_transactions_max];

		$append = preg_replace('/pg=([0-9]*)/', '', (($_GET[pg]=="")?'&amp;':'').htmlentities($_SERVER["QUERY_STRING"]));
		$page = new pager($query, template('list_pages_output.html', array(), 0), 5, $settings[admin_transactions_max], $_GET[pg], $append);
		$list[pages] = $page->paginate();

		$table1content = $list[pages]."<br />";
		$table1content .= $forms->start(array('name' => 'bulk', 'url' => 'adminindex.php?action=settings&sub=pictures'.(($_GET[type]!="")?'&type='.$_GET[type]:''), 'hide' => 'Table'));
		$table1content .= $tablestart;

		$results = $DB_site->query($query);
		while ($row = $DB_site->fetch_assoc($results)) {
			$links = ($admin[manage_trans]==1)?icon(2, "adminindex.php?action=settings&sub=pictures&type=edit&id=$row[pic_id]").icon(3, "adminindex.php?action=settings&sub=pictures&type=delete&id=$row[pic_id]\" onclick=\"return jsconfirm();"):'';
			$table1content .= content(array(template('form_checkbox.html', array('value' => $row[pic_id], 'name' => 'item[]')), $row[pic_id], $row[pic_title], $row[pic_cat], $links), array(), array("center","center","left","center"), '', "#FFFFFF", 1);
		}
		$table1content .= contentend();
		$table1content .= bulk_action().$forms->end(array('hide' => 'Table'));
		$table1content .= "<br />".$list[pages];

		$statuslist = get_data_array('status', 'name', 'dorder', "WHERE `type`='2'");
		array_unshift($statuslist, 'Any');
		$statuses = $forms->item("dropdown", "", "s[status]", $forms->farray($statuslist, $statuslist), "", "", "", array('style' => 'width: 100%;', 'return_item' => 1));

		$table2 = starttable("545", Pictures, $table1content, array());

		$out = (($status!="")?status($status):"")."$table1<br>$table2";

		}
	}
	/////////////////////////////////////////////////////////////////////////
	// END PICTURES - NETWAVE DESIGN
	/////////////////////////////////////////////////////////////////////////


	////////////////////
	// Shipping Settings
	////////////////////

	if ($_GET[sub] == "shipping") {
		$vars[sidetable] .= getsidesubs($startlink, 4, 0);

		$status = urldecode($_GET[status]);

		$start  = $forms->start(array('url' => 'adminindex.php?action=settings&sub=update&type=shipping'));
		$start .= $forms->item("dropdown", help($lang['actives'], $lang['actives_d']), "shipmethod", $forms->farray(array("realtime", "set", "shiptable", "fixed"), array($lang['realti'], $lang['productdefi'], $lang['shiptabl'], $lang['fixd'])), $settings[shipmethod]);
		$start .= $forms->item("dropdown", help($lang['fixedm'], $lang['fixedm_d']), "method", $forms->farray(array("perorder","perpound","peritem","percentage"), array($lang['prorder'],$lang['prpound'],$lang['pritem'],$lang['prctag'])), $settings[method]);
		$start .= $forms->item("dropdown", help($lang['shippingt'], $lang['shippingt_d']), "tableset", $forms->farray(array("price","weight"), array($lang['totpri'],$lang['tweight'])), $settings[tableset]);
		$start .= $forms->item("textbox", help($lang['fixedr'], $lang['fixedr_d']), "rate", "", p($settings[rate], false), 5, '', array('lead' => (($settings[cs_pos]=='before' && $settings[method]!='percentage')?$settings[cs]:''), 'follow' => (($settings[cs_pos]=='after' && $settings[method]!='percentage')?$settings[cs]:'')));
		$start .= $forms->item("textbox", help($lang['handlingc'], $lang['handlingc_d']), "handling", "", p($settings[handling], false), 5, '', array('lead' => (($settings[cs_pos]=='before')?$settings[cs]:''), 'follow' => (($settings[cs_pos]=='after')?$settings[cs]:'')));
		$start .= $forms->item("textbox", help($lang['expcharg'], $lang['addspecd']), "expedited", "", p($settings[expedited], false), 5, '', array('lead' => (($settings[cs_pos]=='before')?$settings[cs]:''), 'follow' => (($settings[cs_pos]=='after')?$settings[cs]:'')));
		$start .= $forms->item("radio", help($lang['taxship'], ""), "taxtoshipping", $forms->farray(array("1","0"), array($lang['on'],$lang['off'])), $settings[taxtoshipping]);
		$start .= $forms->item("radio", help($lang['dshipcap'], ""), "dropshipon", $forms->farray(array("1","0"), array($lang['on'],$lang['off'])), $settings[dropshipon]);
		$start .= $forms->item("radio", help($lang['bcprint'], ""), "showbc_print", $forms->farray(array("Yes","No"), array($lang['on'],$lang['off'])), $settings[showbc_print]);
		$start .= $forms->item("radio", help($lang['bcplist'], ""), "showbc_plist", $forms->farray(array("Yes","No"), array($lang['on'],$lang['off'])), $settings[showbc_plist]);
		$start .= $forms->item("submit", "", "", "", $lang['edits']);
		$start .= $forms->end(array('hide' => 'Form'));

		// Package Settings
		$form  = $forms->start(array('hide' => 'Form'));
		$form .= $forms->item("textbox", help($lang['averageb'], $lang['averageb_d']), "avg_length", "", $settings[avg_length], 6);
		$form .= $forms->item("textbox", help($lang['averagebw'], $lang['averagebw_d']), "avg_width", "", $settings[avg_width], 6);
		$form .= $forms->item("textbox", help($lang['averagebh'], $lang['averagebh_d']), "avg_height", "", $settings[avg_height], 6);
		$form .= $forms->item("dropdown", help($lang['dimensionu'], $lang['dimensionu_d']), "dimension_units", $forms->farray(array("IN","CM"), array($lang['inches'],$lang['cent'])), $settings[dimension_units]);
		$form .= $forms->item("dropdown", help($lang['weightu'], $lang['weightu_d']), "weight_units", $forms->farray(array("LB","KG","OZ"), array($lang['pnds'],$lang['kilo'],$lang['ounces'])), $settings[weight_units]);
		$form .= $forms->item("radio", help($lang['weightr'], $lang['weightr_d']), "roundup", $forms->farray(array("Yes","No"), array($lang['on'],$lang['off'])), $settings[roundup]);
		$form .= $forms->item("radio", help($lang['packaget'], $lang['packaget_d']), "shiptogether", $forms->farray(array("1","0"), array($lang['on'],$lang['off'])), $settings[shiptogether]);
		$form .= $forms->item("submit", "", "", "", $lang['edits']);
		$form .= $forms->end(array('hide' => 'Form'));

		$tab_items  = tab_item($lang['packset'], $form);

		// Shipping Zones
		$table1content = contentstart(array($lang['id'], $lang['name'], $lang['zaselected'], $lang['action']), array(), array("center","left","center","center"), "#536da7", 0, "500");
		$results = $DB_site->query("SELECT * FROM `".$dbprefix."ship_zones` ORDER by `name`"); $num = 0;
		while ($row = $DB_site->fetch_assoc($results)) {
			$links  = icon(4, "adminindex.php?action=settings&sub=shipping_zone&do=edit&id=$row[id]").icon(3, "adminindex.php?action=settings&sub=module_update&do=delete_zone&id=$row[id]");
			$selected = get_data_array('ship_zones_relation', 'areaid',  'areaid', 'WHERE zoneid=\''.$row[id].'\'');
			$table1content .= content(array($row[id], $row[name], count($selected), $links), array(), array("center","left","center","center"));
			$num++;
		}
		$table1content .= contentend();

		$content = template('add_zone.html', array('zone_list' => $table1content));
		$tab_items .= tab_item($lang['szones'], $content);

		// Shipping Table
		$zonelist1 = get_data_array('ship_zones', 'id', 'name', '');
		$zonelist2 = get_data_array('ship_zones', 'name', 'name', '');
		array_unshift($zonelist1, ""); array_unshift($zonelist2, "Select a Zone");
		$zone_list = $forms->item("dropdown", '', "zone_id", $forms->farray($zonelist1, $zonelist2), $_GET[zone_id], "", "", array('return_item' => 1, 'onchange' => 'updateShip(this.value)'));

		$table1content = contentstart(array($lang['id'], $lang['frvalue'], $lang['tovalue'], $lang['price'], $lang['action']), array(), array("center","center","center","center","center"), "#536da7", 0, "500");
		$results = $DB_site->query("SELECT * FROM `".$dbprefix."ship_table` where `zoneid`='".$_GET[zone_id]."' ORDER by `from_value`,`to_value`"); $num = 0;
		while ($row = $DB_site->fetch_assoc($results)) {
			$hide 	= $forms->item("hidden", "", 'tableids['.$num.']', "", $row[id], "", "", array('return_item' => 1));
			$from 	= $forms->item("textbox", "", 'froms['.$num.']', "", $row[from_value], "5", "", array('return_item' => 1));
			$to 	= $forms->item("textbox", "", 'tos['.$num.']', "", $row[to_value], "5", "", array('return_item' => 1));
			$price 	= $forms->item("textbox", "", 'prices['.$num.']', "", p($row[price], false), "5", "", array('return_item' => 1));
			$links  = icon(3, "adminindex.php?action=settings&sub=module_update&do=delete_table&zid=$_GET[zone_id]&id=$row[id]&type=shipping");
			$table1content .= content(array($row[id].$hide, $from, $to, (($settings[cs_pos]=='before')?$settings[cs]:'').$price.(($settings[cs_pos]=='after')?$settings[cs]:''), $links), array(), array("center","center","center","center","center"));
			$num++;
		}
		$table1content .= contentend();
		$table1content .= $forms->start(array('hide' => 'Form'));
		$table1content .= $forms->item("submit", "", "", "", $lang['stableu']);
		$table1content .= $forms->end(array('hide' => 'Form'));

		$addinfo = get('ship_zones', $_GET[zone_id]);
		$content = template('add_shiptable.html', array('ship_list' => $table1content, 'zone_list' => $zone_list, 'area_name' => $addinfo[name], 'zone_id' => $addinfo[id]));
		$tab_items .= tab_item($lang['stableh'], $content);

		// Installed Modules
		$pm = modules('shipping');
		$pm = $sort->sortit($pm, 'module_name', true);
		$form = contentstart(array($lang['modulen'], $lang['filen'], $lang['version'], $lang['status'], $lang['actions']), array(), array("left","left","center","center","center"), "#536da7", 0, "500");
		for ($i=0; $i<count($pm); $i++) {
			$enabled = module_vars($pm[$i][class_name], 'shipping');
			if ($pm[$i]["installed"] == 1) {
				$links = icon(9,"adminindex.php?action=settings&sub=module_settings&id=".$pm[$i][file_name]."&type=shipping&tab=4")."&nbsp;&nbsp;".icon(11,"adminindex.php?action=settings&sub=module_update&do=uninstall&id=".$pm[$i][file_name].'&type=shipping&tab=4" onclick="return jsconfirm();');
				$form .= content(array($pm[$i][module_fullname], $pm[$i][file_name], $pm[$i][module_ver], (($enabled[enabled]==1)?'<font color="#008000">'.$lang['on'].'</font>':'<font color="#D4D4D4">'.$lang['off'].'</font>'), $links), array(), array("left","left","center","center","center"));
				$added++;
			}
		}
		if (!isset($added)) { $form .= '<td align="center" colspan="5">'.$lang['ninstalled'].'</td>'; }
		$form .= contentend();

		$tab_items .= tab_item($lang['inmods'], $form);

		// Available Modules
		$form = contentstart(array($lang['modulen'], $lang['filen'], $lang['type'], $lang['version'], $lang['actions']), array(), array("left","left","center","center","center"), "#536da7", 0, "500");
		for ($i=0; $i<count($pm); $i++) {
			if ($pm[$i]["installed"] == 0) {
				$links = icon(10,"adminindex.php?action=settings&sub=module_update&do=install&id=".$pm[$i][file_name]."&type=shipping&tab=5");
				$form .= content(array($pm[$i][module_fullname], $pm[$i][file_name], $pm[$i][module_type], $pm[$i][module_ver], $links), array(), array("left","left","center","center","center"));
			}
		}
		$form .= contentend();

		$tab_items .= tab_item($lang['availm'], $form);

		$data = $start.start_tabs($tab_items);

		$out = (($status!="")?status($status):"").starttable("545", $lang['ssettings'], $data);
	}

	/////////////////
	// Shipping Zones
	/////////////////

	if ($_GET[sub] == "shipping_zone") {
		switch ($_GET['do']) {
			case 'update':
				$DB_site->query("DELETE FROM `".$dbprefix."ship_zones_relation` where `zoneid`='".$_POST[zone]."'");
			case 'store':
				if ($_GET['do'] == 'store') { $DB_site->query("INSERT INTO `".$dbprefix."ship_zones` set `name`='".sf($_POST[name])."'"); $_POST[zone] = $DB_site->insert_id(); }
				else $DB_site->query("UPDATE `".$dbprefix."ship_zones` set `name`='".sf($_POST[name])."' where `id`='".$_POST[zone]."'");

				for ($i=0; $i<count($_POST[areas]); $i++) {
					if ($_POST[areas][$i] != "") $DB_site->query("INSERT INTO `".$dbprefix."ship_zones_relation` set `zoneid`='".$_POST[zone]."', `areaid`='".$_POST[areas][$i]."'");
				}
				header('location: adminindex.php?action=settings&sub=shipping&tab=2&status='.urlencode('Zone areas saved sucessfully.'));
				exit;
			break;
		}


		$do 	= ($_GET['do']=="add")?'store':'update';
		$word 	= ($_GET['do']=="add")?$lang['add']:$lang['edit'];
		$info 	= get('ship_zones', $_GET[id]);

		$statelist1 = get_data_array('state_country', 'id',  'type,name', 'WHERE type=\''.STATE.'\' OR type=\''.PROVINCE.'\'');
		$statelist2 = get_data_array('state_country', 'name',  'type,name', 'WHERE type=\''.STATE.'\' OR type=\''.PROVINCE.'\'');
		$countrylist1 = get_data_array('state_country', 'id',  'name', 'WHERE type=\''.COUNTRY.'\'');
		$countrylist2 = get_data_array('state_country', 'name',  'name', 'WHERE type=\''.COUNTRY.'\'');
		$ziplist1 = get_data_array('state_country', 'id',  'name', 'WHERE type=\''.ZIP.'\'');
		$ziplist2 = get_data_array('state_country', 'name',  'name', 'WHERE type=\''.ZIP.'\'');


		$list1 = array_merge(array(''),$statelist1,array(''),$countrylist1,array(''),$ziplist1);
		$list2 = array_merge(array('-----STATES-----'),$statelist2,array('---COUNTRIES---'),$countrylist2,array('---ZIP CODES---'),$ziplist2);
		$selected = ($_GET['do']=="edit")?get_data_array('ship_zones_relation', 'areaid',  'areaid', 'WHERE zoneid=\''.$_GET[id].'\''):'';

		$vars[sidetable] .= getsidesubs($startlink, 4, 0);
		$form  = $forms->start(array('url' => 'adminindex.php?action=settings&sub=shipping_zone&do='.$do));
		$form .= ($_GET['do']=="edit")?$forms->item("hidden", "", "zone", "", $info[id]):'';
		$form .= $forms->item("textbox", help($lang['name'], $lang['dispname']), "name", "", $info[name], 35);
		$form .= $forms->item("dropdown", help($lang['zaselected'], $lang['zaselectedd']), "areas", $forms->farray($list1, $list2), $selected, 0, 0, array('multi' => '1', 'style' => 'width: 400; height: 400;'));
		$form .= $forms->item("submit", "", "", "", "$word $lang[szones]");
		$form .= $forms->end();
		$data = $form;

		$out = starttable("545", "$word $lang[szones]", $data, array());
	}

	///////////////////
	// Payment Settings
	///////////////////

	if ($_GET[sub] == "paymodules" || $_GET[sub] == "payment" || $_GET[sub] == "methods") {
		$vars[sidetable] .= getsidesubs($startlink, 4, 0);

		$status = urldecode($_GET[status]);

		$ret_ret[symbols] = get_data_array('currency', 'currency', 'name');
		$ret_ret[countries] = get_data_array('currency', 'name', 'name');

		$start  = $forms->start(array('url' => 'adminindex.php?action=settings&sub=update&type=paymodules'));
		$start .= $forms->item("dropdown", help($lang['dcurrency'], $lang['dcurrencydesc']), "defaultrate", $forms->farray($ret_ret[symbols], $ret_ret[countries]), $settings[defaultrate]);
		$start .= $forms->item("dropdown", help($lang['currencyc'], $lang['currencycdesc']), "currencychange", $forms->farray(array("0","1"), array($lang['off'],$lang['on'])), $settings[currencychange]);
		$start .= $forms->item("dropdown", help($lang['giftc'], $lang['giftc_d']), "giftcerts", $forms->farray(array("No","Yes"), array($lang['off'],$lang['on'])), $settings[giftcerts]);
		$start .= $forms->item("textbox", help($lang['gcmin'], $lang['gcmin_d']), "giftcerts_min", "", $settings[giftcerts_min], 5);
		$start .= $forms->item("textbox", help($lang['orderm'], $lang['orderm_d']), "order_min", "", $settings[order_min], 5);
		$start .= $forms->item("textbox", help($lang['globalpc'], $lang['globalpcdesc']), "globalpriceoffset", "", $settings[globalpriceoffset], 5);
		$start .= $forms->item("textbox", help($lang['decpos'], $lang['decposdesc']), "decimal", "", $settings[decimal], 5);
		$start .= $forms->item("textbox", help($lang['csymbol'], $lang['csymboldesc']), "cs", "", $settings[cs], 5);
		$start .= $forms->item("dropdown", help($lang['displays'], $lang['displays_d']), "cs_pos", $forms->farray(array("before","after"), array($lang['befprice'],$lang['aftprice'])), $settings[cs_pos]);
		$start .= $forms->item("submit", "", "", "", $lang['updates']);
		$start .= $forms->end(array('hide' => 'Form'));

		// Payment Methods
		$pms = modules('methods');
		$pms = $sort->sortit($pms, 'module_name', true);
		$form = contentstart(array($lang['modulen'], $lang['version'], $lang['order'], $lang['status'], $lang['actions']), array(), array("left","center","center","center","center"), "#536da7", 0, "500");
		for ($i=0; $i<count($pms); $i++) {
			$enabled = module_vars($pms[$i][class_name], 'methods');
			if ($pms[$i]["installed"] == 1) {
				$links = icon(9,"adminindex.php?action=settings&sub=module_settings&id=".$pms[$i][file_name]."&type=methods&tab=1")."&nbsp;&nbsp;".icon(11,"adminindex.php?action=settings&sub=module_update&do=uninstall&id=".$pms[$i][file_name].'&type=methods&tab=1" onclick="return jsconfirm();');
				$form .= content(array($pms[$i][module_name], $pms[$i][module_ver], $pms[$i][display_order], (($enabled[enabled]==1)?'<font color="#008000">'.$lang['on'].'</font>':'<font color="#D4D4D4">'.$lang['off'].'</font>'), $links), array(), array("left","center","center","center","center"));
				$added++;
			}
		}
		if (!isset($added)) { $form .= '<td align="center" colspan="5">'.$lang['ninstalled'].'</td>'; }
		$form .= contentend();

		$tab_items  = tab_item($lang['paymentm'], $form);

		// Payment Processors
		$pm = modules('payment');
		$pm = $sort->sortit($pm, 'module_name', true);
		$form = contentstart(array($lang['modulen'], $lang['version'], $lang['status'], $lang['actions']), array(), array("left","center","center","center"), "#536da7", 0, "500");
		unset($added);
		for ($i=0; $i<count($pm); $i++) {
			$enabled = module_vars($pm[$i][class_name], 'methods');
			if ($pm[$i]["installed"] == 1) {
				$links = icon(9,"adminindex.php?action=settings&sub=module_settings&id=".$pm[$i][file_name]."&type=payment&tab=2").icon(11,"adminindex.php?action=settings&sub=module_update&do=uninstall&id=".$pm[$i][file_name].'&type=payment&tab=2" onclick="return jsconfirm();').icon((($pm[$i][file_name]==$settings[payment_module])?12:13),"adminindex.php?action=settings&sub=module_update&do=".(($pm[$i][file_name]==$settings[payment_module])?'setoff':'seton')."&id=".$pm[$i][file_name]."&type=payment&tab=2\" onclick=\"return jsconfirm();");
				$form .= content(array($pm[$i][module_name], $pm[$i][module_ver], (($pm[$i][file_name]==$settings[payment_module])?'<font color="#008000">'.$lang['on'].'</font>':'<font color="#D4D4D4">'.$lang['off'].'</font>'), $links), array(), array("left","center","center","center"));
				$added++;
			}
		}
		if (!isset($added)) { $form .= '<td align="center" colspan="5">'.$lang['ninstalled'].'</td>'; }
		$form .= contentend();

		$tab_items .= tab_item($lang['pprocess'], $form);

		// Available Modules
		$pm = array_merge($pms, $pm);
		$form = contentstart(array($lang['modulen'], $lang['type'], $lang['version'], $lang['actions']), array(), array("left","center","center","center"), "#536da7", 0, "500");
		for ($i=0; $i<count($pm); $i++) {
			if ($pm[$i]["installed"] == 0) {
				$links = icon(10,"adminindex.php?action=settings&sub=module_update&do=install&id=".$pm[$i][file_name]."&type=".(($pm[$i][module_type]=='Pay Method')?"methods&tab=3":"payment&tab=3"));
				$form .= content(array($pm[$i][module_name], $pm[$i][module_type], $pm[$i][module_ver], $links), array(), array("left","center","center","center"));
			}
		}
		$form .= contentend();

		$tab_items .= tab_item($lang['availm'], $form);

		// Customer Rewards
		$form  = $forms->start(array('hide' => 'Form'));
		$form .= $forms->item("radio", help($lang['rpoints'], $lang['rpoints_d']), "rewards_points", $forms->farray(array("Yes","No"), array($lang['on'],$lang['off'])), $settings[rewards_points]);
		$form .= $forms->item("textbox", help($lang['dtop'], $lang['dtop_d']), "dollars_to_points", "", $settings[dollars_to_points], 5);
		$form .= $forms->item("textbox", help($lang['ptod'], $lang['ptod_d']), "points_to_dollars", "", $settings[points_to_dollars], 5);
		$form .= $forms->item("submit", "", "", "", $lang['updates']);
		$form .= $forms->end();

		$tab_items  .= tab_item($lang['crewards'], $form);

		$data = $start.start_tabs($tab_items);

		$out = (($status!="")?status($status):"").starttable("545", $lang['psettings'], $data);
	}

	/////////////////
	// Plugin Modules
	/////////////////

	if ($_GET[sub] == "plugins") {

		$status = urldecode($_GET[status]);

		// Payment Processors
		$pm = modules('plugins');
		$pm = $sort->sortit($pm, 'module_name', true);
		$form = contentstart(array($lang['pluginn'], $lang['filen'], $lang['version'], $lang['status'], $lang['actions']), array(), array("left","left","center","center","center"), "#536da7", 0, "500");
		unset($added);
		for ($i=0; $i<count($pm); $i++) {
			$enabled = module_vars($pm[$i][class_name], 'plugins');
			if ($pm[$i]["installed"] == 1) {
				$links = icon(9,"adminindex.php?action=settings&sub=module_settings&id=".$pm[$i][file_name]."&type=plugins&tab=1").icon(11,"adminindex.php?action=settings&sub=module_update&do=uninstall&id=".$pm[$i][file_name].'&type=plugins&tab=1" onclick="return jsconfirm();');
				$form .= content(array($pm[$i][module_name], $pm[$i][file_name], $pm[$i][module_ver], (($pm[$i]["enabled"] == 1)?'<font color="#008000">'.$lang['on'].'</font>':'<font color="#D4D4D4">'.$lang['off'].'</font>'), $links), array(), array("left","left","center","center","center"));
				$added++;
			}
		}
		if (!isset($added)) { $form .= '<td align="center" colspan="5">'.$lang['ninstalled'].'</td>'; }
		$form .= contentend();

		$tab_items .= tab_item($lang['iplugin'], $form);

		// Available Modules
		$form = contentstart(array($lang['pluginn'], $lang['filen'], $lang['version'], $lang['actions']), array(), array("left","left","center","center","center"), "#536da7", 0, "500");
		for ($i=0; $i<count($pm); $i++) {
			if ($pm[$i]["installed"] == 0) {
				$links = icon(10,"adminindex.php?action=settings&sub=module_update&do=install&id=".$pm[$i][file_name]."&type=plugins&tab=2");
				$form .= content(array($pm[$i][module_name], $pm[$i][file_name], $pm[$i][module_ver], $links), array(), array("left","left","center","center","center"));
			}
		}
		$form .= contentend();

		$tab_items .= tab_item($lang['aplugins'], $form);

		$data = $start.start_tabs($tab_items);

		$out = (($status!="")?status($status):"").starttable("545", $lang['psettings'], $data);
	}

	//////////////////
	// Resize Settings
	//////////////////

	if ($_GET[sub] == "resizing") {
		$vars[sidetable] .= getsidesubs($startlink, 4, 0);
		$status = urldecode($_GET[status]);

		if (extension_loaded("imagick")) { $list_it[] = $lang['imag']; $value_it[] = "imagick"; }
		if (extension_loaded("gd")) {  $list_it[] = $lang['gdlb']; $value_it[] = "gd"; }
		$list_it[] = "None"; $value_it[] = "none";

		$form  = $forms->start(array('url' => 'adminindex.php?action=settings&sub=update&type=resizing'));
		$form .= $forms->item("dropdown", help($lang['resizingm'], $lang['resizingm_d']), "resize", $forms->farray($value_it, $list_it), $settings[resize]);
		$form .= $forms->item("radio", help($lang['autor'], $lang['autor_d']), "auto_resize", $forms->farray(array('true','false'), array($lang['on'],$lang['off'])), $settings[auto_resize]);
		$form .= $forms->item("textbox", help($lang['maxt'], $lang['maxt_d']), "auto_tiny_width", "", $settings[auto_tiny_width], 4);
		$form .= $forms->item("textbox", help($lang['maxtih'], $lang['maxtih_d']), "auto_tiny_height", "", $settings[auto_tiny_height], 4);
		$form .= $forms->item("textbox", help($lang['maxthw'], $lang['maxthw_d']), "auto_thumb_width", "", $settings[auto_thumb_width], 4);
		$form .= $forms->item("textbox", help($lang['maxthh'], $lang['maxthh_d']), "auto_thumb_height", "", $settings[auto_thumb_height], 4);
		$form .= $forms->item("textbox", help($lang['maxde'], $lang['maxde_d']), "auto_detail_width", "", $settings[auto_detail_width], 4);
		$form .= $forms->item("textbox", help($lang['maxdh'], $lang['maxdh_d']), "auto_detail_height", "", $settings[auto_detail_height], 4);
		$form .= $forms->item("textbox", help($lang['maxl'], $lang['maxl_d']), "auto_large_width", "", $settings[auto_large_width], 4);
		$form .= $forms->item("textbox", help($lang['maxlh'], $lang['maxlh_d']), "auto_large_height", "", $settings[auto_large_height], 4);
		$form .= $forms->item("submit", "", "", "", $lang['edits']);
		$form .= $forms->end(array('hide' => 'Form'));

		$out = (($status!="")?status($status):"").starttable("545", $lang['rsettings'], $form);
	}

	///////////////
	// Tax Settings
	///////////////

	if ($_GET[sub] == "tax") {
		$vars[sidetable] .= getsidesubs($startlink, 4, 0);

		if ($_GET['do'] == "delete") {
			$DB_site->query("DELETE FROM `".$dbprefix."taxes` WHERE `id`='".$_GET[id]."'");
			$status = $lang['trated'];
		}

		if ($_GET['do'] == "update") {
			if ($_POST[name] != "" && $_POST[rate] != "") {
				$area = get('state_country', $_POST[area], 'type`=\''.$_POST[type].'\' AND `abb');
				$DB_site->query("INSERT INTO `".$dbprefix."taxes` set `name`='".sf($_POST[name])."', `type`='".$_POST[type]."', `tvalue`='".sf($area[id])."', `rate`='".sf($_POST[rate])."'");
				$status = $lang['tratea']."<br />";
			}
			if (is_array($_POST[ids])) {
				foreach ($_POST[ids] as $k => $v) {
					$DB_site->query("UPDATE `".$dbprefix."taxes` set `name`='".sf($_POST[names][$k])."', `rate`='".sf($_POST[rates][$k])."', `address`='".sf($_POST[addresses][$k])."' where `id`='".$_POST[ids][$k]."'");
				}
				$status .= $lang['tratesu'];
			}
		}

		$_GET[orderby]	= ($_GET[orderby]=='')?'rate':$_GET[orderby];
		$_GET[sort]		= ($_GET[sort]=='')?'asc':$_GET[sort];
		$_GET[pg] 		= (isset($_GET[pg]) && $_GET[pg] > 0)?intval($_GET[pg]):0;

		$taxlist = contentstart(array(template('form_toggle_checkbox.html', array('cname' => 'selectall', 'name' => 'item', 'form' => 'addTax')), l($lang['id'],"id"), $lang['area'], l($lang['us_name'],"name"), l($lang['rate'],"rate"), $lang['calculatef'], $lang['action']), array(), array("center","center","left","left","left","left","center"), "#536da7", 1);
		$query = "SELECT id FROM `".$dbprefix."taxes` order by ".$_GET[orderby]." ".$_GET[sort]." LIMIT ".((($_GET[pg]==0)?0:$_GET[pg]-1)*50).",50";

		$append = preg_replace('/pg=([0-9]*)/', '', (($_GET[pg]=="")?'&amp;':'').htmlentities($_SERVER["QUERY_STRING"]));
		$page = new pager($query, template('list_pages_output.html', array(), 0), 5, 50, $_GET[pg], $append);
		$list[pages] = $page->paginate();

		$results = $DB_site->query($query); $num = 0;
		while ($row = $DB_site->fetch_assoc($results)) {
			$tax = get('taxes', $row[id]);
			$area = get('state_country', $tax[tvalue]);
			$links = ($admin[manage_status]==1)?icon(3, "adminindex.php?action=settings&sub=tax&do=delete&id=$row[id]\" onclick=\"return jsconfirm();"):'None';
			$taxids	 = $forms->item("hidden", "", 'ids['.$num.']', "", $tax[id], "", "", array('return_item' => 1));
			$taxname = $forms->item("textbox", "", 'names['.$num.']', "", $tax[name], "20", "", array('return_item' => 1));
			$taxrate = $forms->item("textbox", "", 'rates['.$num.']', "", $tax[rate], "10", "", array('return_item' => 1));
			$taxadd  = $forms->item("dropdown", "", 'addresses['.$num.']', $forms->farray(array("bill", "ship"), array($lang['billaddr'], $lang['shipaddr'])), $tax[address], '', '', array('return_item' => 1));
			$taxlist .= content(array(template('form_checkbox.html', array('value' => $row[id], 'name' => 'item[]')), $row[id].$taxids, $area[name], $taxname, $taxrate, $taxadd, $links), array(), array("center","center","left","left","left","left","center"));
			$num++;
		}
		$listend = contentend().bulk_action();

		$statelist1 = get_data_array('state_country', 'abb',  'name', 'WHERE type=\''.STATE.'\'');
		$statelist2 = get_data_array('state_country', 'name',  'name', 'WHERE type=\''.STATE.'\'');
		$type_drop = $forms->item("dropdown", "", "type", $forms->farray(array(STATE, PROVINCE, COUNTRY, ZIP), array($lang['state2'], $lang['prov'], $lang['country'], $lang['zip'])), STATE, '', '', array('return_item' => 1, 'style' => 'width: 100%;', 'onchange' => 'updateTax(this.value)'));
		$area_drop = $forms->item("dropdown", "", "area", $forms->farray($statelist1, $statelist2), $settings[state], '', '', array('return_item' => 1, 'style' => 'width: 100%;'));
		$allout = template('add_tax.html', array('taxes_list' => $taxlist, 'type_drop' => $type_drop, 'area_drop' => $area_drop, 'pages' => $list[pages], 'listend' => $listend));

		$table1 = starttable("545", $lang['tsettings'], $allout, array());

		$out = (($status!="")?status($status):"")."$table1";
	}

	///////////////////////
	// Google Base Settings
	///////////////////////

	if ($_GET[sub] == "google") {
		$vars[sidetable] .= getsidesubs($startlink, 4, 0);
		$status = urldecode($_GET[status]);

		$form  = $forms->start(array('url' => 'adminindex.php?action=settings&sub=update&type=google'));
		$form .= $forms->item("textbox", help($lang['googleb'], $lang['googleb_d']), "google_host", "", $settings[google_host], 35);
		$form .= $forms->item("textbox", help($lang['registeredf'], $lang['registeredf_d']), "google_filename", "", $settings[google_filename], 35);
		$form .= $forms->item("textbox", help($lang['googlebu'], $lang['googlebu_d']), "google_username", "", $settings[google_username], 20);
		$form .= $forms->item("password", help($lang['googlebp'], $lang['googlebp_d']), "google_password", "", $settings[google_password], 20);
		$form .= $forms->item("radio", help($lang['transferm'], $lang['transferm_d']), "google_uploadmethod", $forms->farray(array('none','ftp'), array($lang['mbulk'],$lang['autoftp'])), $settings[google_uploadmethod]);
		$form .= $forms->item("submit", "", "", "", $lang['edits']);
		$form .= $forms->end(array('hide' => 'Form'));

		$out = (($status!="")?status($status):"").starttable("545", $lang['fsettings'], $form);
	}

	/////////////////////
	// Quickbooks Settings
	/////////////////////

	if ($_GET[sub] == "quickbooks") {
		$vars[sidetable] .= getsidesubs($startlink, 4, 0);
		$status = urldecode($_GET[status]);

		$form  = $forms->start(array('url' => 'adminindex.php?action=settings&sub=update&type=quickbooks'));
		$form .= $forms->item("textbox", help($lang['exclass'], ''), "qb_account", "", $settings[qb_account], 30);
		$form .= $forms->item("textbox", help($lang['taxacct'], $lang['taxacct_d']), "qb_tax", "", $settings[qb_tax], 30);
		$form .= $forms->item("textbox", help($lang['prodacct'], $lang['prodacct_d']), "qb_products", "", $settings[qb_products], 30);
		$form .= $forms->item("textbox", help($lang['shipacct'], $lang['shipacct_d']), "qb_shipping", "", $settings[qb_shipping], 30);
		$form .= $forms->item("textbox", help($lang['disscacct'], $lang['disscacct_d']), "qb_discount", "", $settings[qb_discount], 30);
		$form .= $forms->item("textbox", help($lang['coupdisc'], $lang['coupdisc_d']), "qb_coupondiscount", "", $settings[qb_coupondiscount], 30);
		$form .= $forms->item("textbox", help($lang['giftcertdisc'], $lang['giftcertdisc_d']), "qb_gcdiscount", "", $settings[qb_gcdiscount], 30);
		$form .= $forms->item("textbox", help($lang['invacct'], $lang['invacct_d']), "qb_inventory", "", $settings[qb_inventory], 30);
		$form .= $forms->item("radio", help($lang['expinv'], ''), "qb_productexport", $forms->farray(array('Y','N'), array($lang['yes'],$lang['no'])), $settings[qb_productexport]);
		$form .= $forms->item("radio", help($lang['expcompl'], $lang['expcompl_d']), "qb_paymentsexport", $forms->farray(array('Y','N'), array($lang['yes'],$lang['no'])), $settings[qb_paymentsexport]);
		$form .= $forms->item("submit", "", "", "", $lang['edits']);
		$form .= $forms->end(array('hide' => 'Form'));

		$out = (($status!="")?status($status):"").starttable("545", $lang['qbsettings'], $form);
	}

	//////////////////
	// Status Meanings
	//////////////////

	if ($_GET[sub] == "statmeanings") {
		$vars[sidetable] = getside($startlink, 3);
		$vars[sidetable] .= getsidesubs($startlink, 3, 3);
		$status = urldecode($_GET[status]);

		$_GET[type] = $_GET[type]==''?2:$_GET[type];

		$form  = $forms->start(array('url' => 'adminindex.php?action=settings&sub=update&type=statmeanings&ptype='.$_GET[type]));
		$form .= $forms->item("dropdown", help('Statuses Considered Pending', ''), "statpending".$_GET[type], $forms->farray(statuslist($_GET[type]), statuslist($_GET[type])), explode('::', $settings['statpending'.$_GET[type]]), '', '', array('multi' => 1));
		$form .= $forms->item("dropdown", help('Statuses Considered Complete', ''), "statcomplete".$_GET[type], $forms->farray(statuslist($_GET[type]), statuslist($_GET[type])), explode('::', $settings['statcomplete'.$_GET[type]]), '', '', array('multi' => 1));
		$form .= $forms->item("dropdown", help('Statuses Considered Failed', ''), "statfailed".$_GET[type], $forms->farray(statuslist($_GET[type]), statuslist($_GET[type])), explode('::', $settings['statfailed'.$_GET[type]]), '', '', array('multi' => 1));
		$form .= $forms->item("submit", "", "", "", $lang['edits']);
		$form .= $forms->end(array('hide' => 'Form'));

		$out = (($status!="")?status($status):"").starttable("545", $lang['statuses'.$_GET[type]], $form);
	}

	////////////////////////////////
	// Manage Areas & Currency Rates
	////////////////////////////////

	if ($_GET[sub] == "areas" || $_GET[sub] == "rates") {
		$vars[sidetable] .= ($_GET[sub]=="areas")?getsidesubs($startlink, 4, 1):"";
		$vars[sidetable] .= ($_GET[sub]=="rates")?getsidesubs($startlink, 4, 3):"";
		$status = urldecode($_GET[status]);

		if ($_GET['do'] == "delete") {
			$DB_site->query("DELETE FROM `".$dbprefix.(($_GET[sub]=="areas")?"state_country":"currency")."` WHERE `id`='".$_GET[id]."'");
			$status = (($_GET[sub]=="areas")?$lang['area']:$lang['crate'])." ".$lang['hdeleted'];
		}

		if ($_GET['do'] == "updaterates") {
			getlatestrates();
			$status = $lang['cupdated'];
		}

		if ($_GET['do'] == "commonrates") {
			getlatestrates(1);
			$status = $lang['cupdated'];
		}

		if ($_GET['do'] == "update") {
			if ($_POST[name] != "") {
				switch ($_GET[sub]) {
					case 'areas':
						$DB_site->query("INSERT INTO `".$dbprefix."state_country` set `name`='".sf($_POST[name])."', `type`='".$_POST[atype]."', `abb`='".sf($_POST[abb])."'");
						$status = (($_GET[sub]=="areas")?$lang['area']:$lang['crate']."")." ".$lang['hadded'].".";
						break;
					case 'rates':
						$DB_site->query("INSERT INTO `".$dbprefix."currency` set `name`='".sf($_POST[name])."', `currency`='".sf($_POST[cur])."', `rate`='".sf($_POST[rate])."'");
						$status = (($_GET[sub]=="areas")?$lang['area']:$lang['crate'])." ".$lang['hadded'].".";
						break;
				}
			}
			if (is_array($_POST[ids])) {
				foreach ($_POST[ids] as $k => $v) {
					switch ($_GET[sub]) {
						case 'areas':
							$DB_site->query("UPDATE `".$dbprefix."state_country` set `name`='".sf($_POST[names][$k])."', `abb`='".sf($_POST[abbs][$k])."' where `id`='".$_POST[ids][$k]."'");
							break;
						case 'rates':
							$DB_site->query("UPDATE `".$dbprefix."currency` set `name`='".sf($_POST[names][$k])."', `currency`='".sf($_POST[curs][$k])."', `rate`='".sf($_POST[rates][$k])."' where `id`='".$_POST[ids][$k]."'");
							break;
					}
				}
				$status = (($_GET[sub]=="areas")?$lang['areas']:$lang['currencyr2'])." ".$lang['hupdated'].".";
			}
		}

		$_GET[orderby]	= ($_GET[orderby]=='')?(($_GET[sub]=="areas")?"type, name":"name"):$_GET[orderby];
		$_GET[sort]		= ($_GET[sort]=='')?'asc':$_GET[sort];
		$_GET[pg] 		= (isset($_GET[pg]) && $_GET[pg] > 0)?intval($_GET[pg]):0;

		switch ($_GET[sub]) {
			case 'areas':
				$arealist = contentstart(array(template('form_toggle_checkbox.html', array('cname' => 'selectall', 'name' => 'item', 'form' => 'addArea')), l($lang['id'],"id"), l($lang['areat'],"type, name"), l($lang['name'],"name"), l($lang['abbr'],"abb"), $lang['action']), array(), array("center","center","left","left","left","center"), "#536da7", 1);
				$query = "SELECT id FROM `".$dbprefix."state_country` ".(($_GET[type]=="")?"":"WHERE `type`='".$_GET[type]."'")." order by ".$_GET[orderby]." ".$_GET[sort]." LIMIT ".((($_GET[pg]==0)?0:$_GET[pg]-1)*50).",50";
				break;
			case 'rates':
				$arealist = contentstart(array(template('form_toggle_checkbox.html', array('cname' => 'selectall', 'name' => 'item', 'form' => 'addRate')), l($lang['id'],"id"), l($lang['name'],"name"), l($lang['currency'],"currency"), l($lang['rate'],"rate"), $lang['action']), array(), array("center","center","left","left","left","center"), "#536da7", 1);
				$query = "SELECT id FROM `".$dbprefix."currency` order by ".$_GET[orderby]." ".$_GET[sort]." LIMIT ".((($_GET[pg]==0)?0:$_GET[pg]-1)*50).",50";
				break;
		}

		$append = preg_replace('/pg=([0-9]*)/', '', (($_GET[pg]=="")?'&amp;':'').htmlentities($_SERVER["QUERY_STRING"]));
		$page = new pager($query, template('list_pages_output.html', array(), 0), 5, 50, $_GET[pg], $append);
		$list[pages] = $page->paginate();

		$results = $DB_site->query($query); $num = 0;
		while ($row = $DB_site->fetch_assoc($results)) {
			switch ($_GET[sub]) {
				case 'areas':
					$area = get('state_country', $row[id]);
					$links = icon(3, "adminindex.php?action=settings&sub=areas&do=delete&id=$row[id]\" onclick=\"return jsconfirm();");
					$ids	= $forms->item("hidden", "", 'ids['.$num.']', "", $area[id], "", "", array('return_item' => 1));
					$two	= $forms->item("textbox", "", 'names['.$num.']', "", $area[name], "45", "", array('return_item' => 1));
					$three	= $forms->item("textbox", "", 'abbs['.$num.']', "", $area[abb], "6", "", array('return_item' => 1));
					switch ($area[type]) {
						case 1: $one = $lang['country']; break; case 2: $one = $lang['state2']; break; case 3: $one = $lang['prov']; break; case 4: $one = $lang['other']; break; case 5: $one = $lang['zip']; break;
					}
					break;
				case 'rates':
					$rate  = get('currency', $row[id]);
					$links = icon(3, "adminindex.php?action=settings&sub=rates&do=delete&id=$row[id]\" onclick=\"return jsconfirm();");
					$ids	= $forms->item("hidden", "", 'ids['.$num.']', "", $rate[id], "", "", array('return_item' => 1));
					$one	= $forms->item("textbox", "", 'names['.$num.']', "", $rate[name], "40", "", array('return_item' => 1));
					$two	= $forms->item("textbox", "", 'curs['.$num.']', "", $rate[currency], "6", "", array('return_item' => 1));
					$three	= $forms->item("textbox", "", 'rates['.$num.']', "", $rate[rate], "6", "", array('return_item' => 1));
					break;
			}
			$arealist .= content(array(template('form_checkbox.html', array('value' => $row[id], 'name' => 'item[]')), $row[id].$ids, $one, $two, $three, $links), array(), array("center","center","left","left","left","center")); $num++;
		}
		$listend = contentend().bulk_action();

		switch ($_GET[sub]) {
			case 'areas':
				$type_drop = $forms->item("dropdown", "", "atype", $forms->farray(array(STATE, PROVINCE, COUNTRY, ZIP), array($lang['state2'], $lang['prov'], $lang['country'], $lang['zip'])), $_GET[type], '', '', array('return_item' => 1, 'style' => 'width: 100%;'));
				$allout = template('add_area.html', array('area_list' => $arealist, 'type_drop' => $type_drop, 'pages' => $list[pages], 'listend' => $listend));
				break;
			case 'rates':
				$allout = template('add_currency.html', array('area_list' => $arealist, 'pages' => $list[pages], 'listend' => $listend));
				break;
		}

		$table1 = starttable("545", ($_GET[sub]=="areas")?$lang['mareas']:$lang['mrates'], $allout, array());

		$out = (($status!="")?status($status):"")."$table1";
	}

	/////////////////////////
	// Manage Meta Data Pages
	///////////////////	/////

	if ($_GET[sub] == "meta") {
		$vars[sidetable] .= getsidesubs($startlink, 4, 7);

		if ($_GET['do'] == "delete") {
			$DB_site->query("DELETE FROM `".$dbprefix.$_GET[type]."pages_meta_data` WHERE `id`='".$_GET[id]."'");
			$status = $lang['cpmeta']." ".$_GET[id]." ".$lang['hdeleted'];
		}

		$_GET[pg] = (isset($_GET[pg]) && $_GET[pg] > 0)?intval($_GET[pg]):0;

		$pagelist = $forms->start(array('name' => 'bulk', 'url' => 'adminindex.php?action=settings&sub=fields&type='.$_GET[type], 'hide' => 'Table'));
		$pagelist .= contentstart(array(template('form_toggle_checkbox.html', array('cname' => 'selectall', 'name' => 'item', 'form' => 'bulk')), $lang['id'], $lang['page'], $lang['metat'], $lang['action']), array(), array("center","center","left","center"), "#536da7", 1);
		$query = "SELECT * FROM `".$dbprefix.$_GET[type]."pages_meta_data` order by `page` asc LIMIT ".((($_GET[pg]==0)?0:$_GET[pg]-1)*50).",50";

		$append = preg_replace('/pg=([0-9]*)/', '', (($_GET[pg]=="")?'&amp;':'').htmlentities($_SERVER["QUERY_STRING"]));
		$page = new pager($query, template('list_pages_output.html', array(), 0), 5, 50, $_GET[pg], $append);
		$list[pages] = $page->paginate();

		$results = $DB_site->query($query); $num = 0;
		while ($row = $DB_site->fetch_assoc($results)) {
			$row = filter_data($row);
			$links = icon(2, "adminindex.php?action=settings&sub=editadd_meta&id=".$row[id])." ".icon(3, "adminindex.php?action=settings&sub=meta&do=delete&id=".$row[id]."\" onclick=\"return jsconfirm();");
			$move = template('move_up_down.html', array('type' => 'pages_meta_data', 'id' => $row[id]));
			$pagelist .= content(array(template('form_checkbox.html', array('value' => $row[id], 'name' => 'item[]')), $row[id], $row[page], $row[meta_title], $links), array(), array("center","center","left","center")); $num++;
		}
		$pagelist .= contentend().bulk_action();
		$pagelist .= $forms->end(array('hide' => 'Table'));

		$table1 = starttable("545", $lang['mmd'], $pagelist, array('style' => (($num<1)?'height: 50px;':'')));
		$out = (($status!="")?status($status):"")."$table1";
	}

	//////////////////////////////
	// View / Edit Pages Meta Data
	//////////////////////////////

    if ($_GET[sub] == "editadd_meta") {
		$vars[sidetable] .= getsidesubs($startlink, 4, 7);

		if ($_GET['do'] == "add" || $_GET['do'] == "edit") {
			$query 	= (($_GET['do']=="edit")?"UPDATE `":"INSERT INTO `").$dbprefix."pages_meta_data` set";
			$result = $DB_site->query("DESCRIBE `".$dbprefix."pages_meta_data`");
			while ($field = $DB_site->fetch_assoc($result)) {
				if (isset($_POST[$field['Field']]))
					$query .= " `".$field['Field']."`='".sf($_POST[$field['Field']])."',";
			}
			$query .= ($_GET['do']=="edit")?" `id`='".$_POST[id]."' where `id`='".$_POST[id]."'":"";
			$query  = ($_GET['do']!="edit")?substr($query, 0, -1):$query;
			$DB_site->query($query);
			$_GET[id] = ($_GET['do']=="edit")?$_POST[id]:$DB_site->insert_id();
			$status = $lang['cpmeta']." ".(($_GET['do']=="edit")?$lang['hupdated'] :$lang['hadded']);
		}

		$info = get('pages_meta_data', (($_POST[id]!="")?$_POST[id]:$_GET[id]));
		$infolist = info_page_list();

		if ($info[id] == "") $do = 'add'; else $do = 'edit';

		$form  = $forms->start(array('url' => 'adminindex.php?action=settings&sub=editadd_meta&do='.$do));
		$form .= ($do=='edit')?$forms->item("hidden", "", "id", "", $info[id]):'';
		$form .= ($do=='add')?$forms->item("dropdown", help($lang['page'], $lang['page_d']), "page", $forms->farray($infolist, $infolist), '', 50):'';
		$form .= ($do=='edit')?$forms->item("show", help($lang['page'], $lang['page_d']), "", "", $info[page], 35):'';
		$form .= $forms->item("textbox", help($lang['metat'], $lang['metakeysdesc']), "meta_title", "", $info[meta_title], 63);
		$form .= $forms->item("textbox", help($lang['metakeys'], $lang['metakeysdesc']), "meta_keywords", "", $info[meta_keywords], 63);
		$form .= $forms->item("textarea", help($lang['metadesc'], $lang['metadescdesc']), "meta_description", "", $info[meta_description], 60, 5);

		$form .= $forms->item("submit", "", "", "", $lang[$do].' '.ucwords($lang['cpdata']));
		$form .= $forms->end();

		$out = (($status!="")?status($status):"").starttable("545", $lang['mmd'], $form);
	}

	///////////////////////
	// Manage Custom Fields
	///////////////////////

	if ($_GET[sub] == "fields") {
		$vars[sidetable] .= getsidesubs($startlink, 4, 4);

		if ($_GET['do'] == "delete") {
			$DB_site->query("DELETE FROM `".$dbprefix.$_GET[type]."_custom_fields` WHERE `id`='".$_GET[id]."'");
			$status = $lang['cfield']." ".$_GET[id]." ".$lang['hdeleted'];
		}

		$_GET[type]		= ($_GET[type]=='')?'orders':$_GET[type];
		$_GET[pg] 		= (isset($_GET[pg]) && $_GET[pg] > 0)?intval($_GET[pg]):0;

		$fieldlist = $forms->start(array('name' => 'bulk', 'url' => 'adminindex.php?action=settings&sub=fields&type='.$_GET[type], 'hide' => 'Table'));
		$fieldlist .= contentstart(array(template('form_toggle_checkbox.html', array('cname' => 'selectall', 'name' => 'item', 'form' => 'bulk')), $lang['id'], $lang['order'], $lang['name'], $lang['type'], $lang['required'], $lang['action']), array(), array("center","center","center","left","center","center"), "#536da7", 1);
		$query = "SELECT * FROM `".$dbprefix.$_GET[type]."_custom_fields` order by `dorder` asc LIMIT ".((($_GET[pg]==0)?0:$_GET[pg]-1)*50).",50";

		$append = preg_replace('/pg=([0-9]*)/', '', (($_GET[pg]=="")?'&amp;':'').htmlentities($_SERVER["QUERY_STRING"]));
		$page = new pager($query, template('list_pages_output.html', array(), 0), 5, 50, $_GET[pg], $append);
		$list[pages] = $page->paginate();

		$results = $DB_site->query($query); $num = 0;
		while ($row = $DB_site->fetch_assoc($results)) {
			$row = filter_data($row);
			$links = icon(2, "adminindex.php?action=settings&sub=editadd_fields&type=".$_GET[type]."&id=".$row[id])." ".icon(3, "adminindex.php?action=settings&sub=fields&type=".$_GET[type]."&do=delete&id=".$row[id]."\" onclick=\"return jsconfirm();");
			$move = template('move_up_down.html', array('type' => $_GET[type].'_custom_fields', 'id' => $row[id], 'extra' => '&ptype='.$_GET[type]));
			$fieldlist .= content(array(template('form_checkbox.html', array('value' => $row[id], 'name' => 'item[]')), $row[id], $move, $row[name], ucfirst(($row[type]=='select')?'dropdown':$row[type]), ucfirst($row[required]), $links), array(), array("center","center","center","left","center","center")); $num++;
		}
		$fieldlist .= contentend().bulk_action();
		$fieldlist .= $forms->end(array('hide' => 'Table'));

		$table1 = starttable("545", $lang['cust'].' '.ucfirst($_GET[type]).' '.$lang['fields'], $fieldlist, array('style' => (($num<1)?'height: 50px;':'')));
		$out = (($status!="")?status($status):"")."$table1";
	}

	////////////////////////////
	// View / Edit Custom Fields
	////////////////////////////

    if ($_GET[sub] == "editadd_fields") {
		$vars[sidetable] .= getsidesubs($startlink, 4, 4);

		if ($_GET['do'] == "add") {
			$DB_site->query("INSERT into `".$dbprefix.$_POST[ftype]."_custom_fields` set `name`='".sf($_POST[name])."', `default`='".sf($_POST['default'])."', `type`='".sf($_POST[type])."', `length`='".sf($_POST[length])."', `required`='".sf($_POST[required])."', `packinglist`='".sf($_POST[packinglist])."', `printorder`='".sf($_POST[printorder])."'");
			$_GET[id] = $DB_site->insert_id();
			$_GET[type] = $_POST[ftype];
		}

		$_GET[type] = ($_GET[type]=='')?'orders':$_GET[type];

		if ($_GET['do'] == "delete") {
			$DB_site->query("DELETE FROM `".$dbprefix.$_GET[type]."_custom_fields_items` where `id`='".$_GET[opid]."'");
			$status = $lang['fodeleted'];
		}

		if ($_GET['do'] == "edit") {
			$DB_site->query("UPDATE `".$dbprefix.$_GET[type]."_custom_fields` set `name`='".sf($_POST[name])."', `default`='".sf($_POST['default'])."', `type`='".sf($_POST[type])."', `length`='".sf($_POST[length])."', `required`='".sf($_POST[required])."', `packinglist`='".sf($_POST[packinglist])."', `printorder`='".sf($_POST[printorder])."' where `id`='".$_POST[id]."'");
			if ($_POST[ivalue] != "") {
				$info = get($_GET[type].'_custom_fields', $_POST[id]);
				if ($info[type] == 'textbox' || $info[type] == 'textarea') {
					$status = $lang['nocitems']."<br />";
				} elseif (sqlcount($_GET[type].'_custom_fields_items', "WHERE `fieldid`='$_POST[id]'") < 1 || $info[type] != 'checkbox') {
					$count = $DB_site->query_first("SELECT `dorder` FROM `".$dbprefix.$_GET[type]."_custom_fields_items` WHERE `fieldid`='".$_POST[id]."' order by `dorder` desc");
					$DB_site->query("INSERT INTO `".$dbprefix.$_GET[type]."_custom_fields_items` set `fieldid`='".$_POST[id]."', `name`='".sf($_POST[iname])."', `value`='".sf($_POST[ivalue])."', `dorder`='".($count[dorder]+10)."'");
					$status = $lang['cfadded']."<br />";
				} else {
					$status = $lang['onecitem']."<br />";
				}
			}
			if (is_array($_POST[ids])) {
				foreach ($_POST[ids] as $k => $v) {
					$DB_site->query("UPDATE `".$dbprefix.$_GET[type]."_custom_fields_items` set `name`='".sf($_POST[names][$k])."', `value`='".sf($_POST[values][$k])."' where `id`='".$_POST[ids][$k]."'");
				}
			}
			$status .= $lang['cfupdated'];
		}

		$info = get($_GET[type].'_custom_fields', (($_POST[id]!="")?$_POST[id]:$_GET[id]));

		if ($info[id] == "") $do = 'add'; else $do = 'edit';

		$start  = $forms->start(array('url' => 'adminindex.php?action=settings&sub=editadd_fields&type='.$_GET[type].'&do='.$do));
		$start .= ($do=='edit')?$forms->item("hidden", "", "id", "", $info[id]):'';
		$start .= ($do=='add')?$forms->item("dropdown", help($lang['type'], $lang['type_d']), "ftype", $forms->farray(array('orders', 'users'), array($lang['cof'], $lang['caf'])), 'orders', 35):'';
		$start .= ($do=='edit')?$forms->item("show", help($lang['type'], $lang['type_d']), "", "", (($_GET[type]=='users')?$lang['caf']:$lang['cof']), 35):'';
		$start .= $forms->item("textbox", help($lang['name'], $lang['name_d']), "name", "", $info[name], 35);
		$start .= $forms->item("textbox", help($lang['default'], $lang['default_d']), "default", "", $info['default'], 35);
		$start .= $forms->item("dropdown", help($lang['type'], $lang['type_d']), "type", $forms->farray(array('select', 'radio', 'checkbox', 'textbox', 'textarea'), array('Dropdown', 'Radio', 'Checkbox', 'Textbox', 'Textarea')), $info[type], 35);
		$start .= ($info[type]=="textarea" || $info[type]=="textbox" || $info[type]=='')?$forms->item("textbox", help($lang['length'], $lang['length_d']), "length", "", $info[length], 5):"";
		$start .= $forms->item("dropdown", help($lang['required'], $lang['required_d']), "required", $forms->farray(array('y', 'n'), array($lang['yes'], $lang['no'])), $info[required], 35);
		$start .= $forms->item("dropdown", help($lang['dcfpl'], $lang['dcfpl_d']), "packinglist", $forms->farray(array('y', 'n'), array($lang['yes'], $lang['no'])), $info[packinglist], 35);
		$start .= $forms->item("dropdown", help($lang['dcfpo'], $lang['dcfpl_d']), "printorder", $forms->farray(array('y', 'n'), array($lang['yes'], $lang['no'])), $info[printorder], 35);
		$start .= $forms->item("submit", "", "", "", $lang[$do].' '.ucwords($lang['cfield']));
		$start .= $forms->end(array('hide' => 'Form'));

		// Custom Field Items
		$form = contentstart(array($lang['id'], $lang['order'], $lang['value'], $lang['action']), array(), array("center","center","left","center"), "#536da7");
		$results = $DB_site->query("SELECT * FROM `".$dbprefix.$_GET[type]."_custom_fields_items` where `fieldid`='".$info[id]."' ORDER by `dorder`"); $num = 0;
		while ($row = $DB_site->fetch_assoc($results)) {
			$row = filter_data($row);
			$hide 	= $forms->item("hidden", "", 'ids['.$num.']', "", $row[id], "", "", array('return_item' => 1));
			$move 	= template('move_up_down.html', array('type' => $_GET[type].'_custom_fields_items', 'id' => $row[id], 'extra' => '&oid='.$info[id]));
			$value 	= $forms->item("textbox", "", 'values['.$num.']', "", $row[value], "41", "", array('return_item' => 1));
			$links  = icon(3, "adminindex.php?action=settings&sub=editadd_fields&amp;type=$_GET[type]&amp;do=delete&amp;id=$info[id]&amp;opid=$row[id]\" onclick=\"return jsconfirm();");
			$form .= content(array($row[id].$hide, $move, $value, $links), array(), array("center","center","left","center"));
			$num++;
		}
		$form .= contentend();
		$form .= $forms->start(array('hide' => 'Form'));
		$form .= $forms->item("submit", "", "", "", $lang[$do].' '.$lang['cfitems']);
		$form .= $forms->end(array('hide' => 'Form'));

		$form .= template('add_field_options_item.html', array());

		if ($do == 'edit') {
			$tab_items .= tab_item($lang['cfitems'], $form);
			$data = $start.start_tabs($tab_items);
		} else {
			$data = $start;
		}

		$out = (($status!="")?status($status):"").starttable("545", $lang['aecfitems'], $data);
	}

	///////////////////
	// Manage Templates
	///////////////////

	if ($_GET[sub] == "templates") {

		$vars[sidetable] .= getsidesubs($startlink, 4, 2);

		if ($_GET['do'] == "add") {
			$theme = $DB_site->query_first("SELECT * from `".$dbprefix."settings` where name='theme'");
			if (file_exists($abs_path."/themes/".$theme[value]."/".$_POST[name])) {
				$msg = $lang['duptemplate'].": ".$_POST[name];
			} else {
				if ($fp = @fopen($abs_path."/themes/".$theme[value]."/".$_POST[name], "w")) {
					@fwrite($fp, $lang['btemplate']);
					@fclose($fp);
					$msg = $lang['template']." ".$_POST["template"]." ".$lang['createds'];
				} else {
					$msg = $lang['cannotf'].": ".$_POST[name];
				}
			}
		}

		$templates = import_templates();
		$temp_list = template_list($templates);

		$content = template("add_template.html", array('temp_list' => $temp_list, 'msg' => $msg));

		$table1 = starttable("545", $lang['mtemplates'], $content, array());

		$out = (($status!="")?status($status):"")."$table1";
	}

	//////////////////
	//Product Templates
	//////////////////

	if ($_GET[sub] == "backup_templates") {
		include $abs_path.'/include/classes/class.zip.php';

		$dir_array = array();
		dir_to_array($abs_path.'/themes/');

		$filename = $abs_path.'/'.ADMIN_DIR.'/backup/'.randompass(10).'_site_templates.zip';

		$ziper = new zipfile();
		$ziper->addFiles($dir_array);
		$ziper->output($filename);

		header("Cache-control: private");
		header("Content-type: application/zip");
		header("Content-transfer-encoding: binary\n");
		header("Content-disposition: attachment; filename=\"".strtolower(str_replace(" ", "_", $settings[title]))."_templates.zip\"");
		header("Content-Length: ".filesize($filename));
		readfile($filename);
		@unlink($filename);
		exit;
	}

	//////////////////
	// Backup Database
	//////////////////

	if ($_GET[sub] == "backup") {
		$vars[sidetable] .= getsidesubs($startlink, 4, 6);

		if ($_GET['do'] == "backup") {
			$dater = date("m-d-Y",time());
			for ($i=0; $i<count($_POST[tables]); $i++) {
				$sqldump .= sqldumpbackup($_POST[tables][$i])."\n\n";
				if ($i == 0) $list = $_POST[tables][$i];
				else $list .= "<br>".$_POST[tables][$i];
			}
			$output  = "<?PHP\n\$version = \"SunShop $ssversion\";\n\$dater = \"$dater\";\nif (\$step == \"\") {\n\n\$message = \"This restore file will restore your database with the data last collected on \$dater.<br><br>The following tables will be erased and re-populated with this data: <br><br><strong>$list</strong><br><br>Click \\\"Perform Restore\\\" to continue with this action.\";\n\n} elseif (\$step == 2) {\n\n";
			$output .= "$sqldump\n\$message = \"The database restore was successfully. Restore file has been deleted from the server.\";\n\n}\n?>";

			$filename = $abs_path.'/'.ADMIN_DIR.'/backup/'.randompass(10).'_'.$_POST[filename];
			$filehandle = fopen($filename, "w");
			fwrite($filehandle, $output);
			fclose($filehandle);

			header("Cache-control: private");
			header("Content-type: text/plain");
			header("Content-disposition: attachment; filename=\"".$_POST[filename]."\"");
			header("Content-Length: ".filesize($filename));
			readfile($filename);
			@unlink($filename);
			exit;
		}

		$backup = array('table' => array(), 'export' => array());

		$result = $DB_site->query("SHOW tables");
		while ($currow = $DB_site->fetch_array($result)) {
			if ($dbprefix != "") {
			    $thepre = explode ("_", $currow[0]);
				if ($thepre[0]."_" == $dbprefix) {
					array_push($backup[table], $currow[0]);
					array_push($backup[export], 1);
				}
			} else {
				array_push($backup[table], $currow[0]);
				array_push($backup[export], 1);
			}
		}

		$form = $forms->start(array('url' => 'adminindex.php?action=settings&sub=backup&do=backup'));
		$form .= $forms->item("textbox", help($lang['filen'], $lang['filen_d']), "filename", "", "sunshop_".date("m_d_Y").".ssbackup", 40);
		$form .= $forms->item("dropdown", help($lang['tables'], $lang['tables_d']), "tables", $forms->farray($backup[table], $backup[table]), $backup[table], "", "", array('style' => 'height: 150px', 'multi' => 1));
		$form .= $forms->item("submit", "", "", "", $lang['backupdb']);
		$form .= $forms->end();

		$table1 = starttable("545", $lang['backupdb'], $form, array());

		$form = $forms->start(array('url' => 'adminindex.php?action=settings&sub=restore" enctype="multipart/form-data'));
		$form .= $forms->item("file", help($lang['importf'], $lang['importf_d']), "backupfile", "", "", 40);
		$form .= $forms->item("submit", "", "", "", $lang['restored']);
		$form .= $forms->end();

		$table2 = starttable("545", $lang['restored'], $form, array());

		$out = (($status!="")?status($status):"")."$table1<br>$table2";
	}

	if ($_GET[sub] == "restore") {
		if ($_GET['do'] == "") {
			$file_name = $_FILES['backupfile']['name'];
		    $file_size = $_FILES['backupfile']['size'];
			$file_type = $_FILES['backupfile']['type'];
			$file_tmp  = $_FILES['backupfile']['tmp_name'];

			file_check(trim($file_name), "restore", $file_type);

			if (@move_uploaded_file($file_tmp, $abs_path.'/'.ADMIN_DIR.'/backup/'.$file_name)) {
			   @chmod($abs_path.'/'.ADMIN_DIR.'/backup/'.$file_name, 0777);
			}

			if (!$fp = fopen($abs_path.'/'.ADMIN_DIR.'/backup/'.$file_name, 'r')) {
				$form = '<font color="#FF0000">'.$lang['unabler'].'</font>';
			} else {
				fclose($fp);
				ob_start();
				$temp = @include $abs_path.'/'.ADMIN_DIR.'/backup/'.$file_name;
				ob_end_clean();
				if ($dater != "" && $message != "") {
					$form  = $forms->start(array('url' => 'adminindex.php?action=settings&sub=restore&do=restore'));
					$form .= $forms->item("hidden", "",  "file_name", "", $file_name);
					$form .= $forms->item("show", "", "", "", $message);
					$form .= $forms->item("submit", "", "", "", $lang['restorep']);
					$form .= $forms->end();
				} else {
				    @unlink($abs_path.'/'.ADMIN_DIR.'/backup/'.$file_name);
					$form = '<font color="#FF0000">'.$lang['invalidr'].'</font>';
				}
			}
		} else {
			$step = 2;
			$temp = include $abs_path.'/'.ADMIN_DIR.'/backup/'.$_POST[file_name];
			@unlink($abs_path.'/'.ADMIN_DIR.'/backup/'.$_POST[file_name]);
			$form = '<font color="#FF0000">'.$message.'</font>';
		}
		$out = starttable("545", $lang['restored'], $form, array());
	}

	////////////////////
	// Optimize Database
	////////////////////

	if ($_GET[sub] == "optimize") {
		$vars[sidetable] .= getsidesubs($startlink, 4, 6);

		$form  = $forms->start(array('hide' => 'Form'));
		$result = $DB_site->query("SHOW tables");
		while ($currow = $DB_site->fetch_array($result)) {
			$out = $DB_site->query_first("REPAIR TABLE ".$currow[0]);
			$form .= $forms->item("show", $lang['repairt']." `$currow[0]`", "", "", '[<strong><font color="'.(($out[Msg_text]=="OK")?'green">':'red">').$out[Msg_text].'</font></strong>]');

			$out = $DB_site->query_first("OPTIMIZE TABLE ".$currow[0]);
			$form .= $forms->item("show", $lang['optable']." `$currow[0]`", "", "", '[<strong><font color="'.(($out[Msg_text]=="OK")?'green">':'red">').$out[Msg_text].'</font></strong>]');
		}
		$form .= $forms->end(array('hide' => 'Form'));

		$out = starttable("545", $lang['optdb'], $form, array());
	}

	////////////////////
	// Cleanout Database
	////////////////////

	if ($_GET[sub] == "clean") {
		$vars[sidetable] .= getsidesubs($startlink, 4, 6);

		$relations = array(
			'categories' => array(
				'table' => 'categories',
				'this' => 'subof',
				'that' => 'id',
				'skip' => '0'
			),
			'coupons_relation' => array(
				'table' => 'coupons',
				'this' => 'couponid',
				'that' => 'id'
			),
			'discounts_relation' => array(
				'table' => 'discounts',
				'this' => 'discountid',
				'that' => 'id'
			),
			'orders_notes' => array(
				'table' => 'orders',
				'this' => 'orderid',
				'that' => 'id'
			),
			'orders_products' => array(
				'table' => 'orders',
				'this' => 'orderid',
				'that' => 'id'
			),
			'orders_tracking' => array(
				'table' => 'orders',
				'this' => 'orderid',
				'that' => 'id'
			),
			'orders_custom_entries' => array(
				'table' => 'orders',
				'this' => 'orderid',
				'that' => 'id'
			),
			'orders_custom_fields_items' => array(
				'table' => 'orders_custom_fields',
				'this' => 'fieldid',
				'that' => 'id'
			),
			'products_attributes' => array(
				'table' => 'products',
				'this' => 'productid',
				'that' => 'id'
			),
			'products_categories' => array(
				'table' => 'products',
				'this' => 'productid',
				'that' => 'id'
			),
			'products_dl_count' => array(
				'table' => 'products',
				'this' => 'productid',
				'that' => 'id'
			),
			'products_dl_count' => array(
				'table' => 'orders',
				'this' => 'orderid',
				'that' => 'id'
			),
			'products_downloads' => array(
				'table' => 'products',
				'this' => 'productid',
				'that' => 'id'
			),
			'products_images' => array(
				'table' => 'products',
				'this' => 'productid',
				'that' => 'id'
			),
			'products_options' => array(
				'table' => 'products',
				'this' => 'productid',
				'that' => 'id'
			),
			'products_options_items' => array(
				'table' => 'products_options',
				'this' => 'optionid',
				'that' => 'id'
			),
			'products_pricing' => array(
				'table' => 'products',
				'this' => 'productid',
				'that' => 'id'
			),
			'products_related' => array(
				'table' => 'products',
				'this' => 'productid',
				'that' => 'id'
			),
			'products_reviews' => array(
				'table' => 'products',
				'this' => 'productid',
				'that' => 'id'
			),
			'ship_table' => array(
				'table' => 'ship_zones',
				'this' => 'zoneid',
				'that' => 'id'
			),
			'ship_zones_relation' => array(
				'table' => 'ship_zones',
				'this' => 'zoneid',
				'that' => 'id'
			),
			'users_registry' => array(
				'table' => 'users',
				'this' => 'userid',
				'that' => 'id'
			),
			'users_wishlist' => array(
				'table' => 'users',
				'this' => 'userid',
				'that' => 'id'
			),
			'users_custom_entries' => array(
				'table' => 'users',
				'this' => 'userid',
				'that' => 'id'
			),
			'users_custom_fields_items' => array(
				'table' => 'users_custom_fields',
				'this' => 'fieldid',
				'that' => 'id'
			),
			'users_saved_carts' => array(
				'table' => 'users',
				'this' => 'userid',
				'that' => 'id',
				'skip' => '0'
			)
		);

		$form  = $forms->start(array('hide' => 'Form'));
		foreach ($relations as $k => $v) {
			$this_deleted = 0;
			$result = $DB_site->query("SELECT * from `".$dbprefix.$k."`");
			while ($currow = $DB_site->fetch_array($result)) {
				if ($currow[$v[this]] != $v[skip] || $v[skip] == '') {
					$match = $DB_site->query_first("SELECT * from `".$dbprefix.$v[table]."` where `".$v[that]."`='".$currow[$v[this]]."'");
					if ($match[id]=='') { $DB_site->query("DELETE from `".$dbprefix.$k."` where `id`='".$currow[id]."'"); $this_deleted++; }
				}
			}
			$form .= $forms->item("show", $lang['cleaning']." `".$k."`", "", "", '[<strong><font color="'.(($this_deleted>0)?'green">'.$lang['cleanin']:'red">'.$lang['skipn']).'</font></strong>]');
			$form .= ($this_deleted>0)?$forms->item("show", "", "", "", $this_deleted.' '.$lang['junkrows']):'';
		}

		$this_deleted = 0;
		$todayMinus90 = date('Y-m-d H:i:s', strtotime('-90 Days'));
		$result = $DB_site->query("SELECT * from `".$dbprefix."users_saved_carts` where `stamp`<'".$todayMinus90."'");
		while ($currow = $DB_site->fetch_array($result)) {
			$DB_site->query("DELETE from `".$dbprefix."users_saved_carts` where `id`='".$currow[id]."'");
			$this_deleted++;
		}
		$form .= $forms->item("show", $lang['cleaning']." `users_saved_carts` > 90 Days", "", "", '[<strong><font color="'.(($this_deleted>0)?'green">'.$lang['cleanin']:'red">'.$lang['skipn']).'</font></strong>]');
		$form .= ($this_deleted>0)?$forms->item("show", "", "", "", $this_deleted.' '.$lang['junkrows']):'';

		$form .= $forms->end(array('hide' => 'Form'));
		$out = starttable("545", $lang['cleanupdb'], $form, array());
	}

	/////////////////////
	// Google Base Export
	/////////////////////

	if ($_GET[sub] == "gbexport") {
		$delim = "\t";
		$sarray = array("\t", "\r", "\n");
		$rarray = array(' ', '', '');
		$end = "\n";

		$impexp = new imp_exp('tab');

		$prods = array (
			array('header' => 'id',					'value' => 'num'),
			array('header' => 'title',				'value' => 'title'),
			array('header' => 'description',		'value' => 'short_desc'),
			array('header' => 'price', 				'value' => 'out_price'),
			array('header' => 'price_type', 		'value' => 'starting'),
			array('header' => 'link', 				'value' => 'link'),
			array('header' => 'image_link', 		'value' => 'image'),
			array('header' => 'quantity', 			'value' => 'in_stock'),
			array('header' => 'upc', 				'value' => 'sku'),
			array('header' => 'pickup', 			'value' => 'pickup')
		);

		foreach ($prods as $v) {
			$header .= $v[header].$delim;
		}

		$impexp->tmp_file = $impexp->rand_name();

		include_once $abs_path.'/include/classes/class.dispatcher.php';
		$html = new html_generator();

		$fp = fopen($impexp->tmp_file, 'w');
		fwrite($fp, substr($header, 0, -1).$end);
		$sql = "SELECT p.`id` AS `id`, c.`title` AS `cat_title`
		FROM `".$dbprefix."products` p
		LEFT JOIN `".$dbprefix."categories` c ON c.id=p.catid
		WHERE p.viewable='y' AND p.avail_to='0'
		ORDER BY p.`id` ASC";
		$result = $DB_site->query($sql);
		while ($row = $DB_site->fetch_assoc($result)) {
			$item = get('products', $row[id]); $line = "";
			foreach ($prods as $v) {
				switch ($v[value]) {
					case 'image':
						$item[image] = ($item[detail_image]!="")?$settings[shopurl].$settings[productpath].$item[detail_image]:"";
						break;
					case 'link':
						$item[link] = ($settings[htmlpages]=="on")?$html->rewrite_link($settings[shopurl]."index.php?l=product_detail&p=".$item[id]):$settings[shopurl]."index.php?l=product_detail&p=".$item[id];
						break;
					case 'payment':
						$methods = $DB_site->query("SELECT * FROM `".$dbprefix."modules_methods` WHERE `internalname`='display_name'");
						while ($module = $DB_site->fetch_assoc($methods)) {
							$enabled = $DB_site->query_first("SELECT value FROM `".$dbprefix."modules_methods` WHERE `internalname`='enabled' AND `module`='".$module[module]."'");
							if ($enabled[value] == 1) $item[payment] .= (($item[payment]!="")?", ":"").$module[value];
						}
						break;
					case 'pickup':
						$enabled = $DB_site->query_first("SELECT value FROM `".$dbprefix."modules_methods` WHERE `internalname`='enabled' AND `module`='local'");
						$item[pickup] = ($enabled[value]==1)?'true':'false';
						break;
				}
				$line .= str_replace($sarray, $rarray, strip_tags(stripslashes(str_replace($sarray,$rarray,$item[$v[value]])))).$delim;
			}
		    fwrite($fp, substr($line, 0, -1).$end);
		}
		fclose($fp);

		if ($settings[google_uploadmethod] == "ftp") {
			if (!extension_loaded("ftp")) {
				$error = 'The FTP functionality requires that FTP be compiled into PHP as an extension. Please contact your hosting provider or use the manual upload function.';
			} else {
				$conn_id = @ftp_connect($settings[google_host]);
				$login_result = @ftp_login($conn_id, $settings[google_username], $settings[google_password]);
				if (!$conn_id) {
					$error = $lang['uconnect'].' "'.$settings[google_host].'"';
				} elseif (!$login_result) {
					$error = $lang['floging'];
				} else {
					@ftp_delete($settings[google_filename]);
					@ftp_pasv($conn_id, false);
					$transfer = @fopen($impexp->tmp_file, "r");
					if (!@ftp_fput($conn_id, $settings[google_filename], $transfer, FTP_ASCII)) {
						@ftp_pasv($conn_id, true);
						if (!@ftp_fput($conn_id, $settings[google_filename], $transfer, FTP_ASCII)) {
							$error = ''.$lang['unableg'].' "'.$settings[google_host].'"';
						} else {
							$error = 'File transfered successfully to "'.$settings[google_host].'"';
						}
					} else {
						$error = 'File transfered successfully to "'.$settings[google_host].'"';
					}
					@fclose($transfer);
				}
			}
			@unlink($impexp->tmp_file);
			header('location: adminindex.php?action=settings&sub=google&status='.urlencode($error));
		} else {
			$impexp->download($settings[google_filename]);
			exit;
		}
	}

	////////////////////////
	// Import / Export Menus
	////////////////////////

	if ($_GET[sub] == "impexp" || $_GET[sub] == "export" || $_GET[sub] == "import") {
		switch ($_GET[type]) {
			case 'users':
				$vars[sidetable] = getside($startlink, 0);
				$vars[sidetable] .= getsidesubs($startlink, 0, 0);
				break;
			case 'admins':
				$vars[sidetable] = getside($startlink, 0);
				$vars[sidetable] .= getsidesubs($startlink, 0, 1);
				break;
			case 'groups':
				$vars[sidetable] = getside($startlink, 0);
				$vars[sidetable] .= getsidesubs($startlink, 0, 2);
				break;
			case 'products':
				$vars[sidetable] = getside($startlink, 1);
				$vars[sidetable] .= getsidesubs($startlink, 1, 0);
				break;
			case 'vendors':
				$vars[sidetable] = getside($startlink, 1);
				$vars[sidetable] .= getsidesubs($startlink, 1, 1);
				break;
			case 'manufacturers':
				$vars[sidetable] = getside($startlink, 1);
				$vars[sidetable] .= getsidesubs($startlink, 1, 2);
				break;
			case 'categories':
				$vars[sidetable] = getside($startlink, 2);
				break;
			case 'orders':
				$vars[sidetable] = getside($startlink, 3);
				break;
			case 'state_country':
				$vars[sidetable] = getside($startlink, 4);
				$vars[sidetable] .= getsidesubs($startlink, 4, 1);
				break;
			case 'currency':
				$vars[sidetable] = getside($startlink, 4);
				$vars[sidetable] .= getsidesubs($startlink, 4, 3);
				break;
			case 'coupons':
				$vars[sidetable] = getside($startlink, 5);
				$vars[sidetable] .= getsidesubs($startlink, 5, 0);
				break;
			case 'discounts':
				$vars[sidetable] = getside($startlink, 5);
				$vars[sidetable] .= getsidesubs($startlink, 5, 1);
				break;
			case 'giftcerts':
				$vars[sidetable] = getside($startlink, 5);
				$vars[sidetable] .= getsidesubs($startlink, 5, 2);
				break;
		}
	}

	//////////////////
	// Import / Export
	//////////////////

	if ($_GET[sub] == "impexp") {
                $backup = array('table' => array(), 'export' => array());

		$result = $DB_site->query("SHOW tables");
		while ($currow = $DB_site->fetch_array($result)) {
			array_push($backup[table], str_replace($dbprefix, '', $currow[0]));
			array_push($backup[export], ucwords(str_replace(array($dbprefix, '_'), array('', ' '), $currow[0])));
		}

		$form  = $forms->start(array('url' => 'adminindex.php?action=settings&sub=export', 'name' => 'export'));
		$form .= $forms->item("textbox", help($lang['filen'], $lang['filen_d']), "filename", "", $_GET[type].".csv");
		$form .= $forms->item("dropdown", help($lang['datas'], $lang['datas_d']), "table", $forms->farray($backup[table], $backup[export]), $_GET[type], '', '', array('onchange' => 'document.forms[\'export\'].elements[\'filename\'].value=this.value+\'.csv\''));
		$form .= $forms->item("dropdown", help($lang['filed'], $lang['filed_d']), "delimiter", $forms->farray(array("comma", "tab", "semi"), array($lang['comma'], $lang['tab'], $lang['semicolon'])), "comma");
		$form .= $forms->item("radio", help($lang['alterf'], $lang['alterf_d']), "alterorder", $forms->farray(array("yes", "no"), array($lang['yes'],$lang['no'])), 'no');
		$form .= $forms->item("submit", "", "", "", $lang['exportd']);
		$form .= $forms->end();

		$table1 = starttable("545", $lang['exportd'], $form, array());

		$form  = $forms->start(array('url' => 'adminindex.php?action=settings&sub=import" enctype="multipart/form-data'));
		$form .= $forms->item("file", help($lang['importf'], $lang['importf_d']), "upload", "", "");
		$form .= $forms->item("dropdown", help($lang['datas'], $lang['datas_d']), "table", $forms->farray($backup[table], $backup[export]), $_GET[type]);
		$form .= $forms->item("dropdown", help($lang['filed'], $lang['filed_d']), "delimiter", $forms->farray(array("comma", "tab", "semi"), array($lang['comma'], $lang['tab'], $lang['semicolon'])), "comma");
		$form .= $forms->item("dropdown", help($lang['importm'], $lang['importm_d']), "method", $forms->farray(array("0", "2", "1"), array($lang['storen'], $lang['storenu'], $lang['deleteci'])), "0");
		$form .= $forms->item("submit", "", "", "", $lang['importd']);
		$form .= $forms->end();

		$table2 = starttable("545", $lang['importd'], $form, array());

		$out = "$table1<br>$table2";
	}

	/////////
	// Export
	/////////

	if ($_GET[sub] == "export") {
		$impexp = new imp_exp($_POST[delimiter]);

		if ($_POST['alterorder'] == "yes") {
			$impexp->fields_parse($_POST['table']);
			$form  = $forms->start(array('url' => 'adminindex.php?action=settings&sub=export&type='.$_GET[type]));
			$form .= $forms->item("hidden", "", "table", "", $_POST[table]);
			$form .= $forms->item("hidden", "", "filename", "", $_POST[filename]);
			$form .= $forms->item("hidden", "", "delimiter", "", $_POST[delimiter]);
			$form .= $forms->item("hidden", "", "process", "", "1");
			for ($i=0; $i<count($impexp->fields); $i++) {
				$form .= $forms->item("dropdown", help($lang['field']." ".($i+1), ""), "order[$i]", $forms->farray($impexp->fields, $impexp->fields), $impexp->fields[$i]);
			}
			$form .= $forms->item("submit", "", "", "", $lang['processe']);
			$form .= $forms->end();

			$table1 = starttable("545", $lang['forder'], $form, array());
		} else {
			$impexp->fields_parse($_POST['table']);
			$order = ($_POST['process'] == 1)?$_POST['order']:$impexp->fields;
			$impexp->export($_POST['table'], $order);
			$impexp->download($_POST['filename']);
		}

		$out = "$table1<br>$table2";
	}

	/////////
	// Import
	/////////

	if ($_GET[sub] == "import") {
		$impexp = new imp_exp($_POST[delimiter]);

		if ($_POST['process'] == 1) {
			$impexp->import($_POST['table'], $_POST['order'], $_POST[method]);
			$table1 = starttable("545", $lang['importc'], $lang['imports']."<br /><br /><br /><br /><br /><br />", array());
		} else {
			$result = $impexp->upload();
			$header = $impexp->process_uploaded();
			array_push($header[numbers], count($header[numbers]));
			array_push($header[names], "");
			if ($result[error] == "") {
				$impexp->fields_parse($_POST['table']);
				$form  = $forms->start(array('url' => 'adminindex.php?action=settings&sub=import&type='.$_GET[type]));
				$form .= $forms->item("hidden", "", "table", "", $_POST[table]);
				$form .= $forms->item("hidden", "", "filename", "", $result[filename]);
				$form .= $forms->item("hidden", "", "delimiter", "", $_POST[delimiter]);
				$form .= $forms->item("hidden", "", "method", "", $_POST[method]);
				$form .= $forms->item("hidden", "", "process", "", "1");
				for ($i=0; $i<count($impexp->fields); $i++) {
					$count = ($header[names][$i]=="")?(count($header[numbers])-1):$i;
					$form .= $forms->item("dropdown", help($lang['field']." ".($i+1), ""), "order[$i]", $forms->farray($header[numbers], $header[names]), $count, '', '', array('follow' => ' => '.strtoupper(str_replace("_", " ", $impexp->fields[$i]))));
				}
				$form .= $forms->item("submit", "", "", "", $lang['pimport']);
				$form .= $forms->end();

				$table1 = starttable("545", $lang['importo'], $form, array());
			} else {
				$table1 = $result[error];
			}
		}
		$out = "$table1<br>$table2";
	}

	////////////////
	// Generate HTML
	////////////////

	if ($_GET[sub] == "html") {
		$status = urldecode($_GET[status]);
		$out .= (($status!="")?status($status):"");

		$form = $forms->start(array('url' => 'adminindex.php?action=settings&sub=update&type=html'));
		$form .= $forms->item("textbox", help($lang['htmld'], $lang['htmld_d']), "html_dir", "", $settings[html_dir], 50);
		$form .= $forms->item("textbox", help($lang['categoryp'], $lang['categoryp_d']), "html_cat", "", $settings[html_cat], 50);
		$form .= $forms->item("textbox", help($lang['productp'], $lang['productp_d']), "html_product", "", $settings[html_product], 50);
		$form .= $forms->item("textbox", help($lang['manufacturerp'], $lang['manufacturerp_d']), "html_manufacturer", "", $settings[html_manufacturer], 50);
		$form .= $forms->item("textbox", help($lang['infop'], $lang['infop_d']), "html_page", "", $settings[html_page], 50);
		$form .= $forms->item("textbox", help($lang['spaced'], $lang['spaced_d']),  "html_space", "", $settings[html_space], 5);
		$form .= $forms->item("radio", help($lang['tolower'], $lang['tolower_d']), "html_tolower", $forms->farray(array('true', 'false'), array($lang['on'], $lang['off'])), $settings[html_tolower]);
		$form .= $forms->item("submit", "", "", "", $lang['edits']);
		$form .= $forms->end();

		$out .= starttable("545", $lang['htmlset'], $form, array());

		$manlist1 = get_data_array('manufacturers', 'id', 'name');
		$manlist2 = get_data_array('manufacturers', 'name', 'name');
		$infolist = info_page_list();

		$form = $forms->start(array('url' => 'adminindex.php?action=generate_html" target="generate_html" onsubmit="window.open(\'\', this.target, \'directories=no,status=no,location=no,menubar=no,toolbar=no,scrollbars=no,resizable=no,width=300,height=200\');'));
		$form .= $forms->item("show", "", "", "", "<div style=\"float: left; font-weight: bold;\">".$lang['hcategories'].":</div><div style=\"float: right;\"><a href=\"javascript:selectall('categories[]', true);\">".$lang['selectall']."</a>&nbsp;&nbsp;&nbsp;<a href=\"javascript:selectall('categories[]', false);\">".$lang['selectno']."</a></div>", 0, 0);
		$form .= $forms->item("catlist", "", "categories", "", array(), "", "", array('multi' => '1', 'style' => 'width: 495px; height: 200px;', 'nonnum' => '1'));
		$form .= $forms->item("show", "", "", "", "<div style=\"float: left; font-weight: bold;\">".$lang['hproducts'].":</div><div style=\"float: right;\"><a href=\"javascript:selectall('products[]', true);\">".$lang['selectall']."</a>&nbsp;&nbsp;&nbsp;<a href=\"javascript:selectall('products[]', false);\">".$lang['selectno']."</a></div>", 0, 0);
		$form .= $forms->item("itemlist", "", "products", "", array(), "", "", array('style' => 'width: 495px; height: 200px;', 'multi' => '1'));
		$form .= $forms->item("show", "", "", "", "<div style=\"float: left; font-weight: bold;\">".$lang['manufacturers'].":</div><div style=\"float: right;\"><a href=\"javascript:selectall('manufacturers[]', true);\">".$lang['selectall']."</a>&nbsp;&nbsp;&nbsp;<a href=\"javascript:selectall('manufacturers[]', false);\">".$lang['selectno']."</a></div>", 0, 0);
		$form .= $forms->item("dropdown", "", "manufacturers", $forms->farray($manlist1, $manlist2), array(), "", "", array('multi' => '1', 'style' => 'width: 495px; height: 200px;'));
		$form .= $forms->item("show", "", "", "", "<div style=\"float: left; font-weight: bold;\">".$lang['infopages'].":</div><div style=\"float: right;\"><a href=\"javascript:selectall('infos[]', true);\">".$lang['selectall']."</a>&nbsp;&nbsp;&nbsp;<a href=\"javascript:selectall('infos[]', false);\">".$lang['selectno']."</a></div>", 0, 0);
		$form .= $forms->item("dropdown", "", "infos", $forms->farray($infolist, $infolist), array(), "", "", array('multi' => '1', 'style' => 'width: 495px; height: 200px;'));
		$form .= $forms->item("submit", "", "", "", $lang['genhtml']);
		$form .= $forms->end();

		$out .= "<br />".starttable("545", $lang['htmlpg'], $form, array());
	}

	//////////////////
	// Generate Sitemap
	//////////////////

	if ($_GET[sub] == "sitemap") {
		$status = urldecode($_GET[status]);
		$out .= (($status!="")?status($status):"");

		$form = $forms->start(array('url' => 'adminindex.php?action=settings&sub=update&type=sitemap'));
		$form .= $forms->item("dropdown", help($lang['smchangefreq'], $lang['smchangefreq_d']), "smchangefreq", $forms->farray(array('always', 'hourly', 'daily', 'weekly', 'monthly', 'yearly', 'never'), array('Always', 'Hourly', 'Daily', 'Weekly', 'Monthly', 'Yearly', 'Never')), $settings[smchangefreq], 50);
		$form .= $forms->item("textbox", help($lang['smcpriority'], $lang['smcpriority_d']), "smcpriority", "", $settings[smcpriority], 4);
		$form .= $forms->item("textbox", help($lang['smppriority'], $lang['smppriority_d']), "smppriority", "", $settings[smppriority], 4);
		$form .= $forms->item("textbox", help($lang['smmpriority'], $lang['smmpriority_d']), "smmpriority", "", $settings[smmpriority], 4);
		$form .= $forms->item("textbox", help($lang['smpapriority'], $lang['smpapriority_d']), "smpapriority", "", $settings[smpapriority], 4);
		$form .= $forms->item("submit", "", "", "", $lang['edits']);
		$form .= $forms->end();

		$out .= starttable("545", $lang['sitemapset'], $form, array());

		$manlist1 = get_data_array('manufacturers', 'id', 'name');
		$manlist2 = get_data_array('manufacturers', 'name', 'name');
		$infolist = info_page_list();

		$form = $forms->start(array('url' => 'adminindex.php?action=settings&sub=sitemap_generator'));
		$form .= $forms->item("show", "", "", "", "<div style=\"float: left; font-weight: bold;\">".$lang['hcategories'].":</div><div style=\"float: right;\"><a href=\"javascript:selectall('categories[]', true);\">".$lang['selectall']."</a>&nbsp;&nbsp;&nbsp;<a href=\"javascript:selectall('categories[]', false);\">".$lang['selectno']."</a></div>", 0, 0);
		$form .= $forms->item("catlist", "", "categories", "", array(), "", "", array('multi' => '1', 'style' => 'width: 495px; height: 200px;', 'nonnum' => '1'));
		$form .= $forms->item("show", "", "", "", "<div style=\"float: left; font-weight: bold;\">".$lang['hproducts'].":</div><div style=\"float: right;\"><a href=\"javascript:selectall('products[]', true);\">".$lang['selectall']."</a>&nbsp;&nbsp;&nbsp;<a href=\"javascript:selectall('products[]', false);\">".$lang['selectno']."</a></div>", 0, 0);
		$form .= $forms->item("itemlist", "", "products", "", array(), "", "", array('style' => 'width: 495px; height: 200px;', 'multi' => '1'));
		$form .= $forms->item("show", "", "", "", "<div style=\"float: left; font-weight: bold;\">".$lang['manufacturers'].":</div><div style=\"float: right;\"><a href=\"javascript:selectall('manufacturers[]', true);\">".$lang['selectall']."</a>&nbsp;&nbsp;&nbsp;<a href=\"javascript:selectall('manufacturers[]', false);\">".$lang['selectno']."</a></div>", 0, 0);
		$form .= $forms->item("dropdown", "", "manufacturers", $forms->farray($manlist1, $manlist2), array(), "", "", array('multi' => '1', 'style' => 'width: 495px; height: 200px;'));
		$form .= $forms->item("show", "", "", "", "<div style=\"float: left; font-weight: bold;\">".$lang['infopages'].":</div><div style=\"float: right;\"><a href=\"javascript:selectall('infos[]', true);\">".$lang['selectall']."</a>&nbsp;&nbsp;&nbsp;<a href=\"javascript:selectall('infos[]', false);\">".$lang['selectno']."</a></div>", 0, 0);
		$form .= $forms->item("dropdown", "", "infos", $forms->farray($infolist, $infolist), array(), "", "", array('multi' => '1', 'style' => 'width: 495px; height: 200px;'));
		$form .= $forms->item("submit", "", "", "", $lang['genhtml']);
		$form .= $forms->end();

		$out .= "<br />".starttable("545", $lang['sitemapent'], $form, array());
	}

	//////////////////////
	// Generate Sitemap  File
	//////////////////////

	if ($_GET[sub] == "sitemap_generator") {

		include_once $abs_path.'/include/classes/class.dispatcher.php';
		$html = new html_generator();

		$xml_out = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" .
			"<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n";

		function xml_url ($url, $priority) {
			global $settings;
			$out  = "\t<url>\n";
			$out .= "\t\t<loc>".xf($url)."</loc>\n";
			$out .= "\t\t<lastmod>".date("Y-m-d", strtotime('Now'))."</lastmod>\n";
			$out .= "\t\t<changefreq>".$settings[smchangefreq]."</changefreq>\n";
			$out .= "\t\t<priority>".$priority."</priority>\n";
			$out .= "\t</url>\n";
			return $out;
		}

		if (is_array($_POST[categories])) {
			foreach ($_POST[categories] as $v) {
				$url = ($settings[htmlpages]=="on")?$html->rewrite_link($settings[shopurl]."index.php?l=product_list&c=".$v):$settings[shopurl]."index.php?l=product_list&c=".$v;
				$xml_out .= xml_url($url, $settings[smcpriority]);
			}
		}

		if (is_array($_POST[products])) {
			foreach ($_POST[products] as $v) {
				$url = ($settings[htmlpages]=="on")?$html->rewrite_link($settings[shopurl]."index.php?l=product_detail&p=".$v):$settings[shopurl]."index.php?l=product_detail&p=".$v;
				$xml_out .= xml_url($url, $settings[smppriority]);
			}
		}

		if (is_array($_POST[manufacturers])) {
			foreach ($_POST[manufacturers] as $v) {
				$url = ($settings[htmlpages]=="on")?$html->rewrite_link($settings[shopurl]."index.php?l=product_list&m=".$v):$settings[shopurl]."index.php?l=product_list&m=".$v;
				$xml_out .= xml_url($url, $settings[smmpriority]);
			}
		}

		if (is_array($_POST[infos])) {
			foreach ($_POST[infos] as $v) {
				$url = ($settings[htmlpages]=="on")?$html->rewrite_link($settings[shopurl]."index.php?l=page_view&p=".$v):$settings[shopurl]."index.php?l=page_view&p=".$v;
				$xml_out .= xml_url($url, $settings[smpapriority]);
			}
		}

		$xml_out .= "</urlset>";

		if ($fp = @fopen($abs_path."/".$settings[html_dir]."/sitemap.xml", "w")) {
			@fwrite($fp, $xml_out);
			@fclose($fp);
			$msg = "$lang[sitemap1]<br /><br />$lang[sitemap2]<br /><br /><div style='background-color: #EFEFEF; padding-left: 5px; padding-right: 5px;'><br />Sitemap: $settings[shopurl]".$settings[html_dir]."/sitemap.xml<br /><br /></div><br />$lang[sitemap3]";
		} else {
			$msg = $lang[sitemap4].'<br /><br /><br />';
		}

		$out .= starttable("545", $lang['sitemapent'], $msg, array());
	}

	//////////////
	// Admin Logout
	//////////////

	if ($_GET[sub] == "logout") {
		$sess->destroy();
		header("location: login.php");
		exit;
	}
}

///////////////////////////////////////////
// Coupons, Discounts and Gift Certificates
///////////////////////////////////////////

elseif ($_GET[action] == "cdg") {

	$vars[sidetable]  = getside($startlink, 5);

	//////////////////////////////////////////////////////////
	// Update & Store Coupons, Discounts and Gift Certificates
	//////////////////////////////////////////////////////////

	if ($_GET[sub] == "update" || $_GET[sub] == "store") {
		$info = ($_GET[type]!="giftcerts")?get($_GET[type], $_POST[id]):"";

		if ($_GET[type]!="giftcerts")
			$DB_site->query("DELETE FROM `".$dbprefix.$_GET[type]."_relation` WHERE `".substr($_GET[type], 0, -1)."id`='".$_POST[id]."'");

		if (is_array($_POST['list'])) {
			foreach ($_POST['list'] as $v) {
				$DB_site->query("INSERT INTO `".$dbprefix.$_GET[type]."_relation` set `".substr($_GET[type], 0, -1)."id`='".$_POST[id]."', `relationid`='".$v."'");
			}
		}

		$_POST[vstart] 	= strtotime($_POST[smonth].'/'.$_POST[sday].'/'.$_POST[syear]);
		$_POST[vend] 	= strtotime($_POST[emonth].'/'.$_POST[eday].'/'.$_POST[eyear]);

		$query 	= (($_GET[sub]=="update")?"UPDATE ":"INSERT INTO ").$dbprefix.(($_GET[type]=="giftcerts")?"gift_certificates":$_GET[type])." set";
		$result = $DB_site->query("DESCRIBE ".$dbprefix.(($_GET[type]=="giftcerts")?"gift_certificates":$_GET[type]));
		while ($field = $DB_site->fetch_assoc($result)) {
			if (isset($_POST[$field['Field']]))
				$query .= " `".$field['Field']."`='".sf($_POST[$field['Field']])."',";
		}
		$query .= ($_GET[sub]=="update")?" `id`='".$_POST[id]."' where `id`='".$_POST[id]."'":"";
		$query  = ($_GET[sub]!="update")?substr($query, 0, -1):$query;
		$DB_site->query($query);

		$id = ($_GET[sub]=="update")?$_POST[id]:$DB_site->insert_id();
		header("location: adminindex.php?action=cdg&sub=view&type=".$_GET[type].'&status='.urlencode($lang['update_s'].$_GET[type]));
		exit;
	}

	///////////////////////////////////////////
	// Coupons, Discounts and Gift Certificates
	///////////////////////////////////////////

	if ($_GET[sub] == "view") {
		$_GET[orderby]	= ($_GET[orderby]=='')?'id':$_GET[orderby];
		$_GET[sort]		= ($_GET[sort]=='')?'asc':$_GET[sort];
		$_GET[pg] 		= (isset($_GET[pg]) && $_GET[pg] > 0)?intval($_GET[pg]):0;
		$type			= $lang[$_GET[type]];
		$status			= urldecode($_GET[status]);

		switch ($_GET[type]) {
			case '':
			case 'coupons':
				$tablestart = contentstart(array(template('form_toggle_checkbox.html', array('cname' => 'selectall', 'name' => 'item', 'form' => 'bulk')), l($lang['id'],"id"), l($lang['code'],"code"), l($lang['value'],"value"), l($lang['type'],"ctype"), l($lang['vdates'],"vstart,vend"), $lang['action']), array(), array("center","center","left","left","center","center","center"), "#536da7", 1);
				$query = "SELECT id FROM `".$dbprefix."coupons` order by ".$_GET[orderby]." ".$_GET[sort]." LIMIT ".((($_GET[pg]==0)?0:$_GET[pg]-1)*50).",50";
				$vars[sidetable] .= getsidesubs($startlink, 5, 0);
				break;
			case 'discounts':
				$tablestart = contentstart(array(template('form_toggle_checkbox.html', array('cname' => 'selectall', 'name' => 'item', 'form' => 'bulk')), l($lang['id'],"id"), l($lang['name'],"name"), l($lang['value'],"value"), l($lang['type'],"ctype"), l($lang['vdates'],"vstart,vend"), $lang['action']), array(), array("center","center","left","left","center","center","center"), "#536da7", 1);
				$query = "SELECT id FROM `".$dbprefix."discounts` order by ".$_GET[orderby]." ".$_GET[sort]." LIMIT ".((($_GET[pg]==0)?0:$_GET[pg]-1)*50).",50";
				$vars[sidetable] .= getsidesubs($startlink, 5, 1);
				break;
			case 'giftcerts':
				$tablestart = contentstart(array(template('form_toggle_checkbox.html', array('cname' => 'selectall', 'name' => 'item', 'form' => 'bulk')), l($lang['id'],"id"), $lang['user'], $lang['purchaser'], l($lang['amount'],"amount"), l($lang['remaining'],"remaining"), $lang['action']), array(), array("center","center","left","left","left","left","center"), "#536da7", 1);
				$query = "SELECT id FROM `".$dbprefix."gift_certificates` order by ".$_GET[orderby]." ".$_GET[sort]." LIMIT ".((($_GET[pg]==0)?0:$_GET[pg]-1)*50).",50";
				$vars[sidetable] .= getsidesubs($startlink, 5, 2);
				break;
		}

		$append = preg_replace('/pg=([0-9]*)/', '', (($_GET[pg]=="")?'&amp;':'').htmlentities($_SERVER["QUERY_STRING"]));
		$page = new pager($query, template('list_pages_output.html', array(), 0), 5, 50, $_GET[pg], $append);
		$list[pages] = $page->paginate();

		$table1content = $list[pages]."<br />";
		$table1content .= $forms->start(array('name' => 'bulk', 'url' => 'adminindex.php?action=cdg&sub=view'.(($_GET[type]!="")?'&type='.$_GET[type]:''), 'hide' => 'Table'));
		$table1content .= $tablestart;

		$results = $DB_site->query($query);
		while ($row = $DB_site->fetch_assoc($results)) {
			switch ($_GET[type]) {
				case '':
				case 'coupons':
					$coup = get('coupons', $row[id]);
					$links = ($admin[manage_coups]==1)?icon(2,"adminindex.php?action=cdg&sub=edit&type=coupons&id=$row[id]").icon(3,"adminindex.php?action=cdg&sub=delete&type=coupons&id=$row[id]\" onclick=\"return jsconfirm();"):'None';
					$table1content .= content(array(template('form_checkbox.html', array('value' => $row[id], 'name' => 'item[]')), $row[id], $coup[code], $coup[value], ($coup[ctype]=='A')?$lang['amount']:(($coup[ctype]=='P')?$lang['perc']:(($coup[ctype]=='S')?$lang['shipp']:$lang['unkn'])), date($settings[datestamp], $coup[vstart]).'-'.date($settings[datestamp], $coup[vend]), $links), array(), array("center","center","left","left","center","center","center"));
					break;
				case 'discounts':
					$disc = get('discounts', $row[id]);
					$links = ($admin[manage_disc]==1)?icon(2,"adminindex.php?action=cdg&sub=edit&type=discounts&id=$row[id]").icon(3,"adminindex.php?action=cdg&sub=delete&type=discounts&id=$row[id]\" onclick=\"return jsconfirm();"):'None';
					$table1content .= content(array(template('form_checkbox.html', array('value' => $row[id], 'name' => 'item[]')), $row[id], $disc[name], $disc[value], ($disc[dtype]=='A')?$lang['amount']:(($disc[dtype]=='P')?$lang['perc']:(($disc[dtype]=='S')?$lang['shipp']:$lang['unkn'])), date($settings[datestamp], $disc[vstart]).'-'.date($settings[datestamp], $disc[vend]), $links), array(), array("center","center","left","left","center","center","center"));
					break;
				case 'giftcerts':
					$cert = get('gift_certificates', $row[id]);
					$links = ($admin[manage_certs]==1)?icon(2,"adminindex.php?action=cdg&sub=edit&type=giftcerts&id=$row[id]").icon(3,"adminindex.php?action=cdg&sub=delete&type=giftcerts&id=$row[id]\" onclick=\"return jsconfirm();"):'None';
					$table1content .= content(array(template('form_checkbox.html', array('value' => $row[id], 'name' => 'item[]')), $row[id], ($cert[userid]==0)?$lang['nassig']:'<a href="adminindex.php?action=users&sub=edit&type=user&id='.$cert[userid].'">'.$cert[userid].'</a>', ($cert[purchaser]==0)?$cert[purchaser_name]:'<a href="adminindex.php?action=users&sub=edit&type=user&id='.$cert[purchaser].'">'.$cert[purchaser].'</a>', p($cert[amount]), p($cert[remaining]), $links), array(), array("center","center","left","left","left","left","center"));
					break;
			}
		}
		$table1content .= contentend();
		$table1content .= bulk_action().$forms->end(array('hide' => 'Table'));
		$table1content .= "<br />".$list[pages];

		$table1 = (($status!="")?status($status):"").starttable("545", $type, $table1content, array('style' => ((3<2)?'height: 50px;':'')));
		$out = "$table1";
	}

	//////////////////////////////////////////////////////
	// Add & Edit Coupons, Discounts and Gift Certificates
	//////////////////////////////////////////////////////

	if ($_GET[sub] == "add" || $_GET[sub] == "edit") {
		$do 	= ($_GET[sub]=="add")?'store':'update';
		$word 	= ($_GET[sub]=="add")?$lang['add']:$lang['edit'];
		$type	= $lang[$_GET[type]];

		$grouplist1 = get_data_array('groups', 'id', 'name');
		$grouplist2	= get_data_array('groups', 'name', 'name');
		array_unshift($grouplist1, 0);
		array_unshift($grouplist2, "All");

		switch ($_GET[type]) {
			case '':
			case 'coupons':
				$info = get('coupons', $_GET[id]);
				$relations = $DB_site->query("SELECT * FROM `".$dbprefix."coupons_relation` WHERE `couponid`='".$info[id]."'");

				$smonth = $forms->item("date", "", "smonth", "month", (($_GET[sub]=="add")?date('n'):date('n', $info[vstart])), "", "", array('return_item' => 1));
				$sday   = $forms->item("date", "", "sday", "day", (($_GET[sub]=="add")?date('j'):date('j', $info[vstart])), "", "", array('return_item' => 1));
				$syear  = $forms->item("date", "", "syear", "year", (($_GET[sub]=="add")?date('Y'):date('Y', $info[vstart])), "", "", array('return_item' => 1));

				$emonth = $forms->item("date", "", "emonth", "month", (($_GET[sub]=="add")?date('n'):date('n', $info[vend])), "", "", array('return_item' => 1));
				$eday   = $forms->item("date", "", "eday", "day", (($_GET[sub]=="add")?date('j'):date('j', $info[vend])), "", "", array('return_item' => 1));
				$eyear  = $forms->item("date", "", "eyear", "year", (($_GET[sub]=="add")?(date('Y')+1):date('Y', $info[vend])), "", "", array('return_item' => 1));

				$data  = $forms->start(array('url' => 'adminindex.php?action=cdg&type=coupons&sub='.$do));
				$data .= ($_GET[sub]=="edit")?$forms->item("hidden", "", "id", "", $info[id]):'';
				$data .= $forms->item("textbox", help($lang['couponn'], $lang['couponn_d']), "name", "", $info[name], 35);
				$data .= $forms->item("textbox", help($lang['couponc'], $lang['couponc_d']), "code", "", $info[code], 35);
				$data .= $forms->item("dropdown", help($lang['discountt'], $lang['discountt_d']), "ctype", $forms->farray(array("A","P","S"), array($lang['dollaramt'],$lang['percent'],$lang['freeship'])), $info[ctype]);
				$data .= $forms->item("dropdown", help($lang['discountap'], $lang['discountap_d']), "dapply", $forms->farray(array("A","O"), array($lang['applyall'], $lang['applyone'])), $info[dapply]);
				$data .= $forms->item("textbox", help($lang['value'], $lang['value_d']), "value", "", p($info[value], false), 4);
				$data .= $forms->item("textbox", help($lang['mino'], $lang['mino_d']), "omin", "", p($info[omin], false), 4);
				$data .= $forms->item("textbox", help($lang['maxu'], $lang['maxu_d']), "max", "", $info[max], 2);
				$data .= ($_GET[sub]=="edit")?$forms->item("textbox", help($lang['currentu'], $lang['currentu_d']), "used", "", $info[used], 2):"";
				$data .= $forms->item("show", help($lang['startd'], $lang['startd_d']), "", "", $smonth.' '.$sday.' '.$syear);
				$data .= $forms->item("show", help($lang['endd'], $lang['endd_d']), "", "", $emonth.' '.$eday.' '.$eyear);
				$data .= $forms->item("dropdown", help($lang['availablet'], $lang['availablet_d']), "avail_to", $forms->farray($grouplist1, $grouplist2), $info[avail_to]);
				$data .= $forms->item("dropdown", help($lang['coupont'], $lang['coupont_d']), "type", $forms->farray(array('G','P','C','U'), array($lang['global'],$lang['prelated'],$lang['crelated'],$lang['urelated'])), $info[type]);
				$data .= $forms->item("radio", help($lang['status'], $lang['status_d']), "status", $forms->farray(array('1','0'), array($lang['on'],$lang['off'])), ($info[status]=='')?'1':$info[status]);
				$data .= $forms->item("submit", "", "", "", "$word $type");
				$data .= $forms->end(array('hide' => 'Form'));

				$vars[sidetable] .= getsidesubs($startlink, 5, 0);

				break;
			case 'discounts':
				$info = get('discounts', $_GET[id]);
				$relations = $DB_site->query("SELECT * FROM `".$dbprefix."discounts_relation` WHERE `discountid`='".$info[id]."'");

				$smonth = $forms->item("date", "", "smonth", "month", (($_GET[sub]=="add")?date('n'):date('n', $info[vstart])), "", "", array('return_item' => 1));
				$sday   = $forms->item("date", "", "sday", "day", (($_GET[sub]=="add")?date('j'):date('j', $info[vstart])), "", "", array('return_item' => 1));
				$syear  = $forms->item("date", "", "syear", "year", (($_GET[sub]=="add")?date('Y'):date('Y', $info[vstart])), "", "", array('return_item' => 1));

				$emonth = $forms->item("date", "", "emonth", "month", (($_GET[sub]=="add")?date('n'):date('n', $info[vend])), "", "", array('return_item' => 1));
				$eday   = $forms->item("date", "", "eday", "day", (($_GET[sub]=="add")?date('j'):date('j', $info[vend])), "", "", array('return_item' => 1));
				$eyear  = $forms->item("date", "", "eyear", "year", (($_GET[sub]=="add")?(date('Y')+1):date('Y', $info[vend])), "", "", array('return_item' => 1));

				$data  = $forms->start(array('url' => 'adminindex.php?action=cdg&type=discounts&sub='.$do));
				$data .= ($_GET[sub]=="edit")?$forms->item("hidden", "", "id", "", $info[id]):'';
				$data .= $forms->item("textbox", help($lang['name'], $lang['name_d']), "name", "", $info[name], 35);
				$data .= $forms->item("dropdown", help($lang['discountt'], $lang['discountt_d']), "dtype", $forms->farray(array("A","P","S"), array($lang['dollaramt'],$lang['percent'],$lang['freeship'])), $info[dtype]);
				$data .= $forms->item("dropdown", help($lang['discountap'], $lang['discountap_d']), "dapply", $forms->farray(array("A","O"), array($lang['applyall'], $lang['applyone'])), $info[dapply]);
				$data .= $forms->item("textbox", help($lang['value'], $lang['value_d']), "value", "", p($info[value], false), 4);
				$data .= $forms->item("textbox", help($lang['mino'], $lang['mino_d']), "omin", "", p($info[omin], false), 4);
				$data .= $forms->item("textbox", help($lang['minp'], $lang['minp_d']), "pmin", "", $info[pmin], 2);
				$data .= $forms->item("textbox", help($lang['maxu'], $lang['maxu_d']), "max", "", $info[max], 2);
				$data .= ($_GET[sub]=="edit")?$forms->item("textbox", help($lang['currentu'], $lang['currentu_d']), "used", "", $info[used], 2):"";
				$data .= $forms->item("show", help($lang['startd'], $lang['startd_d']), "", "", $smonth.' '.$sday.' '.$syear);
				$data .= $forms->item("show", help($lang['endd'], $lang['endd_d']), "", "", $emonth.' '.$eday.' '.$eyear);
				$data .= $forms->item("dropdown", help($lang['availablet'], $lang['availablet_d']), "avail_to", $forms->farray($grouplist1, $grouplist2), $info[avail_to]);
				$data .= $forms->item("dropdown", help($lang['discountt'], $lang['discountt_d']), "type", $forms->farray(array('G','P','C','U'), array($lang['global'],$lang['prelated'],$lang['crelated'],$lang['urelated'])), $info[type]);
				$data .= $forms->item("radio", help($lang['status'], $lang['status_d']), "status", $forms->farray(array('1','0'), array($lang['on'],$lang['off'])), ($info[status]=='')?'1':$info[status]);
				$data .= $forms->item("submit", "", "", "", "$word $type");
				$data .= $forms->end(array('hide' => 'Form'));

				$vars[sidetable] .= getsidesubs($startlink, 5, 1);

				break;
			case 'giftcerts':
				$info 		= get('gift_certificates', $_GET[id]);
				$user 		= get('users', $info[userid]);
				$purchaser 	= get('users', $info[purchaser]);
				$order		= get('orders', $info[orderid]);

				if ($_GET['do'] == "resend") { $gs->resend(array_merge($info, array('cert' => $info[code], 'sender_name' => $info[purchaser_name]))); $status = $lang['giftcsent']; }

				$data  = $forms->start(array('url' => 'adminindex.php?action=cdg&type=giftcerts&sub='.$do));
				$data .= ($_GET[sub]=="edit")?$forms->item("hidden", "", "id", "", $info[id]):'';
				$data .= ($_GET[sub]=="add")?$forms->item("hidden", "", "code", "", $gs->generate()):'';
				$data .= ($_GET[sub]=="edit")?$forms->item("show", help($lang['certificatec'], $lang['certificatec_d']), "", "", $info[code]):"";
				$data .= ($_GET[sub]=="edit" && $info[orderid] != 0)?$forms->item("show", help($lang['orderi'], $lang['orderi_d']), "", "", '<a href="adminindex.php?action=transactions&sub=view&id='.$info[orderid].'">'.$info[orderid].'</a>'):"";
				$data .= ($_GET[sub]=="edit")?$forms->item("show", help($lang['purchasedb'], $lang['purchasedb_d']), "", "", (($info[purchaser]!=0 && $info[purchaser]!='')?$purchaser[bill_last_name].', '.$purchaser[bill_first_name].' [ <a href="adminindex.php?action=users&sub=edit&type=user&id='.$purchaser[id].'">'.$purchaser[id].'</a> ]':$info[purchaser_name])):"";
				$data .= ($_GET[sub]=="edit")?$forms->item("show", help($lang['lastu'], $lang['lastu_d']), "", "", (($info[userid]!=0 && $info[userid]!='')?$user[bill_last_name].', '.$user[bill_first_name].' [ <a href="adminindex.php?action=users&sub=edit&type=user&id='.$user[id].'">'.$user[id].'</a> ]':$lang['nassig'] )):"";
				$data .= $forms->item("textbox", help($lang['purchasern'], $lang['purchasern_d']), "purchaser_name", "", $info[purchaser_name], 30);
				$data .= $forms->item("textbox", help($lang['recipientn'], $lang['recipientn_d']), "recipient_name", "", $info[recipient_name], 30);
				$data .= $forms->item("textbox", help($lang['recipiente'], $lang['recipiente_d']), "recipient_email", "", $info[recipient_email], 50);
				$data .= $forms->item("textarea", help($lang['message'], $lang['message_d']), "message", "", $info[message], 50);
				$data .= $forms->item("textbox", help($lang['amount'], $lang['amount_d']), "amount", "", p($info[amount], false), 4, '', array('lead' => (($settings[cs_pos]=='before')?$settings[cs]:''), 'follow' => (($settings[cs_pos]=='after')?$settings[cs]:'')));
				$data .= $forms->item("textbox", help($lang['remaining'], $lang['remaining_d']), "remaining", "", p($info[remaining], false), 4, '', array('lead' => (($settings[cs_pos]=='before')?$settings[cs]:''), 'follow' => (($settings[cs_pos]=='after')?$settings[cs]:'')));
				$data .= $forms->item("radio", help($lang['status'], $lang['status_d']), "status", $forms->farray(array('1','0'), array($lang['enable'],$lang['disable'])), ($info[status]!="")?$info[status]:'1');
				$data .= $forms->item("submit", "", "", "", "$word $type");
				$data .= ($_GET[sub]=="edit")?$forms->item("show", "", "", "", '<input style="margin-top: 10px;" type="button" value="'.$lang['resendd'].'" onclick="javascript:location.href=\'adminindex.php?action=cdg&sub=edit&type=giftcerts&id='.$_GET[id].'&do=resend\';" />'):"";
				$data .= $forms->end(array('hide' => 'Form'));

				$vars[sidetable] .= getsidesubs($startlink, 5, 2);

				break;
		}

		// Related Items

		$related = array();
		switch ($info[type]) {
			case 'C':
				while ($row = $DB_site->fetch_assoc($relations)) array_push($related, $row[relationid]);
				$relate_list  = $forms->start(array('hide' => 'Form'));
				$relate_list .= $forms->item("catlist", "", "list", "", $related, "", "", array('style' => 'width: 495px; height: 200px;', 'multi' => '1'));
				$relate_list .= $forms->item("show", "", "", "", $lang['selectc_s']);
				$relate_list .= $forms->item("submit", "", "", "", "$word $type");
				$relate_list .= $forms->end();

				$tab_items	= tab_item($lang['catrel'], $relate_list);
				$tab_out	= start_tabs($tab_items);
				$data	   .= $tab_out;
				break;
			case 'P':
				while ($row = $DB_site->fetch_assoc($relations)) array_push($related, $row[relationid]);
				$relate_list  = $forms->start(array('hide' => 'Form'));
				$relate_list .= $forms->item("itemlist", "", "list", "", $related, "", "", array('style' => 'width: 495px; height: 200px;', 'multi' => '1'));
				$relate_list .= $forms->item("show", "", "", "", $lang['selectp_s']);
				$relate_list .= $forms->item("submit", "", "", "", "$word $type");
				$relate_list .= $forms->end();

				$tab_items	= tab_item($lang['prodrel'], $relate_list);
				$tab_out	= start_tabs($tab_items);
				$data	   .= $tab_out;
				break;
			case 'U':
				$userlist1 = get_data_array('users', 'id', 'bill_last_name');
				$userlist2 = get_data_array('users', array('bill_last_name', 'bill_first_name'), 'bill_last_name');

				while ($row = $DB_site->fetch_assoc($relations)) array_push($related, $row[relationid]);
				$relate_list  = $forms->start(array('hide' => 'Form'));
				$relate_list .= $forms->item("dropdown", "", "list", $forms->farray($userlist1, $userlist2), $related, "", "", array('style' => 'width: 495px; height: 200px;', 'multi' => '1'));
				$relate_list .= $forms->item("show", "", "", "", $lang['selectu_s']);
				$relate_list .= $forms->item("submit", "", "", "", "$word $type");
				$relate_list .= $forms->end();

				$tab_items	= tab_item($lang['userel'], $relate_list);
				$tab_out	= start_tabs($tab_items);
				$data	   .= $tab_out;
				break;
		}

		$out = (($status!="")?status($status):"").starttable("545", "$word $type", $data, array());
	}

	/////////
	// Delete
	/////////

	if ($_GET[sub] == "delete") {
		$DB_site->query("DELETE from ".$dbprefix.(($_GET[type]=="giftcerts")?"gift_certificates":$_GET[type])." where id='".$_GET[id]."'");
		header("location: adminindex.php?action=cdg&sub=view&type=".$_GET[type].'&status='.urlencode("Successfully deleted id $_GET[id]."));
		exit;
	}
}

/////////////
// Move Items
/////////////

elseif ($_GET[action] == "move") {
	switch ($_GET[type]) {
		case 'categories':
			$addsql = "WHERE subof='".$_GET[subof]."'";
			$return = 'adminindex.php?action=categories&sub=view&subof='.$_GET[subof];
			break;
		case 'products_options_items':
			$addsql = "WHERE optionid='".$_GET[oid]."'";
			$return = 'adminindex.php?action=products&sub=options&id='.$_GET[oid];
			break;
		case 'products_attributes':
		case 'products_related':
		case 'products_options':
			$addsql = "WHERE productid='".$_GET[pid]."'";
			$return = 'adminindex.php?action=products&sub=edit&id='.$_GET[pid].'&tab='.$_GET[tab];
			break;
		case 'status':
			$addsql = "WHERE type='".$_GET[stype]."'";
			$return = 'adminindex.php?action=transactions&sub=status';
			break;
		case 'manufacturers':
			$addsql = "WHERE 1";
			$return = 'adminindex.php?action=products&sub=manage&type=manufacturers';
			break;
		case 'orders_custom_fields': case 'users_custom_fields':
			$addsql = "WHERE 1";
			$return = 'adminindex.php?action=settings&sub=fields&type='.$_GET[ptype];
			break;
		case 'orders_custom_fields_items':
			$addsql = "WHERE 1";
			$return = 'adminindex.php?action=settings&sub=editadd_fields&type=orders&id='.$_GET[oid];
			break;
		case 'users_custom_fields_items':
			$addsql = "WHERE 1";
			$return = 'adminindex.php?action=settings&sub=editadd_fields&type=users&id='.$_GET[oid];
			break;
	}
	$start = 0;
    $result = $DB_site->query("SELECT * FROM `".$dbprefix.$_GET[type]."` ".$addsql." order by `dorder`");
	$rows	= $DB_site->num_rows($result);
	while($row = $DB_site->fetch_assoc($result)) {
		$DB_site->query("UPDATE `".$dbprefix.$_GET[type]."` set `dorder`='".($start+10)."' where `id`='".$row[id]."'");
		$start = $start+10;
	}
	$move = $DB_site->query_first("SELECT `dorder` FROM `".$dbprefix.$_GET[type]."` ".$addsql." AND `id`='".$_GET[id]."'");
	if ($_GET[move] == "up") {
	    $temp = $move[dorder]-10;
		$halt = ($move[dorder]==1)?1:0;
	} else {
		$temp = $move[dorder]+10;
		$halt = ($move[dorder]==$rows)?1:0;
	}
	if ($halt != 1) {
	    $DB_site->query("UPDATE `".$dbprefix.$_GET[type]."` set `dorder`='".$move[dorder]."' ".$addsql." AND `dorder`='".$temp."'");
		$DB_site->query("UPDATE `".$dbprefix.$_GET[type]."` set `dorder`='".$temp."' ".$addsql." AND `id`='".$_GET[id]."'");
	}
	header('location: '.$return);
	exit;
}

elseif ($_GET[action] != "denied") {
	$out = starttable ("545", $lang['resendd'], $lang['invalidurl'], array('style' => 'height: 50px;'));
}

////////////////
// Access Denied
////////////////

elseif ($_GET[action] == "denied") {
	$out = starttable ("545", $lang['accessd'], $lang['noaccess'], array('style' => 'height: 50px;'));
}

//////////////////////////
// Display Header & Footer
//////////////////////////

echo template('header.html', array_merge(array('sessname' => $sess->name(), 'sessid' => $sess->id(), 'action' => $action, 'logged' => $sess->gvar('adminid'), 'sub' => $sub, 'sidetable' => $vars[sidetable]), head_links($startlink)));
echo $out;
echo template('footer.html', array());

?>