<?php
/*
  include/class.cccheck.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

class cc_check {
	var $cards;
	var $error;
	var $errors = array();
	var $return = array();
	
	function cc_check () {
		global $lang;
		$lango	= $lang['order'];
		
		$this->cards = array (
			array (
				'name' => 'American Express', 
				'length' => '15',
				'prefixes' => '34,37',
				'checkdigit' => true
			),
			array (
				'name' => 'Carte Blanche', 
				'length' => '14', 
				'prefixes' => '300,301,302,303,304,305,36,38',
				'checkdigit' => true
			),
			array (
				'name' => 'Diners Club', 
				'length' => '14',
				'prefixes' => '300,301,302,303,304,305,36,38',
				'checkdigit' => true
			),
			array (
				'name' => 'Discover', 
				'length' => '16', 
				'prefixes' => '6011',
				'checkdigit' => true
			),
			array (
				'name' => 'Enroute', 
				'length' => '15', 
				'prefixes' => '2014,2149',
				'checkdigit' => true
			),
			array (
				'name' => 'JCB', 
				'length' => '15,16', 
				'prefixes' => '3,1800,2131',
				'checkdigit' => true
			),
			array (
				'name' => 'Maestro', 
				'length' => '16', 
				'prefixes' => '5020,6',
				'checkdigit' => true
			),
			array (
				'name' => 'MasterCard', 
				'length' => '16', 
				'prefixes' => '51,52,53,54,55',
				'checkdigit' => true
			),
			array (
				'name' => 'Solo', 
				'length' => '16,18,19', 
				'prefixes' => '6334, 6767',
				'checkdigit' => true
			),
			array (
				'name' => 'Switch', 
				'length' => '16,18,19', 
				'prefixes' => '4903,4905,4911,4936,564182,633110,6333,6759',
				'checkdigit' => true
			),
			array (
				'name' => 'Visa', 
				'length' => '13,16', 
				'prefixes' => '4',
				'checkdigit' => true
			),
			array (
				'name' => 'VisaElectron', 
				'length' => '16', 
				'prefixes' => '417500,4917,4913',
				'checkdigit' => true
			)
		);
		
		$this->errors[0] = $lango['cc_unknown'];
		$this->errors[1] = $lango['cc_empty'];
		$this->errors[2] = $lango['cc_invalid'];
		$this->errors[3] = $lango['cc_length'];
		$this->errors[4] = $lango['cc_expired'];
		$this->errors[5] = $lango['cc_started'];
	}
	
	function check ($cardname, $cardnumber) {
		for ($i=0; $i<sizeof($this->cards); $i++) {
			if (strtolower($cardname) == strtolower($this->cards[$i]['name'])) {
				$cardType = $i;
				break;
			}
		}
		
		if ($cardType == "" && $cardType != 0) {
			$this->error = $this->errors[0];
			return false; 
		}
		
		if (strlen($cardnumber) == 0)  {
			$this->error = $this->errors[1];
			return false; 
		}
		
		$cardNo = ereg_replace("[^0-9]", "", $cardnumber);
		if ($this->cards[$cardType]['checkdigit']) {
			$checksum = 0;
			$mychar = "";
			$j = 1;
			
			for ($i = strlen($cardNo) - 1; $i >= 0; $i--) {
				$calc = $cardNo{$i} * $j;
				if ($calc > 9) {
					$checksum = $checksum + 1;
					$calc = $calc - 10;
				}
				$checksum = $checksum + $calc;
				if ($j ==1) {$j = 2;} else {$j = 1;};
			} 
			
			if ($checksum % 10 != 0) {
				$this->error = $this->errors[2];
				return false; 
			}
		}  
		
		$PrefixValid = false;
		$prefix = split(',', $this->cards[$cardType]['prefixes']);
		for ($i=0; $i<sizeof($prefix); $i++) {
			$exp = '^' . $prefix[$i];
			if (ereg($exp, $cardNo)) {
				$PrefixValid = true;
				break;
			}
		}
		
		if (!$PrefixValid) {
			$this->error = $this->errors[2];
			return false; 
		}
		
		$LengthValid = false;
		$lengths = split(',', $this->cards[$cardType]['length']);
		for ($j=0; $j<sizeof($lengths); $j++) {
			if (strlen($cardNo) == $lengths[$j]) {
				$LengthValid = true;
				break;
			}
		}
		
		if (!$LengthValid) {
			$this->error = $this->errors[3];
			return false; 
		};
		
		return true;
	}
}
?>