<?PHP
/*
  include/class.dispatcher.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

if (!defined('SS_SESSION_START')) { die("Access denied"); }

function js_clean ($in) {
	$out = trim(str_replace(array("  ", "\t", "\r\n", "\r", "\n"), '', $in));
	$out = trim(str_replace("'", "\'", $out));
	return $out;
}

function xout ($xout) {
	header("Content-Type: application/xml");
	echo "<?xml version=\"1.0\"?>\n";
	echo $xout;
}

class products {
	var $datatype;
	
	function products ($data) {
		$this->datatype = $data;
	}
	
	function addImage () {
		$items	= template('images_item.html', array('cnt' => $_GET[addid], 'add' => 'addimages', 'name' => 'thumb', 'display_name' => 'Thumb', 'id' => $_GET['jsid'], 'location' => 'photo-not-available.jpg', 'hide' => array('X')));
		$items .= template('images_item.html', array('cnt' => $_GET[addid], 'add' => 'addimages', 'name' => 'large', 'display_name' => 'Large', 'id' => ($_GET['jsid']+1), 'location' => 'photo-not-available.jpg', 'hide' => array('X')))."<td>&nbsp;</td>";
		$new	= template('images_table.html', array('image_items' => $items));
		header("Content-Type: text/html");
		echo 'fillDIV(\''.js_clean($new).'\', \'add_images\', 1);';
	}
	
	function delImage () {
		global $DB_site, $dbprefix;
		$temp = explode('_', $_GET[divID]); $imgID = $temp[1];
		$DB_site->query("DELETE from `".$dbprefix."products_images` where `id`='".$imgID."'");
		header("Content-Type: text/html");
		echo 'document.getElementById(\'img_'.$imgID.'\').style.display = \'none\';';
	}
	
	function addOption () {
		global $DB_site, $dbprefix;
		$count = $DB_site->query_first("SELECT `dorder` FROM `".$dbprefix."products_options` WHERE `productid`='".$_POST[productid]."' order by `dorder` desc");
		$DB_site->query("INSERT INTO `".$dbprefix."products_options` set 
			`productid`='".$_POST[productid]."',
			`name`='".sf($_POST[name])."',
			`description`='".sf($_POST[desc])."',
			`default`='".sf($_POST[def])."',
			`type`='".sf($_POST[type])."',
			`length`='".sf($_POST[len])."',
			`dorder`='".($count[dorder]+10)."'
		");
		$thisid = $DB_site->insert_id();
		header("Content-Type: text/html");
		echo 'var items = new Array ("name", "desc", "def", "type", "len");';
		echo 'reset_forms(items, \'addOpt\');';
		echo 'if (refresh()) location.href = \'adminindex.php?action=products&sub=edit&id='.$_POST[productid].'&tab=5\';';
	}
	
	function delOption () {
		global $DB_site, $dbprefix;
		$temp = explode('_', $_GET[divID]); $optID = $temp[1];
		$DB_site->query("DELETE from `".$dbprefix."products_options_items` where `id`='".$optID."'");
		$DB_site->query("DELETE from `".$dbprefix."products_options` where `id`='".$optID."'");
		header("Content-Type: text/html");
		echo 'document.getElementById(\'sep_'.$_GET[divID].'\').style.display = \'none\';';
		echo 'document.getElementById(\''.$_GET[divID].'\').style.display = \'none\';';
	}
	
	function addAtt () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO `".$dbprefix."products_attributes` set 
			`productid`='".$_POST[productid]."',
			`name`='".sf($_POST[name])."',
			`value`='".sf($_POST[val])."',
			`dorder`='".(++$count)."'
		");
		$thisid = $DB_site->insert_id();
		header("Content-Type: text/html");
		echo 'var items = new Array ("name", "val");';
		echo 'reset_forms(items, \'addAtt\');';
		echo 'if (refresh()) location.href = \'adminindex.php?action=products&sub=edit&id='.$_POST[productid].'&tab=6\';';
	}
	
	function delAtt () {
		global $DB_site, $dbprefix;
		$temp = explode('_', $_GET[divID]); $attID = $temp[1];
		$DB_site->query("DELETE from `".$dbprefix."products_attributes` where `id`='".$attID."'");
		header("Content-Type: text/html");
		echo 'document.getElementById(\'sep_'.$_GET[divID].'\').style.display = \'none\';';
		echo 'document.getElementById(\''.$_GET[divID].'\').style.display = \'none\';';
	}
	
	function addPri () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO `".$dbprefix."products_pricing` set 
			`groupid`='".$_POST[group]."',
			`productid`='".$_POST[productid]."',
			`quantity`='".sf($_POST[quan])."',
			`retail`='".sf($_POST[retail])."',
			`price`='".sf($_POST[price])."'
		");
		$thisid = $DB_site->insert_id();
		header("Content-Type: text/html");
		echo 'var items = new Array ("quan", "retail", "price", "group");';
		echo 'reset_forms(items, \'addPri\');';
		echo 'if (refresh()) location.href = \'adminindex.php?action=products&sub=edit&id='.$_POST[productid].'&tab=7\';';
	}
	
	function delPri () {
		global $DB_site, $dbprefix;
		$temp = explode('_', $_GET[divID]); $priID = $temp[1];
		$DB_site->query("DELETE from `".$dbprefix."products_pricing` where `id`='".$priID."'");
		header("Content-Type: text/html");
		echo 'document.getElementById(\'sep_'.$_GET[divID].'\').style.display = \'none\';';
		echo 'document.getElementById(\''.$_GET[divID].'\').style.display = \'none\';';
	}
	
	function addDwn () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO `".$dbprefix."products_downloads` set 
			`productid`='".$_POST[productid]."',
			`name`='".sf($_POST[name])."',
			`filename`='".sf($_POST[file])."',
			`description`='".sf($_POST[desc])."'
		");
		$thisid = $DB_site->insert_id();
		header("Content-Type: text/html");
		echo 'var items = new Array ("name", "file", "desc");';
		echo 'reset_forms(items, \'addDwn\');';
		echo 'if (refresh()) location.href = \'adminindex.php?action=products&sub=edit&id='.$_POST[productid].'&tab=8\';';
	}
	
	function delDwn () {
		global $DB_site, $dbprefix;
		$temp = explode('_', $_GET[divID]); $dwnID = $temp[1];
		$DB_site->query("DELETE from `".$dbprefix."products_downloads` where `id`='".$dwnID."'");
		header("Content-Type: text/html");
		echo 'document.getElementById(\'sep_'.$_GET[divID].'\').style.display = \'none\';';
		echo 'document.getElementById(\''.$_GET[divID].'\').style.display = \'none\';';
	}
	
	function cList () {
		global $DB_site, $dbprefix, $forms;
		$info	= get('products_'.$_GET[type].'s', $_GET[opID]);
		$prod	= get('products', $info[productid]);
		$select	= get_data_array('products_'.$_GET[type].'s', 'productid', 'id', "WHERE `name`='".addslashes($info[name])."' AND ".(($_GET[type]=='option')?"`default`='".addslashes($info['default'])."'":"`value`='".addslashes($info['value'])."'"));
		$items	= $forms->item("itemlist", "", "products", "", $select, "380px; height: 100px;", "", array('return_item' => 1, 'multi' => 1, 'catid' => $_POST[cat]));
		header("Content-Type: text/html");
		echo 'fillDIV(\''.js_clean($items).'\', \'itemList\', 0);';
	}
	
	function iList () {
		global $DB_site, $dbprefix, $forms;
		$items = $forms->item("itemlist", "", "items", "", "", "100%", "", array('return_item' => 1, 'catid' => $_GET[catID]));
		header("Content-Type: text/html");
		echo 'fillDIV(\''.js_clean($items).'\', \'itemList\', 0);';
	}
	
	function addRel () {
		global $DB_site, $dbprefix;
		if ($_POST[items] != "") {
			$DB_site->query("INSERT INTO `".$dbprefix."products_related` set
				`productid`='".$_POST[productid]."',
				`relatedto`='".$_POST[items]."',
				`dorder`='".(++$count)."'
			");
			$thisid = $DB_site->insert_id();
			header("Content-Type: text/html");
			echo 'var items = new Array ("items", "cats");';
			echo 'reset_forms(items, \'addRel\');';
			echo 'if (refresh()) location.href = \'adminindex.php?action=products&sub=edit&id='.$_POST[productid].'&tab=9\';';
		}
	}
	
	function delRel () {
		global $DB_site, $dbprefix;
		$temp = explode('_', $_GET[divID]); $relID = $temp[1];
		$DB_site->query("DELETE from `".$dbprefix."products_related` where `id`='".$relID."'");
		header("Content-Type: text/html");
		echo 'document.getElementById(\'sep_'.$_GET[divID].'\').style.display = \'none\';';
		echo 'document.getElementById(\''.$_GET[divID].'\').style.display = \'none\';';
	}
}

class categories {
	var $datatype;
	var $cats;
	var $groups;
	var $links;
	
	function categories ($data) {
		global $forms, $admin;
		
		$grouplist1 = get_data_array('groups', 'id', 'name');
		$grouplist2	= get_data_array('groups', 'name', 'name');
		array_unshift($grouplist1, 0);
		array_unshift($grouplist2, "All");
		
		$this->datatype = $data;
		$this->cats 	= $forms->item("catlist", "", "cats[".$_GET[id]."]", "", "", "", "", array('style' => 'width: 100%;', 'return_item' => 1, 'All' => 1, 'addblank' => '1'));
		$this->groups	= $forms->item("dropdown", "", "groups[".$_GET[id]."]", $forms->farray($grouplist1, $grouplist2), '', '', '', array('return_item' => 1, 'style' => 'width: 100%;'));
		$this->links	= ($admin[manage_cats]==1)?icon(8, "javascript:void(0);\" onclick=\"javascript:add_bulk();").icon(3, "javascript:del_bulk(".$_GET[id].");\" onclick=\"return jsconfirm();").icon(7,"javascript:void(0);\" onclick=\"javascript:clone_bulk(".$_GET[id].");"):'None';
	}
	
	function aBulk () {
		$update_js = 'var form = document.forms[\'saveBulk\'];';
		foreach ($_POST[form][values] as $k => $v) {
			if ($_POST[form][types][$k] == 'select-one') $update_js .= 'form.elements[\''.$_POST[form][names][$k].'\'].selectedIndex = '.$_POST[form][select][$k].';';
			else $update_js .= 'form.elements[\''.$_POST[form][names][$k].'\'].value = \''.$_POST[form][values][$k].'\';';
		}
		
		$addIt	= template('add_bulk_categories_item.html', array('cats' => $this->cats, 'groups' => $this->groups, 'links' => $this->links, 'id' => $_GET[id]));
		header("Content-Type: text/html");
		echo 'fillDIV(\''.js_clean($addIt).'\', \'main_tables\', 1);';
		echo $update_js;
	}
	
	function cBulk () {
		$update_js  = 'var form = document.forms[\'saveBulk\'];';
		foreach ($_POST[form][values] as $k => $v) {
			if ($_POST[form][types][$k] == 'select-one') $update_js .= 'form.elements[\''.$_POST[form][names][$k].'\'].selectedIndex = '.$_POST[form][select][$k].';';
			else $update_js .= 'form.elements[\''.$_POST[form][names][$k].'\'].value = \''.$_POST[form][values][$k].'\';';
		}
		$update_js .= 'form.elements[\'cats['.$_GET[id].']\'].selectedIndex = '.$_POST[cat].';';
		$update_js .= 'form.elements[\'groups['.$_GET[id].']\'].selectedIndex = '.$_POST[group].';';
		$update_js .= 'form.elements[\'names['.$_GET[id].']\'].value = \''.$_POST[name].'\';';
		
		$addIt	= template('add_bulk_categories_item.html', array('cats' => $this->cats, 'groups' => $this->groups, 'links' => $this->links, 'id' => $_GET[id]));
		header("Content-Type: text/html");
		echo 'fillDIV(\''.js_clean($addIt).'\', \'main_tables\', 1);';
		echo $update_js;
	}
}

class orders {
	var $datatype;
	
	function orders ($data) {
		$this->datatype = $data;
	}
	
	function xmlperms () {
		xout(template('xml_login_failed.xml', array(), 1, $abs_path.'/include/classes/xml/'));
		exit;
	}
	
	function out ($data) {
		return trim(stripslashes(strip_tags($data)));
	}
	
	function ordersOut () {
		global $DB_site, $dbprefix;
		$_GET[u] = ($_GET[u]=="")?$_POST[u]:$_GET[u];
		$_GET[p] = ($_GET[p]=="")?$_POST[p]:$_GET[p];
		
		$admin = checkadmin($_GET[u], md5($_GET[p]), 1);
		
		if ($admin == false || $admin[manage_trans] != 1) {
			$this->xmlPerms();
		} else {
			$headers = array();
			$result = $DB_site->query("DESCRIBE `".$dbprefix."orders`");
			while ($field = $DB_site->fetch_assoc($result)) {
				array_push($headers, $field['Field']);
			}
			
			$count = 1;
			$xml = "<?xml version=\"1.0\"?>\r\n<ss>\r\n<Orders>\r\n";
			$result = $DB_site->query("SELECT * from  `".$dbprefix."orders` where `xml_export`='0'");
			while ($row = $DB_site->fetch_assoc($result)) {
				$xml .= "\t<Order>\r\n";
				for ($i=0; $i<count($headers); $i++) {
					$xml .= "\t\t<$headers[$i]>".$this->out($row[$headers[$i]])."</$headers[$i]>\r\n";
				}
				
				$xml .= "\t\t<Items>\r\n";
				$results = $DB_site->query("SELECT * FROM `".$dbprefix."orders_products` where `orderid`='".$row[id]."' ORDER by `id`");
				while ($irow = $DB_site->fetch_assoc($results)) {
					$xml .= "\t\t\t<Item>\r\n";
					$irow  = filter_data($irow);
					$prod = unserialize(base64_decode($irow[item]));
					$item = new orderitem ($irow[data]);
					$xml .= "\t\t\t\t<id>".$this->out($prod[num])."</id>\r\n\t\t\t\t<title>".$this->out(str_replace('&', 'and', $prod[title]))."</title>\r\n\t\t\t\t<price>".$this->out($irow[price]+$item->options_price_increase())."</price>\r\n\t\t\t\t<quantity>".$this->out($item->get_quantity())."</quantity>\r\n\t\t\t\t<options>".$this->out($item->display_options())."</options>\r\n";
					$xml .= "\t\t\t</Item>\r\n";
				}
				$xml .= "\t\t</Items>\r\n";
				
				$xml .= "\t</Order>\r\n";
				$count++;
			}
			$xml .= "</Orders>\r\n</ss>\r\n";
		}
		header("Content-Type: application/xml");
		echo $xml;
	}
	
	function ordersUpdate () {
		global $DB_site, $dbprefix;
		$_GET[u] = ($_GET[u]=="")?$_POST[u]:$_GET[u];
		$_GET[p] = ($_GET[p]=="")?$_POST[p]:$_GET[p];
		
		$admin = checkadmin($_GET[u], md5($_GET[p]), 1);
		
		if ($admin == false || $admin[manage_trans] != 1) {
			$this->xmlPerms();
		} else {
			$xml_in = parse_xml($_POST[xml], array('order'));
			foreach($xml_in[update][order] as $k => $v) {
				$DB_site->query("UPDATE `".$dbprefix."orders` set `xml_export`='1' where `id`='".$v[id]."'");
			}
			if (count($xml_in[update][order]) < 1) {
				$xml = '<result><error>Please pass at least one valid order id.</error></result>';
			} else {
				$xml = '<result><message>Order updated sucessfully.</message></result>';
			}
		}
		header("Content-Type: application/xml");
		echo $xml;
	}
}

class iphone {
	var $datatype;
	
	function iphone ($data) {
		$this->datatype = $data;
	}
	
	function xmlperms () {
		xout(template('xml_login_failed.xml', array(), 1, $abs_path.'/include/classes/xml/'));
		exit;
	}
	
	function out ($data) {
		return trim(stripslashes(strip_tags($data)));
	}
	
	function summary () {
		global $DB_site, $dbprefix;
		$data = array(); $methods = array();
		$summary = array(); $summary[totalorders] = 0;
		$summary[totalsales] = p(0.00, false);
		$total_orders = 0;
		for ($j=($_GET[days]!=""?$_GET[days]:2); $j>=0; $j--) {
			$thisdate = date("Y-m-d", mktime(0, 0, 0, date("m"), (date("d")-$j), date("Y")));
			$data[$thisdate] = array();
			$data[$thisdate][title] = date("D m/d", strtotime($thisdate));
			$data[$thisdate][totalorders] = 0;
			$data[$thisdate][totalsales] = p(0.00, false);
			$results = $DB_site->query("SELECT `pay_method`, `total`, `order_date` FROM `".$dbprefix."orders` where `order_date`='".$thisdate."' order by `order_date`");
			while ($row = $DB_site->fetch_assoc($results)) {
				$this_method = $row[pay_method];
				$data[$thisdate][totalorders]++;
				$data[$thisdate][totalsales] = p($data[$thisdate][totalsales]+$row[total], false);
				$summary[totalsales] = p($summary[totalsales]+$row[total], false);
				if (!is_numeric($methods[$this_method])) $methods[$this_method] = 1;
				else $methods[$this_method]++;
				$total_orders++;
				$summary[totalorders]++;
			}
		}
		
		foreach ($data as $k => $v) {
			$v['date'] = $k;
			$v[totalsales] = p($v[totalsales], true, true);
			$summary[days] .= template('xml_summary_day.xml', $v, 1, $abs_path.'/include/classes/xml/');
		}
		
		foreach ($methods as $k => $v) {
			$proccess[title] = $k;
			$proccess[percentage] = number_format((($v/$summary[totalorders])*100), 2);
			$proccess[totalorders] = $v;
			$summary[processors] .= template('xml_summary_processor.xml', $proccess, 1, $abs_path.'/include/classes/xml/');
		}
		
		$summary[totalsales] = p($summary[totalsales], true, true);
		xout(template('xml_summary.xml', $summary, 1, $abs_path.'/include/classes/xml/'));
	}
	
	function statuses () {
		global $DB_site, $dbprefix;

		$result[totalstatuses] = 1;
		$result[statuses] = template('xml_statuses_status.xml', array('name' => 'All'), 1, $abs_path.'/include/classes/xml/');
		$results = $DB_site->query("SELECT * from  `".$dbprefix."status` where `type`='2' ORDER by `dorder` asc");
		while ($row = $DB_site->fetch_assoc($results)) {
			$result[totalstatuses]++;
			$result[statuses] .= template('xml_statuses_status.xml', $row, 1, $abs_path.'/include/classes/xml/');
		}
		
		xout(template('xml_statuses.xml', $result, 1, $abs_path.'/include/classes/xml/'));
	}
	
	function search () {
		global $DB_site, $dbprefix;
		
		$search = "SELECT * from  `".$dbprefix."orders` where `id`>'0' ";
		$search .= ($_POST[id]!="")?"AND `id`='".$_POST['id']."' ":"";
		$search .= ($_POST[email]!="")?"AND `email` like '%".$_POST['email']."%' ":"";
		$search .= ($_POST[status]!="All")?"AND `status`='".$_POST['status']."' ":"";
		
		switch ($_POST[range]) {
			case 'today':
				$search .= "AND `order_date`='".date('Y').'-'.date('m').'-'.date('d')."' ";
			break;
			case 'yesterday':
				$search .= "AND `order_date`='".date("Y-m-d", mktime(0, 0, 0, date("m"), (date("d")-1), date("Y")))."' ";
			break;
			case 'thismonth':
				$search .= "AND `order_stamp`>='".mktime(0, 0, 0, date('m'), 1, date('Y'))."' AND `order_stamp`<='".mktime(23, 59, 59, date("m")+1, 0, date("Y"))."' ";
			break;
			case 'date':
				$search .= "AND `order_stamp`>='".mktime(0, 0, 0, $_POST[smonth], $_POST[sday], $_POST[syear])."' AND `order_stamp`<='".mktime(23, 59, 59, $_POST[emonth], $_POST[eday], $_POST[eyear])."' ";
			break;
		}
		
		$search .= "ORDER by `id` desc";
				
		$result[totalorders] = 0;
		$results = $DB_site->query($search);
		while ($row = $DB_site->fetch_assoc($results)) {
			$result[totalorders]++;
			$result[totalsales] = p($row[total]+$result[totalsales], false);
			$row[total] = p($row[total], true, true);
			$result[orders] .= template('xml_search_order.xml', $row, 1, $abs_path.'/include/classes/xml/');
		}
		
		$result[totalsales] = p($result[totalsales], true, true);
		xout(template('xml_search.xml', $result, 1, $abs_path.'/include/classes/xml/'));
	}
	
	function order () {
		global $DB_site, $dbprefix, $settings;
		
		$headers = array();
		$results = $DB_site->query("DESCRIBE `".$dbprefix."orders`");
		while ($field = $DB_site->fetch_assoc($results)) {
			array_push($headers, $field['Field']);
		}
		
		$price = array('subtotal', 'discount', 'coupon_savings', 'ship_price', 'tax', 'gift_cert_savings', 'total');
		
		$order = $DB_site->query_first("SELECT * from  `".$dbprefix."orders` where `id`='$_GET[id]'");
		for ($i=0; $i<count($headers); $i++) {
			$out[name]	= $this->out($headers[$i]);
			$out[value]	= $this->out(($order[$headers[$i]]=="")?'N/A':$order[$headers[$i]]);
			$out[value] = (in_array($out[name], $price))?p($out[value], true, true):$out[value];
			$result[data] .= ($out[name]!='cc_card_no')?template('xml_order_out_field.xml', $out, 1, $abs_path.'/include/classes/xml/'):'';
		}
		
		$results = $DB_site->query("SELECT * FROM `".$dbprefix."orders_products` where `orderid`='$_GET[id]' ORDER by `id`");
		while ($irow = $DB_site->fetch_assoc($results)) {
			$irow  = filter_data($irow);
			$prod = unserialize(base64_decode($irow[item]));
			$item = new orderitem ($irow[data]);
			$options = $item->display_options_together();
			$result[items] .= "<item>\r\n";
			$result[items] .= "<id>".$this->out($prod[num])."</id>";
			$result[items] .= "<title>".$this->out($prod[title])."</title>";
			$result[items] .= "<price>".p($this->out($irow[price]+$item->options_price_increase()), true, true)."</price>";
			$result[items] .= "<quantity>".$this->out($item->get_quantity())."</quantity>";
			$result[items] .= "<options>".(($options=='')?'None':$options)."</options>";
			$result[items] .= "</item>";
		}
		
		$results = $DB_site->query("SELECT * FROM `".$dbprefix."orders_notes` where `orderid`='$_GET[id]' ORDER by `id`");
		while ($nrow = $DB_site->fetch_assoc($results)) {
			$nrow = filter_data($nrow);
			$result[notes] .= "<note>\r\n";
			$result[notes] .= "<id>".$this->out($nrow[id])."</id>";
			$result[notes] .= "<date>".$this->out(date($settings[datestamp].' '.$settings[timestamp], $nrow[datestamp]))."</date>";
			$result[notes] .= "<addedby>".$this->out($nrow[addedby])."</addedby>";
			$result[notes] .= "<message>".$this->out($nrow[note])."</message>";
			$result[notes] .= "</note>";
		}
		
		xout(template('xml_order_out.xml', $result, 1, $abs_path.'/include/classes/xml/'));
	}
	
	function login () {
		$_GET[u] = ($_GET[u]=="")?$_POST[u]:$_GET[u];
		$_GET[p] = ($_GET[p]=="")?$_POST[p]:$_GET[p];
		$admin = checkadmin($_GET[u], $_GET[p], 1);
		if ($admin == false || $admin[manage_trans] != 1) $this->xmlperms();
	}
}

class shipping {
	var $datatype;
	
	function shipping ($data) {
		$this->datatype = $data;
	}
	
	function addShip () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO `".$dbprefix."ship_table` set
			`zoneid`='".$_POST[zone_id]."',
			`from_value`='".sf($_POST[from_value])."',
			`to_value`='".sf($_POST[to_value])."',
			`price`='".sf($_POST[price])."'
		");
		$thisid = $DB_site->insert_id();
		header("Content-Type: text/html");
		echo 'location.href = \'adminindex.php?action=settings&sub=shipping&zone_id='.$_POST[zone_id].'&tab=3\';';
	}
}

class settings {
	var $datatype;
	
	function settings ($data) {
		$this->datatype = $data;
	}
	
	function areaSet () {
		global $DB_site, $dbprefix, $forms, $settings;
		$array = array('none', 'country', 'state', 'state', 'none', 'zip');
		$list1 = get_data_array('state_country', 'abb',  'name', 'WHERE type=\''.$_GET[type].'\'');
		$list2 = get_data_array('state_country', 'name',  'name', 'WHERE type=\''.$_GET[type].'\'');
		$items = $forms->item("dropdown", "", "area", $forms->farray($list1, $list2), $settings[$array[$_GET[type]]], "", "", array('return_item' => 1, 'style' => 'width: 100%;'));
		header("Content-Type: text/html");
		echo 'fillDIV(\''.js_clean($items).'\', \'areas\', 0);';
	}
}

class templates {
	var $datatype;
	
	function templates ($data) {
		$this->datatype = $data;
	}
	
	function get () {
		global $DB_site, $dbprefix, $abs_path;
		ob_start();
		$theme = $DB_site->query_first("SELECT * from `".$dbprefix."settings` where `name`='theme'");
		readfile($abs_path."/themes/".$theme[value]."/".$_POST[template]);
		$content = stripslashes(ob_get_contents());
		ob_end_clean();
		echo $content;
	}
	
	function save () {
		global $DB_site, $dbprefix, $abs_path;
		$theme = $DB_site->query_first("SELECT * from `".$dbprefix."settings` where `name`='theme'");
		if ($fp = @fopen($abs_path."/themes/".$theme[value]."/".$_POST[template], "w")) {
			@fwrite($fp, stripslashes($_POST["content"]));
			@fclose($fp);
			echo "Template ".$_POST["template"]." saved successfully!";
		} else {
			echo "Cannot write to file: ".$_POST["template"];
		}
	}
	
	function delete () {
		global $DB_site, $dbprefix, $abs_path;
		header("Content-Type: text/html");
		$theme = $DB_site->query_first("SELECT * from `".$dbprefix."settings` where `name`='theme'");
		if (!@unlink($abs_path."/themes/".$theme[value]."/".$_POST[template])) {
			echo "var e = document.getElementById(\"msg\");";
			echo "e.innerHTML = \"Unable to delete ".$_POST["template"]."\";";
		} else {
			echo "location.href = 'adminindex.php?action=settings&sub=templates&deleted=1'";
		}
	}
}

class newsletter {
	var $datatype;
	
	function newsletter ($data) {
		$this->datatype = $data;
	}
	
	function send () {
		global $DB_site, $dbprefix, $settings, $abs_path;
		$emails = array(); $i=0;
		
		$result = $DB_site->query("SELECT email FROM `".$dbprefix."newsletters_recipients` LIMIT 0,".intval($_POST['burstamount']));
		while ($row = $DB_site->fetch_assoc($result)) {
			if ($settings[mail_method] != "smtp") mail_send($row[email], $row[email], base64_decode($_POST[subject]), base64_decode($_POST[message]), base64_decode($_POST[from_email]), base64_decode($_POST[from_email]), base64_decode($_POST[mode]));
			$emails[++$i] = $row[email];
		}
		if ($settings[mail_method] == "smtp") mail_send($emails, $emails, base64_decode($_POST[subject]), base64_decode($_POST[message]), base64_decode($_POST[from_email]), base64_decode($_POST[from_email]), base64_decode($_POST[mode]));
		
		if ($i > 0) $DB_site->query("DELETE FROM `".$dbprefix."newsletters_recipients` WHERE email IN ('".join("','", $emails)."')");
		
		$remainaing = $DB_site->query_first("SELECT COUNT(*) AS amount FROM `".$dbprefix."newsletters_recipients`");
		
		echo "{ sent:'".$i."', remaining:'".$remainaing[amount]."' }";
	}
}

class order_data {
	var $datatype;
	
	function order_data ($data) {
		$this->datatype = $data;
	}
	
	function data () {
		global $settings, $DB_site, $dbprefix;
		header("Content-Type: text/html");
		$order = get('orders', sanitize($_POST[id]));
		
		$order[date] = date($settings[datestamp], $order[order_stamp]);
		$order[time] = date($settings[timestamp], $order[order_stamp]);
		
		$order[hide] = array();
		$hides = array('userid', 'bill_company_name', 'bill_address2', 'ship_company_name', 'ship_address2');
		foreach ($hides as $k => $v) {
			if ($order[$v] == "") array_push($order[hide], $hides[$k]);
		}
		
		$price = array('subtotal', 'discount', 'coupon_savings', 'ship_price', 'tax', 'gift_cert_savings', 'rewards_savings', 'total');
		foreach ($price as $k => $v) {
			$order[$v] = p($order[$v]);
			if (p(0) == $order[$v]) array_push($order[hide], $v);
		}
		
		$count = 1;
		$results = $DB_site->query("SELECT * FROM `".$dbprefix."orders_products` where `orderid`='".$_POST[id]."' ORDER by `id`");
		while ($row = $DB_site->fetch_assoc($results)) {
			$prod = unserialize(base64_decode($row[item]));
			$item = new orderitem ($row[data]);
			
			$prod[count] 	= $count;
			$prod[hide] 	= array();
			$prod[options] 	= $item->display_options();
			$prod[quantity] = $item->get_quantity();
			$prod[price] 	= $row[price]+$item->options_price_increase();
			$prod[ptotal] 	= ($prod[quantity] * ($row[price]+$item->options_price_increase()));
			
			$price = array('price', 'ptotal');
			foreach ($price as $k => $v) $prod[$v] = p($prod[$v]);
			
			array_push($prod[hide], 'num_barcode');
			
			$order[items] .= template('packing_list_item.html', $prod);
			$count++;
		}
		
		$out = template('transaction_quick_view.html', $order);
		echo "fillDIV('".js_clean($out)."', 'data_".$_POST[id]."', 0);";
	}
	
}

class html_generator {
	var $datatype;
	
	function html_generator ($data='js') {
		$this->datatype = $data;
	}
	
	function crawl_page ($post_url, $post_str) {
		$parse = parse_url($post_url);
		$result = "";
		$header_passed = false;
		
		$fp = fsockopen($parse['host'], ($parse['port']=='')?80:$parse['port'], $errno, $errstr, 30);
		if (!$fp) return array("", "");
		else {
			fputs ($fp, "GET $post_url?$post_str HTTP/1.0\r\n");
			fputs ($fp, "Host: ".$parse['host']."\r\n");
			fputs ($fp, "User-Agent: Mozilla/5.0 [en]\r\n");
			fputs ($fp,"\r\n");
			
			$http_header	= array();
			$http_header["ERROR"] = chop(fgets($fp,4096));
			
			while (!feof($fp)) {
				if (!$header_passed) $line = fgets($fp, 4096);
				else $result .= fread($fp, 65536);
				
				if ($header_passed == false && ($line == "\n" || $line == "\r\n")) {
					$header_passed = true;
					continue;
				}
				
				if ($header_passed == false) {
					$header_line = explode(": ", $line, 2);
					$header_line[0] = strtoupper($header_line[0]);
					$http_header[$header_line[0]] = chop($header_line[1]);
				}
			}
			fclose($fp);
		}
		return array($http_header, $result);
	}
	
	function rewrite_link ($link_in) {
		global $DB_site, $dbprefix, $settings;
		$link = parse_url(str_replace("&amp;", "&", $link_in));
		if ($link[query] != "") {
			$qarray = query_array($link[query]);
			switch ($qarray[l]) {
				case 'page_view':
					$filename = str_replace(array('{page_name}'), array($qarray[p]), $settings[html_page]);
					$new_link = $settings[shopurl].(($settings[html_dir]!='')?$settings[html_dir].'/':'').$this->format_title((($settings[html_tolower]=='true')?strtolower($filename):$filename));
					break;
				case 'product_detail':
					$product = get('products', $qarray[p]);
					$category = get('categories', $product[catid]);
					$filename = str_replace(array('{category_name}', '{product_name}', '{product_id}'), array($this->format_cat($category[title]), $this->format_title($product[title]), $this->format_title($product[id])), $settings[html_product]);
					$new_link = $settings[shopurl].(($settings[html_dir]!='')?$settings[html_dir].'/':'').(($settings[html_tolower]=='true')?strtolower($filename):$filename);
					break;
				case 'product_list':
					if ($qarray[m] != "") {
						$manufacturer = get('manufacturers', $qarray[m]);
						$filename = str_replace(array('{manufacturer_name}', '{manufacturer_id}', '{page}'), array($manufacturer[name], $manufacturer[id], (($qarray[pg]=="")?1:$qarray[pg])), $settings[html_manufacturer]);
					} else {
						$category = get('categories', $qarray[c]);
						$filename = str_replace(array('{category_name}', '{category_id}', '{page}'), array($category[title], $category[id], (($qarray[pg]=="")?1:$qarray[pg])), $settings[html_cat]);
					}
					$new_link = $settings[shopurl].(($settings[html_dir]!='')?$settings[html_dir].'/':'').$this->format_title((($settings[html_tolower]=='true')?strtolower($filename):$filename));
					break;
				default:
					$new_link = $link_in;
					break;
			}
		} else {
			$new_link = $link_in;
		}
		return $new_link;
	}
	
	function reformat ($match) {
		global $settings;
		return "<a".$match[1]."href=\"".$this->rewrite_link($match[2])."\"".$match[3].">";
	}
	
	function reformat2 ($match) {
		global $settings;
		return "<option value=\"".str_replace(array($settings[shopurl], $settings[secureurl]), array('', ''), $this->rewrite_link($match[1]))."\">";
	}
	
	function reformat3 ($match) {
		global $settings;
		return "<input type=\"button\"".$match[1]."onclick=\"javascript: location.href='".$this->rewrite_link($match[2])."'\"".$match[3].">";
	}
	
	function parse_code ($txt) {
		global $DB_site, $dbprefix, $settings;
		$txt = preg_replace_callback("/\<a(.*?)href\s*=\s*['|\"|\s*](.*?)['|\"|>](.*?)\>/", array($this, 'reformat'), $txt);
		$txt = preg_replace_callback("/\<option value\s*=\s*['|\"|\s*](.*?)['|\"|>]\>/", array($this, 'reformat2'), $txt);
		$txt = preg_replace_callback("/\<input type=\"button\"(.*?)onclick=\"javascript: location.href\s*=\s*['|\"|\s*](.*?)['|\"|>];\"(.*?)\>/", array($this, 'reformat3'), $txt);
		return $txt;
	}
	
	function format_title ($in) {
		global $settings;
		preg_match_all('/[a-zA-Z0-9-.'.$settings[html_space].']/', str_replace(array("_", " ", "&amp;", "&quot;", "&"), array("-", $settings[html_space], "and", "", "and"), $in), $matches);
		for ($i=0; $i<count($matches[0]); $i++) $new_name .= $matches[0][$i];
		return $new_name;
	}
	
	function format_cat ($in) {
		global $settings;
		preg_match_all('/[a-zA-Z0-9-.\/'.$settings[html_space].']/', str_replace(array("_", " ", "&amp;", "&quot;", "&"), array("-", $settings[html_space], "and", "", "and"), $in), $matches);
		for ($i=0; $i<count($matches[0]); $i++) $new_name .= $matches[0][$i];
		return $new_name;
	}
	
	function write_file ($name, $content) {
		global $abs_path, $settings;
		$file = $abs_path.'/'.(($settings[html_dir]!='')?$settings[html_dir].'/':'').$name;
		@unlink($file);
		$fp = fopen ($file, "w");
		fwrite($fp, stripslashes(stripslashes($content)));
		fclose ($fp);
	}
	
	function start_generation () {
		global $DB_site, $dbprefix, $settings, $abs_path;
		$result = $DB_site->query("SELECT * FROM `".$dbprefix."generate_html` LIMIT 0,".intval($_POST['burstamount']));
		while ($row = $DB_site->fetch_assoc($result)) {
			switch ($row[type]) {
				case 'pages':
					$crawl = $this->crawl_page($settings[shopurl], 'l=page_view&p='.$row[gen_id].'&setbase=1');
					$filename = str_replace(array('{page_name}'), array($row[gen_id]), $settings[html_page]);
					$this->write_file($this->format_title((($settings[html_tolower]=='true')?strtolower($filename):$filename)), $this->parse_code($crawl[1])); $generated++;
					$DB_site->query("DELETE FROM `".$dbprefix."generate_html` where `id`='".$row[id]."'");
					break;
				case 'products':
					$product = get('products', $row[gen_id]);
					$category = get('categories', $product[catid]);
					$crawl = $this->crawl_page($settings[shopurl], 'l=product_detail&p='.$row[gen_id].'&setbase=1');
					$filename = str_replace(array('{category_name}', '{product_name}', '{product_id}'), array($this->format_cat($category[title]), $this->format_title($product[title]), $this->format_title($product[id])), $settings[html_product]);
					$check_dirs = explode('/', (($settings[html_tolower]=='true')?strtolower($filename):$filename));
					for ($i=0; $i<(count($check_dirs)-1); $i++) {
						if (!is_dir($abs_path.'/'.(($settings[html_dir]!='')?$settings[html_dir].'/':'').$check_dirs[$i])) {
							mkdir($abs_path.'/'.(($settings[html_dir]!='')?$settings[html_dir].'/':'').$check_dirs[$i]);
						}
					}
					$this->write_file((($settings[html_tolower]=='true')?strtolower($filename):$filename), $this->parse_code($crawl[1])); $generated++;
					$DB_site->query("DELETE FROM `".$dbprefix."generate_html` where `id`='".$row[id]."'");
					break;
				case 'categories':
					if (is_numeric($row[gen_id])) {
						$query = "SELECT p.`id` FROM `".$dbprefix."products` p
							INNER JOIN (
								SELECT p.`id` AS pid
								FROM `".$dbprefix."products` p
								LEFT JOIN `".$dbprefix."categories` c ON c.`id`=p.`catid`
								WHERE p.`catid`='".$row[gen_id]."'
								UNION SELECT `productid` AS pid
								FROM `".$dbprefix."products_categories` pc
								LEFT JOIN `".$dbprefix."categories` c ON c.`id`=pc.`catid`
								WHERE pc.`catid`='".$row[gen_id]."'
							) prods ON prods.`pid`=p.`id` WHERE p.`viewable`='y'";
					} else {
						switch ($row[gen_id]) {
							case 'bestsellers':
								$query = "SELECT p.`id` FROM `".$dbprefix."products` p WHERE title<>'' AND p.`viewable`='y' LIMIT $settings[itemsperpage]";
								break;
							case 'new':
								$query = "SELECT p.`id` FROM `".$dbprefix."products` p WHERE p.`is_new`='y' AND p.`viewable`='y'";
								break;
							case 'specials':
								$query = "SELECT p.`id` FROM `".$dbprefix."products` p WHERE p.`sale_price`>'0' AND p.`viewable`='y'";
								break;
							case 'featured':
								$query = "SELECT p.`id` FROM `".$dbprefix."products` p WHERE p.`is_featured`='y' AND p.`viewable`='y'";
								break;
						}
					}
					$results = $DB_site->query($query);
					$count = $DB_site->num_rows($results);
					$num = ($count==0)?1:ceil(($count/$settings[itemsperpage]));
					for ($i=1; $i<=$num; $i++) {
						$category = get('categories', $row[gen_id]);
						$crawl = $this->crawl_page($settings[shopurl], 'pg='.$i.'&l=product_list&c='.$row[gen_id].'&setbase=1');
						$filename = str_replace(array('{category_name}', '{category_id}', '{page}'), array($category[title], $category[id], $i), $settings[html_cat]);
						$this->write_file($this->format_title((($settings[html_tolower]=='true')?strtolower($filename):$filename)), $this->parse_code($crawl[1])); $generated++;
					}
					$DB_site->query("DELETE FROM `".$dbprefix."generate_html` where `id`='".$row[id]."'");
					break;
				case 'manufacturers':
					$query = "SELECT p.id FROM `".$dbprefix."products` p 
					LEFT JOIN `".$dbprefix."manufacturers` pm ON p.`manufacturer` = pm.`id` 
					WHERE pm.`id`='".$row[gen_id]."'";
					$results = $DB_site->query($query);
					$count = $DB_site->num_rows($results);
					$num = ($count==0)?1:ceil(($count/$settings[itemsperpage]));
					for ($i=1; $i<=$num; $i++) {
						$manufacturer = get('manufacturers', $row[gen_id]);
						$crawl = $this->crawl_page($settings[shopurl], 'pg='.$i.'&l=product_list&m='.$row[gen_id].'&setbase=1');
						$filename = str_replace(array('{manufacturer_name}', '{manufacturer_id}', '{page}'), array($manufacturer[name], $manufacturer[id], $i), $settings[html_manufacturer]);
						$this->write_file($this->format_title((($settings[html_tolower]=='true')?strtolower($filename):$filename)), $this->parse_code($crawl[1])); $generated++;
					}
					$DB_site->query("DELETE FROM `".$dbprefix."generate_html` where `id`='".$row[id]."'");
					break;
				default:
					break;
			}
		}
		
		echo "{ generated:'".$generated."' }";
	}
}

class dispatch {
	var $mode = '';
	var $datatype = 'xml';
	var $handler = NULL;
	
	function dispatch () {
		return;
	}
	
	function setDatatype ($data='xml') {
		$this->datatype = $data;
	}
	
	function setMode ($mode='_oout') {
		$this->mode = $mode;
	}
	
	function sendResponse () {
		switch ($this->mode) {
			case '_isum':
				$this->handler = new iphone($this->datatype);
				$this->handler->login();
				$this->handler->summary();
				break;
			case '_isrch':
				$this->handler = new iphone($this->datatype);
				$this->handler->login();
				$this->handler->search();
				break;
			case '_ists':
				$this->handler = new iphone($this->datatype);
				$this->handler->login();
				$this->handler->statuses();
				break;
			case '_iord':
				$this->handler = new iphone($this->datatype);
				$this->handler->login();
				$this->handler->order();
				break;
			case '_addimg':
				$this->handler = new products($this->datatype);
				$this->handler->addImage();
				break;
			case '_delimg':
				$this->handler = new products($this->datatype);
				$this->handler->delImage();
				break;
			case '_addopt':
				$this->handler = new products($this->datatype);
				$this->handler->addOption();
				break;
			case '_delopt':
				$this->handler = new products($this->datatype);
				$this->handler->delOption();
				break;
			case '_addatt':
				$this->handler = new products($this->datatype);
				$this->handler->addAtt();
				break;
			case '_delatt':
				$this->handler = new products($this->datatype);
				$this->handler->delAtt();
				break;
			case '_addpri':
				$this->handler = new products($this->datatype);
				$this->handler->addPri();
				break;
			case '_delpri':
				$this->handler = new products($this->datatype);
				$this->handler->delPri();
				break;
			case '_adddwn':
				$this->handler = new products($this->datatype);
				$this->handler->addDwn();
				break;
			case '_deldwn':
				$this->handler = new products($this->datatype);
				$this->handler->delDwn();
				break;
			case '_addrel':
				$this->handler = new products($this->datatype);
				$this->handler->addRel();
				break;
			case '_delrel':
				$this->handler = new products($this->datatype);
				$this->handler->delRel();
				break;
			case '_ilist':
				$this->handler = new products($this->datatype);
				$this->handler->iList();
				break;
			case '_clist':
				$this->handler = new products($this->datatype);
				$this->handler->cList();
				break;
			case '_abulk':
				$this->handler = new categories($this->datatype);
				$this->handler->aBulk();
				break;
			case '_cbulk':
				$this->handler = new categories($this->datatype);
				$this->handler->cBulk();
				break;
			case '_oout':
				$this->handler = new orders($this->datatype);
				$this->handler->ordersOut();
				break;
			case '_oupd':
				$this->handler = new orders($this->datatype);
				$this->handler->ordersUpdate();
				break;
			case '_adds':
				$this->handler = new shipping($this->datatype);
				$this->handler->addShip();
				break;
			case '_aset':
				$this->handler = new settings($this->datatype);
				$this->handler->areaSet();
				break;
			case '_gettemp':
				$this->handler = new templates($this->datatype);
				$this->handler->get();
				break;
			case '_savetemp':
				$this->handler = new templates($this->datatype);
				$this->handler->save();
				break;
			case '_deltemp':
				$this->handler = new templates($this->datatype);
				$this->handler->delete();
				break;
			case '_newsletter':
				$this->handler = new newsletter($this->datatype);
				$this->handler->send();
				break;
			case '_htmlgenerator':
				$this->handler = new html_generator($this->datatype);
				$this->handler->start_generation();
				break;
			case '_orderdata':
				$this->handler = new order_data($this->datatype);
				$this->handler->data();
				break;
			default:
				echo 'Unrecognized mode!';
				exit;
		}
		$this->handler = NULL;
	}
}
?>