<?PHP
/*
  include/class.giftcerts.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

class gift_certs {
	var $cert_update = 0;
	
	function gift_certs () {
		return;
	}
	
	function info () {
		$data = array (
			'title' 			=> 'Gift Certificate',
			'sku'				=> 'gift_cert',
			'num'				=> 'gift_cert',
			'charge_shipping' 	=> 'n',
			'charge_tax'		=> 'n',
			'price'				=> '0',
			'thumb_image' 		=> '../gift_certs.jpg',
			'in_stock'			=> '9999'
		);
		return $data;
	}
	
	function cert_array ($item) {
		$data = array (
			'sender_name' 		=> $item->sender_name,
			'recipient_name' 	=> $item->recipient_name,
			'recipient_email' 	=> $item->recipient_email,
			'message' 			=> $item->message,
			'amount' 			=> $item->price,
			'cert' 				=> $item->cert
		);
		return $data;
	}
	
	function check_code () {
		global $settings, $DB_site, $dbprefix, $orderinfo, $lang, $ae;
		$gift_cert = sanitize($_POST[order][giftcert]);
		$cert = $DB_site->query_first("SELECT `id` FROM `".$dbprefix."gift_certificates` WHERE `code`='".$gift_cert."' AND `status`='1' AND `remaining`>'0'");
		if ($cert[id] == "" && $gift_cert != "") {
			$ae->new_error($lang['order']['inv_cert']);
			header('location: '.$settings[secureurl].'checkout.php?l=details');
			exit;
		}
		$orderinfo[gift_cert] = $gift_cert;
	}
	
	function update_remaining ($orderinfo) {
		global $settings, $DB_site, $dbprefix, $sess;
		$cert = $DB_site->query_first("SELECT `remaining` FROM `".$dbprefix."gift_certificates` WHERE `code`='".$orderinfo[gift_cert]."'");
		$DB_site->query("UPDATE `".$dbprefix."gift_certificates` set `remaining`='".(p($cert[remaining], false)-p($orderinfo[gift_cert_savings], false))."', `userid`='".$sess->gvar("userid")."' WHERE `code`='".$orderinfo[gift_cert]."'");
	}
	
	function process_code ($total) {
		global $settings, $DB_site, $dbprefix, $orderinfo;
		$gift_cert = sanitize($orderinfo[gift_cert]);
		$cert = $DB_site->query_first("SELECT * FROM `".$dbprefix."gift_certificates` WHERE `code`='".$gift_cert."' AND `status`='1'");
		if ($cert[id] == "") return 0;
		$extra = ($total - $cert[remaining]);
		if ($extra > 0) return $cert[remaining];
		else return ($extra + $cert[remaining]);
	}
	
	function generate ($length=15) {
		global $DB_site, $dbprefix;
		$all = explode("-", "A-B-C-D-E-F-G-H-I-J-K-L-M-N-O-Q-R-S-T-U-V-W-X-Y-Z-1-2-3-4-5-6-7-8-9-0");
		$keeptrying = 1;
		while ($keeptrying >= 1) {
			$cert = '';
			for ($i=1; $i<=$length; $i++) { 
				srand((double)microtime()*1000000); 
				$randy = rand(0, 35); 
				$cert .= $all[$randy];
			}
			$exists = $DB_site->query_first("SELECT `id` FROM `".$dbprefix."gift_certificates` WHERE `code`='".$cert."'");
			if ($exists[id] == "") $keeptrying = 0;
		}
	    return $cert; 
	}
	
	function check_data () {
		global $settings, $cart, $sess, $lang, $ae;
		foreach ($_POST[gift] as $k => $v) $gift[$k] = strip_tags($v);
		
		if ($gift[from] == "" || $gift[to] == "" || $gift[to_email] == "" || $gift[message] == "") $ae->new_error($lang['gift_certificates']['req']);
		if (!check_email_address($gift[to_email])) $ae->new_error($lang['gift_certificates']['email']);
		if (p($gift[amount], false) < p($settings[giftcerts_min], false)) $ae->new_error($lang['gift_certificates']['vmin']);
		
		if (!$ae->is_errors()) {
			$prod = $this->info();
			$data = array (
				'gs' 				=> 1, 
				'sender_name' 		=> $gift[from],
				'recipient_name' 	=> $gift[to],
				'recipient_email' 	=> $gift[to_email],
				'message' 			=> $gift[message],
				'amount' 			=> $gift[amount]
			);
			$cart->additem('gs', 1, $data);
			$sess->svar('cart', $cart);
			$ae->new_alert('"'.$prod[title].'"'.$lang['product_list']['addedd']);
			header("location: ".$settings[shopurl]."index.php?".(($settings[addtocart]=='goback')?substr(get_previous(), 1):'l=cart_view'));
		} else {
			header("location: ".$settings[shopurl]."index.php?l=page_view&p=gift_certificates");
		}
		exit;
	}
	
	function send ($cert) {
		global $DB_site, $settings, $lang;
		$email = template('email_gift_certificate.html', array('cert' => $cert, 'lang' => $lang['order'], 'hide' => $hide));
		mail_send($cert[recipient_email], $cert[recipient_name], $cert[sender_name].$lang['order']['email_certificate_subject'], $email, $settings[contactemail], $settings[title], true);
	}
	
	function resend ($cert) {
		global $DB_site, $abs_path, $settings;
		$success = @include($abs_path."/lang/".$settings[language]);
		$email = template_client('email_gift_certificate.html', array('cert' => $cert, 'lang' => $lang['order'], 'hide' => $hide));
		mail_send($cert[recipient_email], $cert[recipient_name], $cert[sender_name].$lang['order']['email_certificate_subject'], $email, $settings[contactemail], $settings[title], true);
	}
}
?>