<?PHP
/*
  include/class.importer.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

if (!defined('SS_SESSION_START')) { die("Access denied"); }

class imp_exp {
	var $delim;
	var $sarray;
	var $rarray;
	var $end = "\n";
	var $fields = array();
	var $tmp_file;
	var $tmp_upload;
	
	function imp_exp ($delim='comma') {
		switch ($delim) {
			case 'comma':
				$this->delim = ',';
				$this->sarray = array(',', "\r", "\n");
				$this->rarray = array('&#44;', '&return&', '&newline&');
				break;
			case 'tab':
				$this->delim = "\t";
				$this->sarray = array("\t", "\r", "\n");
				$this->rarray = array('&tab&', '&return&', '&newline&');
				break;
			case 'semi':
				$this->delim = ';';
				$this->sarray = array(';', "\r", "\n");
				$this->rarray = array('&semi&', '&return&', '&newline&');
				break;
		}
	}
	
	function rand_name () {
		global $abs_path;
		$rand_name = str_replace('\\', '/', $abs_path).'/'.ADMIN_DIR.'/backup/tmp_'.rand(10000, 100000);
		if (@file_exists($rand_name)) @unlink($rand_name);
		return $rand_name;
	}
	
	function fields_parse ($table) {
		global $DB_site, $dbprefix;
		$result = $DB_site->query("DESCRIBE `".$dbprefix.$table."`");
		while ($field = $DB_site->fetch_assoc($result)) {
			array_push($this->fields, $field['Field']);
		}
	}
	
	function download ($filename) {
		header("Cache-Control: private");
	    header("Content-Type: text/plain");
		header("Content-Transfer-Encoding: quoted-printable");
		header("Content-Disposition: attachment; filename=\"$filename\"");
		header("Content-Length: ".filesize($this->tmp_file));
		readfile($this->tmp_file);
		@unlink($this->tmp_file);
		exit;
	}
	
	function export ($table, $order) {
		global $DB_site, $dbprefix;
		$this->tmp_file = $this->rand_name();
		
		$heading_f = array('_', 'id');
		$heading_t = array(' ', '_id');
		foreach ($order as $k => $v) {
			$header .= strtoupper(str_replace($heading_f, $heading_t, $order[$k])).$this->delim;
		}
		
		$fp = @fopen($this->tmp_file, 'w');
		fwrite($fp, substr($header, 0, -1).$this->end);
		$result = $DB_site->query("SELECT * FROM `".$dbprefix.$table."` ORDER by `id`");
		while ($row = $DB_site->fetch_assoc($result)) {
			$line = "";
			foreach ($order as $k => $v) {
				$line .= str_replace($this->sarray, $this->rarray, $row[$order[$k]]).$this->delim;
			}
		    fwrite($fp, substr($line, 0, -1).$this->end);
		}
		fclose($fp);
	}
	
	function upload () {
		$this->tmp_upload = $this->rand_name();
		
		$file_name=$_FILES['upload']['name'];
	    $file_size=$_FILES['upload']['size'];
		$file_type=$_FILES['upload']['type'];
		$file_tmpn=$_FILES['upload']['tmp_name'];
		$file_type=$_FILES['upload']['type'];
		
		file_check($file_name, "import", $file_type);
		
		if (@file_exists($this->tmp_upload)) @unlink($this->tmp_upload);
		
		if (!move_uploaded_file($file_tmpn, $this->tmp_upload)) {
			$resp[error] = "Could not upload import file.<br>";
			$resp[filename] = '';
		} else {
			@chmod($this->tmp_upload, 0777);
			$resp[filename] = $this->tmp_upload;
		}
		return $resp;
	}
	
	function process_uploaded () {
		$header = array();
		$header[names] = array();
		$header[numbers] = array();
		$file_array	 = file($this->tmp_upload);
		$items_array = explode($this->delim, addslashes($file_array[0]));
		for ($i=0; $i<count($items_array); $i++) {
			array_push($header[names], shortenit($items_array[$i], 40));
			array_push($header[numbers], $i);
		}
		return $header;
	}
	
	function import ($table, $order, $overwrite=0) {
		global $DB_site, $dbprefix;
		if ($overwrite == 1) $DB_site->query("TRUNCATE TABLE `".$dbprefix.$table."`");
		$file_array	 = file($_POST[filename]);
		foreach ($file_array as $k => $v) {
			$items_array = explode($this->delim, addslashes($file_array[$k]));
			$existing = $DB_site->query_first("SELECT * FROM `".$dbprefix.$table."` WHERE `id`='".$items_array[$order[0]]."'");
			if ($existing[id] == "") {
				$query 	= "INSERT INTO `".$dbprefix.$table."` set"; $count = 0;
				$result = $DB_site->query("DESCRIBE `".$dbprefix.$table."`");
				while ($field = $DB_site->fetch_assoc($result)) {
					$query .= " `".$field['Field']."`='".addslashes(str_replace($this->rarray, $this->sarray, trim($items_array[$order[$count++]])))."',";
				}
				$DB_site->query(substr($query, 0, -1));
			} elseif ($overwrite == 2 && $existing[id] != "") {
				$query 	= "UPDATE `".$dbprefix.$table."` set"; $count = 0;
				$result = $DB_site->query("DESCRIBE `".$dbprefix.$table."`");
				while ($field = $DB_site->fetch_assoc($result)) {
					$query .= " `".$field['Field']."`='".addslashes(str_replace($this->rarray, $this->sarray, trim($items_array[$order[$count++]])))."',";
				}
				$DB_site->query(substr($query, 0, -1)." WHERE `id`='".$existing[id]."'");
			}
		}
		@unlink($_POST[filename]);
	}
}
?>