<?php
/*
  include/class.quickbooks.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

class quickbooks {
	var $query = '';
	
	function out ($in) {
		return str_replace(array('"', '&quot;', '&amp;', "\t", "\r", "\n", "{delim}", "{newline}", "{break}"), array('\'\'', '\'\'', '&', ' ', '', '', "\t", "\r\n", "\\\\\\\\n"), $in);
	}
	
	function search($s) {
		global $dbprefix;
		
		$this->query = "SELECT `id` FROM `".$dbprefix."orders` WHERE `id`<>'0'";
		
		if ($s[span] == "today") {
			$this->query .= " AND `order_date`='".date('Y').'-'.date('m').'-'.date('d')."'";
		}
		if ($s[span] == "yesterday") {
			$this->query .= " AND `order_date`='".date("Y-m-d", mktime(0, 0, 0, date("m"), (date("d")-1), date("Y")))."'";
		}
		if ($s[span] == "month") {
			$this->query .= " AND `order_stamp`>='".mktime(0, 0, 0, date('m'), 1, date('Y'))."' AND `order_stamp`<='".mktime(23, 59, 59, date("m")+1, 0, date("Y"))."'";
		}
		if ($s[span] == "lastmonth") {
			$this->query .= " AND `order_stamp`>='".mktime(0, 0, 0, date('m')-1, 1, date('Y'))."' AND `order_stamp`<='".mktime(23, 59, 59, date("m"), 0, date("Y"))."'";
		}
		if ($s[span] == "date") {
			$this->query .= " AND `order_stamp`>='".mktime(0, 0, 0, $s[smonth], $s[sday], $s[syear])."' AND `order_stamp`<='".mktime(23, 59, 59, $s[emonth], $s[eday], $s[eyear])."'";
		}
	}
	
	function process_customers () {
		global $DB_site, $dbprefix, $settings;
		$results = $DB_site->query("SELECT * FROM `".$dbprefix."users` ORDER by `id`");
		while ($user = $DB_site->fetch_assoc($results)) {
			$user = filter_data($user);
			$qb .= $this->out("CUST{delim}$user[bill_last_name], $user[bill_first_name] - $user[username]{delim}$user[bill_first_name] $user[bill_last_name]{delim}$user[bill_address1] $user[bill_address2]{delim}$user[bill_city] $user[bill_state]$user[bill_other], $user[bill_zip]{delim}$user[bill_country]{delim}{delim}$user[ship_first_name] $user[ship_last_name]{delim}$user[ship_address1] $user[ship_address2]{delim}$user[ship_city] $user[ship_state]$user[ship_other], $user[ship_zip]{delim}$user[ship_country]{delim}{delim}$user[phone]{delim}$user[fax]{delim}$user[email]{delim}$user[bill_last_name], $user[bill_first_name]{delim}$user[prefix]{delim}$user[bill_company_name]{delim}$user[bill_first_name]{delim}$user[bill_last_name]{delim}$user[username]{newline}");
		}
		return $qb;
	}
	
	function process_products () {
		global $DB_site, $dbprefix, $settings;
		$results = $DB_site->query("SELECT `id` FROM `".$dbprefix."products` ORDER by `id`");
		while ($product = $DB_site->fetch_assoc($results)) {
			$product = get('products', $product[id]);
			$qb .= $this->out("INVITEM{delim}$product[num]{delim}INVENTORY{delim}$product[title]{delim}$product[title]{delim}$settings[qb_products]{delim}$settings[qb_inventory]{delim}$product[out_price]{delim}".ucfirst($product[charge_tax])."{newline}");
		}
		return $qb;
	}
	
	function process_orders () {
		global $DB_site, $dbprefix, $settings;
		$completed = explode('::', $settings[statcomplete1]);
		$results = $DB_site->query($this->query." ORDER by `id`");
		while ($order = $DB_site->fetch_assoc($results)) {
			$order = get('orders', $order[id]); 
			$user = get('users', $order[userid]);
			
			// Reset Data
			$qb_end = '';
			$qb_total = 0;
			
			//Loop Products
			$presults = $DB_site->query("SELECT * FROM `".$dbprefix."orders_products` where `orderid`='".$order[id]."'");
			while ($product = $DB_site->fetch_assoc($presults)) {
				$product = filter_data($product);
				$prod = unserialize(base64_decode($product[item]));
				$item = new orderitem ($product[data]);
				$qb_total += p(($product[price]+$item->options_price_increase())*$item->get_quantity(), false);
				$qb_end .= "SPL{delim}INVOICE{delim}".date('m/d/Y', $order[order_stamp])."{delim}$settings[qb_products]{delim}$order[bill_last_name], $order[bill_first_name]".(($user[id]!="")?" - $user[username]":"")."{delim}$settings[qb_account]{delim}-".p(($product[price]+$item->options_price_increase())*$item->get_quantity(), false)."{delim}$order[id]{delim}$prod[title]".(($item->display_options_together() != '')?'{break}'.str_replace('; ', '{break}', $item->display_options_together()):'')."{delim}".p($product[price]+$item->options_price_increase(), false)."{delim}-".$item->get_quantity()."{delim}$prod[num]{delim}N{delim}{newline}";
			}
			
			// Discount
			$qb_end .= (p($order[discount], false)==p(0, false))?'':"SPL{delim}INVOICE{delim}".date('m/d/Y', $order[order_stamp])."{delim}$settings[qb_discount]{delim}$order[bill_last_name], $order[bill_first_name]".(($user[id]!="")?" - $user[username]":"")."{delim}$settings[qb_account]{delim}$order[discount]{delim}$order[id]{delim}Discount{delim}-$order[discount]{delim}-1{delim}Discount{delim}N{delim}{newline}";
			// Coupon Savings
			$qb_end .= (p($order[coupon_savings], false)==p(0, false))?'':"SPL{delim}INVOICE{delim}".date('m/d/Y', $order[order_stamp])."{delim}$settings[qb_coupondiscount]{delim}$order[bill_last_name], $order[bill_first_name]".(($user[id]!="")?" - $user[username]":"")."{delim}$settings[qb_account]{delim}$order[coupon_savings]{delim}$order[id]{delim}$order[coupon]{delim}-$order[coupon_savings]{delim}-1{delim}Coupon Discount{delim}N{delim}{newline}";
			// Shipping
			$qb_end .= (p($order[ship_price], false)==p(0, false))?'':"SPL{delim}INVOICE{delim}".date('m/d/Y', $order[order_stamp])."{delim}$settings[qb_shipping]{delim}$order[bill_last_name], $order[bill_first_name]".(($user[id]!="")?" - $user[username]":"")."{delim}$settings[qb_account]{delim}-$order[ship_price]{delim}$order[id]{delim}$order[ship_method]{delim}$order[ship_price]{delim}-1{delim}Shipping{delim}N{delim}{newline}";
			// Tax
			$qb_end .=  "SPL{delim}INVOICE{delim}".date('m/d/Y', $order[order_stamp])."{delim}$settings[qb_tax]{delim}$order[bill_last_name], $order[bill_first_name]".(($user[id]!="")?" - $user[username]":"")."{delim}$settings[qb_account]{delim}-$order[tax]{delim}$order[id]{delim}Tax{delim}$order[tax]{delim}-1{delim}Tax{delim}N{delim}{newline}";
			// Gift Certificate
			$qb_end .= (p($order[gift_cert_savings], false)==p(0, false))?'':"SPL{delim}INVOICE{delim}".date('m/d/Y', $order[order_stamp])."{delim}$settings[qb_gcdiscount]{delim}$order[bill_last_name], $order[bill_first_name]".(($user[id]!="")?" - $user[username]":"")."{delim}$settings[qb_account]{delim}$order[gift_cert_savings]{delim}$order[id]{delim}$order[gift_cert]{delim}-$order[gift_cert_savings]{delim}-1{delim}Gift Certificate{delim}N{delim}{newline}";
			// End Transaction
			$qb_end .= "ENDTRNS{newline}";
			
			$qb_total = p($qb_total-$order[discount]-$order[coupon_savings]+$order[ship_price]+$order[tax]-$order[gift_cert_savings], false);
			
			// Build Output
			$qb .= $this->out("TRNS{delim}$order[id]{delim}INVOICE{delim}".date('m/d/Y', $order[order_stamp])."{delim}Accounts Receivable{delim}$order[bill_last_name], $order[bill_first_name]".(($user[id]!="")?" - $user[username]":"")."{delim}$settings[qb_account]{delim}$qb_total{delim}$order[id]{delim}$settings[title] Order #: $order[id]{delim}$order[bill_first_name] $order[bill_last_name]{delim}$order[bill_address1] $order[bill_address2]{delim}$order[bill_city] $order[bill_state]$order[bill_other], $order[bill_zip]{delim}$order[bill_country]{delim}{delim}".(in_array($order[cc_status], $completed)?'Y':'N')."{delim}$orders[ship_method]{delim}$order[ship_first_name] $order[ship_last_name]{delim}$order[ship_address1] $order[ship_address2]{delim}$order[ship_city] $order[ship_state]$order[ship_other], $order[ship_zip]{delim}$order[ship_country]{delim}{delim}Y{newline}");
			$qb .= $this->out($qb_end);
		}
		return $qb;
	}
	
	function process_payments () {
		global $DB_site, $dbprefix, $settings;
		$completed = explode('::', $settings[statcomplete2]);
		$results = $DB_site->query($this->query." AND `status` IN ('".implode("','", $completed)."')");
		while ($order = $DB_site->fetch_assoc($results)) {
			$order = get('orders', $order[id]); $qb_total = 0;
			$user = get('users', $order[userid]);
			$presults = $DB_site->query("SELECT * FROM `".$dbprefix."orders_products` where `orderid`='".$order[id]."'");
			while ($product = $DB_site->fetch_assoc($presults)) {
				$product = filter_data($product);
				$item = new orderitem ($product[data]);
				$qb_total += p(($product[price]+$item->options_price_increase())*$item->get_quantity(), false);
			}
			
			$qb_total = p($qb_total-$order[discount]-$order[coupon_savings]+$order[ship_price]+$order[tax]-$order[gift_cert_savings], false);
			$qb .= $this->out("TRNS{delim}PAYMENT{delim}".date('m/d/Y', $order[order_stamp])."{delim}Undeposited Funds{delim}$order[bill_last_name], $order[bill_first_name]".(($user[id]!="")?" - $user[username]":"")."{delim}$qb_total{delim}$order[pay_method]{delim}$order[id]{newline}");
			$qb .= $this->out("SPL{delim}PAYMENT{delim}".date('m/d/Y', $order[order_stamp])."{delim}Accounts Receivable{delim}$order[bill_last_name], $order[bill_first_name]".(($user[id]!="")?" - $user[username]":"")."{delim}-$qb_total{delim}$order[id]{newline}");
			$qb .= $this->out("ENDTRNS{newline}");
		}
		return $qb;
	}
}
?>
