<?php
/*
  include/class.shiptrack.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2006 Turnkey Web Tools, Inc.
*/

class shiptrack {
	var $CARRIER         = "";
	var $TRACKING_NUMBER = "";
	var $LINKTEXT        = "";
	var $SHIPPING_TYPE   = "";
	var $OPENWINDOW      = "";
	var $EXTRACODE       = "";
	var $DEBUG           = 0;
	
    function shiptrack () {
		$this->CARRIER 			= "";
		$this->TRACKING_NUMBER	= "";
		$this->SHIPPING_TYPE	= "";
		$this->OPENWINDOW		= "";
		$this->EXTRACODE		= "";
    }
	
    function print_link ($carrier, $tracking_number, $linktext="", $shipping_type="", $openwindow="", $extracode="") {
		echo $this->return_link($carrier, $tracking_number, $linktext, $shipping_type, $openwindow, $extracode);
    }
	
    function return_link ($carrier, $tracking_number, $linktext="", $shipping_type="", $openwindow="", $extracode="") {
		$this->initialize($carrier, $tracking_number, $linktext, $shipping_type, $openwindow, $extracode);
		return $this->make_link();
    }
	
    function initialize ($carrier, $tracking_number, $linktext="", $shipping_type="", $openwindow="", $extracode="") {
		$this->CARRIER			= "";
		$this->TRACKING_NUMBER	= "";
		$this->SHIPPING_TYPE	= "";
		$this->OPENWINDOW		= "";
		$this->EXTRACODE		= "";
		$this->CARRIER			= $carrier;
		$this->TRACKING_NUMBER	= $tracking_number;
		$this->SHIPPING_TYPE	= $shipping_type;
		$this->EXTRACODE		= $extracode;
		
		$this->set_link_text($linktext);
		$this->set_open_window($openwindow);
    }
	
    function set_link_text ($linktext="") {
		$this->LINKTEXT = "";
		if (!strlen($linktext)) $this->LINKTEXT = $this->CARRIER;
		else {
			switch($linktext) {
				case 1:	 $this->LINKTEXT = $this->CARRIER; break;
				case 2:  $this->LINKTEXT = "Track"; break;
				default: $this->LINKTEXT = $linktext;
			}
		}
    }
	
	function set_open_window ($openwindow="") {
		$this->OPENWINDOW = "";
		if (!strlen($openwindow)) $this->OPENWINDOW = "";
		else $this->OPENWINDOW = ' target="'.$openwindow.'"';
    }
	
	function make_link() {
		$link = "";
		switch(strtoupper($this->CARRIER)) {
			case "UPS":
				$link = '<a href="http://wwwapps.ups.com/etracking/tracking.cgi?tracknums_displayed=1&TypeOfInquiryNumber=T&HTMLVersion=4.0&InquiryNumber1='.$this->TRACKING_NUMBER.'&track=Track"'.$this->OPENWINDOW.$this->EXTRACODE.'>'.$this->LINKTEXT.'</a>';
				break;
			case "FEDEX":
				$link = '<a href="http://www.fedex.com/Tracking?tracknumbers='.$this->TRACKING_NUMBER.'&language=english&action=track&cntry_code=us"'.$this->OPENWINDOW.$this->EXTRACODE.'>'.$this->LINKTEXT.'</a>';
				break;
			case "DHL":
				$link = '<form name="fedex" action="http://track.dhl-usa.com/TrackByNbr.asp" method="POST"'.$this->OPENWINDOW.$this->EXTRACODE.'><input type="hidden" name="hdnPostType" value="init"><input type="hidden" name="txtTrackNbrs" value="'.$this->TRACKING_NUMBER.'"><a href="javascript:void(0);" onclick="document.forms[\'fedex\'].submit();">'.$this->LINKTEXT.'</a></form>';
				break;
			case "USPS":
				$link = '<a href="http://trkcnfrm1.smi.usps.com/PTSInternetWeb/InterLabelInquiry.do?CAMEFROM=OK&strOrigTrackNum='.$this->TRACKING_NUMBER.'"'.$this->OPENWINDOW.$this->EXTRACODE.'>'.$this->LINKTEXT.'</a>';
				break;
			case "CANADA POST":
				$link = '<a href="https://em.canadapost.ca/emo/basicPin.do?trackingId='.$this->TRACKING_NUMBER.'&trackingCode=PIN&action=query&language=en&scloc=segment"'.$this->OPENWINDOW.$this->EXTRACODE.'>'.$this->LINKTEXT.'</a>';
				break;
			case "AUSTRALIAN POST":
				$link = '<form name="auspost" action="http://www.eparcel.com.au/EPTrack_Internet_Send_Message.process?nav_main=eparcel_track&nav_sub=Tracking" method="POST"'.$this->OPENWINDOW.$this->EXTRACODE.'><input type="hidden" name="IWPEProcessFlow.submitted.sequenceID" value="EPTrack_Internet_Main|WriteDisplay"><input type="hidden" name="EParcel_Number" value="'.$this->TRACKING_NUMBER.'"><a href="javascript:void(0);" onclick="document.forms[\'auspost\'].submit();">'.$this->LINKTEXT.'</a></form>';
				break;
			default:
				$link = $this->TRACKING_NUMBER;
		}
		return $link;
    }
}
?>
