<?PHP
/*
  include/plugins/checkout_by_amazon.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "Checkout by Amazon";
$ADDON_VERSION 	= "1.0";
$CLASS_NAME 	= "checkout_by_amazon";

class checkout_by_amazon {
	var $class_vars;
	var $nusoap;
	var $merchant;
	
	function checkout_by_amazon ($class_vars) {
		$this->class_vars = $class_vars;
		$this->merchant = array(
			'merchantIdentifier' => $this->class_vars[merchant_token],
			'merchantName' => $this->class_vars[merchant_name]
		);
	}
	
	function render () {}
	
	function catch_return () {
		global $DB_site, $dbprefix, $settings, $abs_path, $lang, $sess;
		
		$lango = $lang['order'];
		$cart_entry = $DB_site->query_first("SELECT * FROM ".$dbprefix."users_saved_carts WHERE id='".base64_decode(urldecode($_GET['amznPmtsReqId']))."'");
		
		if ($cart_entry[id] == "" || $_GET['amznPmtsReqId'] == "") {
			echo "Failed to retrieve your shopping cart data.";
			exit;
		} else {
			$cart = unserialize(base64_decode($cart_entry[cart]));
			$sess->svar('cart', $cart);
		}
		
		$subtotal = $cart->subtotal();
		
		$orderinfo = array(
			'subtotal'			=> $subtotal,
			'total'				=> $subtotal
		);
		
		$sess->svar('orderinfo', $orderinfo);
		
		$append = array(
			'pm_module'			=> 'checkout_by_amazon.php',
			'pm_type'			=> 'methods',
			'pm_name'			=> 'Checkout by Amazon',
			'pm_orderid'		=> $_GET['amznPmtsOrderIds'],
			'ship_first_name' 	=> 'Not Yet Retrieved',
			'ship_last_name' 	=> '',
			'ship_company_name' => '',
			'ship_address1' 	=> 'Not Yet Retrieved',
			'ship_address2' 	=> '',
			'ship_city' 		=> 'Not Yet Retrieved',
			'ship_state' 		=> '',
			'ship_zip' 			=> '',
			'ship_country' 		=> '',
			'bill_first_name' 	=> 'Not Yet Retrieved',
			'bill_last_name' 	=> '',
			'bill_company_name' => '',
			'bill_address1' 	=> 'Not Yet Retrieved',
			'bill_address2'		=> '',
			'bill_city'			=> 'Not Yet Retrieved',
			'bill_state'		=> '',
			'bill_zip'			=> '',
			'bill_country'		=> '',
			'email'				=> 'Not Yet Retrieved',
			'phone'				=> 'Not Yet Retrieved',
			'ship_method'		=> 'Not Yet Retrieved',
			'userid'			=> $cart_entry[userid],
			'status'			=> 'Pending',
			'cc_status'			=> 'Awaiting Amazon Retrieval',
		);
		
		$data[orderid]	= store_order($append, 'Checkout by Amazon', false);
		$data[result]	= $lango['order_success'];
		
		return $data;
	}
	
	function connect () {
		global $abs_path;
		include_once $abs_path.'/include/classes/pear/PEAR.php';
		include_once $abs_path.'/include/classes/pear/mimeDecode.php';
		include_once $abs_path.'/include/classes/pear/mimePart.php';
		include_once $abs_path.'/include/soap/nusoap.php';
		include_once $abs_path.'/include/soap/nusoapmime.php';
		$this->nusoap = new nusoapclientmime($abs_path.'/include/plugins/checkout_by_amazon/wsdl/merchant-interface-mime.wsdl', true);
		$this->nusoap->username         = $this->class_vars[seller_email];
		$this->nusoap->password         = $this->class_vars[seller_pass];
		$this->nusoap->authtype         = 'basic';
		$this->nusoap->soap_defencoding	= 'UTF-8';

		if ($this->nusoap->getError()) return false;
		else return true;
	}
	
	function doc_ids () {
		$params = array('merchant' => $this->merchant, 'messageType' => "_GET_ORDERS_DATA_");
		$result = $this->nusoap->call('getAllPendingDocumentInfo', $params);
		
		if ($this->nusoap->getError()) {
		   return false;
		} else {
		   return $result;
		} 
	}
	
	function get_document ($documentID) {
		 $params = array('merchant' => $this->merchant, 'documentIdentifier' => $documentID);
		 $result = $this->nusoap->call('getDocument', $params);
		 
		 if ($this->nusoap->getError()) {
		   return false;
		} else {
		   return $result;
		}
	}
	
	function document_ack ($documentIDs) {
		 $params = array('merchant' => $this->merchant, 'messageType' => $messageType, 'documentIdentifierArray' => $documentID);
		 $result = $this->nusoap->call('postDocumentDownloadAck', $params);
		 
		 if ($this->nusoap->getError()) {
		   return false;
		} else {
		   return $result;
		}
	}
	
	function get_order_data () {
		global $DB_site, $dbprefix, $abs_path;
		$connect = $this->connect();
		$result = $this->doc_ids();
		if (!$connect || !$result) {
			return $this->nusoap->getError();
		} else {
			$docs = array();
			$documentIDs = (!is_array($result))?array($result):$result;
			foreach ($documentIDs[MerchantDocumentInfo] as $k => $v) {
				array_push($docs, $v['documentID']);
			}
			
			if (count($docs) > 0) {
				foreach ($docs as $v) {
					$info = $this->get_document($v);
					include_once $abs_path.'/include/classes/class.mimeparser.php';
					$parser = new mime_parser_class();
					
					$parser->decode_bodies = 1;
					$parser->extract_addresses = 0;
					$parameters = array('Data' => $this->nusoap->response);
					$parser->Decode($parameters, $decoded);
					
					if ($decoded[0]['Parts'][1]['Body'] == '') {
						return $this->nusoap->getError();
					} else {
						$aorder = parse_xml($decoded[0]['Parts'][1]['Body'], array('Item', 'Component'));
						$order = $DB_site->query_first("SELECT * FROM `".$dbprefix."orders` where `pm_orderid`='".$aorder[AmazonEnvelope][Message][OrderReport][AmazonOrderID]."'");
						if ($order[id] == $_GET[id]) {		
							foreach ($aorder[AmazonEnvelope][Message][OrderReport][Item] as $k => $v) {
								foreach ($v[ItemPrice][Component] as $k1 => $v1) {
									if ($v1[Type] == "Shipping") $this_shipping += $v1[Amount];
									if ($v1[Type] == "Tax") $this_tax += $v1[Amount];
								}
							}
							
							$name = explode(' ', $aorder[AmazonEnvelope][Message][OrderReport][FulfillmentData][Address][Name]);
							
							$DB_site->query("UPDATE `".$dbprefix."orders` set
								`email`='".sf($aorder[AmazonEnvelope][Message][OrderReport][BillingData][BuyerEmailAddress])."',
								`phone`='".sf($aorder[AmazonEnvelope][Message][OrderReport][BillingData][BuyerPhoneNumber])."',
								`ship_first_name`='".sf($name[0])."',
								`ship_last_name`='".sf(trim($name[1].' '.$name[2].' '.$name[3].' '.$name[4]))."',
								`ship_address1`='".sf($aorder[AmazonEnvelope][Message][OrderReport][FulfillmentData][Address][AddressFieldOne])."',
								`ship_address2`='".sf($aorder[AmazonEnvelope][Message][OrderReport][FulfillmentData][Address][AddressFieldTwo])."',
								`ship_city`='".sf($aorder[AmazonEnvelope][Message][OrderReport][FulfillmentData][Address][City])."',
								`ship_state`='".sf($aorder[AmazonEnvelope][Message][OrderReport][FulfillmentData][Address][StateOrRegion])."',
								`ship_zip`='".sf($aorder[AmazonEnvelope][Message][OrderReport][FulfillmentData][Address][PostalCode])."',
								`ship_country`='".sf($aorder[AmazonEnvelope][Message][OrderReport][FulfillmentData][Address][CountryCode])."',
								`bill_first_name`='".sf($name[0])."',
								`bill_last_name`='".sf(trim($name[1].' '.$name[2].' '.$name[3].' '.$name[4]))."',
								`bill_address1`='".sf($aorder[AmazonEnvelope][Message][OrderReport][FulfillmentData][Address][AddressFieldOne])."',
								`bill_address2`='".sf($aorder[AmazonEnvelope][Message][OrderReport][FulfillmentData][Address][AddressFieldTwo])."',
								`bill_city`='".sf($aorder[AmazonEnvelope][Message][OrderReport][FulfillmentData][Address][City])."',
								`bill_state`='".sf($aorder[AmazonEnvelope][Message][OrderReport][FulfillmentData][Address][StateOrRegion])."',
								`bill_zip`='".sf($aorder[AmazonEnvelope][Message][OrderReport][FulfillmentData][Address][PostalCode])."',
								`bill_country`='".sf($aorder[AmazonEnvelope][Message][OrderReport][FulfillmentData][Address][CountryCode])."',
								`ship_method`='".sf($aorder[AmazonEnvelope][Message][OrderReport][FulfillmentData][FulfillmentServiceLevel])."',
								`ship_price`='".sf('Standard')."',
								`tax`='".p($this_tax, false)."',
								`ship_price`='".p($this_shipping, false)."',
								`total`='".p($order[total]+$this_shipping+$this_tax, false)."',
								`cc_status`='Payment Received'
								where `id`='".$order[id]."'
							");
							$this->document_ack(array('string' => $v));
							return 'Order Information Updated.';
						}
					}
				}
				return 'Information on this order is not yet available. Please note orders can take up to 24 hours to register on Seller Central. Orders will normally be ready within 15 minutes.';
			} else {
				return 'There is currently no order data for this order yet in Seller Central.';
			}
		}
		return 'An unknown error occured.';
	}
	
	function post_fulfillment_data ($order) {
		global $abs_path;
		
		$connect = $this->connect();
		if (!$connect) {
			return $this->nusoap->getError();
		}
		
		if ($order[carrier] == "") return "Please set the shipping information on the 'Status Information' tab first.";
		$order[ship_date] = date('Y-m-d\TH:i:s'). substr_replace(date('O'),':',3,0);
		$order[merchant_id] = $this->class_vars[merchant_token];
		
		$xml = xml_doc('include/plugins/checkout_by_amazon/amazon_fulfillment_data.xml', $order);
		$attachment = $this->nusoap->addAttachment($xml, '', 'application/binary');
		$params = array('merchant' => $this->merchant, 'messageType' => '_POST_PAYMENT_ADJUSTMENT_DATA_', 'doc' => 'href="cid:'.$attachment.'"', 'amazonHack' => true);
		$result = $this->nusoap->call('postDocument', $params);
		
		if ($this->nusoap->getError()) {
		   return $this->nusoap->getError();
		} else {
			if ($result[documentTransactionID] != '') {
				return 'Shipping information has been sent successfully. Document ID: '.$result[documentTransactionID];
			}
			return 'An unknown error occured.';
		}
	}
	
	function load_actions () {
		$map_actions = array (
			'Checkout by Amazon: Get Order Data' => 'get_order_data',
			'Checkout by Amazon: Post Shipping Information' => 'post_fulfillment_data'
		);
		return $map_actions;
	}
	
	function parse_return ($in) {
		global $request;
	}

	function install () {
		global $DB_site, $dbprefix, $settings;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='checkout_by_amazon', `internalname`='enabled', `name`='', `moptions`='', `options`='', `value`='0', `help`='', `size`='', `dorder`='', `field_type`='hidden'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='checkout_by_amazon', `internalname`='seller_email', `name`='Seller Central Email', `options`='', `value`='', `help`='Your seller central email address.', `size`='40', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='checkout_by_amazon', `internalname`='seller_pass', `name`='Seller Central Password', `options`='', `value`='', `help`='Your seller central password.', `size`='30', `dorder`='2', `field_type`='password'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='checkout_by_amazon', `internalname`='merchant_token', `name`='Merchant Token', `options`='', `value`='', `help`='Your Merchant Token', `size`='30', `dorder`='3', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='checkout_by_amazon', `internalname`='merchant_name', `name`='Merchant Name', `options`='', `value`='', `help`='Your Merchant Name', `size`='30', `dorder`='4', `field_type`='textbox'");
		
		$DB_site->query("INSERT INTO ".$dbprefix."modules_plugins set `module`='checkout_by_amazon', `internalname`='enabled', `name`='Enabled', `moptions`='', `options`='0::1->Off::On', `value`='1', `help`='', `size`='0', `dorder`='1', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_plugins set `module`='checkout_by_amazon', `internalname`='merchant_id', `name`='Your Merchant ID', `options`='', `value`='', `help`='Your Merchant ID', `size`='30', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_plugins set `module`='checkout_by_amazon', `internalname`='merchant_key_id', `name`='Access Key ID', `options`='', `value`='', `help`='Your Access Key ID', `size`='30', `dorder`='3', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_plugins set `module`='checkout_by_amazon', `internalname`='merchant_key_secret', `name`='Secret Access Key', `options`='', `value`='', `help`='Your Secret Access Key', `size`='30', `dorder`='4', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_plugins set `module`='checkout_by_amazon', `internalname`='bg', `name`='Image Style', `moptions`='', `options`='orange_white::tan_white::orange_other::tan_other->Light Backgound Orange Button::Light Backgound Tan Button::Dark Backgound Orange Button::Dark Backgound Tan Button', `value`='light_orange', `help`='Image and background type that will be used to display your checkout button.', `size`='0', `dorder`='5', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_plugins set `module`='checkout_by_amazon', `internalname`='size', `name`='Image Size', `moptions`='', `options`='medium::large->Medium::Large', `value`='medium', `help`='Image size that will be used to display your checkout button.', `size`='0', `dorder`='6', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_plugins set `module`='checkout_by_amazon', `internalname`='sandbox', `name`='Sandbox Mode', `options`='true::false->Yes::No', `value`='false', `help`='Set to this value for testing mode. Set to \"No\" for LIVE.', `size`='0', `dorder`='7', `field_type`='dropdown'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_methods where `module`='checkout_by_amazon'");
		$DB_site->query("DELETE FROM ".$dbprefix."modules_plugins where `module`='checkout_by_amazon'");
	}
}

$OUT_DATA = 'PHRhYmxlIGJvcmRlcj0iMCIgY2VsbHNwYWNpbmc9IjAiIGNlbGxwYWRkaW5nPSIzIj4NCgk8dHI+DQoJCTx0ZCB2YWxpZ249Im1pZGRsZSI+PGltZ
	yBzcmM9ImltYWdlcy9hbWF6b25fcGF5bWVudHMucG5nIiBhbHQ9IkFtYXpvbiBQYXltZW50cyIgd2lkdGg9IjEzNCIgaGVpZ2h0PSI4NCIgYm9yZGVyPSIwIiB
	zdHlsZT0iYm9yZGVyOiAwcHggc29saWQgIzAwMDAwMDsiPjwvdGQ+DQoJCTx0ZD48aW1nIHNyYz0iJHNldHRpbmdzW3RoZW1lX3BhdGhdL2ltYWdlcy9zcGFjZ
	S5naWYiIHdpZHRoPSIxMCIgaGVpZ2h0PSIxIiBib3JkZXI9IjAiPjwvdGQ+DQoJCTx0ZCB2YWxpZ249Im1pZGRsZSI+DQoJCQlBbWF6b24gUGF5bWVudHMgb2Z
	mZXJzIG1lcmNoYW50cyBhIHNldCBvZiBwYXltZW50IGFuZCBjaGVja291dCBzb2x1dGlvbnMgdGhhdCB0aGV5IGNhbiBpbnRlZ3JhdGUgDQoJCQlvbiB0aGVpc
	iBzaXRlLiBUaGVzZSBzb2x1dGlvbnMgZW5hYmxlIHRoZSB0ZW5zIG9mIG1pbGxpb25zIG9mIEFtYXpvbiBjdXN0b21lcnMgdG8gY29tcGxldGUgcHVyY2hhc2V
	zIG9uIHlvdXIgDQoJCQl3ZWJzaXRlIHVzaW5nIHRoZSBzYW1lIGluZm9ybWF0aW9uIGluIHRoZWlyIEFtYXpvbi5jb20gYWNjb3VudC48YnI+PGJyPg0KCQkJP
	GlucHV0IHR5cGU9ImJ1dHRvbiIgdmFsdWU9IkxlYXJuIE1vcmUiIG9uQ2xpY2s9IndpbmRvdy5vcGVuKCdodHRwOi8vd3d3LnR1cm5rZXl3ZWJ0b29scy5jb20
	vc3Vuc2hvcC9hbWF6b24uaHRtbCcsJ0FtYXpvbicsJ3dpZHRoPTYwMCxoZWlnaHQ9NTAwLHJlc2l6YWJsZT0xLHNjcm9sbGJhcnM9MSx0aXRsZWJhcj0xLG1lb
	nViYXI9MSx0b29sYmFyPTEsbG9jYXRpb249MSxzdGF0dXM9MSxkaXJlY3Rvcmllcz0xLGNoYW5uZWxtb2RlPTAsZnVsbHNjcmVlbj0wJyk7IHJldHVybiBmYWx
	zZTsiPg0KCQk8L3RkPg0KDQoJPC90cj4NCjwvdGFibGU+';
	
?>