<?PHP
/*
  include/methods/credit_card.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "Credit Card";
$ADDON_VERSION 	= "1.3";
$ADDON_TYPE 	= "Pay Method";
$CLASS_NAME 	= "credit_card";

class credit_card {
	var $class_vars;
	var $required;
	var $remove;
	var $cards;
	var $months;
	var $years;
	
	function credit_card ($class_vars) {
		global $settings, $abs_path;
		
		@include $abs_path.'/lang/'.$settings[language];
		$lango = $lang['order'];
		
		$this->class_vars	= $class_vars;
		$this->required		= array('cc_name_on_card', 'cc_card_no', 'cc_expir_month', 'cc_expir_year', 'cc_card_type', 'cc_issue', 'cc_start_month', 'cc_start_year');
		$this->req_names	= array($lango['cc_name_on_card'], $lango['cc_card_no'], $lango['cc_expir_date'], $lango['cc_expir_date'], $lango['cc_card_type'], $lango['cc_issue'], $lango['cc_start_date'], $lango['cc_start_date']);
		$this->remove		= array('cc_card_no');
		
		if ($this->class_vars[req_cvv2]) {
			array_push($this->required, 'cc_cvv2');
			array_push($this->req_names, $lang['order']['cc_cvv2']);
		}
		
		$this->cards = array (
			'visa' 			=> $lango['visa'],
			'mastercard' 	=> $lango['mastercard'],
			'amex' 			=> $lango['amex'],
			'discover' 		=> $lango['discover'],
			'diners'		=> $lango['diners'],
			'discover' 		=> $lango['discover'],
			'jcb' 			=> $lango['jcb'],
			'carte_blanche'	=> $lango['carte_blanche'],
			'aus_bankcard'	=> $lango['aus_bankcard'],
			'switch'		=> $lango['switch'],
			'solo'			=> $lango['solo'],
		);
		
		$this->months = array (
			'1' => 'Jan (01)',
			'2' => 'Feb (02)',
			'3' => 'Mar (03)',
			'4' => 'Apr (04)',
			'5' => 'May (05)',
			'6' => 'Jun (06)',
			'7' => 'Jul (07)',
			'8' => 'Aug (08)',
			'9' => 'Sep (09)',
			'10' => 'Oct (10)',
			'11' => 'Nov (11)',
			'12' => 'Dec (12)'
		);
		
		$this->years = array();
		for ($i=date("Y"); $i<(date("Y")+10); $i++) array_push($this->years, $i);
		$this->syears = array();
		for ($i=date("Y"); $i>(date("Y")-10); $i--) array_push($this->syears, $i);
	}
	
	function render () {
		global $DB_site, $dbprefix, $sess, $abs_path, $settings, $lang, $orderinfo;
		
		if (p($orderinfo[total]) == p(0)) {
			$sess->dvar('orderinfo'); 
			$sess->svar('orderinfo', $orderinfo);
			header('location: '.$settings[secureurl].'checkout.php?l=review');
			exit;
		}
		
		if ($settings[payment_module] != "") {
			include $abs_path."/include/payment/".$settings[payment_module];
			$class_vars = module_vars($CLASS_NAME, 'payment');
			$process = new $CLASS_NAME($class_vars);
			if (method_exists($process, 'skip_form')) $process->skip_form();
		}
		
		foreach ($this->remove as $k => $v) if (isset($orderinfo[$v])) unset($orderinfo[$v]);
		
		$accept = explode("::", $this->class_vars[accepted]);
		foreach ($this->cards as $k => $v) {
			if (in_array($v, $accept))
			$accepted_cards .= template('misc_option_select.html', array('option' => array('value' => $v, 'name' => $v, 'selected' => (($orderinfo[cc_card_type]==$v)?' selected="selected"':''))));
		}
		foreach ($this->months as $k => $v) {
			$month_options .= template('misc_option_select.html', array('option' => array('value' => $k, 'name' => $v, 'selected' => (($orderinfo[cc_expir_month]==$k)?' selected="selected"':''))));
		}
		foreach ($this->years as $k => $v) {
			$year_options .= template('misc_option_select.html', array('option' => array('value' => $v, 'name' => $v, 'selected' => (($orderinfo[cc_expir_year]==$v)?' selected="selected"':''))));
		}
		
		$start_month_options = $month_options;
		
		foreach ($this->syears as $k => $v) {
			$start_year_options .= template('misc_option_select.html', array('option' => array('value' => $v, 'name' => $v, 'selected' => (($order[cc_start_year]==$v)?' selected="selected"':''))));
		}
		return template('order_payment_credit_card.html', array('lang' => $lang['order'], 'orderinfo' => $orderinfo, 'accepted_cards' => $accepted_cards, 'month_options' => $month_options, 'year_options' => $year_options, 'start_month_options' => $start_month_options, 'start_year_options' => $start_year_options));
	}
	
	function check_required () {
		global $DB_site, $dbprefix, $abs_path, $lang;
		include $abs_path."/include/classes/class.cccheck.php";
		$check	= new cc_check();
		$lango	= $lang['order'];
		
		if ($_POST[order][cc_card_type] != $lango['switch'] && $_POST[order][cc_card_type] != $lango['solo']) {
			unset($this->required[5]); unset($this->required[6]); unset($this->required[7]);
			unset($this->req_names[5]); unset($this->req_names[6]); unset($this->req_names[7]);
		}
		
		foreach ($this->required as $k => $v)
			if ($_POST[order][$v] == "") 
				return template('misc_error_alert.html', array('error' => array('message' => "'".$this->req_names[$k]."'".$lango['is_required'])));
		
		if (stamp() >= strtotime("+1 month", strtotime($_POST[order][cc_expir_month]."/01/".$_POST[order][cc_expir_year])))
			return template('misc_error_alert.html', array('error' => array('message' => $lango['cc_expired'])));
		
		if ($_POST[order][cc_card_type] == $lango['switch'] || $_POST[order][cc_card_type] == $lango['solo'])
			if (stamp() < strtotime($_POST[order][cc_start_month]."/01/".$_POST[order][cc_start_year]))
				return template('misc_error_alert.html', array('error' => array('message' => $lango['cc_started'])));
		
		if (!$check->check($_POST[order][cc_card_type], $_POST[order][cc_card_no]))
			return template('misc_error_alert.html', array('error' => array('message' => $check->error)));
	}
	
	function pre_process () {
		global $DB_site, $dbprefix, $abs_path, $orderinfo, $settings, $sess, $lang;
		$lango = $lang['order'];
		
		$display = array(
			$lango['pay_method'] 		=> $this->class_vars[display_name],
			$lango['cc_name_on_card'] 	=> $orderinfo[cc_name_on_card],
			$lango['cc_card_no'] 		=> $this->safe_display(tempdecryptit($orderinfo[cc_card_no])),
			$lango['cc_card_type']		=> $orderinfo[cc_card_type],
			$lango['cc_cvv2'] 			=> $orderinfo[cc_cvv2],
			$lango['cc_expir_date']		=> ($orderinfo[cc_expir_month]!="")?$orderinfo[cc_expir_month].' '.$orderinfo[cc_expir_year]:"",
			$lango['cc_start_date'] 	=> ($orderinfo[cc_card_type] == $lango['solo'] || $orderinfo[cc_card_type] == $lango['switch'])?$orderinfo[cc_start_date]:"",
			$lango['cc_issue'] 			=> ($orderinfo[cc_card_type] == $lango['solo'] || $orderinfo[cc_card_type] == $lango['switch'])?$orderinfo[cc_issue]:"",
		);
		
		foreach ($display as $k => $v) {
			$data[payment_details] .= ($v != "")?template('order_overall_review_payment_item.html', array('item' => array('name' => $k, 'value' => $v))):"";
		}
		
		$data[form_action] = $settings[secureurl].'checkout.php?l=process';
		return $data;
	}
	
	function process () {
		global $DB_site, $dbprefix, $abs_path, $settings, $sess, $cart, $lang, $ae;
		$lango = $lang['order'];
		$orderinfo = $sess->gvar('orderinfo');
		if ($settings[payment_module] != "") {
			include $abs_path."/include/payment/".$settings[payment_module];
			$class_vars = module_vars($CLASS_NAME, 'payment');
			$process = new $CLASS_NAME($class_vars);
			
			if ($class_vars[pass_cart] == "1") $process->pass_cart($cart->pass_cart());
			
			if (p($orderinfo[total]) != p(0)) {
				if (method_exists($process, 'hold_forward')) {
					$data = $process->hold_forward();
					echo template('order_hold_and_forward.html', array('data' => $data, 'lang' => $lang['order']));
					exit;
				}
				$data = $process->process();
			} else {
				$data['addon_oid']	= 'N/A';
				$data['addon_auth']	= 'N/A';
				$data['addon_avs']	= 'N/A';
				$data['addon_cvn']	= 'N/A';
				$data['approved']	= 'Approved';
				$data['a_notes']	= 'Payment information not processed for $0.00 order.';
			}
			
			$append = array(
				'pm_module'				=> $settings[payment_module],
				'pm_type'				=> 'payment',
				'pm_name'				=> $ADDON_NAME,
				'pm_orderid'			=> $data['addon_oid'],
				'pm_preauth'			=> $data['addon_auth'],
				'pm_avs'				=> $data['addon_avs'],
				'pm_cvn'				=> $data['addon_cvn'],
				'cc_name_on_card' 		=> ($this->class_vars[store_cc]==1)?$orderinfo[cc_name_on_card]:'',
				'cc_card_no_lastfour' 	=> $this->safe_display(tempdecryptit($orderinfo[cc_card_no])),
				'cc_card_no' 			=> ($this->class_vars[store_cc]==1)?permstoredetails(tempdecryptit($orderinfo[cc_card_no])):'',
				'cc_card_type' 			=> ($this->class_vars[store_cc]==1)?$orderinfo[cc_card_type]:'',
				'cc_cvv2'				=> ($this->class_vars[store_cc]==1 && $this->class_vars[store_cvv2]=='agree')?$orderinfo[cc_cvv2]:'',
				'cc_expir_date'			=> ($this->class_vars[store_cc]==1)?$orderinfo[cc_expir_month].'/'.$orderinfo[cc_expir_year]:'',
				'cc_start_date'			=> ($this->class_vars[store_cc]==1 && ($orderinfo[cc_card_type] == $lango['solo'] || $orderinfo[cc_card_type] == $lango['switch']))?$orderinfo[cc_start_month].'/'.$orderinfo[cc_start_year]:'',
				'cc_issue_number'		=> ($this->class_vars[store_cc]==1 && ($orderinfo[cc_card_type] == $lango['solo'] || $orderinfo[cc_card_type] == $lango['switch']))?$orderinfo[cc_issue_number]:'',
			);
			
			switch ($data['approved']) {
				case 'Approved':
					$append2 = array('status' => 'Pending', 'cc_status' => (($append[pm_preauth]!='')?'Pending Approval':'Payment Received'));
					$data[orderid]	= store_order(array_merge($append, $append2));
					$data[result]	= $lango['order_success'];
					break;
				case 'Review':
					$append2 = array('status' => 'Pending', 'cc_status' => 'Requires Review');
					$data[orderid]	= store_order(array_merge($append, $append2));
					$data[result] 	= $lango['order_success'];
					$data[notes]	= $lango['order_review'];
					break;
				case 'Error':
					$ae->new_error('<strong>'.$lango['pay_error'].'</strong>'.$data['addon_code'].' '.$data['addon_message']);
					$data[result]	= $lango['order_error'];
					break;
			}
			if ($data[a_notes]!="") $DB_site->query("INSERT INTO `".$dbprefix."orders_notes` set `orderid`='".$data[orderid]."', `type`='A', `private`='1', `note`='".sf($data[a_notes])."', `addedby`='".sf($ADDON_NAME)."', `datestamp`='".stamp()."'");
		} else {
			$append = array(
				'cc_cvv2'				=> ($this->class_vars[store_cvv2]=='agree')?$orderinfo[cc_cvv2]:'',
				'cc_status'				=> 'Pending Approval',
				'status'				=> 'Pending',
				'cc_card_no_lastfour' 	=> $this->safe_display(tempdecryptit($orderinfo[cc_card_no])),
				'cc_card_no' 			=> permstoredetails(tempdecryptit($orderinfo[cc_card_no])),
				'cc_expir_date'			=> ($orderinfo[cc_expir_month]!="")?$orderinfo[cc_expir_month].'/'.$orderinfo[cc_expir_year]:'',
				'cc_start_date'			=> ($orderinfo[cc_card_type] == $lango['solo'] || $orderinfo[cc_card_type] == $lango['switch'])?$orderinfo[cc_start_month].'/'.$orderinfo[cc_start_year]:''
			);
			$data[orderid]	= store_order($append);
			$data[result]	= $lango['order_success'];
		}
		return $data;
	}
	
	function catch_return () {
		global $DB_site, $dbprefix, $abs_path, $settings, $cart, $lang, $gs, $orderinfo, $ae;
		
		include $abs_path."/include/payment/".$settings[payment_module];
		include_once $abs_path.'/include/classes/class.orderitem.php';
		$class_vars = module_vars($CLASS_NAME, 'payment');
		
		$returned = ($class_vars[pass_type]=="get")?$_GET:$_POST;
		
		$lango 		= $lang['order'];
		$orderinfo	= get('orders', $returned[$ADDON_SHOPOID]);
		$userinfo	= $orderinfo;
		$cart		= new cart();
		$gift_certs = array();
		
		$orderinfo[pay_method] = ($orderinfo[pay_method]=='Credit Card')?'credit_card':$orderinfo[pay_method];
		
		$results = $DB_site->query("SELECT * FROM `".$dbprefix."orders_products` where `orderid`='".$orderinfo[id]."' ORDER by `id`");
		while ($row = $DB_site->fetch_assoc($results)) {
			$cart->items[] = unserialize(base64_decode(stripslashes($row[data])));
			if ($row[productid] == '0') array_push($gift_certs, $row[data]);
		}
		
		$process = new $CLASS_NAME($class_vars);
		$data = $process->catch_return();
		
		$append = array(
			'pm_module'		=> $settings[payment_module],
			'pm_type'		=> 'payment',
			'pm_name'		=> $ADDON_NAME,
			'pm_orderid'	=> $returned[$ADDON_ORDERID],
			'pm_avs'		=> $data['addon_avs'],
			'pm_cvn'		=> $data['addon_cvn']
		);
		
		switch ($data['approved']) {
			case 'Approved':
				$append2 = array('status' => 'Pending', 'cc_status' => 'Payment Received');
				$data[orderid]	= update_order($orderinfo[id], array_merge($append, $append2), true);
				$data[result]	= $lango['order_success'];
				
				foreach ($gift_certs as $k => $v) {
					$cert = new orderitem($v); $gs->send($gs->cert_array($cert->item->options[0]));
				}
				break;
			case 'Review':
				$append2 = array('status' => 'Pending', 'cc_status' => 'Requires Review');
				$data[orderid]	= update_order($orderinfo[id], array_merge($append, $append2), true);
				$data[result] 	= $lango['order_success'];
				$data[notes]	= $lango['order_review'];
				break;
			case 'Error':
				$ae->new_error('<strong>'.$lango['pay_error'].'</strong> '.$data[error]);
				$append2 = array('status' => 'Pending', 'cc_status' => 'Error');
				$data[orderid]	= update_order($orderinfo[id], array_merge($append, $append2), false);
				$data[result]	= $lango['order_error'];
				break;
			case 'NoChange':
				$ae->new_error(($data[returned]=='notok')?'<strong>'.$lango['pay_error'].'</strong> '.$data[error]:'');
				$data[result]	= ($data[returned]=='ok')?$lango['order_success']:$lango['order_error'];
				break;
		}
		return $data;
	}
	
	function install () {
		global $DB_site, $dbprefix, $settings, $abs_path;
		
		@include $abs_path.'/lang/'.$settings[language];
		$lango = $lang['order'];
		
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='credit_card', `internalname`='enabled', `name`='Enabled', `moptions`='', `options`='0::1->Off::On', `value`='1', `help`='', `size`='0', `dorder`='1', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='credit_card', `internalname`='display_name', `name`='Display Name', `moptions`='', `options`='', `value`='Credit Card', `help`='', `size`='36', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='credit_card', `internalname`='accepted', `name`='Accepted Cards', `moptions`='".implode('::', $this->cards)."->".implode('::', $this->cards)."', `options`='', `value`='".$lango['visa']."::".$lango['mastercard']."', `help`='', `size`='200', `dorder`='3', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='credit_card', `internalname`='req_cvv2', `name`='Require CVV2', `moptions`='', `options`='1::0->Yes::No', `value`='1', `help`='', `size`='0', `dorder`='4', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='credit_card', `internalname`='store_cc', `name`='Store Card Details', `moptions`='', `options`='1::0->Yes::No', `value`='0', `help`='Credit card details will not be store on orders processed by a payment processor unless this is set on.', `size`='0', `dorder`='5', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='credit_card', `internalname`='store_cvv2', `name`='Store CVV2', `moptions`='', `options`='', `value`='', `help`='By default SunShop does not store your customers cvv2 number when doing manual processing due to laws in the USA. To enable this and release Turnkey Web Tools, Inc. of any liability you MUST type &quot;agree&quot; in the box.', `size`='5', `dorder`='6', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='credit_card', `internalname`='display_order', `name`='Display Order', `moptions`='', `options`='', `value`='1', `help`='', `size`='4', `dorder`='7', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_methods where `module`='credit_card'");
	}
	
	function safe_display ($ccnum, $char='X', $show=4) {
		if ($show > 10) $show = 10;
		if ($show < 4) $show = 4;
		for($i=0; $i<strlen($ccnum)-$show; $i++) $ccout .= $char;
		$ccout .= substr($ccnum, -$show, $show);
		return $ccout;
	}
}

?>