<?PHP
/*
  include/methods/paypal_standard.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "PayPal Standard (IPN)";
$ADDON_VERSION 	= "1.3";
$ADDON_TYPE 	= "Pay Method";
$CLASS_NAME 	= "paypal_standard";

class paypal_standard {
	var $class_vars;
	
	function paypal_standard ($class_vars) {
		global $settings;
		$this->class_vars	= $class_vars;
		$this->required		= array();
		$this->req_names	= array();
	}
	
	function render () {
		global $settings, $orderinfo, $sess;
		$sess->dvar('orderinfo'); 
		$sess->svar('orderinfo', $orderinfo);
		header('location: '.$settings[secureurl].'checkout.php?l=review');
		exit;
	}
	
	function check_required () {
		return true;
	}
	
	function pre_process () { 
		global $settings, $lang;
		$lango = $lang['order'];
		
		$display = array($lango['pay_method'] => $this->class_vars[display_name]);
		foreach ($display as $k => $v) {
			$data[payment_details] .= ($v != "")?template('order_overall_review_payment_item.html', array('item' => array('name' => $k, 'value' => $v))):"";
		}
		
		$data[form_action] = $settings[secureurl].'checkout.php?l=process';
		return $data;
	}
	
	function process () {
		global $settings, $lang, $txname, $mrb, $sess;
		$lango = $lang['order'];
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$append = array(
			'cc_status'		=> 'Awaiting Payment',
			'status'		=> 'Pending',
			'pm_name'		=> $ADDON_NAME,
			'pm_module'		=> 'paypal_standard.php',
			'pm_type'		=> 'methods',
		);
		$data[orderid]	= store_order($append);
		$data[result]	= $lango['order_success'];
		$data[notes]	= $lango['notes_paypal'];
		
		$proceed[data] = '
		<input type="hidden" name="cmd" value="_xclick">
		<input type="hidden" name="bn" value="'.$txname.'">
		<input type="hidden" name="mrb" value="'.$mrb.'">
		<input type="hidden" name="rm" value="2">
		<input type="hidden" name="invoice" value="'.$sess->gvar('userid').'-'.$data[orderid].'">
		<input type="hidden" name="currency_code" value="'.$settings[defaultrate].'">
		<input type="hidden" name="notify_url" value="'.$settings[shopurl].'include/methods/paypal_ipn/paypal_ipn.php">
		<input type="hidden" name="business" value="'.$this->class_vars[paypal_email].'">
		<input type="hidden" name="item_name" value="'.$settings[title].' Order #: '.$data[orderid].'">
		<input type="hidden" name="item_number" value="User ID: '.$sess->gvar('userid').'">
		<input type="hidden" name="amount" value="'.p($orderinfo[total], false).'">
		<input type="hidden" name="tax" value="0">
		<input type="hidden" name="shipping" value="0">
		<input type="hidden" name="return" value="'.$settings[shopurl].'index.php?cc=1">
		<input type="hidden" name="cancel_return" value="'.$settings[shopurl].'">';
		$proceed[url] = $this->class_vars[url];
		$data[form] = template('order_payment_proceed.html', array('proceed' => $proceed, 'lang' => $lango));
		
		return $data;
	}
	
	function send_reminder ($order) {
		global $DB_site, $dbprefix, $settings, $txname, $mrb, $sess, $abs_path; 
		@include_once($abs_path."/lang/".$settings[language]);
		
		$order['datestamp'] = date($settings[datestamp].' '.$settings[timestamp], $order[order_stamp]);
		$order['paypal_url'] = 'https://www.paypal.com/cgi-bin/webscr?cmd=_xclick&business='.urlencode($this->class_vars[paypal_email]).'&invoice='.urlencode($order['userid'].'-'.$order[id]).'&item_name='.urlencode($settings[title].' Order #: '.$order[id]).'&item_number='.urlencode('User ID: '.$order['userid']).'&currency_code='.urlencode($settings[defaultrate]).'&bn='.urlencode($txname).'&mbr='.urlencode($mrb).'&rm=2&notify_url='.urlencode($settings[shopurl].'include/methods/paypal_ipn/paypal_ipn.php').'&amount='.urlencode($order[total]).'&tax=0&shipping=0&return='.urlencode($settings[shopurl].'index.php?cc=1').'&charset=UTF%2d8';
		
		foreach ($order as $k => $v) if ($v == "" || (is_numeric($v) && p($v) == p(0))) $hide[] = $k;
		$price_arrays = array('ship_price', 'tax', 'subtotal', 'discount', 'total', 'coupon_savings', 'gift_cert_savings');
		foreach ($price_arrays as $v) $order[$v] = p($order[$v]);
				
		$results = $DB_site->query("SELECT * FROM `".$dbprefix."orders_products` where `orderid`='".$order[id]."' ORDER by `id`");
		while ($row = $DB_site->fetch_assoc($results)) {
			$item = new orderitem($row[data]);
			$product = unserialize(base64_decode($row[item]));
			$product[price] 	= $row[price]+$item->options_price_increase();
			$product[quantity]	= $item->item->quantity;
			$product[subtotal]	= p($item->item->quantity*$product[price]);
			$product[price]		= p($product[price]);
			$product[options]	= $item->display_options();
			$order[items] .= template_client('email_order_confirmation_item.html', array('product' => $product, 'lang' => $lang['order']));
		}
		$email = template_client('email_order_paypal_reminder.html', array('order' => $order, 'lang' => $lang['order'], 'hide' => $hide));
		mail_send($order[email], $order[bill_first_name].' '.$order[bill_last_name], $lang['order']['email_order_subject'].': Payment Reminder', $email, $settings[contactemail], $settings[title], true);
		return 'Email has been sent successfully.';
	}
	
	function load_actions () {
		$map_actions = array (
			'PayPal: Send Payment Reminder' => 'send_reminder'
		);
		return $map_actions;
	}
	
	function install () {
		global $DB_site, $dbprefix, $settings;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='paypal_standard', `internalname`='enabled', `name`='Enabled', `moptions`='', `options`='0::1->Off::On', `value`='1', `help`='', `size`='0', `dorder`='1', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='paypal_standard', `internalname`='display_name', `name`='Display Name', `moptions`='', `options`='', `value`='PayPal (Via PayPal Site)', `help`='', `size`='36', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='paypal_standard', `internalname`='paypal_email', `name`='PayPal Email Address', `moptions`='', `options`='', `value`='', `help`='', `size`='36', `dorder`='3', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='paypal_standard', `internalname`='url', `name`='Transaction URL', `moptions`='', `options`='', `value`='https://www.paypal.com/cgi-bin/webscr', `help`='', `size`='36', `dorder`='4', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='paypal_standard', `internalname`='display_order', `name`='Display Order', `moptions`='', `options`='', `value`='1', `help`='', `size`='4', `dorder`='5', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_methods where `module`='paypal_standard'");
	}
}

?>