<?PHP
/*
  include/methods/purchase_order.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "Purchase Order";
$ADDON_VERSION 	= "1.1";
$ADDON_TYPE 	= "Pay Method";
$CLASS_NAME 	= "purchase_order";

class purchase_order {
	var $class_vars;
	
	function purchase_order ($class_vars) {
		global $settings, $lang;
		$lango = $lang['order'];
		
		$this->class_vars	= $class_vars;
		$this->required		= array('po_number', 'po_company');
		$this->req_names	= array($lango['po_number'], $lango['po_company']);
	}
	
	function render () {
		global $DB_site, $dbprefix, $order, $sess, $lang, $orderinfo;
		
		if (p($orderinfo[total]) == p(0)) {
			$sess->dvar('orderinfo'); 
			$sess->svar('orderinfo', $orderinfo);
			header('location: '.$settings[secureurl].'checkout.php?l=review');
			exit;
		}
		
		return template('order_payment_purchase_order.html', array('lang' => $lang['order'], 'orderinfo' => $orderinfo));
	}
	
	function check_required () {
		global $abs_path, $lang;
		$lango = $lang['order'];
		foreach ($this->required as $k => $v)
			if ($_POST[order][$v] == "") 
				return template('misc_error_alert.html', array('error' => array('message' => "'".$this->req_names[$k]."'".$lango['is_required'])));
	}
	
	function pre_process () { 
		global $settings, $lang, $sess, $orderinfo;
		$lango = $lang['order'];
		
		$display = array(
			$lango['pay_method'] 	=> $this->class_vars[display_name],
			$lango['po_number'] 	=> $orderinfo[po_number],
			$lango['po_company']	=> $orderinfo[po_company]
		);
		foreach ($display as $k => $v) {
			$data[payment_details] .= ($v != "")?template('order_overall_review_payment_item.html', array('item' => array('name' => $k, 'value' => $v))):"";
		}
		
		$data[form_action] = $settings[secureurl].'checkout.php?l=process';
		return $data;
	}
	
	function process () {
		global $settings, $lang;
		$lango = $lang['order'];
		$append = array(
			'cc_status'		=> 'Awaiting Payment',
			'status'		=> 'Pending'
		);
		$data[orderid]	= store_order($append);
		$data[result]	= $lango['order_success'];
		$data[notes]	= $lango['notes_po'];
		return $data;
	}
	
	function install () {
		global $DB_site, $dbprefix, $settings;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='purchase_order', `internalname`='enabled', `name`='Enabled', `moptions`='', `options`='0::1->Off::On', `value`='1', `help`='', `size`='0', `dorder`='1', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='purchase_order', `internalname`='display_name', `name`='Display Name', `moptions`='', `options`='', `value`='Purchase Order', `help`='', `size`='36', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_methods set `module`='purchase_order', `internalname`='display_order', `name`='Display Order', `moptions`='', `options`='', `value`='1', `help`='', `size`='4', `dorder`='3', `field_type`='textbox'");
		
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_methods where `module`='purchase_order'");
	}
}

?>