<?PHP
/*
  include/payment/beanstream.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "TD Canada Trust Online Mart (BeanStream)";
$ADDON_VERSION 	= "2.1";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "beanstream";

class beanstream {
	var $class_vars;
	
	function beanstream ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function process () {
		global $cconnect, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$orderinfo[invoiceid] = $sess->gvar('userid')."-".date("mdyHis");
		
		$data = array (
			'requestType'		=> 'BACKEND',
			'merchant_id'		=> $this->class_vars[merchid],
			'trnType'			=> 'P',
			'trnCardOwner'		=> $orderinfo[cc_name_on_card],
			'trnCardNumber'		=> tempdecryptit($orderinfo[cc_card_no]),
			'trnExpMonth'		=> str_pad($orderinfo[cc_expir_month], 2, "0", STR_PAD_LEFT),
			'trnExpYear'		=> substr($orderinfo[cc_expir_year], 2, 2),
			'trnCardCvd'		=> $orderinfo[cc_cvv2],
			'trnOrderNumber'	=> $orderinfo[invoiceid],
			'trnAmount'			=> p($orderinfo[total], false),
			'ordEmailAddress'	=> $userinfo[email],
			'ordName'			=> $userinfo[bill_first_name]." ".$userinfo[bill_last_name],
			'ordPhoneNumber'	=> $userinfo[phone],
			'ordAddress1'		=> $userinfo[bill_address1],
			'ordAddress2'		=> $userinfo[bill_address2],
			'ordCity'			=> $userinfo[bill_city],
			'ordProvince'		=> (($userinfo[bill_state]=='')?$userinfo[bill_other]:substr($userinfo[bill_state], 0, 2)),
			'ordPostalCode'		=> $userinfo[bill_zip],
			'ordCountry'		=> $userinfo[bill_country]
		);
		
		foreach ($data as $k => $v) {
			$data_string .= $k.'='.$v.'&';
		}
		
		$header_array = array(
			"POST / HTTP/1.0",
		    "Content-type: application/x-www-form-urlencoded",
		    "Content-length: ".strlen($data_string)
		);
		
		$header = "POST / HTTP/1.0\r\n".
			"Content-Type: application/x-www-form-urlencoded\r\n".
			"Content-Length: " . strlen ($data_string) . "\r\n\r\n";
		
		$results = $cconnect->connect($data_string, $header, $header_array, $this->class_vars[url]);
		$auth	 = $this->parse_return($results);
		
		$auth["addon_message"] 	= $auth["messageText"];
		$auth["addon_code"]		= $auth["messageId"];
		$auth["addon_oid"] 		= $auth["trnId"];
		
		if ($auth["trnApproved"] == 1) {
			$auth["approved"] = "Approved";
		} else {
			$auth["approved"] = "Error";
		}
		
		return $auth;
	}
	
	function parse_return ($in) {
		$result_decoded = urldecode($in);
	    $temp_array = split('&',$result_decoded);
	    foreach ($temp_array as $entry) {
	        list($name,$value) = split('=',$entry);
	        $transaction_array[$name] = $value;
	    }
		
		return $transaction_array;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='beanstream', `internalname`='merchid', `name`='Merchant ID', `options`='', `value`='', `help`='Your assigned merchant ID', `size`='0', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='beanstream', `internalname`='url', `name`='Transaction URL', `options`='', `value`='https://www.beanstream.com/scripts/process_transaction.asp', `help`='Transaction URL', `size`='60', `dorder`='4', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='beanstream'");
	}
}
?>
