<?PHP
/*
  include/payment/citibank.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "Citibank CitiPayGate Direct Link";
$ADDON_VERSION 	= "2.2";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "citibank";

$ADDON_SHOPOID	= "OrderID";
$ADDON_ORDERID	= "OrderID";

class citibank {
	var $class_vars;
	var $carttot;
	var $cartinfo = array();
	
	function citibank ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function pass_cart ($cartinfo) {
		for ($i=0; $i<count($cartinfo); $i++) {
			$num = $i+1;
			$this_array = array (
				'ItemUnitPrice'.$num	=> str_pad(str_replace(".","",$cartinfo[$i][price]), 12, "0", STR_PAD_LEFT),
				'ItemDescription'.$num	=> trim($cartinfo[$i][items]),
				'ItemQuantity'.$num		=> $cartinfo[$i][quantity]
			);
			$this->cartinfo = array_merge($this->cartinfo, $this_array);
		}
		$this->carttot = $num;
	}
	
	function hold_forward () {
		global $sess, $settings;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$append = array(
			'pm_name'			=> 'Citibank CitiPayGate Direct Link',
			'status' 			=> 'Pending',
			'cc_status' 		=> 'Awaiting Payment',
			'cc_name_on_card' 	=> ($this->class_vars[store_cc])?$orderinfo[cc_name_on_card]:'',
			'cc_card_no' 		=> ($this->class_vars[store_cc])?$orderinfo[cc_card_no]:'',
			'cc_card_type' 		=> ($this->class_vars[store_cc])?$orderinfo[cc_card_type]:'',
			'cc_cvv2'			=> ($this->class_vars[store_cc] && $this->class_vars[store_cvv2]=='agree')?$orderinfo[cc_cvv2]:'',
			'cc_expir_date'		=> ($this->class_vars[store_cc])?$orderinfo[cc_expir_month].'/'.$orderinfo[cc_expir_year]:'',
			'cc_start_date'		=> ($this->class_vars[store_cc] && ($orderinfo[cc_card_type] == $lango['solo'] || $orderinfo[cc_card_type] == $lango['switch']))?$orderinfo[cc_start_month].'/'.$orderinfo[cc_start_year]:'',
			'cc_issue_number'	=> ($this->class_vars[store_cc] && ($orderinfo[cc_card_type] == $lango['solo'] || $orderinfo[cc_card_type] == $lango['switch']))?$orderinfo[cc_issue_number]:'',
		);
		$orderid = store_order($append, '', false);
		
		$orderinfo[total] = str_replace(".", "", p($orderinfo[total], false));
		$orderinfo[total] = str_pad($orderinfo[total], 12, "0", STR_PAD_LEFT);
		
		$hash_string = $this->class_vars[password].$this->class_vars[merchant_id].$this->class_vars[aquirer_id].$orderinfo[orderid].p($orderinfo[total], false).$this->ccode($settings[defaultrate]);
		$hash = mhash(MHASH_SHA1, $hash_string);
		$this->signature = base64_encode($hash);
		
		$data = array (
			'MerID'						=> $this->class_vars[merchant_id],
			'AcqID'						=> $this->class_vars[aquirer_id],
			'MerRespURL'				=> $settings[secureurl].'checkout.php?return=credit_card',
			'CardNo'					=> tempdecryptit($orderinfo[cc_card_no]),
			'CardCVV2'					=> $orderinfo[cc_cvv2],
			'CardExpDate'				=> str_pad($orderinfo[cc_expir_month], 2, "0", STR_PAD_LEFT).substr($orderinfo[cc_expir_year], 2, 2),
			'Version'					=> '1.0.0',
			'PurchaseCurrencyExponent'	=> '2',
			'CaptureFlag'				=> 'A',
			'OrdersDetails'				=> 'Y',
			'IsItemised'				=> 'Y',
			'SignatureMethod'			=> 'SHA1',
			'Signature'					=> $this->signature,
			'NoOfItems'					=> $this->carttot,
			'PurchaseCurrency'			=> $this->ccode($settings[defaultrate]),
			'OrderID'					=> $orderid,
			'CustomerID'				=> $sess->gvar('userid'),
			'PurchaseAmt'				=> p($orderinfo[total], false),
		/*	'TestFlag'					=> $this->class_vars[test_mode], */
		);
		
		$data = array_merge($data, $this->cartinfo);
		
		foreach ($data as $k => $v) $out[payment_tags] .= '<input type="hidden" name="'.$k.'" id="'.$k.'" value="'.$v.'"/>'."\n";
		
		$out[url] = $this->class_vars[url];
		$out[method] = "POST";
		
		return $out;
	}
	
	function catch_return () {
		global $userinfo, $orderinfo;
		$orderinfo[total] = str_replace(".", "", p($orderinfo[total], false));
		$orderinfo[total] = str_pad($orderinfo[total], 12, "0", STR_PAD_LEFT);
		$hash_string = $this->class_vars[password].$this->class_vars[merchant_id].$this->class_vars[aquirer_id].$orderinfo[id].$_POST['ResponseCode'].$_POST['ReasonCode'];
		$hash = mhash(MHASH_SHA1, $hash_string);
		$this->signature = base64_encode($hash);
		
		if ($_POST['ResponseCode'] == 1 && $this->signature == $_POST[Signature]) {
			$results['approved'] = "Approved";
		} else {
			$results['approved'] = "Error";
			$results[error] = $_POST['ReasonCodeDesc'].' Please contact us to see if the order was processed successfully.';
		}
		return $results;
	}
	
	function ccode ($cc) {
		$codes = array (
			"AUD" => "036",
			"BND" => "096",
			"EUR" => "978",
			"HKD" => "344",
			"JPY" => "392",
			"MYR" => "458",
			"NZD" => "554",
			"SGD" => "702",
			"TWD" => "901",
			"THB" => "764",
			"GBP" => "826",
			"USD" => "840",
		);
		return $codes[$cc];
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='citibank', `internalname`='merchant_id', `name`='CitiPayGate ID', `options`='', `value`='', `help`='Your assigned citibank id.', `size`='0', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='citibank', `internalname`='aquirer_id', `name`='Aquirer ID', `options`='', `value`='', `help`='Your assigned citibank aquirer id.', `size`='0', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='citibank', `internalname`='password', `name`='CitiPayGate Password', `options`='', `value`='', `help`='Your citibank password.', `size`='0', `dorder`='3', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='citibank', `internalname`='url', `name`='Transaction URL', `options`='', `value`='https://testuat.financial-link.com.my/SENTRY/PaymentGateway/Application/DirectAuthLink.aspx', `help`='Transaction url. Leave to default if unless needed.', `size`='60', `dorder`='4', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='citibank', `internalname`='test_mode', `name`='Test Mode', `options`='True::False->True::False', `value`='True', `help`='Set to this value for testing mode. Set to \"False\" for LIVE.', `size`='0', `dorder`='5', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='citibank', `internalname`='pass_cart', `name`='', `options`='', `value`='1', `help`='', `size`='0', `dorder`='', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='citibank'");
	}
}
?>
