<?PHP
/*
  include/payment/eprocessingnetwork.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "eProcessing Network";
$ADDON_VERSION 	= "2.1";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "eprocessingnetwork";

class eprocessingnetwork {
	var $class_vars;
	
	function eprocessingnetwork ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function process () {
		global $cconnect, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$data = array (
			'ePNAccount'	=> $this->class_vars[authuser],
			'Address'		=> $userinfo[bill_address1],
			'Zip'			=> $userinfo[bill_zip],
			'EMail'			=> $userinfo[email],
			'CVV2Type'		=> '1',
			'CardNo'		=> tempdecryptit($orderinfo[cc_card_no]),
			'CVV2'			=> $orderinfo[cc_cvv2],
			'ExpMonth'		=> $orderinfo[cc_expir_month],
			'ExpYear'		=> substr($orderinfo[cc_expir_year], 2, 2),
			'Total'			=> p($orderinfo[total], false),
			'HTML'			=> 'No'
		);
		
		foreach ($data as $k => $v) {
			$data_string .= $k.'='.$v.'&';
		}
		
		$header_array = array(
			"POST / HTTP/1.0",
		    "Content-type: application/x-www-form-urlencoded",
		    "Content-length: ".strlen($data_string)
		);
		
		$header = "POST / HTTP/1.0\r\n".
			"Content-Type: application/x-www-form-urlencoded\r\n".
			"Content-Length: " . strlen ($data_string) . "\r\n\r\n";
		
		$results = $cconnect->connect($data_string, $header, $header_array, $this->class_vars[authurl]);
		$auth	 = $this->parse_return($results);
		
		$auth["addon_message"] 	= $auth["x_response_subcode"];
		$auth["addon_code"]		= "";
		$auth["addon_oid"] 		= $auth["x_response_subcode"];
		
		if ($auth["x_response_code"] == "Y") {
			$auth["approved"] = "Approved";
		} else {
			$auth["approved"] = "Error";
		}
		
		return $auth;
	}
	
	function parse_return ($in) {
		$remaining 	= str_replace("\"", "", trim($in));
		$split	 	= explode(",", $remaining);
		$auth		= substr($split[0], 0, 1);
		$auth2		= substr($split[0], 1);
		
		$out = array(
			"x_response_code"		=> "$auth",
			"x_response_subcode"	=> "$auth2",
			"x_response_avs_code"	=> "$split[1]",
			"x_response_cvv2_code"	=> "$split[2]"
		);
		
		return $out;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='eprocessingnetwork', `internalname`='authuser', `name`='Merchant Login', `options`='', `value`='', `help`='Your assigned merchant login ID.', `size`='0', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='eprocessingnetwork', `internalname`='authurl', `name`='Transaction URL', `options`='', `value`='https://www.eProcessingNetwork.com/cgi-bin/tdbe/transact.pl', `help`='Transaction url. Leave to default if unless needed.', `size`='60', `dorder`='2', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='eprocessingnetwork'");
	}
}
?>
