<?PHP
/*
  include/payment/eway_xml.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "eWay XML Payment";
$ADDON_VERSION 	= "1.0";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "eway_xml";

class eway_xml {
	var $class_vars;
	
	function eway_xml ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function process () {
		global $cconnect, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$oid = $sess->gvar('userid')."-".date("mdyHis");
		
		$data  = "<ewaygateway>";
		$data .= "<ewayCustomerID>".$this->class_vars[merchid]."</ewayCustomerID>";
		$data .= "<ewayTotalAmount>".(100*p($orderinfo[total], false))."</ewayTotalAmount>";
		$data .= "<ewayCustomerFirstName>".$userinfo[bill_first_name]."</ewayCustomerFirstName>";
		$data .= "<ewayCustomerLastName>".$userinfo[bill_last_name]."</ewayCustomerLastName>";
		$data .= "<ewayCustomerEmail>".$userinfo[email]."</ewayCustomerEmail>";
		$data .= "<ewayCustomerAddress>".$userinfo[bill_address1]."</ewayCustomerAddress>";
		$data .= "<ewayCustomerPostcode>".$userinfo[bill_zip]."</ewayCustomerPostcode>";
		$data .= "<ewayCustomerInvoiceDescription></ewayCustomerInvoiceDescription>";
		$data .= "<ewayCustomerInvoiceRef>".$oid."</ewayCustomerInvoiceRef>";
		$data .= "<ewayCardHoldersName>".$orderinfo[cc_name_on_card]."</ewayCardHoldersName>";
		$data .= "<ewayCardNumber>".tempdecryptit($orderinfo[cc_card_no])."</ewayCardNumber>";
		$data .= "<ewayCardExpiryMonth>".substr($orderinfo[cc_expir_month],0,2)."</ewayCardExpiryMonth>";
		$data .= "<ewayCardExpiryYear>".substr($orderinfo[cc_expir_year],2,2)."</ewayCardExpiryYear>";
		$data .= "<ewayCVN>".$orderinfo[cc_cvv2]."</ewayCVN>";
		$data .= "<ewayTrxnNumber></ewayTrxnNumber>";
		$data .= "<ewayOption1></ewayOption1>";
		$data .= "<ewayOption2></ewayOption2>";
		$data .= "<ewayOption3></ewayOption3>";
		$data .= "</ewaygateway>";
		
		$header_array = array(
			"POST / HTTP/1.0",
		    "Content-type: application/x-www-form-urlencoded",
		    "Content-length: " . strlen($data)
		);
		
		$header = "POST / HTTP/1.0\r\n".
			"Content-Type: application/x-www-form-urlencoded\r\n".
			"Content-Length: " . strlen($data) . "\r\n\r\n";
		
		$results = $cconnect->connect($data, $header, $header_array, $this->class_vars[url]);
		$auth	 = $this->parse_return($results);
		
		//debug($auth);
		
		$auth["addon_message"] 	= $auth[ewayTrxnError];
		$auth["addon_code"]		= "";
		$auth["addon_oid"] 		= $auth[ewayTrxnNumber];
		
		if ($auth[ewayTrxnStatus] == "True") {
			$auth["approved"] = "Approved";
		} else {
			$auth["approved"] = "Error";
		}
		
		return $auth;
	}
	
	function parse_return ($in) {
		$attributes = array();
		$attributes = XMLParser($in);
		
		reset($attributes);
		while (list ($key, $val) = each ($attributes)) {
			$name = $val['tag']; $value = $val['value'];
			$out[$name] = $value;
		}
		return $out;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='eway_xml', `internalname`='merchid', `name`='Merchant ID', `options`='', `value`='', `help`='Your eWay merchant ID', `size`='20', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='eway_xml', `internalname`='url', `name`='Transaction URL', `options`='', `value`='https://www.eway.com.au/gateway_cvn/xmlpayment.asp', `help`='eWay Transaction URL', `size`='60', `dorder`='2', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='eway_xml'");
	}
}
?>
