<?PHP
/*
  include/payment/netbilling_directmode.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "Netbilling Direct Mode";
$ADDON_VERSION 	= "2.1";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "netbiling_directmode";

class netbiling_directmode {
	var $class_vars;
	
	function netbiling_directmode ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function process () {
		global $settings, $cconnect, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$oid = $sess->gvar('userid')."-".date("mdyHis");
		
		$data = array (
			'account_id'		=> $this->class_vars[account_id],
			
			'bill_name1'		=> $userinfo[bill_first_name],
			'bill_name2'		=> $userinfo[bill_last_name],
			'cust_phone'		=> $userinfo[phone],
			'bill_street'		=> $userinfo[bill_address1],
			'bill_city'			=> $userinfo[bill_city],
			'bill_state'		=> (($userinfo[bill_state]=='')?$userinfo[bill_other]:substr($userinfo[bill_state], 0, 2)),
			'bill_zip'			=> $userinfo[bill_zip],
			'bill_country'		=> $userinfo[bill_country],
			'cust_email'		=> $userinfo[email],
			'cust_ip'			=> $_SERVER['REMOTE_ADDR'],
			
			'pay_type'			=> 'C',
			'tran_type'			=> 'S',
			'card_number'		=> tempdecryptit($orderinfo[cc_card_no]),
			'card_cvv2'			=> $orderinfo[cc_cvv2],
			'card_expire'		=> $orderinfo[cc_expir_month].substr($orderinfo[cc_expir_year], 2, 2),
			
			'amount'			=> p($orderinfo[total], false),
			'user_data'			=> 'Customer-Number:'.$sess->gvar('userid'),
			'trans_id'			=> $oid,
			'description'		=> $settings[title]."%20Order%20Payment",
			
			'ship_name1'		=> $userinfo[ship_first_name],
			'ship_name2'		=> $userinfo[ship_last_name],
			'ship_street'		=> $userinfo[ship_address1],
			'ship_city'			=> $userinfo[ship_city],
			'ship_state'		=> (($userinfo[ship_state]=='')?$userinfo[shipl_other]:substr($userinfo[ship_state], 0, 2)),
			'ship_zip'			=> $userinfo[ship_zip],
			'ship_country'		=> $userinfo[ship_country]
		);
		
		foreach ($data as $k => $v) {
			$data_string .= $k.'='.$v.'&';
		}
		
		$header_array = array(
			"POST / HTTP/1.0",
		    "Content-type: application/x-www-form-urlencoded",
		    "Content-length: ".strlen($data_string)
		);
		
		$header = "POST / HTTP/1.0\r\n".
			"Content-Type: application/x-www-form-urlencoded\r\n".
			"Content-Length: " . strlen ($data_string) . "\r\n\r\n";
		
		$results = $cconnect->connect($data_string, $header, $header_array, $this->class_vars[authurl]);
		$authnet = $this->parse_return($results);
		
		$authnet["addon_message"] 	= $authnet["auth_msg"]." ".$authnet["reason_code2"];
		$authnet["addon_code"]		= $authnet["status_code"];
		$authnet["addon_oid"] 		= $authnet["trans_id"];
		
		if ($authnet["addon_code"] == 1 || $authnet["addon_code"] == "T") {
			$authnet["approved"] = "Approved";
		} else {
			$authnet["approved"] = "Error";
		}
		
		return $authnet;
	}
	
	function parse_return ($in) {
		$out = explode("&", $in);
		for ($i=0; $i < count($out); $i++) {
			$val = explode("=", $out[$i]);
			$return[$val[0]] = urldecode($val[1]);
		}
		return $return;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='netbiling_directmode', `internalname`='account_id', `name`='Account ID', `options`='', `value`='', `help`='This is the number of your merchant or agent account, as a 12 digit string. Required for all transactions.', `size`='20', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='netbiling_directmode', `internalname`='authurl', `name`='Transaction URL', `options`='', `value`='https://secure.netbilling.com:1402/gw/sas/direct3.1', `help`='Transaction url. Leave default if you are unsure.', `size`='60', `dorder`='2', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='netbiling_directmode'");
	}
}
?>