<?PHP
/*
  include/payment/paymentech.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "Paymentech (Orbital Gateway)";
$ADDON_VERSION 	= "2.3";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "paymentech";

class paymentech {
	var $class_vars;
	
	function paymentech ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function process () {
		global $cconnect, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$oid = date("mdyHis")."0000";
		$data = '
		<Request>
			<AC>
				<CommonData>
					<CommonMandatory AuthOverrideInd="N" LangInd="00" CardHolderAttendanceInd="01" HcsTcsInd="T" TxCatg="7" MessageType="AC" Version="2" TzCode="705">
						<AccountNum AccountTypeInd="91">'.tempdecryptit($orderinfo[cc_card_no]).'</AccountNum>
						<POSDetails POSEntryMode="01"/>
						<MerchantID>'.$this->class_vars[ptmerchid].'</MerchantID>
						<TerminalID TermEntCapInd="05" CATInfoInd="06" TermLocInd="01" CardPresentInd="N" POSConditionCode="59" AttendedTermDataInd="01">001</TerminalID>
						<BIN>'.$this->class_vars[ptbin].'</BIN>
						<OrderID>'.$oid.'</OrderID>
						<AmountDetails>
							<Amount>'.str_replace(".","",p($orderinfo[total], false)).'</Amount>
						</AmountDetails>
						<TxTypeCommon TxTypeID="G"/>
						<Currency CurrencyCode="840" CurrencyExponent="2"/>
						<CardPresence>
							<CardNP>
								<Exp>'.str_pad($orderinfo[cc_expir_month], 2, "0", STR_PAD_LEFT).substr($orderinfo[cc_expir_year], 2, 2).'</Exp>
							</CardNP>
						</CardPresence>
						<TxDateTime/>
					</CommonMandatory>
					<CommonOptional>
						<Comments>User ID #'.$sess->gvar('userid').' Payment</Comments>
						<ShippingRef></ShippingRef>
						<CardSecVal CardSecInd="1">'.$orderinfo[cc_cvv2].'</CardSecVal>
						<ECommerceData ECSecurityInd="07">
							<ECOrderNum>'.$oid.'</ECOrderNum>
						</ECommerceData>
					</CommonOptional>
				</CommonData>
				<Auth>
					<AuthMandatory FormatInd="H"/>
					<AuthOptional>
						<AVSextended>
							<AVSname>'.$userinfo[bill_first_name].' '.$userinfo[bill_last_name].'</AVSname>
							<AVSaddress1>'.$userinfo[bill_address1].'</AVSaddress1>
							<AVSaddress2>'.$userinfo[bill_address2].'</AVSaddress2>
							<AVScity>'.$userinfo[bill_city].'</AVScity>
							<AVSstate>'.(($userinfo[bill_state]=='')?$userinfo[bill_other]:substr($userinfo[bill_state], 0, 2)).'</AVSstate>
							<AVSzip>'.$userinfo[bill_zip].'</AVSzip>
						</AVSextended>
					</AuthOptional>
				</Auth>
				<Cap>
					<CapMandatory>
						<EntryDataSrc>02</EntryDataSrc>
					</CapMandatory>
					<CapOptional/>
				</Cap>
			</AC>
		</Request>';
		
		$header_array = array(
			"POST /AUTHORIZE HTTP/1.0",
			"MIME-Version: 1.0",
			"Content-type: application/PTI34",
			"Content-length: ".strlen($data),
			"Content-transfer-encoding: text",
			"Request-number: 1",
			"Document-type: Request",
			"Interface-Version: Test 1.4"
		);
		
		$header = "POST /AUTHORIZE HTTP/1.0\r\n";
		$header .= "Content-type: application/PTI34\r\n";
		$header .= "Content-transfer-encoding: text\r\n";
		$header .= "Request-number: 1\r\n";
		$header .= "Document-type: Request\r\n";
		$header .= "Interface-Version: Test 1.4\r\n";
		$header .= "Content-Length: ".strlen($data)."\r\n\r\n";
		
		$results = $cconnect->connect($data, $header, $header_array, $this->class_vars[pturl]);
		
		$auth	 = $this->parse_return($results);
		
		$result["addon_message"] 	= $auth["StatusMsg"];
		$result["addon_code"]		= $auth["ProcStatus"];
		$result["addon_oid"] 		= $auth["TxRefNum"];
		
		if ($auth[ProcStatus] == 0 && $auth[ApprovalStatus] == 1) {
			$result["approved"] = "Approved";
		} else {
			$result["approved"] = "Error";
		}
		
		return $result;
	}
	
	function parse_return ($in) {
		$attributes = array();
		$attributes = XMLParser($in);
		
		reset($attributes);
		while (list ($key, $val) = each ($attributes)) {
			$name = $val['tag']; $value = $val['value'];
			$results[$name] = $value;
		}
		
		return $results;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='paymentech', `internalname`='ptmerchid', `name`='Merchant Login', `options`='', `value`='', `help`='Your assigned merchant login ID.', `size`='0', dorder='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='paymentech', `internalname`='ptbin', `name`='Merchant BIN', `options`='', `value`='000002', `help`='Your assigned BIN.', `size`='0', dorder='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='paymentech', `internalname`='pturl', `name`='Transaction Mode', `options`='https://orbital1.paymentech.net/authorize::https://orbitalvar1.paymentech.net/authorize->Live Mode::Test Mode', `value`='https://orbitalvar1.paymentech.net/authorize', `help`='Transaction mode. Set to live mode when you are ready to go live.', `size`='0', dorder='3', `field_type`='dropdown'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='paymentech'");
	}
}
?>
