<?PHP
/*
  include/payment/plugnpay.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "Plug n Pay";
$ADDON_VERSION 	= "2.1";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "plugnpay";

class plugnpay {
	var $class_vars;
	
	function plugnpay ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function process () {
		global $cconnect, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		/**** Login Information ****/
		$data   = "publisher-name=".$this->class_vars[Uname]."&";
		$data  .= "publisher-email=".$this->class_vars[Uemail]."&";
		
		/**** Contact Information ****/
		$data .= "card-address1=".$userinfo[bill_address1]."&";
		$data .= "card-address2=".$userinfo[bill_address2]."&";
		$data .= "card-city=".$userinfo[bill_city]."&";
		$data .= "card-state=".(($userinfo[bill_state]=='')?$userinfo[bill_other]:substr($userinfo[bill_state], 0, 2))."&";
		$data .= "card-zip=".$userinfo[bill_zip]."&";
		$data .= "card-country=".$userinfo[bill_country]."&";
		$data .= "email=".$userinfo[email]."&";
		
		/**** Credit Card Information ****/ 
		$data .= "card-name=".$orderinfo[cc_name_on_card]."&";
		$data .= "card-number=".tempdecryptit($orderinfo[cc_card_no])."&";
		$data .= "card-cvv=".$orderinfo[cc_cvv2]."&";
		$data .= "card-exp=".$orderinfo[cc_expir_month].substr($orderinfo[cc_expir_year], 2, 2)."&";
		
		/**** Transaction Information ****/ 
		$data .= "mode=auth&";
		$data .= "authtype=authpostauth&";
		$data .= "dontsndmail=yes&";
		$data .= "order-id=".$sess->gvar('userid')."&";
		$data .= "card-amount=".p($orderinfo[total], false);
		
		$header_array = array(
			"POST / HTTP/1.0",
		    "Content-type: application/x-www-form-urlencoded",
		    "Content-length: ".strlen($data)
		);
		
		$header = "POST / HTTP/1.0\r\n".
			"Content-Type: application/x-www-form-urlencoded\r\n".
			"Content-Length: " . strlen ($data) . "\r\n\r\n";
		
		$results = $cconnect->connect($data, $header, $header_array, $this->class_vars[url]);
		$auth	 = $this->parse_return($results);
		
		$result["addon_message"] 	= $auth["MErrMsg"];
		$result["addon_code"]		= $auth["resp-code"];
		$result["addon_oid"] 		= $auth["orderID"];
		
		if ($auth['FinalStatus'] == "success") {
			$result["approved"] = "Approved";
		} else {
			$result["approved"] = "Error";
		}
		
		return $result;
	}
	
	function parse_return ($in) {
		$pnp_result_decoded = urldecode($in);
	    $pnp_temp_array = split('&',$pnp_result_decoded);
	    foreach ($pnp_temp_array as $entry) {
	        list($name,$value) = split('=',$entry);
	        $pnp_transaction_array[$name] = $value;
	    }
		
		return $pnp_transaction_array;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='plugnpay', `internalname`='Uname', `name`='Merchant Login', `options`='', `value`='', `help`='Username issued by Plug\'n Pay to you at time of sign-up.', `size`='0', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='plugnpay', `internalname`='Uemail', `name`='Merchant Email Address', `options`='', `value`='', `help`='Address where order confirmation is sent.  This is also the return address for email sent to customer.', `size`='0', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='plugnpay', `internalname`='url', `name`='Transaction URL', `options`='', `value`='https://pay1.plugnpay.com/payment/pnpremote.cgi', `help`='Transaction url. Leave to default if unless needed.', `size`='60', `dorder`='3', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='plugnpay'");
	}
}
?>
