<?PHP
/*
  include/payment/secpay.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "SECPay";
$ADDON_VERSION 	= "2.1";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "secpay";

class secpay {
	var $class_vars;
	
	function secpay ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function process () {
		global $cconnect, $settings, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$oid = $sess->gvar('userid').date("mdyHis");
		
		switch ($payment[card_type]) { 
			case "VisaCard":	$ctype = "Visa"; 				break;
			case "MasterCard":	$ctype = "Master Card"; 		break;
			case "AmExCard":	$ctype = "American Express";	break;
			case "Other":		$ctype = "Switch"; 				break;
			case "SO":			$ctype = "Solo"; 				break;
			case "Diners":		$ctype = "Diners"; 				break;
			case "JCB":			$ctype = "JCB"; 				break;
		}
		
		$request = array(
			"merchant" 			=> $this->class_vars[merchant],
			"trans_id" 			=> $oid,
			"currency"			=> $settings[defaultrate],
			"bill_addr_1" 		=> $userinfo[bill_address1],
			"bill_addr_2" 		=> $userinfo[bill_address2],
			"bill_city"			=> $userinfo[bill_city],
			"bill_state" 		=> (($userinfo[bill_state]=='')?$userinfo[bill_other]:substr($userinfo[bill_state], 0, 2)),
			"bill_post_code" 	=> $userinfo[bill_zip],
			"bill_country" 		=> $userinfo[bill_country],
			"bill_tel"			=> $userinfo[phone],
			"bill_email"		=> $userinfo[email],
			"customer"			=> $orderinfo[cc_name_on_card],
			"card_no" 			=> tempdecryptit($orderinfo[cc_card_no]),
			"card_type"			=> $ctype,
			"cv2" 				=> $orderinfo[cc_cvv2],
			"issue" 			=> $orderinfo[issue_number],
			"start_date" 		=> $orderinfo[start_month].substr($orderinfo[start_year], -2),
			"expiry" 			=> $orderinfo[cc_expir_month].substr($orderinfo[cc_expir_year], -2),
			"amount" 			=> p($orderinfo[total], false),
			"options"			=> "test_status=".$this->class_vars[testmode].",dups=false"
		);
		
		if (count($request) > 0) {
			reset($request);
			while (list($name, $value) = each($request)) {
				$str .= "&".$name."=".$value;
			}
			$data = substr($str,1);
		}
		
		$header_array = array(
			"POST / HTTP/1.0",
		    "Content-type: application/x-www-form-urlencoded",
		    "Content-length: ".strlen($data)
		);
		
		$header = "POST / HTTP/1.0\r\n".
			"Content-Type: application/x-www-form-urlencoded\r\n".
			"Content-Length: " . strlen ($data) . "\r\n\r\n";
		
		$results = $cconnect->connect($data, $header, $header_array, $this->class_vars[url]);
		$auth	 = $this->parse_return($results);
		
		$result["addon_message"] 	= $auth["message"];
		$result["addon_code"]		= $auth["code"];
		$result["addon_oid"] 		= $oid;
		
		if ($auth["code"] == 1) {
			$result["approved"] = "Approved";
		} else {
			$result["approved"] = "Error";
		}
		
		return $result;
	}
	
	function parse_return ($in) {
		$resp = array(
			"A" 	=> "Transaction authorised by bank. auth_code available as bank reference.",
			"N" 	=> "Transaction not authorised. Failure message text available to merchant.",
			"C" 	=> "Communication problem. Trying again later may well work.",
			"P:A" 	=> "Pre-bank checks. Amount not supplied or invalid.",
			"P:X" 	=> "Pre-bank checks. Not all mandatory parameters supplied.",
			"P:P" 	=> "Pre-bank checks. Same payment presented twice.",
			"P:S" 	=> "Pre-bank checks. Start date invalid.",
			"P:E" 	=> "Pre-bank checks. Expiry date invalid.",
			"P:I" 	=> "Pre-bank checks. Issue number invalid.",
			"P:C" 	=> "Pre-bank checks. Card number fails LUHN check.",
			"P:T"	=> "Pre-bank checks. Card type invalid - i.e. does not match card number prefix.",
			"P:N"	=> "Pre-bank checks. Customer name not supplied.",
			"P:M"	=> "Pre-bank checks. Merchant does not exist or not registered yet.",
			"P:B"	=> "Pre-bank checks. Merchant account for card type does not exist.",
			"P:D"	=> "Pre-bank checks. Merchant account for this currency does not exist.",
			"P:V"	=> "Pre-bank checks. CV2 security code mandatory and not supplied / invalid.",
			"P:R"	=> "Pre-bank checks. Transaction timed out awaiting a virtual circuit. Merchant may not have enough virtual circuits for the volume of business.",
			"P:#"	=> "Pre-bank checks. No MD5 hash / token key set up against account."
		); 
		
		preg_match("/valid=(.*)&/U", $in, $parse);
		
		if ($parse[1] == "true") {
			preg_match("/auth_code=(.*)&/U", $in, $parse);
			$out["code"] = 1;
			$out["message"] = "Approved";
		} else {
			preg_match("/&code=(.*)&/U", $in, $parse);
			$out["code"] = $parse[1];
			$out["message"] = $resp[$parse[1]];
		}
		return $out;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='secpay', `internalname`='merchant', `name`='Merchant ID', `options`='', `value`='', `help`='Your assigned merchant id.', `size`='0', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='secpay', `internalname`='url', `name`='Transaction URL', `options`='', `value`='https://www.secpay.com:443/java-bin/ValCard', `help`='Transaction url. Leave to default if unless needed.', `size`='60', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='secpay', `internalname`='testmode', `name`='Test Mode', `options`='true::false::live->All Approved::All Declined::Live Mode', `value`='false', `help`='Set to live mode when ready to take orders.', `size`='', `dorder`='3', `field_type`='dropdown'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='secpay'");
	}
}
?>
