<?PHP
/*
  include/payment/viaklix.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "viaKLIX (NOVA)";
$ADDON_VERSION 	= "2.1";
$ADDON_TYPE 	= "Processor";
$CLASS_NAME 	= "viaklix";

class viaklix {
	var $class_vars;
	
	function viaklix ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function process () {
		global $cconnect, $settings, $sess;
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		/**** Login Information ****/
		$data   = "ssl_merchant_id=".$this->class_vars[user_merchant_id]."&";
		$data  .= "ssl_user_id=".$this->class_vars[user_id]."&";
		$data  .= "ssl_pin=".$this->class_vars[user_pin]."&";
		
		/**** Billing Information ****/
		$data .= "ssl_first_name=".$userinfo[bill_first_name]."&";
		$data .= "ssl_last_name=".$userinfo[bill_last_name]."&";
		$data .= "ssl_avs_address=".urlencode($userinfo[bill_address1])."&";
		$data .= "ssl_address2=".urlencode($userinfo[bill_address2])."&";
		$data .= "ssl_city=".$userinfo[bill_city]."&";
		$data .= "ssl_state=".(($userinfo[bill_state]=='')?$userinfo[bill_other]:substr($userinfo[bill_state], 0, 2))."&";
		$data .= "ssl_avs_zip=".$userinfo[bill_zip]."&";
		$data .= "ssl_country=".$userinfo[bill_country]."&";
		$data .= "ssl_email=".$userinfo[email]."&";
		$data .= "ssl_phone=".$userinfo[phone]."&";
		
		/**** Shipping Information ****/
		$data .= "ssl_ship_to_first_name=".$userinfo[ship_first_name]."&";
		$data .= "ssl_ship_to_last_name=".$userinfo[ship_last_name]."&";
		$data .= "ssl_ship_to_avs_address=".urlencode($userinfo[ship_address1])."&";
		$data .= "ssl_ship_to_address2=".urlencode($userinfo[ship_address2])."&";
		$data .= "ssl_ship_to_city=".$userinfo[ship_city]."&";
		$data .= "ssl_ship_to_state=".(($userinfo[ship_state]=='')?$userinfo[shipl_other]:substr($userinfo[ship_state], 0, 2))."&";
		$data .= "ssl_ship_to_avs_zip=".$userinfo[ship_zip]."&";
		$data .= "ssl_ship_to_country=".$userinfo[ship_country]."&";
		
		/**** Credit Card Information ****/ 
		$data .= "ssl_card_number=".tempdecryptit($orderinfo[cc_card_no])."&";
		$data .= "ssl_cvv2=PRESENT&";
		$data .= "ssl_cvv2cvc2=".$orderinfo[cc_cvv2]."&";
		$data .= "ssl_exp_date=".str_pad($orderinfo[cc_expir_month], 2, "0", STR_PAD_LEFT).substr($orderinfo[cc_expir_year], 2, 2)."&";
		
		/**** Transaction Information ****/ 
		$data .= "ssl_test_mode=".$this->class_vars[test_mode]."&";
		$data .= "ssl_transaction_type=SALE&";
		$data .= "ssl_result_format=ASCII&";
		$data .= "ssl_show_form=FALSE&";
		$data .= "ssl_customer_code=".$sess->gvar('userid')."&";
		$data .= "ssl_amount=".p($orderinfo[total], false)."&";
		$data .= "ssl_salestax=0.00";
		
		$header_array = array(
			"POST / HTTP/1.0",
		    "Content-type: application/x-www-form-urlencoded",
		    "Content-length: ".strlen($data)
		);
		
		$header = "POST / HTTP/1.0\r\n".
			"Content-Type: application/x-www-form-urlencoded\r\n".
			"Content-Length: " . strlen ($data) . "\r\n\r\n";
		
		$results = $cconnect->connect($data, $header, $header_array, $this->class_vars[url]);
		$result	 = $this->parse_return($results);
		
		$auth["addon_message"] 	= $result["ssl_result_message"];
		$auth["addon_code"]		= $result["approval_code"];
		$auth["addon_oid"] 		= $result["ssl_txn_id"];
		
		if ($result["ssl_result"] == "0") {
			$auth["approved"] = "Approved";
		} else {
			$auth["approved"] = "Error";
		}
		
		return $auth;
	}
	
	function parse_return ($in) {
		$results = explode("\n", $in);
		for ($i=0; $i<count($results); $i++) {
			$split = explode("=", $results[$i]);
			$out[trim($split[0])] = trim($split[1]);
		}
		return $out;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='viaklix', `internalname`='user_merchant_id', `name`='Merchant ID', `options`='', `value`='', `help`='Your assigned viaKLIX merchant id.', `size`='0', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='viaklix', `internalname`='user_id', `name`='User ID', `options`='', `value`='', `help`='Your assigned viaKLIX user id.', `size`='0', `dorder`='2', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='viaklix', `internalname`='user_pin', `name`='User Pin', `options`='', `value`='', `help`='Your assigned viaKLIX merchant pin.', `size`='0', `dorder`='3', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='viaklix', `internalname`='url', `name`='Transaction URL', `options`='', `value`='https://www.viaklix.com/process.asp', `help`='Transaction url. Leave to default if unless needed.', `size`='60', `dorder`='4', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_payment set `module`='viaklix', `internalname`='test_mode', `name`='Test Mode', `options`='true::false->True::False', `value`='true', `help`='Set to this value for testing mode. Set to \"False\" for LIVE.', `size`='0', `dorder`='5', `field_type`='dropdown'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_payment where `module`='viaklix'");
	}
}
?>
