<?PHP
/*
  include/plugins/google_checkout/ss_responsehandler.php - 4/3/2009 - 8:32pm PST - 4.1.9
	
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
	
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$abs_path = dirname(dirname(dirname(dirname(__FILE__))));

require_once($abs_path.'/global.php');
require_once($abs_path.'/include/plugins/google_checkout/googleresponse.php');
require_once($abs_path.'/include/plugins/google_checkout/googlerequest.php');
require_once($abs_path.'/include/plugins/google_checkout/googlemerchantcalculations.php');
require_once($abs_path.'/include/plugins/google_checkout/googleresult.php');

// Set to 1 to turn logging on (googlemessage.log must exist and be writeable)
define('LOGGING', 0);
define('RESPONSE_HANDLER_LOG_FILE', 'googlemessage.log');

if (LOGGING) {
	if (!$message_log = fopen(RESPONSE_HANDLER_LOG_FILE, "a")) {
		error_func("Cannot open " . RESPONSE_HANDLER_LOG_FILE . " file.\n", 0);
		exit(1);
	}
}

$class_vars = module_vars('google_checkout', 'plugins');
$response = new GoogleResponse($class_vars[merchant_id], $class_vars[merchant_key]);
$request = new GoogleRequest($class_vars[merchant_id], $class_vars[merchant_key], ($class_vars[sandbox])?"sandbox":"checkout", $settings[defaultrate]);

$xml_response = isset($HTTP_RAW_POST_DATA)?$HTTP_RAW_POST_DATA:file_get_contents("php://input");

if (get_magic_quotes_gpc()) $xml_response = stripslashes($xml_response);

list($root, $data) = $response->GetParsedXML($xml_response);
$response->SetMerchantAuthentication($class_vars[merchant_id], $class_vars[merchant_key]);

// Comment out the two lines below in order to use .htaccess auth
$status = $response->HttpAuthentication();
if(!$status) die('authentication failed');

if (LOGGING) fwrite($message_log, sprintf("\n\r%s:- %s\n",date("D M j G:i:s T Y"), $xml_response));

switch ($root) {
	case "request-received":
	case "error":
	case "diagnosis":
	case "checkout-redirect":
		break;
	case "merchant-calculation-callback":
		$merchant_calc = new GoogleMerchantCalculations();
		
		////////////////////
		// Updating Shipping
		////////////////////
		
		$data_arr 	= explode("||", $data[$root]['shopping-cart']['merchant-private-data']['VALUE']);
		$weight		= $data_arr[0];
		$subtotal	= $data_arr[1];
		
		// Rebuild Cart
		$cart = new cart();
		$items = get_arr_result($data[$root]['shopping-cart']['items']['item']);
		foreach ($items as $curr_item) {
			$cart->restoreitem($curr_item['merchant-private-item-data']['VALUE']);
		}
		
		$addresses = get_arr_result($data[$root]['calculate']['addresses']['anonymous-address']);
		foreach($addresses as $curr_address) {
			$curr_id = $curr_address['id'];
			$country = $curr_address['country-code']['VALUE'];
			$city    = $curr_address['city']['VALUE'];
			$region  = $curr_address['region']['VALUE'];
			$pcode   = $curr_address['postal-code']['VALUE'];
			
			$merchant_result = new GoogleResult($curr_id);
			
			$area = get('state_country', $country, 'type`=\''.COUNTRY.'\' AND `abb'); $area_id_1 = $area[id];
			$area = get('state_country', $region, 'type`=\''.STATE.'\' AND `abb'); $area_id_2 = $area[id];
			$area = get('state_country', $region, 'type`=\''.PROV.'\' AND `abb'); $area_id_3 = $area[id];
			
			$userinfo = array(
				'ship_city'		=> $city,
				'ship_state'	=> $region,
				'ship_zip'		=> $pcode,
				'ship_country'	=> $country,
				'area_id_1'		=> $area_id_1,
				'area_id_2'		=> $area_id_2,
				'area_id_3'		=> $area_id_3
			);
			
			switch ($settings[shipmethod]) {
				case 'realtime':
					// Do Nothing
					break;
				
				default:
					$charge_shipping = 0;
					$items = get_arr_result($data[$root]['shopping-cart']['items']['item']);
					foreach ($items as $curr_item) {
						$info = get('products', $curr_item['merchant-item-id']['VALUE']);
						if ($info[charge_shipping] != 'n') $charge_shipping = 1;
					}
					
					if (isset($data[$root]['calculate']['shipping']) && $charge_shipping == 1) {
						$shipping = get_shipping($weight, $subtotal);
						$merchant_result->SetShippingDetails("Standard Shipping", p($shipping[rates], false), "true");
						if (p($settings[expedited]) != p(0)) {
							$merchant_result1 = new GoogleResult($curr_id);
							$merchant_result1->SetShippingDetails("Expedited Shipping", p(($shipping[rates]+$settings[expedited]), false), "true");
						}
						
					}
					break;
			}
		}
		
		$codes_array = array();
		
		/////////////////////////////
		// Checking Gift Certificates
		/////////////////////////////
		
		$codes = get_arr_result($data[$root]['calculate']['merchant-code-strings']['merchant-code-string']);
		foreach ($codes as $curr_code) {
			$gift_cert = sanitize($curr_code['code']);
			$result = $DB_site->query_first("SELECT * FROM `".$dbprefix."gift_certificates` WHERE `code`='".$gift_cert."' AND `status`='1'");
			if ($result[id] != "") {
				$cert = new GoogleGiftcerts("true", $curr_code['code'], $result[remaining], "Gift Certificate");
				$merchant_result->AddGiftCertificates($cert);
				if (is_object($merchant_result1)) $merchant_result1->AddGiftCertificates($cert);
				array_push($codes_array, $gift_cert);
			}
		}
		
		///////////////////
		// Checking Coupons 
		///////////////////
		
		$codes = get_arr_result($data[$root]['calculate']['merchant-code-strings']['merchant-code-string']);
			foreach ($codes as $curr_code) {
				$coupon = sanitize($curr_code['code']);
				if (!in_array($coupon, $codes_array)) {
					$result = $DB_site->query_first("SELECT * FROM `".$dbprefix."coupons` d WHERE 
					d.`status`='1' AND (d.`used`<d.`max` OR d.`max`='0') AND
					d.`vstart`<='".stamp()."' AND d.`vend`>='".stamp()."' AND
					d.`omin`<='".$subtotal."' AND  d.`code`='".$coupon."' AND d.`type`='G'".restrict('d'));
					if ($result[id] != "") {
						switch ($result[ctype]) {
							case 'P':
								$coup = new GoogleCoupons("true", $curr_code['code'], ($subtotal*($result[value]/100)), xf($result[name]));
								$merchant_result->AddCoupons($coup);
								if (is_object($merchant_result1)) $merchant_result1->AddCoupons($coup);
								break;
							case 'A':
								$coup = new GoogleCoupons("true", $curr_code['code'], $result[value], xf($result[name]));
								$merchant_result->AddCoupons($coup);
								if (is_object($merchant_result1)) $merchant_result1->AddCoupons($coup);
								break;
						}
				} else {
					$coup = new GoogleCoupons("false", $curr_code['code'], 0, $curr_code['code']." is not a valid coupon or the coupon has expired.");
					$merchant_result->AddCoupons($coup);
					if (is_object($merchant_result1)) $merchant_result1->AddCoupons($coup);
				}
			}
		}
		
		$merchant_calc->AddResult($merchant_result);
		if (is_object($merchant_result1)) $merchant_calc->AddResult($merchant_result1);
		if (LOGGING) fwrite($message_log, sprintf("\n\r%s:- %s\n",date("D M j G:i:s T Y"), $merchant_calc->GetXML()));
		$response->ProcessMerchantCalculations($merchant_calc);
		break;
		
	case "new-order-notification":
		// Log Coupons
		$coupons = get_arr_result($data[$root]['order-adjustment']['merchant-codes']['coupon-adjustment']);
		foreach ($coupons as $curr_coupons) {
			$coupon = sanitize($curr_coupons['code']['VALUE']);
			$amount = $curr_coupons['applied-amount']['VALUE'];
			$coup = $DB_site->query_first("SELECT * FROM `".$dbprefix."coupons` where `code`='".$coupon."'");
			$DB_site->query("UPDATE `".$dbprefix."coupons` set `used`='".($coup[used]+1)."' where `code`='".$coupon."'");
			$total_coupons = p(($total_coupons+$amount), false);
		}
		
		// Log Gift Certificate Usage
		$certs = get_arr_result($data[$root]['order-adjustment']['merchant-codes']['gift-certificate-adjustment']);
		foreach ($certs as $curr_cert) {
			$amount = $curr_cert['applied-amount']['VALUE'];
			$result = $DB_site->query_first("SELECT * FROM `".$dbprefix."gift_certificates` WHERE `code`='".$curr_cert['code']['VALUE']."'");
			if ($amount>$result[remaining] || $result[id] == "") {
				$order_notes = "This order was canceled because the amount on the gift certificate used was greater then the amount left on the gift certificate or the gift certificate doesn't exist.";
				$cancel_order = 1;
			} else {
				$DB_site->query("UPDATE `".$dbprefix."gift_certificates` set `remaining`='".($result[remaining]-$amount)."' WHERE `code`='".$curr_cert['code']['VALUE']."'");
			}
			$total_certs = p(($total_certs+$amount), false);
		}
		
		// Define Variables
		$adjustments	= $data[$root]['order-adjustment'];
		$shipping		= $data[$root]['buyer-shipping-address'];
		$billing		= $data[$root]['buyer-billing-address'];
		$ship_method	= (is_array($adjustments['shipping']['merchant-calculated-shipping-adjustment']))?$adjustments['shipping']['merchant-calculated-shipping-adjustment']:$adjustments['shipping']['carrier-calculated-shipping-adjustment'];
		
		// Start Order Array
		$orderinfo = array (
			'order_date' 		=> date('Y-m-d'),
			'ship_method'		=> $ship_method['shipping-name']['VALUE'],
			'ship_price'		=> $ship_method['shipping-cost']['VALUE'],
			'tax' 				=> $adjustments['total-tax']['VALUE'],
			'subtotal' 			=> ($data[$root]['order-total']['VALUE']-$data[$root]['order-adjustment']['total-tax']['VALUE']-$ship_method['shipping-cost']['VALUE']+$total_certs+$total_coupons),
			'discount' 			=> '0.00',
			'total' 			=> $data[$root]['order-total']['VALUE'],
			'pay_method' 		=> 'Credit Card',
			'cc_status'			=> 'Pending Approval',
			'status'			=> 'Pending',
			'coupon' 			=> $coupon,
			'coupon_savings' 	=> $total_coupons,
			'gift_cert' 		=> $adjustments['merchant-codes']['gift-certificate-adjustment']['code']['VALUE'],
			'gift_cert_savings'	=> $total_certs,
			'ship_first_name' 	=> nsplit($shipping['contact-name']['VALUE']),
			'ship_last_name'	=> nsplit($shipping['contact-name']['VALUE'], 1).((nsplit($shipping['contact-name']['VALUE'], 2)!='')?' '.nsplit($shipping['contact-name']['VALUE'], 2):''),
			'ship_company_name'	=> $shipping['company-name']['VALUE'],
			'ship_address1' 	=> $shipping['address1']['VALUE'],
			'ship_address2' 	=> $shipping['address2']['VALUE'],
			'ship_city' 		=> $shipping['city']['VALUE'],
			'ship_state' 		=> $shipping['region']['VALUE'],
			'ship_zip' 			=> $shipping['postal-code']['VALUE'],
			'ship_country' 		=> $shipping['country-code']['VALUE'],
			'bill_first_name' 	=> nsplit($billing['contact-name']['VALUE']),
			'bill_last_name'	=> nsplit($billing['contact-name']['VALUE'], 1),
			'bill_company_name' => $billing['company-name']['VALUE'],
			'bill_address1' 	=> $billing['address1']['VALUE'],
			'bill_address2' 	=> $billing['address2']['VALUE'],
			'bill_city' 		=> $billing['city']['VALUE'],
			'bill_state' 		=> $billing['region']['VALUE'],
			'bill_zip' 			=> $billing['postal-code']['VALUE'],
			'bill_country' 		=> $billing['country-code']['VALUE'],
			'email' 			=> $billing['email']['VALUE'],
			'phone' 			=> $billing['phone']['VALUE'],
			'order_stamp'		=> stamp(),
			'pm_name' 			=> 'Google Checkout',
			'pm_module' 		=> 'plugin_google_checkout.php',
			'pm_type' 			=> 'plugins',
			'pm_notes'			=> '',
			'pm_orderid' 		=> $data[$root]['google-order-number']['VALUE'],
			'ip_addr' 			=> 'Pending'
		);
		
		// Check For Downloads
		$items = get_arr_result($data[$root]['shopping-cart']['items']['item']);
		foreach ($items as $curr_item) {
			if (has_downloads($curr_item['merchant-item-id']['VALUE'])) $force_account = 1;
		}
		
		// Force Create Account
		if ($force_account == 1) {
			$store_info = $orderinfo;
			$getuser = explode('@', $store_info[email]);
			$store_info[username] = $getuser[0].'-'.randomnums(4);
			$store_info[password1] = randompass(10);
			$store_info[password2] = $store_info[password1];
			$store_info[store_info] = 'store';
			$check = check_account($store_info, 1, 1);
			
			$orderinfo['userid'] = $sess->gvar('userid');
		}
		
		// Store Order
		$query  = "INSERT INTO `".$dbprefix."orders` set";
		$result = $DB_site->query("DESCRIBE `".$dbprefix."orders`");
		while ($field = $DB_site->fetch_assoc($result)) {
			$key = $field['Field'];
			if (isset($orderinfo[$key])) $query .= " `".$key."`='".sf($orderinfo[$key])."',";
		}
		$DB_site->query(substr($query, 0, -1));
		$orderid = $DB_site->insert_id();
		
		// Update States
		update_order($orderid, array('pm_notes' => 'Eligible for protection: Unknown<br />Financial State: '.ucwords(strtolower($data[$root]['financial-order-state']['VALUE'])).'<br />Fulfillment State: '.ucwords(strtolower($data[$root]['fulfillment-order-state']['VALUE']))), false);
		
		// Store Marketing Preferences
		$DB_site->query("INSERT INTO `".$dbprefix."orders_notes` set `orderid`='".$orderid."', `type`='A', `private`='1', `note`='Email Marketing Allowed: ".ucfirst($data[$root]['buyer-marketing-preferences']['email-allowed']['VALUE'])."', `addedby`='Google Checkout', `datestamp`='".stamp()."'");
		
		// Run Through Items
		$items = get_arr_result($data[$root]['shopping-cart']['items']['item']);
		foreach ($items as $curr_item) {
			$item = new orderitem($curr_item['merchant-private-item-data']['VALUE']);
			$product = get('products', $curr_item['merchant-item-id']['VALUE']);
			$product[price] = $curr_item['unit-price']['VALUE']-$item->item->options_price_increase();
			
			if ($item->item->id == 'gs') {
				$cert = $gs->generate();
				$DB_site->query("INSERT INTO `".$dbprefix."gift_certificates` set
					`userid`='0',
					`orderid`='".$orderid."',
					`purchaser`='0',
					`code`='".$cert."',
					`purchaser_name`='".sf($item->item->options[0]->sender_name)."',
					`recipient_name`='".sf($item->item->options[0]->recipient_name)."',
					`recipient_email`='".sf($item->item->options[0]->recipient_email)."',
					`message`='".sf($item->item->options[0]->message)."',
					`amount`='".$item->item->options[0]->price."',
					`remaining`='".$item->item->options[0]->price."',
					`start_date`='".date('Y-m-d')."',
					`end_date`='0000-00-00',
					`status`='1'"
				);
				$item->item->options[0]->cert = $cert;
			}
			
			if ($item->item->regid != "") {
				$purch = $DB_site->query("SELECT `purchased` FROM `".$dbprefix."users_wishlist` where `id`='".$item->item->regid."'");
				$DB_site->query("UPDATE `".$dbprefix."users_wishlist` set `purchased`='".($purch[purchased]+$item->item->quantity)."' where `id`='".$item->item->regid."'");
			}
			
			$DB_site->query("INSERT INTO `".$dbprefix."orders_products` set
				`orderid`='".$orderid."',
				`productid`='".$product[id]."',
				`price`='".$product[price]."',
				`data`='".sf(base64_encode($item->return_serialized()))."',
				`item`='".sf(base64_encode(serialize(array('num' => $product[num], 'title' => $product[title], 'short_desc' => $product[short_desc], 'full_desc' => $product[full_desc]))))."'
			");
			
			foreach ($item->item->options as $key => $opt) {
				$option = get('products_options_items', $opt->valueid);
				$DB_site->query("UPDATE `".$dbprefix."products_options_items` set 
					`in_stock`='".($option[in_stock]-$item->item->quantity)."'
					where `id`='".$option[id]."'"
				);
			}
			
			$DB_site->query("UPDATE `".$dbprefix."products` set 
				`in_stock`='".($product[in_stock]-$item->item->quantity)."',
				`num_sold`='".($product[num_sold]+$item->item->quantity)."' 
				where `id`='".$product[id]."'"
			);
		}
		
		// Cancel Order
		if ($cancel_order == 1) {
			$DB_site->query("INSERT INTO `".$dbprefix."orders_notes` set `orderid`='".$orderid."', `type`='A', `private`='0', `note`='".addslashes($order_notes)."', `addedby`='Google Checkout', `datestamp`='".stamp()."'");	
			$request->SendCancelOrder($data[$root]['google-order-number']['VALUE'], $order_notes, '');
		}
		
		$response->SendAck();
		// Send Order Number
		//$request->SendMerchantOrderNumber($data[$root]['google-order-number']['VALUE'], $orderid);
		break;
		
	case "order-state-change-notification":
		$new_financial_state = $data[$root]['new-financial-order-state']['VALUE'];
		$new_fulfillment_order = $data[$root]['new-fulfillment-order-state']['VALUE'];
		$order_id = $data[$root]['google-order-number']['VALUE'];
		
		// Get Order Information
		$order = $DB_site->query_first("SELECT * FROM `".$dbprefix."orders` WHERE `pm_orderid`='".$order_id."'");
		
		$split = explode("<br />", $order[pm_notes]);
		$new[protection]	= $split[0];
		$new[financial]		= ucwords(strtolower($new_financial_state));
		$new[fulfillment]	= ucwords(strtolower($new_fulfillment_order));
		
		switch($new_financial_state) {
			case 'REVIEWING':
				break;
			
			case 'CHARGEABLE':
				if ($class_vars[auto] == 1) $request->SendChargeOrder($order_id, $order[total]);
				break;
			
			case 'CHARGING':
				break;
			
			case 'CHARGED':
				update_order($order_id, array('cc_status' => 'Payment Received'), false);
				break;
			
			case 'PAYMENT_DECLINED':
				update_order($order[id], array('cc_status' => 'Declined', 'status' => 'Error'), false);
				$DB_site->query("INSERT INTO `".$dbprefix."orders_notes` set `orderid`='".$order[id]."', `type`='A', `private`='0', `note`='Payment for this order was declined by the bank.', `addedby`='Google Checkout', `datestamp`='".stamp()."'");
				break;
			
			case 'CANCELLED':
				update_order($order[id], array('cc_status' => 'Cancelled', 'status' => 'Cancelled'), false);
				$DB_site->query("INSERT INTO `".$dbprefix."orders_notes` set `orderid`='".$order[id]."', `type`='A', `private`='0', `note`='This order was canceled by the store owner or by the clients request.', `addedby`='Google Checkout', `datestamp`='".stamp()."'");
				break;
			
			case 'CANCELLED_BY_GOOGLE':
				update_order($order[id], array('cc_status' => 'Cancelled', 'status' => 'Cancelled'), false);
				$DB_site->query("INSERT INTO `".$dbprefix."orders_notes` set `orderid`='".$order[id]."', `type`='A', `private`='0', `note`='This order was cancelled by Google Checkout.', `addedby`='Google Checkout', `datestamp`='".stamp()."'");
			break;
			
			default:
				break;
		}
		
		switch($new_fulfillment_order) {
			case 'NEW':	
			case 'PROCESSING':
			case 'WILL_NOT_DELIVER':
				break;
			case 'DELIVERED':
				update_order($order[id], array('status' => 'Shipped/Complete'), false);
				break;
			default:
				break;
		}
		
		$DB_site->query("UPDATE `".$dbprefix."orders` set `pm_notes`='".$new[protection]."<br />Financial State: ".$new[financial]."<br />Fulfillment State: ".$new[fulfillment]."' WHERE `pm_orderid`='".$order_id."'");
		$response->SendAck();
		break;
		
	case "charge-amount-notification":
		$order_id = $data[$root]['google-order-number']['VALUE'];
		$amount = $data[$root]['total-charge-amount']['VALUE'];
		$order = $DB_site->query_first("SELECT * FROM `".$dbprefix."orders` WHERE `pm_orderid`='".$order_id."'");
		if (p($amount, false) != p($order[total], false)) $new_status = 'Partially Charged';
		else $new_status = 'Payment Received';
		update_order($order[id], array('cc_status' => $new_status), false);
		
		// Send Gift Certificate Info
		if (p($amount, false) == p($order[total], false)) {
			$items = $DB_site->query("SELECT * FROM `".$dbprefix."orders_products` WHERE `orderid`='".$order[id]."'");
			while ($item = $DB_site->fetch_assoc($items)) {
				if ($item[productid] == '0') {
					include_once $abs_path.'/include/classes/class.orderitem.php';
					$data = new orderitem($item[data]);
					$gs->send($gs->cert_array($data->item->options[0]));
				}
			}
		}
		
		$response->SendAck();
		break;
		
	case "chargeback-amount-notification":
		$order_id = $data[$root]['google-order-number']['VALUE'];
		$order = $DB_site->query_first("SELECT * FROM `".$dbprefix."orders` WHERE `pm_orderid`='".$order_id."'");
		update_order($order[id], array('cc_status' => 'Chargeback'), false);
		$DB_site->query("INSERT INTO `".$dbprefix."orders_notes` set `orderid`='".$order[id]."', `type`='A', `private`='1', `note`='A chargeback was received on this order. Please contact Google for more information on this.', `addedby`='Google Checkout', `datestamp`='".stamp()."'");
		$response->SendAck();
		break;
		
	case "refund-amount-notification":
		$order_id = $data[$root]['google-order-number']['VALUE'];
		$amount = $data[$root]['total-refund-amount']['VALUE'];
		$order = $DB_site->query_first("SELECT * FROM `".$dbprefix."orders` WHERE `pm_orderid`='".$order_id."'");
		
		if (p($amount, false) != p($order[total], false)) $new_status = 'Partially Refunded';
		else $new_status = 'Refunded';
		
		$split = explode("<br />", $order[pm_notes]);
		$new[protection]	= $split[0];
		$new[financial]		= $new_status;
		$new[fulfillment]	= $split[2];
		
		update_order($order[id], array('cc_status' => $new_status), false);
		$DB_site->query("UPDATE `".$dbprefix."orders` set `pm_notes`='".$new[protection]."<br />Financial State: ".$new[financial]."<br />".$new[fulfillment]."' WHERE `pm_orderid`='".$order_id."'");
		$response->SendAck();
		break;
		
	case "risk-information-notification":
		$order_id = $data[$root]['google-order-number']['VALUE'];
		$DB_site->query("UPDATE `".$dbprefix."orders` set 
			`pm_avs`='".sf($data[$root]['risk-information']['avs-response']['VALUE'])."', 
			`pm_cvn`='".sf($data[$root]['risk-information']['cvn-response']['VALUE'])."',
			`ip_addr`='".sf($data[$root]['risk-information']['ip-address']['VALUE'])."'
			WHERE `pm_orderid`='".$order_id."'"
		);
		
		// Get Order Information
		$order = $DB_site->query_first("SELECT * FROM `".$dbprefix."orders` WHERE `pm_orderid`='".$order_id."'");
		
		$split = explode("<br />", $order[pm_notes]);
		$new[protection]	= 'Eligible for protection: '.sf(ucwords(strtolower($data[$root]['risk-information']['eligible-for-protection']['VALUE'])));
		$new[financial]		= $split[1];
		$new[fulfillment]	= $split[2];
		
		$DB_site->query("UPDATE `".$dbprefix."orders` set `pm_notes`='".$new[protection]."<br />".$new[financial]."<br />".$new[fulfillment]."' WHERE `pm_orderid`='".$order_id."'");
		$response->SendAck();
		break;
		
	default:
		break;
}

function get_arr_result ($child_node) {
	$result = array();
	if (isset($child_node)) {
		if (is_associative_array($child_node)) {
			$result[] = $child_node;
		} else {
			foreach($child_node as $curr_node) {
				$result[] = $curr_node;
			}
		}
	}
	return $result;
}

function is_associative_array ($var) {
	return is_array($var) && !is_numeric(implode('', array_keys($var)));
}

function nsplit ($fname, $ret=0) {
	$names = explode(' ', $fname);
	return $names[$ret];
}
?>