<?PHP
/*
  include/plugins/plugin_m3Verify.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "m3|Verify (Fraud Screening)";
$ADDON_VERSION 	= "1.1";
$CLASS_NAME 	= "m3Verify";

class m3Verify {
	var $output;
	
	function m3Verify ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function render () {
		global $DB_site, $dbprefix, $settings, $lang, $sess, $cconnect, $result;
		$request = array();
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		// debug($userinfo); die;
		// debug($orderinfo); die;
		// debug($GLOBALS); die;
		
		$data = array();
		$data['ccfd_api_key']			= $this->class_vars['ccfd_api_key'];
		$data['to'] 					= $this->class_vars['to'];
		$data['to_name'] 				= $this->class_vars['to_name'];
		$data['ip'] 					= $_SERVER['REMOTE_ADDR'];
		$data['forwarded_ip']			= $this->vw_ip();
		$data['customer_phone'] 		= $userinfo['phone'];
		$data['city'] 					= $userinfo['bill_city'];
		$data['state_province'] 		= substr($userinfo['bill_state'], 0, 2);
		$data['postal_code'] 			= $userinfo['bill_zip'];
		$data['country'] 				= $userinfo['bill_country'];
		$data['email_domain'] 			= substr($userinfo['email'], (strpos($userinfo['email'], '@')+1), strlen($userinfo['email']));
		$data['md5_email'] 				= md5($userinfo['email']);
		$data['md5_username']			= md5($_SESSION['USERIN']);
		$data['md5_password']			= $_SESSION['PASSIN'];
		$data['shipping_address']		= $userinfo['ship_address1'];
		$data['shipping_city']			= $userinfo['ship_city'];
		$data['shipping_state_province']= $userinfo['ship_state'];
		$data['shipping_postal_code']	= $userinfo['ship_zip'];
		$data['shipping_country']		= $userinfo['ship_country'];
		$data['shipping_country']		= $userinfo['ship_country'];
		$data['transaction_id']			= $_SESSION['userid'].date("mdyHis");
		$data['session_id']				= $result['orderid'];
		
		if ($orderinfo['cc_card_no'] && $this->class_vars['use_premium'] == 'yes') 
			$data['bin'] = substr(tempdecryptit($orderinfo['cc_card_no']), 0, 6);
		
		$results = $this->response2array($cconnect->connect($this->array2query($data), $header, array(), 'http://solidphp.com/vw/index.php'));
		
		if ($results['errors']) {
			$errors = "Auto rejected by system due to pre conditions failing. ( {$results['errors']} )";
			$DB_site->query("INSERT INTO `".$dbprefix."orders_notes` set `orderid`='".$result['orderid']."', `type`='A', `private`='1', `note`='".sf($errors)."', `addedby`='m3Verfiy', `datestamp`='".stamp()."'");
			return;
		}
		
		$message = "Here are the results:\n\n";
		$ht = array(
			'country_match'					=> 'Country Match',
			'country_code'					=> 'IP Country Code',
			'high_risk_country'				=> 'High Risk Country',
			'distance_ip_to_billing'		=> 'Distance from IP to the Billing Address',
			'ip_state_province'				=> 'IP State or Province',
			'ip_city'						=> 'IP City',
			'ip_latitude'					=> 'IP Latitude',
			'ip_longitude'					=> 'IP Longitude',
			'ip_isp'						=> 'IP ISP',
			'ip_org'						=> 'IP Orgainization',
			'anon_proxy'					=> 'Using an anonymous proxy',
			'proxy_score'					=> 'Proxy Score',
			'is_txn_proxy'					=> 'Transaction Proxy',
			'free_email'					=> 'Using a free e-mail provider',
			'carder_email'					=> 'Carder Email',
			'high_risk_username'			=> 'High Risk Username',
			'high_risk_password'			=> 'High Risk Password',
			'bin_match'						=> 'BIN Match',
			'bin_country'					=> 'BIN Country Code',
			'bin_name_match'				=> 'BIN Name Match',
			'bin_name'						=> 'BIN Name',
			'bin_phone_match'				=> 'BIN Phone Match',
			'bin_phone'						=> 'BIN Phone',
			'customer_phone_in_billing'		=> 'Is the customer phone in the billing location?',
			'shipping_forward'				=> 'Shipping Forward',
			'city_postal_match'				=> 'City Postal Code Match',
			'shipping_city_postal_match'	=> 'Shipping City Postal Code Match',
			'score'							=> 'Fraud Score',
			'explanation'					=> 'Explanation',
			'risk_score'					=> 'Risk Score',
			'errors'						=> 'Errors',
			'credits'						=> 'Credits Used for this Transaction',
			'created'						=> 'Report Created',
			'incoming_id'					=> 'Internal Reference [ID]',
			'outgoing_id'					=> 'Internal Reference [OD]'
		);
		
		foreach ($results as $key => $value) {
			if (!$value) continue;
			if ($key=='created') $value = date('r', $value);
			if ($key=='errors') $value = ($value)?$value:'None';
			$message .= "{$ht[$key]}: ".ucfirst($value)."\n";
		}
	
		$ht = array(
			'ip' 						=> 'IP Address',
			'forwarded_ip' 				=> 'Forwarded IP',
			'city' 						=> 'City',
			'state_province' 			=> 'State or Province',
			'postal_code' 				=> 'Postal Code',
			'country' 					=> 'Country',
			'email_domain' 				=> 'E-mail Domain',
			'bin' 						=> 'BIN',
			'bin_name' 					=> 'BIN Name',
			'bin_phone' 				=> 'BIN Phone',
			'customer_phone' 			=> 'Customer Phone',
			'shipping_address' 			=> 'Shipping Address',
			'shipping_city' 			=> 'Shipping City',
			'shipping_state_province' 	=> 'Shipping State or Province',
			'shipping_postal_code' 		=> 'Shipping Postal Code',
			'shipping_country' 			=> 'Shipping Country',
			'ccfd_api_key' 				=> 'API Key'
		);	
		
		$message .= "\n\nHere is what was posted in:\n\n";
		foreach ($data as $key => $value) {
			$skip = array('to', 'to_name', 'md5_email', 'md5_username', 'md5_password', 'transaction_id', 'session_id');
			if (!$value || in_array($key, $skip)) continue;
			if ($key == 'customer_phone') $value = substr($value, 0, 6);
			$message .= "{$ht[$key]}: ".ucfirst($value)."\n";
		}
		
		$message .= "\n\n";
		$message .= "===[ END OF REPORT ]===";
		
		mail_send($data['to'], $data['to_name'], "[m3|Verify] Fraud Report for Order #{$result['orderid']}", $message, 'noreply@solidphp.com', 'm3|Verify Automation', false);
		$mailed = 'Check the fraud report that was e-mailed to you for a complete fraud report.';
		
		$message = "The fraud score is {$results['score']} out of 10, with 10 being almost certainly fraud. Manually review any order with a score over 2. {$mailed}";
		$DB_site->query("INSERT INTO `".$dbprefix."orders_notes` set `orderid`='".$result['orderid']."', `type`='A', `private`='1', `note`='".sf($message)."', `addedby`='m3Verfiy', `datestamp`='".stamp()."'");
		return;
	}
	
	
	function response2array ($response) {
		$buffer = array();
		$data = explode(';', $response);
		foreach ($data as $metric) {
			list($key, $value) = explode("=", $metric);
			$buffer[$key] = $value;
		}
		return $buffer;
	}
	
	function array2query($data) {
		if (!is_array($data)) return $data;
		$buffer = '';
		foreach ($data as $key => $value) {
			if ($buffer) $buffer.='&';
			$buffer .= "{$key}={$value}";
		}
		return $buffer;
	}
	
	function vw_ip() {
		if ($_SERVER["HTTP_X_FORWARDED_FOR"]) return $_SERVER["HTTP_X_FORWARDED_FOR"]; 
		if ($_SERVER["HTTP_CLIENT_IP"]) return $_SERVER["HTTP_CLIENT_IP"];
		return $_SERVER["REMOTE_ADDR"];
	}
	
	function install () {
		global $DB_site, $dbprefix, $settings;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_plugins set `module`='m3Verify', `internalname`='enabled', `name`='Enabled', `moptions`='', `options`='0::1->Off::On', `value`='1', `help`='', `size`='0', `dorder`='1', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_plugins set `module`='m3Verify', `internalname`='use_premium', `name`='Use Premium Credits', `moptions`='', `options`='yes::no->Yes::No', `value`='yes', `help`='Standard transactions use one (1) credit. Premium transactions use three (3) credits. Credit card data must be passed in to use premium credits. If no card information is passed in you will be charged a standard credit.', `size`='0', `dorder`='2', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_plugins set `module`='m3Verify', `internalname`='ccfd_api_key', `name`='m3|Verify API Key', `options`='', `value`='', `help`='The API key you were given when you ordered service.', `size`='0', `dorder`='3', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_plugins set `module`='m3Verify', `internalname`='to', `name`='Mail Fraud Report to E-mail', `options`='', `value`='".$settings[contactemail]."', `help`='The e-mail address you would like to have the fraud report mailed to.', `size`='0', `dorder`='4', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_plugins set `module`='m3Verify', `internalname`='to_name', `name`='Mail Recipient Name', `options`='', `value`='".$settings[companyname]."', `help`='The name of the contact receiving the fraud report e-mail.', `size`='0', `dorder`='5', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_plugins where `module`='m3Verify'");
	}
}

$OUT_DATA = 'PHRhYmxlIGJvcmRlcj0iMCIgY2VsbHNwYWNpbmc9IjAiIGNlbGxwYWRkaW5nPSIzIj4NCgk8dHI+DQoJCTx0ZCB2YWxpZ249Im1pZGRsZSI+PGl
	tZyBzcmM9ImltYWdlcy9tM192ZXJpZnkuanBnIiBhbHQ9Im0zdmVyaWZ5IiB3aWR0aD0iMjA5IiBoZWlnaHQ9Ijc0IiBib3JkZXI9IjAiIHN0eWxlPSJib3J
	kZXI6IDFweCBzb2xpZCAjMDAwMDAwOyI+PC90ZD4NCgkJPHRkPjxpbWcgc3JjPSIkc2V0dGluZ3NbdGhlbWVfcGF0aF0vaW1hZ2VzL3NwYWNlLmdpZiIgd2l
	kdGg9IjEwIiBoZWlnaHQ9IjEiIGJvcmRlcj0iMCI+PC90ZD4NCgkJPHRkIHZhbGlnbj0ibWlkZGxlIj4NCgkJCTxzdHJvbmc+RG9uJ3QgZ28gYXQgaXQgYWx
	vbmUhPC9zdHJvbmc+IEZ1bGx5IGF1dG9tYXRlZCwgbTN8VmVyaWZ5IGZyYXVkIGRldGVjdGlvbiBzZXJ2aWNlIGNhbiBoZWxwIHlvdSBkZXRlcm1pbmUgaWY
	gYW4gb3JkZXIgaXMgZnJhdWR1bGVudCANCgkJCWJ5IHByb3ZpZGluZyBpbi1kZXB0aCBtZXRyaWNzIGFuZCBhbiBvdmVyYWxsIGZyYXVkIHNjb3JlLiBXZSB
	hbHNvIHByb3ZpZGUgYSB2aXJ0dWFsIHRlcm1pbmFsIHdpdGggZXZlcnkgc3Vic2NyaXB0aW9uIHdoaWNoIHlvdSBjYW4gdXNlIHRvIA0KCQkJbWFudWFsbHk
	gc2NyZWVuIG9yZGVycy4gRWFjaCBmcmF1ZCByZXBvcnQgaXMgYXJjaGl2ZWQgaW4gY2FzZSB5b3UgbmVlZCB0byByZXZpZXcgaXQgYWdhaW4gYXQgYSBsYXR
	lciBkYXRlLjxicj48YnI+DQoJCQk8aW5wdXQgdHlwZT0iYnV0dG9uIiB2YWx1ZT0iTGVhcm4gTW9yZSIgb25DbGljaz0id2luZG93Lm9wZW4oJ2h0dHA6Ly9
	3d3cudHVybmtleXdlYnRvb2xzLmNvbS9tM3ZlcmlmeS8nLCdtM3ZlcmlmeScsJ3dpZHRoPTYwMCxoZWlnaHQ9NTAwLHJlc2l6YWJsZT0xLHNjcm9sbGJhcnM
	9MSx0aXRsZWJhcj0xLG1lbnViYXI9MSx0b29sYmFyPTEsbG9jYXRpb249MSxzdGF0dXM9MSxkaXJlY3Rvcmllcz0xLGNoYW5uZWxtb2RlPTAsZnVsbHNjcmV
	lbj0wJyk7IHJldHVybiBmYWxzZTsiPg0KCQk8L3RkPg0KDQoJPC90cj4NCjwvdGFibGU+';

?>
