<?PHP
/*
  include/plugins/paypal_express.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/

$ADDON_NAME 	= "PayPal Express Checkout";
$ADDON_VERSION 	= "1.2";
$CLASS_NAME 	= "paypal_express";

class paypal_express {
	var $class_vars;
	var $ctype;
	var $cartinfo = array();
	
	function paypal_express ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function render () {
		global $DB_site, $dbprefix, $settings, $abs_path, $lang, $sess, $cart;
		
		include_once $abs_path.'/include/classes/class.connect.php';
		$cconnect = new curl_connect();
		
		$userinfo	= $sess->gvar('userinfo');
		$orderinfo	= $sess->gvar('orderinfo');
		
		$this->class_vars = module_vars('paypal_pro', 'payment');
		
		if (!is_array($this->class_vars)) return;
		
		$url	= ($this->class_vars[sandbox]=='true')?'https://api.sandbox.paypal.com/2.0/':'https://api-3t.paypal.com/2.0/';
		$url2	= ($this->class_vars[sandbox]=='true')?'https://www.sandbox.paypal.com/':'https://www.paypal.com/';
		
		$cart_entry = $DB_site->query_first("SELECT * FROM ".$dbprefix."users_saved_carts WHERE sessid='".$sess->id()."'");
		
		$vars = array_merge (
			$this->class_vars,
			array (
				'currency'		=> $settings[defaultrate],
				'total'			=> p($cart->subtotal(), false),
				'return_url'	=> $settings[secureurl].'checkout.php?return=paypal_express_checkout',
				'cancel_url'	=> $settings[shopurl].'index.php?l=cart_view',
				'token'			=> $paypal_token,
				'local_code' 	=> $settings[country],
				'extra'			=> $cart_entry[id]
			)
		);
		
		$xml_data	= xml_doc('include/plugins/paypal_express/paypal_express.xml', $vars);
		$results	= $cconnect->connect($xml_data, $header, array(), $url);
		$paypal		= $this->parse_return($results);
		
		if ($paypal['Ack'] == "Success") {
			return template('plugin_paypal_express.html', array('out' => array('token' => $paypal['Token'], 'url' => $url2), 'lang' => $lang['plugin']));
		}
	}
	
	function parse_return ($in) {
		global $abs_path;
		include_once $abs_path.'/include/soap/nusoap.php';
		$parser = new soap_parser($in, 'UTF-8');
		$out = $parser->get_response();
		return $out;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_plugins set `module`='paypal_express', `internalname`='enabled', `name`='Enabled', `moptions`='', `options`='0::1->Off::On', `value`='1', `help`='If enabaled, PayPal Web Payments Pro payment module must be installed and the credentials set in that module.', `size`='0', `dorder`='1', `field_type`='dropdown'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_plugins where `module`='paypal_express'");
	}
}
?>
