<?PHP
/*
  include/shipping/canada_post.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/
  
$ADDON_NAME 	= "CP";
$ADDON_FULLNAME	= "Canada Post";
$ADDON_VERSION 	= "2.1";
$ADDON_TYPE 	= "Shipping";
$CLASS_NAME 	= "cp_integration";

class cp_integration {
	var $class_vars;
	var $xml_code;
	var $package_id = 1;
	var $to_city;
	var $to_state;
	var $to_country;
	var $to_zip;
	
	function cp_integration ($class_vars) {
		$this->class_vars = $class_vars;
	}
	
	function start () {
		global $settings;
		$this->xml_code = '
		<?xml version="1.0"?> 
	 		<eparcel>
				<language>en</language> 
		 		<ratesAndServicesRequest>
			  		<merchantCPCID>'.$this->class_vars[acc_num].'</merchantCPCID>
					<fromPostalCode>'.$settings[zip].'</fromPostalCode>';
	}
	
	function setaddress ($from_city, $from_state, $from_zip, $from_country, $to_city, $to_state, $to_zip, $to_country) {
		$this->to_city 		= $to_city;
		$this->to_state 	= $to_state;
		$this->to_country 	= $to_country;
		$this->to_zip 		= $to_zip;
		$this->xml_code .= '
					<lineItems>';
    }
	
	function add_package($weight, $length="", $width="", $height="") {
		global $settings;
		if ($settings[dimension_units] == "IN") {
			$length = ($length * 2.54);
			$width = ($width * 2.54);
			$height = ($height * 2.54);
		}
		
		if ($settings[weight_units] == "LB") $weight = ($weight * .45);
		
		$this->xml_code .= '
					<item>
						<quantity>1</quantity>
						<weight>'.$weight.'</weight>
						<length>'.$length.'</length>
						<width>'.$width.'</width>
						<height>'.$height.'</height>
						<description>Package '.$this->package_id.'</description>
					</item>';
		$this->package_id++;
	}
	
	function end_all () {
		$this->xml_code .= '
					</lineItems>
					<city>'.$this->to_city.'</city> 
					<provOrState>'.$this->to_state.'</provOrState> 
					<country>'.$this->to_country.'</country> 
					<postalCode>'.$this->to_zip.'</postalCode>
				</ratesAndServicesRequest>
			</eparcel>';
	}
	
	function connect () {
		$this->fp = fsockopen ($this->class_vars[url], $this->class_vars[port], $errno, $errstr, 30);
		if (!$this->fp) return;
		fwrite($this->fp, $this->xml_code);
		while (!feof($this->fp)) $data .= fgets($this->fp, 4090);
		fclose($this->fp);
		return $data;
	}
	
	function process () {
		global $settings;
		$results = $this->connect();
		$result	 = $this->parse_return($results);
		return $result;
	}
	
	function parse_return ($in) {
		$return = array();
	    $rarray = parse_xml($in, array('product'), array('/product id="([0-9]*)" sequence="([0-9]*)"/'), array('product'));
		
		if ($rarray[eparcel][error] != "") {
			$return[0][status]		= "Failed";
			$return[0][statuscode]	= 0;
			$return[0][error]		= $rarray[eparcel][error][statusMessage];
			$return[0][errorcode]	= $rarray[eparcel][error][statusCode];
			$return[0][rate]		= 0;
			$return[0][method]		= 0;
		} else {
			for ($i=0; $i<count($rarray[eparcel][ratesAndServicesResponse][product]); $i++) {
				$return[$i][status]		= $rarray[eparcel][ratesAndServicesResponse][statusMessage];
				$return[$i][statuscode]	= $rarray[eparcel][ratesAndServicesResponse][statusCode];
				$return[$i][error]		= "";
				$return[$i][errorcode]	= 0;
				$return[$i][rate]		= $rarray[eparcel][ratesAndServicesResponse][product][$i][rate];
				$return[$i][method]		= $rarray[eparcel][ratesAndServicesResponse][product][$i][name];
			}
		}
		
		return $return;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='cp_integration', `internalname`='enabled', `name`='Enabled', `moptions`='', `options`='0::1->Off::On', `value`='0', `help`='', `size`='0', `dorder`='1', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='cp_integration', `internalname`='url', `name`='', `moptions`='', `options`='', `value`='sellonline.canadapost.ca', `help`='', `size`='40', `dorder`='', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='cp_integration', `internalname`='port', `name`='', `moptions`='', `options`='', `value`='30000', `help`='', `size`='40', `dorder`='', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='cp_integration', `internalname`='acc_num', `name`='Account Number', `moptions`='', `options`='', `value`='', `help`='', `size`='20', `dorder`='1', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='cp_integration', `internalname`='multi_support', `name`='', `moptions`='', `options`='', `value`='1', `help`='', `size`='0', `dorder`='', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_shipping where `module`='cp_integration'");
	}
}
?>
