<?PHP
/*
  include/shipping/usps.php - 4/3/2009 - 8:32pm PST - 4.1.9
  
  SunShop Shopping Cart
  http://www.turnkeywebtools.com/sunshop/
  
  Copyright (c) 2001-2009 Turnkey Web Tools, Inc.
*/
  
$ADDON_NAME 	= "USPS";
$ADDON_FULLNAME	= "USPS Domestic";
$ADDON_VERSION 	= "3.1";
$ADDON_TYPE 	= "Shipping";
$CLASS_NAME 	= "usps";

class usps {
	var $class_vars;
	var $xml_code;
	var $loc_code;
	var $countryto;
	var $package_id = 0;
	var $shipm;
	
	var $shipn = array(
		"Express Mail",
		"First-Class Mail",
		"Priority Mail",
		"Parcel Post",
		"Bound Printed Matter",
		"Media Mail",
		"Library Mail"
	);
	
	function usps ($class_vars) {
		$this->class_vars	= $class_vars;
		
		// What services should be matched to results.
		$this->shipm = array(
			"Express Mail" 			=> 'Express Mail', // Also Available: Express Mail Flat-Rate Envelope
			"First-Class Mail" 		=> 'First-Class Mail '.$this->class_vars[firstclass],
			"Priority Mail" 		=> 'Priority Mail', // Also Available: Priority Mail Flat-Rate Envelope, Priority Mail Flat-Rate Box, Priority Mail Large Flat-Rate Box
			"Parcel Post" 			=> 'Parcel Post', 
			"Bound Printed Matter" 	=> 'Bound Printed Matter',
			"Media Mail" 			=> 'Media Mail',
			"Library Mail" 			=> 'Library Mail'
		);
	}
	
	function start () {
		global $settings;
		$this->xml_code = $settings[startusps];
	}
	
	function setaddress ($from_city, $from_state, $from_zip, $from_country, $to_city, $to_state, $to_zip, $to_country) {
		$this->countryto = $to_country;
		$this->loc_code = '
			<ZipOrigination>'.str_replace(" ", "", $from_zip).'</ZipOrigination>
			<ZipDestination>'.str_replace(" ", "", $to_zip).'</ZipDestination>
		';
    }
	
	function add_package($weight, $length="", $width="", $height="") {
		global $settings;
		if ($settings[weight_units] == "LB") { $pounds = floor($weight); $ounces = round(16 * ($weight - floor($weight))); }
		if ($settings[weight_units] == "OZ") { $ounces = round($weight); $pounds = '0'; }
		
		$this->xml_code .= '
			<Package%20ID="'.$this->package_id.'">
				<Service>All</Service>
				'.$this->loc_code.'
				<Pounds>'.$pounds.'</Pounds>
				<Ounces>'.$ounces.'</Ounces>
				<Container>'.urlencode($this->class_vars[box_type]).'</Container>
				<Size>'.$this->class_vars[box_size].'</Size>
				<Machinable>FALSE</Machinable>
			</Package>
		';
		$this->package_id++;
	}
	
	function end_all () {
		$this->xml_code .= '</RateV3Request>';
	}
	
	function process () {
		global $settings, $cconnect, $discounts, $coupon;
		
		if ($this->countryto != "US") { return; }
		$data = "API=RateV3&XML=".$this->xml_code;
		
		$header_array = array(
			"GET / HTTP/1.1",
			"Content-type: application/x-www-form-urlencoded",
			"Content-length: ".strlen($data)
		);
		
		$header = "GET / HTTP/1.1\r\n".
			"Content-Type: application/x-www-form-urlencoded\r\n".
			"Content-Length: " . strlen ($data) . "\r\n\r\n";
		
		$results = $cconnect->connect($data, $header, $header_array, $this->class_vars[url]);
		$result	= $this->parse_return($results);
		$return = array();
		
		if ($result[error] != "" || !is_array($result)) {
			array_push($return, array('status' => '', 'statuscode' => 0, 'error' => $result[error], 'errorcode' => 0, 'rate' => '', 'method' => ''));
		} else {
			$free = array();
			$temp = explode("::", $this->class_vars[free]);
			for ($i=0; $i<count($temp); $i++) array_push($free, $temp[$i]);
			
			$accepted = explode("::", $this->class_vars[accepted]);
			for ($i=0; $i<count($accepted); $i++) {
				$service = $this->shipm[$accepted[$i]];
				foreach ($result[result] as $k => $v) {
					if (trim($service) == trim($v[MailService])) {
						$set_free = (($discounts[free_shipping]==1 || $coupon[free_shipping]==1) && in_array($accepted[$i], $free))?1:0;
						array_push($return, array('status' => '', 'statuscode' => 1, 'error' => '', 'errorcode' => 0, 'rate' => ($set_free==1)?0:$v[Rate], 'method' => $v[MailService]));
					}
				}
			}
		}
		
		return $return;
	}
	
	function parse_return ($in) {
		$rarray 		= parse_xml($in, array('Postage', 'Package'));
		$return 		= array('result' => array(), 'error' => '');
		$parse_array 	= array();
		$total			= 0;
		
		while (list ($key, $val) = @each ($rarray[RateV3Response][Package])) {
			$error = $rarray[RateV3Response][Package][$key][Error][Description];
			if ($error!="") { $return[error] = $error; }
			while (list ($key2, $val2) = @each ($rarray[RateV3Response][Package][$key][Postage])) {
				$method_name = $rarray[RateV3Response][Package][$key][Postage][$key2][MailService];
				$ship_amount = $rarray[RateV3Response][Package][$key][Postage][$key2][Rate];
				$parse_array[$method_name][amount] += $ship_amount;
				$parse_array[$method_name][method]	= $method_name;
				$parse_array[$method_name][hitnum] += 1;
			}
			$total++;
		}
		
		while (list ($key, $val) = @each ($parse_array)) {
			if ($parse_array[$key][hitnum] == $total) {
				$this_val = array(
					'MailService' => $parse_array[$key][method], 
					'Rate' => $parse_array[$key][amount]
				);
				array_push($return[result], $this_val);
			}
		}
		
		$return[error]  = ($return[error]!="")?$return[error]:$rarray[Error][Description];
		return $return;
	}
	
	function install () {
		global $DB_site, $dbprefix;
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='usps', `internalname`='enabled', `name`='Enabled', `moptions`='', `options`='0::1->Off::On', `value`='0', `help`='', `size`='0', `dorder`='1', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='usps', `internalname`='url', `name`='', `moptions`='', `options`='', `value`='http://production.shippingapis.com/ShippingAPI.dll', `help`='', `size`='40', `dorder`='', `field_type`='textbox'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='usps', `internalname`='accepted', `name`='Shipping Methods', `moptions`='".implode("::", $this->shipn)."->".implode("::", $this->shipn)."', `options`='', `value`='First-Class Mail::Priority Mail::Express Mail::Parcel Post', `help`='', `size`='0', `dorder`='2', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='usps', `internalname`='free', `name`='Free Methods', `moptions`='".implode("::", $this->shipn)."->".implode("::", $this->shipn)."', `options`='', `value`='First-Class Mail', `help`='Please select any methods you wish to offer free when free shipping is provided using discounts or coupons.', `size`='0', `dorder`='3', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='usps', `internalname`='firstclass', `name`='First Class Method', `moptions`='', `options`='Letter::Flat::Parcel->Letter::Flat::Parcel', `value`='Parcel', `help`='When selecting first class, what type of package will you be shipping.', `size`='0', `dorder`='4', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='usps', `internalname`='box_type', `name`='Typical Box Type', `moptions`='', `options`='VARIABLE::FLAT RATE BOX::FLAT RATE ENVELOPE::RECTANGULAR::NONRECTANGULAR->Your Packaging::Flat Rate Box::Flat Rate Envelope::Rectangular::Non Rectangular', `value`='VARIABLE', `help`='Your typical packaging for your packages.', `size`='0', `dorder`='5', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='usps', `internalname`='box_size', `name`='Typical Package Size', `moptions`='', `options`='REGULAR::LARGE::OVERSIZE->Regular::Large::Oversize', `value`='REGULAR', `help`='REGULAR: package length plus girth is 84 inches or less. LARGE: package length plus girth measure more than 84 inches but not more than 108 inches. OVERSIZE: package length plus girth is more than 108 but not more than 130 inches.', `size`='0', `dorder`='6', `field_type`='dropdown'");
		$DB_site->query("INSERT INTO ".$dbprefix."modules_shipping set `module`='usps', `internalname`='multi_support', `name`='', `moptions`='', `options`='', `value`='1', `help`='', `size`='0', `dorder`='', `field_type`='textbox'");
	}
	
	function uninstall () {
		global $DB_site, $dbprefix;
		$DB_site->query("DELETE FROM ".$dbprefix."modules_shipping where `module`='usps'");
	}
}
?>
